/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.jdbc;

import com.gemstone.gemfire.cache.TransactionFlag;
import com.gemstone.gemfire.internal.cache.Checkpoint;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.shared.FinalizeObject;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.SQLWarningFactory;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredCallableStatement;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredConnectionControl;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredStatement;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredStatementControl;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public abstract class BrokeredConnection
implements EngineConnection {
    int stateHoldability = 1;
    final BrokeredConnectionControl control;
    private boolean isClosed;
    private String connString;
    private int stateIsolationLevel;
    private boolean stateReadOnly;
    private boolean stateAutoCommit;

    public BrokeredConnection(BrokeredConnectionControl control) {
        this.control = control;
    }

    @Override
    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.control.checkAutoCommit(autoCommit);
            this.getRealConnection().setAutoCommit(autoCommit);
            this.stateAutoCommit = autoCommit;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final boolean getAutoCommit() throws SQLException {
        try {
            return this.getRealConnection().getAutoCommit();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final Statement createStatement() throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().createStatement());
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql), sql, null);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareCall(sql), sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final String nativeSQL(String sql) throws SQLException {
        try {
            return this.getRealConnection().nativeSQL(sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void commit() throws SQLException {
        try {
            this.control.checkCommit();
            this.getRealConnection().commit();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void rollback() throws SQLException {
        try {
            this.control.checkRollback();
            this.getRealConnection().rollback();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            this.control.checkClose();
            if (!this.control.closingConnection()) {
                this.isClosed = true;
                return;
            }
            this.isClosed = true;
            this.getRealConnection().close();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        try {
            boolean realIsClosed = this.getRealConnection().isClosed();
            if (realIsClosed) {
                this.control.closingConnection();
                this.isClosed = true;
            }
            return realIsClosed;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        try {
            return this.getRealConnection().getWarnings();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void clearWarnings() throws SQLException {
        try {
            this.getRealConnection().clearWarnings();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getRealConnection().getMetaData();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.getRealConnection().setReadOnly(readOnly);
            this.stateReadOnly = readOnly;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        try {
            return this.getRealConnection().isReadOnly();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void setCatalog(String catalog) throws SQLException {
        try {
            this.getRealConnection().setCatalog(catalog);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final String getCatalog() throws SQLException {
        try {
            return this.getRealConnection().getCatalog();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void setTransactionIsolation(int level) throws SQLException {
        try {
            this.getRealConnection().setTransactionIsolation(level);
            this.stateIsolationLevel = level;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        try {
            return this.getRealConnection().getTransactionIsolation();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().createStatement(resultSetType, resultSetConcurrency));
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, resultSetType, resultSetConcurrency), sql, null);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareCall(sql, resultSetType, resultSetConcurrency), sql);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.getRealConnection().getTypeMap();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final void setTypeMap(Map map) throws SQLException {
        try {
            this.getRealConnection().setTypeMap(map);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    final EngineConnection getRealConnection() throws SQLException {
        if (this.isClosed) {
            throw Util.noCurrentConnection();
        }
        return this.control.getRealConnection();
    }

    final void notifyException(SQLException sqle) {
        if (!this.isClosed) {
            this.control.notifyException(sqle);
        }
    }

    public void syncState() throws SQLException {
        EngineConnection conn = this.getRealConnection();
        this.stateIsolationLevel = conn.getTransactionIsolation();
        this.stateReadOnly = conn.isReadOnly();
        this.stateAutoCommit = conn.getAutoCommit();
        this.stateHoldability = conn.getHoldability();
    }

    public void getIsolationUptoDate() throws SQLException {
        if (this.control.isIsolationLevelSetUsingSQLorJDBC()) {
            this.stateIsolationLevel = this.getRealConnection().getTransactionIsolation();
            this.control.resetIsolationLevelFlag();
        }
    }

    public void setState(boolean complete) throws SQLException {
        Class[] CONN_PARAM = new Class[]{Integer.TYPE};
        Object[] CONN_ARG = new Object[]{this.stateHoldability};
        EngineConnection conn = this.getRealConnection();
        if (complete) {
            conn.setTransactionIsolation(this.stateIsolationLevel);
            conn.setReadOnly(this.stateReadOnly);
            conn.setAutoCommit(this.stateAutoCommit);
            try {
                Method sh = conn.getClass().getMethod("setHoldability", CONN_PARAM);
                sh.invoke((Object)conn, CONN_ARG);
            }
            catch (Exception e) {
                throw PublicAPI.wrapStandardException(StandardException.plainWrapException(e));
            }
        }
    }

    public BrokeredStatement newBrokeredStatement(BrokeredStatementControl statementControl) throws SQLException {
        return new BrokeredStatement(statementControl);
    }

    public abstract BrokeredPreparedStatement newBrokeredStatement(BrokeredStatementControl var1, String var2, Object var3) throws SQLException;

    public abstract BrokeredCallableStatement newBrokeredStatement(BrokeredStatementControl var1, String var2) throws SQLException;

    @Override
    public final void setDrdaID(String drdaID) {
        try {
            this.getRealConnection().setDrdaID(drdaID);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public final void setPrepareIsolation(int level) throws SQLException {
        this.getRealConnection().setPrepareIsolation(level);
    }

    @Override
    public final int getPrepareIsolation() throws SQLException {
        return this.getRealConnection().getPrepareIsolation();
    }

    @Override
    public final void addWarning(SQLWarning w) throws SQLException {
        this.getRealConnection().addWarning(w);
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
    }

    public String toString() {
        if (this.connString == null) {
            String wrappedString;
            try {
                wrappedString = this.getRealConnection().toString();
            }
            catch (SQLException e) {
                wrappedString = "<none>";
            }
            this.connString = this.getClass().getName() + "@" + this.hashCode() + ", Wrapped Connection = " + wrappedString;
        }
        return this.connString;
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            resultSetHoldability = this.statementHoldabilityCheck(resultSetHoldability);
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, null);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final int getHoldability() throws SQLException {
        try {
            return this.getRealConnection().getHoldability();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    final int statementHoldabilityCheck(int resultSetHoldability) throws SQLException {
        int holdability = this.control.checkHoldCursors(resultSetHoldability, true);
        if (holdability != resultSetHoldability) {
            SQLWarning w = SQLWarningFactory.newSQLWarning("01J07");
            this.addWarning(w);
        }
        return holdability;
    }

    @Override
    public void clearLOBMapping() throws SQLException {
        this.getRealConnection().clearLOBMapping();
    }

    @Override
    public Object getLOBMapping(long key) throws SQLException {
        return this.getRealConnection().getLOBMapping(key);
    }

    @Override
    public String getCurrentSchemaName() throws SQLException {
        try {
            return this.getRealConnection().getCurrentSchemaName();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public void resetFromPool() throws SQLException {
        this.getRealConnection().resetFromPool();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys) throws SQLException {
        try {
            return this.getRealConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int[] columnIndexes) throws SQLException {
        try {
            return this.getRealConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, columnIndexes);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String[] columnNames) throws SQLException {
        try {
            return this.getRealConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, columnNames);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void setPossibleDuplicate(boolean dup) {
        try {
            this.getRealConnection().setPossibleDuplicate(dup);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public final void setEnableStreaming(boolean enable) {
        try {
            this.getRealConnection().setEnableStreaming(enable);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public final LanguageConnectionContext getLanguageConnectionContext() {
        try {
            return this.getRealConnection().getLanguageConnectionContext();
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public final void internalRollback() throws SQLException {
        try {
            this.getRealConnection().internalRollback();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void internalClose() throws SQLException {
        try {
            this.getRealConnection().internalClose();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void forceClose() {
        try {
            this.getRealConnection().forceClose();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public FinalizeObject getAndClearFinalizer() {
        try {
            return this.getRealConnection().getAndClearFinalizer();
        }
        catch (SQLException sqle) {
            return null;
        }
    }

    @Override
    public final boolean isActive() {
        try {
            return this.getRealConnection().isActive();
        }
        catch (SQLException sqle) {
            return false;
        }
    }

    @Override
    public int addLOBMapping(Object lobReference) throws SQLException {
        return this.getRealConnection().addLOBMapping(lobReference);
    }

    @Override
    public void removeLOBMapping(long key) throws SQLException {
        this.getRealConnection().removeLOBMapping(key);
    }

    @Override
    public boolean hasLOBs() throws SQLException {
        return this.getRealConnection().hasLOBs();
    }

    @Override
    public Object getConnectionSynchronization() throws SQLException {
        return this.getRealConnection().getConnectionSynchronization();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.0");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.getRealConnection().setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.getRealConnection().getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.1");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.1");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new AssertionError((Object)"unexpected call in JDBC 4.1");
    }

    @Override
    public void setExecutionSequence(int execSeq) {
        try {
            this.getRealConnection().setExecutionSequence(execSeq);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public EnumSet<TransactionFlag> getTransactionFlags() throws SQLException {
        return this.getRealConnection().getTransactionFlags();
    }

    @Override
    public void setTransactionIsolation(int level, EnumSet<TransactionFlag> transactionFlags) throws SQLException {
        this.getRealConnection().setTransactionIsolation(level, transactionFlags);
    }

    @Override
    public Checkpoint masqueradeAsTxn(TXId txid, int isolationLevel) throws SQLException {
        return this.getRealConnection().masqueradeAsTxn(txid, isolationLevel);
    }

    @Override
    public void updateAffectedRegion(Bucket b) {
        try {
            this.getRealConnection().updateAffectedRegion(b);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

