/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdQueryResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdQueryStreamingResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.SnappyResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.message.LeadNodeExecutorMsg;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.execute.SnappyPrepareResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.SnappySelectResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.SnappyUpdateDeletePutResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericResultDescription;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.snappy.LeadNodeExecutionContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.List;
import java.util.Vector;

public class SnappyActivation
extends BaseActivation {
    private String sql;
    private boolean returnRows;
    private boolean isPrepStmt;
    private boolean isUpdateOrDeleteOrPut;

    public SnappyActivation(LanguageConnectionContext lcc, ExecPreparedStatement eps, boolean returnRows, boolean isPrepStmt, boolean isUpdateOrDeleteOrPut) {
        super(lcc);
        this.sql = eps.getSource();
        this.preStmt = eps;
        this.returnRows = returnRows;
        this.connectionID = lcc.getConnectionId();
        this.isPrepStmt = isPrepStmt;
        this.isUpdateOrDeleteOrPut = isUpdateOrDeleteOrPut;
    }

    public void initialize_pvs() throws StandardException {
        SnappyPrepareResultSet preparedResult = this.prepare();
        try {
            int[] typeNames = preparedResult.makePrepareResult();
            assert (typeNames != null);
            assert (typeNames.length > 0);
            int numberOfParameters = typeNames[0];
            DataTypeDescriptor[] types = new DataTypeDescriptor[numberOfParameters];
            for (int i = 0; i < numberOfParameters; ++i) {
                int index = i * 4 + 1;
                SnappyResultHolder.getNewNullDVD(typeNames[index], i, types, typeNames[index + 1], typeNames[index + 2], typeNames[index + 2] == 1);
            }
            this.pvs = this.lcc.getLanguageFactory().newParameterValueSet(this.lcc.getLanguageConnectionFactory().getClassFactory().getClassInspector(), numberOfParameters, false);
            this.pvs.initialize(types);
            if (this.preStmt instanceof GenericPreparedStatement) {
                GenericPreparedStatement gps = (GenericPreparedStatement)this.preStmt;
                gps.setParameterTypes(types);
                String statementType = this.isUpdateOrDeleteOrPut ? "INSERT" : "SELECT";
                gps.setResultDescription(preparedResult.makeResultDescription(statementType));
            }
        }
        catch (IOException ioex) {
            throw StandardException.newException(ioex.getMessage(), ioex);
        }
    }

    @Override
    public void setupActivation(ExecPreparedStatement ps, boolean scrollable, String stmt_text) throws StandardException {
    }

    @Override
    public final void checkStatementValidity() throws StandardException {
    }

    public final SnappyPrepareResultSet prepare() throws StandardException {
        try {
            SnappyPrepareResultSet rs = this.createPrepareResultSet();
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("SnappyActivation.prepare: Created SnappySelectResultSet: " + rs));
            }
            this.prepareWithResultSet(rs);
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"SnappyActivation.prepare: Done.");
            }
            return rs;
        }
        catch (GemFireXDRuntimeException gfxdrtex) {
            StandardException cause = this.getCause(gfxdrtex);
            if (cause != null) {
                throw cause;
            }
            throw gfxdrtex;
        }
    }

    @Override
    public final ResultSet execute() throws StandardException {
        try {
            SnappySelectResultSet rs = this.createResultSet();
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("SnappyActivation.execute: Created SnappySelectResultSet: " + rs));
            }
            rs.open();
            this.resultSet = rs;
            this.executeWithResultSet(rs);
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"SnappyActivation.execute: Done");
            }
            return rs;
        }
        catch (GemFireXDRuntimeException gfxdrtex) {
            StandardException cause = this.getCause(gfxdrtex);
            if (cause != null) {
                throw cause;
            }
            throw gfxdrtex;
        }
    }

    private StandardException getCause(GemFireXDRuntimeException gfxe) {
        for (Throwable cause = gfxe.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof StandardException)) continue;
            return (StandardException)cause;
        }
        return null;
    }

    private SnappySelectResultSet createResultSet() throws StandardException {
        if (this.isUpdateOrDeleteOrPut) {
            return new SnappyUpdateDeletePutResultSet(this, this.returnRows);
        }
        return new SnappySelectResultSet(this, this.returnRows);
    }

    private SnappyPrepareResultSet createPrepareResultSet() throws StandardException {
        return new SnappyPrepareResultSet(this);
    }

    private void executeWithResultSet(SnappySelectResultSet rs) throws StandardException {
        boolean enableStreaming = this.lcc.streamingEnabled();
        GfxdResultCollector<Object> rc = this.getResultCollector(enableStreaming, rs);
        SnappyActivation.executeOnLeadNode(rs, rc, this.sql, enableStreaming, this.getConnectionID(), this.lcc.getCurrentSchemaName(), this.pvs, this.isPrepStmt, this.isUpdateOrDeleteOrPut, this.lcc);
    }

    private void prepareWithResultSet(SnappyPrepareResultSet rs) throws StandardException {
        GfxdResultCollector<Object> rc = this.getPrepareResultCollector(rs);
        SnappyActivation.prepareOnLeadNode(rs, rc, this.sql, this.getConnectionID(), this.lcc.getCurrentSchemaName(), this.pvs, this.isUpdateOrDeleteOrPut, this.lcc);
    }

    private GfxdResultCollector<Object> getResultCollector(boolean enableStreaming, SnappySelectResultSet rs) throws StandardException {
        AbstractCollection rc = enableStreaming ? new GfxdQueryStreamingResultCollector() : new GfxdQueryResultCollector();
        rs.setupRC((GfxdResultCollector<?>)((Object)rc));
        return rc;
    }

    private GfxdResultCollector<Object> getPrepareResultCollector(SnappyPrepareResultSet rs) throws StandardException {
        GfxdQueryResultCollector rc = new GfxdQueryResultCollector();
        rs.setupRC(rc);
        return rc;
    }

    @Override
    public boolean checkIfThisActivationHasHoldCursor(String tableName) {
        return false;
    }

    @Override
    public Vector getParentResultSet(String resultSetId) {
        throw new UnsupportedOperationException("SnappyActivation::getParentResultSet: not implemented");
    }

    @Override
    public ResultDescription getResultDescription() {
        if (this.resultDescription == null) {
            this.resultDescription = SnappyActivation.makeResultDescription(this.resultSet);
        }
        return this.resultDescription;
    }

    public static ResultDescription makeResultDescription(ResultSet resultSet) {
        assert (resultSet != null) : "expected non noll result set";
        assert (resultSet instanceof SnappySelectResultSet) : "expected SnappySelectResultSet type result set";
        SnappySelectResultSet srs = (SnappySelectResultSet)resultSet;
        return srs.makeResultDescription();
    }

    @Override
    public final long estimateMemoryUsage() throws StandardException {
        return -1L;
    }

    @Override
    public void informOfRowCount(NoPutResultSet resultSet, long rowCount) throws StandardException {
        throw new UnsupportedOperationException("SnappyActivation::informOfRowCount: not implemented");
    }

    @Override
    public void setParentResultSet(TemporaryRowHolder rs, String resultSetId) {
        throw new UnsupportedOperationException("SnappyActivation::setParentResultSet: not implemented");
    }

    @Override
    protected int getExecutionCount() {
        throw new UnsupportedOperationException("SnappyActivation::getExecutionCount: not implemented");
    }

    @Override
    protected Vector getRowCountCheckVector() {
        throw new UnsupportedOperationException("SnappyActivation::getRowCountCheckVector: not implemented");
    }

    @Override
    protected int getStalePlanCheckInterval() {
        throw new UnsupportedOperationException("SnappyActivation::getStalePlanCheckInterval: not implemented");
    }

    @Override
    protected void setExecutionCount(int newValue) {
        throw new UnsupportedOperationException("SnappyActivation::setExecutionCount: not implemented");
    }

    @Override
    protected void setRowCountCheckVector(Vector newValue) {
        throw new UnsupportedOperationException("SnappyActivation::setRowCountCheckVector: not implemented");
    }

    @Override
    protected void setStalePlanCheckInterval(int newValue) {
        throw new UnsupportedOperationException("SnappyActivation::setStalePlanCheckInterval: not implemented");
    }

    @Override
    public void postConstructor() throws StandardException {
        throw new UnsupportedOperationException("SnappyActivation::postConstructor: not implemented");
    }

    public void setResultDescription(GenericResultDescription resultDescription) {
        this.resultDescription = resultDescription;
    }

    private static void executeOnLeadNode(SnappySelectResultSet rs, GfxdResultCollector<Object> rc, String sql, boolean enableStreaming, long connId, String schema, ParameterValueSet pvs, boolean isPreparedStatement, boolean isUpdateOrDeleteOrPut, LanguageConnectionContext lcc) throws StandardException {
        TXManagerImpl.TXContext txContext;
        LeadNodeExecutionContext ctx = new LeadNodeExecutionContext(connId);
        LeadNodeExecutorMsg msg = new LeadNodeExecutorMsg(sql, schema, ctx, rc, pvs, isPreparedStatement, false, isUpdateOrDeleteOrPut);
        if (lcc != null) {
            lcc.getTransactionExecute().releaseAllLocks(true, true);
        }
        if ((txContext = TXManagerImpl.currentTXContext()) != null) {
            txContext.waitForPendingCommit();
        }
        try {
            msg.executeFunction(enableStreaming, false, rs, true);
        }
        catch (RuntimeException | SQLException ex) {
            Exception e = LeadNodeExecutorMsg.handleLeadNodeException(ex, sql);
            throw Misc.processFunctionException("SnappyActivation::executeOnLeadNode", e, null, null);
        }
    }

    private static void prepareOnLeadNode(SnappyPrepareResultSet rs, GfxdResultCollector<Object> rc, String sql, long connId, String schema, ParameterValueSet pvs, boolean isUpdateOrDeleteOrPut, LanguageConnectionContext lcc) throws StandardException {
        LeadNodeExecutionContext ctx = new LeadNodeExecutionContext(connId);
        LeadNodeExecutorMsg msg = new LeadNodeExecutorMsg(sql, schema, ctx, rc, pvs, true, true, isUpdateOrDeleteOrPut);
        if (lcc != null) {
            lcc.getTransactionExecute().releaseAllLocks(true, true);
        }
        try {
            msg.executeFunction(false, false, rs, true);
        }
        catch (RuntimeException | SQLException ex) {
            Exception e = LeadNodeExecutorMsg.handleLeadNodeException(ex, sql);
            throw Misc.processFunctionException("SnappyActivation::prepareOnLeadNode", e, null, null);
        }
    }

    public static boolean isColumnTable(DMLQueryInfo dmlQueryInfo) {
        List<GemFireContainer> allContainers;
        if (dmlQueryInfo != null && (allContainers = dmlQueryInfo.getContainerList()) != null) {
            for (GemFireContainer container : allContainers) {
                if (null == container) continue;
                boolean isColumnTable = container.isRowBuffer();
                if (GemFireXDUtils.TraceQuery) {
                    String tabName = container.getSchemaName() + container.getTableName();
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("SnappyActivation.isColumnTable: table-name=" + tabName + " ,isColumnTable=" + isColumnTable));
                }
                if (!isColumnTable) continue;
                return true;
            }
        }
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"SnappyActivation.isColumnTable: return false");
        }
        return false;
    }
}

