/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.compile;

import com.pivotal.gemfirexd.internal.engine.sql.compile.DistributedJoinStrategy;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.ExpressionClassBuilderInterface;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HashJoinStrategy;

public class DistributedHashFetchRowsJoinStrategy
extends HashJoinStrategy
implements DistributedJoinStrategy {
    @Override
    public boolean feasible(Optimizable innerTable, OptimizablePredicateList predList, Optimizer optimizer) throws StandardException {
        return super.feasible(innerTable, predList, optimizer);
    }

    @Override
    public boolean bulkFetchOK() {
        return true;
    }

    @Override
    public boolean ignoreBulkFetch() {
        return false;
    }

    @Override
    public boolean multiplyBaseCostByOuterRows() {
        return true;
    }

    @Override
    public OptimizablePredicateList getBasePredicates(OptimizablePredicateList predList, OptimizablePredicateList basePredicates, Optimizable innerTable) throws StandardException {
        SanityManager.ASSERT((basePredicates.size() == 0 ? 1 : 0) != 0, (String)"The base predicate list should be empty.");
        for (int i = predList.size() - 1; i >= 0; --i) {
            OptimizablePredicate pred = predList.getOptPredicate(i);
            if (!pred.getReferencedMap().contains(innerTable.getReferencedTableMap())) continue;
            basePredicates.addOptPredicate(pred);
            predList.removeOptPredicate(i);
        }
        basePredicates.classify(innerTable, innerTable.getCurrentAccessPath().getConglomerateDescriptor());
        return basePredicates;
    }

    @Override
    public double nonBasePredicateSelectivity(Optimizable innerTable, OptimizablePredicateList predList) throws StandardException {
        return super.nonBasePredicateSelectivity(innerTable, predList);
    }

    @Override
    public void putBasePredicates(OptimizablePredicateList predList, OptimizablePredicateList basePredicates) throws StandardException {
        super.putBasePredicates(predList, basePredicates);
    }

    @Override
    public void estimateCost(Optimizable innerTable, OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, CostEstimate costEstimate) throws StandardException {
        super.estimateCost(innerTable, predList, cd, outerCost, optimizer, costEstimate);
    }

    @Override
    public int maxCapacity(int userSpecifiedCapacity, int maxMemoryPerTable, double perRowUsage) {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getName() {
        return "DISTRIBUTED-HASH-FETCH-ROWS";
    }

    @Override
    public int scanCostType() {
        return 4;
    }

    @Override
    public String resultSetMethodName(boolean bulkFetch, boolean multiprobe) {
        SanityManager.THROWASSERT((String)"This method should not be called");
        return "getRemoteFetchResultSet";
    }

    @Override
    public String joinResultSetMethodName() {
        return "getNcjPullJoinResultSet";
    }

    @Override
    public String halfOuterJoinResultSetMethodName() {
        SanityManager.THROWASSERT((String)"This method should not be called");
        return "getDistributedHashLeftOuterJoinResultSet";
    }

    @Override
    public int getScanArgs(TransactionController tc, MethodBuilder mb, Optimizable innerTable, OptimizablePredicateList storeRestrictionList, OptimizablePredicateList nonStoreRestrictionList, ExpressionClassBuilderInterface acb, int bulkFetch, MethodBuilder resultRowAllocator, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int maxMemoryPerTable, boolean genInListVals, boolean delayScanOpening, boolean optimizeForOffHeap, boolean indexAccesesBaseTable) throws StandardException {
        return 0;
    }

    @Override
    public void divideUpPredicateLists(Optimizable innerTable, OptimizablePredicateList originalRestrictionList, OptimizablePredicateList storeRestrictionList, OptimizablePredicateList nonStoreRestrictionList, OptimizablePredicateList requalificationRestrictionList, DataDictionary dd) throws StandardException {
    }

    @Override
    public boolean isHashJoin() {
        return true;
    }

    @Override
    public boolean doesMaterialization() {
        return true;
    }
}

