/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.locks;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.LockTimeoutException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.LockNotHeldException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdDRWLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockable;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdReadWriteLock;
import com.pivotal.gemfirexd.internal.engine.locks.impl.GfxdReentrantReadWriteLock;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class GfxdLocalLockService
extends ConcurrentHashMap<Object, GfxdReadWriteLock>
implements GfxdLockService {
    private static final long serialVersionUID = -3658472369312965223L;
    private final String serviceName;
    private final GfxdReadWriteLock lockTemplate;
    final long maxVMWriteLockWait;
    private long lastDumpTime;

    public GfxdLocalLockService(String serviceName, GfxdReadWriteLock lockTemplate, long maxVMWriteLockWait) {
        this.serviceName = serviceName;
        this.lockTemplate = lockTemplate != null ? lockTemplate : GfxdReentrantReadWriteLock.createTemplate(true);
        this.maxVMWriteLockWait = maxVMWriteLockWait;
        this.lastDumpTime = -1L;
    }

    @Override
    public final boolean readLock(Object name, Object owner, long waitTimeMillis) {
        return this.getOrCreateLock(name).attemptReadLock(waitTimeMillis, owner);
    }

    @Override
    public boolean readLock(GfxdLockable lockable, Object owner, long waitTimeMillis) {
        return this.getOrCreateLock(lockable, lockable.getName()).attemptReadLock(waitTimeMillis, owner);
    }

    @Override
    public void readUnlock(Object name) {
        this.readUnlock(name, this.getOrCreateLock(name));
    }

    @Override
    public void readUnlock(GfxdLockable lockable) {
        Object name = lockable.getName();
        this.readUnlock(name, this.getOrCreateLock(lockable, name));
    }

    @SuppressWarnings(value={"IMSE_DONT_CATCH_IMSE"}, justification="lock-service code is allowed to catch this exception")
    private void readUnlock(Object name, GfxdReadWriteLock rwLock) {
        try {
            if (rwLock == null) {
                throw new LockNotHeldException(LocalizedStrings.DLockService_ATTEMPTING_TO_UNLOCK_0_1_BUT_THIS_THREAD_DOESNT_OWN_THE_LOCK.toLocalizedString(new Object[]{this, name}));
            }
            rwLock.releaseReadLock();
        }
        catch (IllegalMonitorStateException ex) {
            LockNotHeldException lnhe = new LockNotHeldException(LocalizedStrings.DLockService_ATTEMPTING_TO_UNLOCK_0_1_BUT_THIS_THREAD_DOESNT_OWN_THE_LOCK.toLocalizedString(new Object[]{this, name}));
            lnhe.initCause((Throwable)ex);
            throw lnhe;
        }
    }

    @Override
    public GfxdLockService.ReadLockState hasReadLock(Object name) {
        GfxdReadWriteLock rwLock = (GfxdReadWriteLock)this.get(name);
        if (rwLock != null) {
            return rwLock.hasReadLock();
        }
        return GfxdLockService.ReadLockState.NOT_HELD;
    }

    @Override
    public boolean writeLock(Object name, Object owner, long waitTimeMillis, long leaseTimeMillis) {
        return this.localWriteLock(name, this.getOrCreateLock(name), owner, waitTimeMillis);
    }

    @Override
    public boolean writeLock(GfxdLockable lockable, Object owner, long waitTimeMillis, long leaseTimeMillis) {
        Object name = lockable.getName();
        return this.localWriteLock(name, this.getOrCreateLock(lockable, name), owner, waitTimeMillis);
    }

    @Override
    public void writeUnlock(Object name, Object owner) {
        if (!this.localWriteUnlock(this.getOrCreateLock(name), owner)) {
            throw new LockNotHeldException(LocalizedStrings.DLockService_ATTEMPTING_TO_UNLOCK_0_1_BUT_THIS_THREAD_DOESNT_OWN_THE_LOCK.toLocalizedString(new Object[]{this, name}));
        }
    }

    @Override
    public void writeUnlock(GfxdLockable lockable, Object owner) {
        Object name = lockable.getName();
        if (!this.localWriteUnlock(this.getOrCreateLock(lockable, name), owner)) {
            throw new LockNotHeldException(LocalizedStrings.DLockService_ATTEMPTING_TO_UNLOCK_0_1_BUT_THIS_THREAD_DOESNT_OWN_THE_LOCK.toLocalizedString(new Object[]{this, name}));
        }
    }

    @Override
    public final Thread newCurrentOwner() {
        return Thread.currentThread();
    }

    @Override
    public GfxdLocalLockService getLocalLockService() {
        return this;
    }

    @Override
    public boolean hasWriteLock(Object name, Object owner) {
        GfxdReadWriteLock rwLock = (GfxdReadWriteLock)this.get(name);
        if (rwLock != null) {
            return rwLock.hasWriteLock(owner);
        }
        return false;
    }

    @Override
    public Object getWriteLockOwner(Object name) {
        GfxdReadWriteLock rwLock = (GfxdReadWriteLock)this.get(name);
        if (rwLock != null) {
            return rwLock.getWriteLockOwner();
        }
        return null;
    }

    @Override
    public void freeResources(Object name) {
        GfxdReadWriteLock lock = (GfxdReadWriteLock)this.remove(name);
        if (lock != null) {
            lock.setInMap(false);
        }
    }

    @Override
    public final TimeoutException getLockTimeoutRuntimeException(Object lockObject, Object lockOwner, boolean dumpAllLocks) {
        if (dumpAllLocks) {
            this.dumpAllRWLocks("LOCK TABLE at the time of failure", null, true);
        }
        InterruptedException cause = null;
        if (Thread.interrupted()) {
            cause = new InterruptedException();
            Thread.currentThread().interrupt();
        }
        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)cause);
        GfxdReadWriteLock lock = lockObject instanceof GfxdLockable ? ((GfxdLockable)lockObject).getReadWriteLock() : (GfxdReadWriteLock)this.get(lockObject);
        String exStr = "lock timeout for object: " + lockObject + ", for lock: " + lock;
        if (lockOwner != null) {
            exStr = exStr + ", requested for owner: " + lockOwner;
        }
        return new LockTimeoutException(exStr, (Throwable)cause);
    }

    @Override
    public final StandardException getLockTimeoutException(Object lockObject, Object owner, boolean dumpAllLocks) {
        return StandardException.newException("40XL1", (Throwable)this.getLockTimeoutRuntimeException(lockObject, owner, dumpAllLocks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpAllRWLocks(String logPrefix, PrintWriter pw, boolean force) {
        GfxdLocalLockService gfxdLocalLockService = this;
        synchronized (gfxdLocalLockService) {
            long currentTime = System.currentTimeMillis();
            if (!force && this.lastDumpTime > 0L && currentTime - this.lastDumpTime < this.maxVMWriteLockWait) {
                return;
            }
            this.lastDumpTime = currentTime;
        }
        String marker = "=================================================================";
        StringBuilder msg = new StringBuilder();
        String thisToString = this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + '[' + this.serviceName + ']';
        LogWriterI18n logger = Misc.getI18NLogWriter();
        msg.append(thisToString).append(": ").append(logPrefix).append(SanityManager.lineSeparator).append("=================================================================").append(SanityManager.lineSeparator);
        try {
            GfxdReadWriteLock lock = null;
            for (Map.Entry lockEntry : this.entrySet()) {
                lock = (GfxdReadWriteLock)lockEntry.getValue();
                lock.dumpAllThreads(msg, lockEntry.getKey(), thisToString);
            }
            if (lock != null) {
                lock.dumpAllReaders(msg, thisToString);
            }
            GfxdDRWLockService.dumpAllDLockServices(msg);
            if (msg.length() > 1000000) {
                TXManagerImpl.dumpMessage((StringBuilder)msg, (PrintWriter)pw);
                msg.setLength(0);
            }
            msg.append(SanityManager.lineSeparator);
            TXManagerImpl.dumpAllTXStates((StringBuilder)msg, (String)"TX states");
            msg.append(SanityManager.lineSeparator);
            TXManagerImpl.dumpAllEntryLocks((StringBuilder)msg, (String)"Entry lock", (PrintWriter)pw);
            if (msg.length() > 1000000) {
                TXManagerImpl.dumpMessage((StringBuilder)msg, (PrintWriter)pw);
                msg.setLength(0);
            }
            msg.append(SanityManager.lineSeparator).append("Full Thread Dump:").append(SanityManager.lineSeparator).append(SanityManager.lineSeparator);
            GfxdLocalLockService.generateThreadDump(msg);
            msg.append("=================================================================").append(SanityManager.lineSeparator);
            TXManagerImpl.dumpMessage((StringBuilder)msg, (PrintWriter)pw);
        }
        catch (Exception ex) {
            logger.severe(LocalizedStrings.DEBUG, (Object)"Exception while dumping lock table of this JVM", (Throwable)ex);
        }
    }

    public static void generateThreadDump(StringBuilder msg) {
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo tInfo : mbean.dumpAllThreads(true, true)) {
            ClientSharedUtils.dumpThreadStack((ThreadInfo)tInfo, (StringBuilder)msg, (String)SanityManager.lineSeparator);
        }
    }

    private boolean localWriteLock(Object name, GfxdReadWriteLock rwLock, Object owner, long waitTimeMillis) {
        if (owner instanceof DistributedLockOwner) {
            ((DistributedLockOwner)owner).setVMCreatorThread();
        }
        return rwLock.attemptWriteLock(waitTimeMillis, owner);
    }

    @SuppressWarnings(value={"IMSE_DONT_CATCH_IMSE"}, justification="lock-service code is allowed to catch this exception")
    private boolean localWriteUnlock(GfxdReadWriteLock rwLock, Object owner) {
        if (rwLock != null) {
            try {
                rwLock.releaseWriteLock(owner);
                return true;
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
        return false;
    }

    GfxdReadWriteLock getOrCreateLock(Object name) {
        return this.getOrCreateLock(name, null);
    }

    private GfxdReadWriteLock getOrCreateLock(Object name, GfxdReadWriteLock origLock) {
        GfxdReadWriteLock rwLock = (GfxdReadWriteLock)this.get(name);
        if (rwLock == null) {
            if (origLock != null) {
                rwLock = origLock;
            } else {
                rwLock = this.lockTemplate.newLock(name);
                rwLock.setInMap(true);
            }
            GfxdReadWriteLock oldLock = this.putIfAbsent(name, rwLock);
            if (oldLock != null) {
                rwLock = oldLock;
            } else if (origLock != null) {
                rwLock.setInMap(true);
            }
        }
        return rwLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GfxdReadWriteLock getOrCreateLock(GfxdLockable lockable, Object name) {
        GfxdReadWriteLock rwLock = lockable.getReadWriteLock();
        if (rwLock != null && rwLock.inMap()) {
            return rwLock;
        }
        GfxdLockable gfxdLockable = lockable;
        synchronized (gfxdLockable) {
            rwLock = this.getOrCreateLock(name, rwLock);
            lockable.setReadWriteLock(rwLock);
            if (lockable.traceLock()) {
                rwLock.setTraceLock();
            }
        }
        return rwLock;
    }

    public static class DistributedLockOwner
    extends GfxdDataSerializable {
        private InternalDistributedMember ownerMember;
        private long ownerThreadId;
        private String ownerThreadName;
        private transient Thread vmCreatorThread;

        public DistributedLockOwner() {
        }

        protected DistributedLockOwner(InternalDistributedMember myId) {
            this(myId, EventID.getThreadId());
        }

        protected DistributedLockOwner(InternalDistributedMember myId, long threadId) {
            this.ownerMember = myId;
            this.ownerThreadId = threadId;
            this.vmCreatorThread = Thread.currentThread();
            this.ownerThreadName = this.vmCreatorThread.toString();
        }

        public final InternalDistributedMember getOwnerMember() {
            return this.ownerMember;
        }

        public final long getOwnerThreadId() {
            return this.ownerThreadId;
        }

        public final String getOwnerThreadName() {
            return this.ownerThreadName;
        }

        protected final Thread getVMCreatorThread() {
            return this.vmCreatorThread;
        }

        protected final void setVMCreatorThread() {
            this.vmCreatorThread = Thread.currentThread();
        }

        public int hashCode() {
            long threadId = this.ownerThreadId;
            if (threadId <= 32767L) {
                return this.ownerMember.hashCode() ^ (int)(threadId << 16);
            }
            if (threadId <= Integer.MAX_VALUE) {
                return this.ownerMember.hashCode() ^ (int)threadId;
            }
            return this.ownerMember.hashCode() ^ (int)(threadId ^ threadId >>> 32);
        }

        public boolean equals(Object other) {
            if (other instanceof DistributedLockOwner) {
                DistributedLockOwner otherOwner = (DistributedLockOwner)other;
                return this.ownerThreadId == otherOwner.ownerThreadId && this.ownerMember.equals(otherOwner.ownerMember);
            }
            return false;
        }

        public String toString() {
            return "DistributedLockOwner(member=" + this.ownerMember + ",threadId=" + this.ownerThreadId + ",ownerThread=" + this.ownerThreadName + ",vmCreatorThread=" + this.getVMCreatorThread() + ')';
        }

        @Override
        public byte getGfxdID() {
            return 88;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            this.ownerMember.toData(out);
            InternalDataSerializer.writeSignedVL((long)this.ownerThreadId, (DataOutput)out);
            DataSerializer.writeString((String)this.ownerThreadName, (DataOutput)out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.ownerMember = new InternalDistributedMember();
            this.ownerMember.fromData(in);
            this.ownerThreadId = InternalDataSerializer.readSignedVL((DataInput)in);
            this.ownerThreadName = DataSerializer.readString((DataInput)in);
        }
    }
}

