/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler;

import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.ArrayPathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.EvaluationContextImpl;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.FilterPathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.PathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.PropertyPathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.WildcardPathToken;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

class ScanPathToken
extends PathToken {
    ScanPathToken() {
    }

    @Override
    void evaluate(String currentPath, Object model, EvaluationContextImpl ctx) {
        if (this.isLeaf()) {
            ctx.addResult(currentPath, model);
            return;
        }
        Predicate predicate = this.createScanPredicate(this.next(), ctx);
        LinkedHashMap<String, Object> predicateMatches = new LinkedHashMap<String, Object>();
        this.walk(currentPath, model, ctx, predicate, predicateMatches);
        PathToken next = this.next();
        if (next instanceof FilterPathToken) {
            if (next.isLeaf()) {
                for (Map.Entry match : predicateMatches.entrySet()) {
                    ctx.addResult((String)match.getKey(), match.getValue());
                }
                return;
            }
            next = next.next();
        }
        for (Map.Entry match : predicateMatches.entrySet()) {
            next.evaluate((String)match.getKey(), match.getValue(), ctx);
        }
    }

    public void walk(String currentPath, Object model, EvaluationContextImpl ctx, Predicate predicate, Map<String, Object> predicateMatches) {
        if (ctx.jsonProvider().isPdxInstance(model)) {
            this.walkObject(currentPath, model, ctx, predicate, predicateMatches);
        } else if (ctx.jsonProvider().isArray(model)) {
            this.walkArray(currentPath, model, ctx, predicate, predicateMatches);
        }
    }

    public void walkArray(String currentPath, Object model, EvaluationContextImpl ctx, Predicate predicate, Map<String, Object> predicateMatches) {
        if (predicate.matches(model)) {
            predicateMatches.put(currentPath, model);
        }
        Iterable<Object> models = ctx.jsonProvider().toIterable(model);
        int idx = 0;
        for (Object evalModel : models) {
            String evalPath = currentPath + "[" + idx + "]";
            if (predicate.clazz().equals(FilterPathToken.class) && predicate.matches(evalModel)) {
                predicateMatches.put(evalPath, evalModel);
            }
            this.walk(evalPath, evalModel, ctx, predicate, predicateMatches);
            ++idx;
        }
    }

    public void walkObject(String currentPath, Object model, EvaluationContextImpl ctx, Predicate predicate, Map<String, Object> predicateMatches) {
        if (predicate.matches(model)) {
            predicateMatches.put(currentPath, model);
        }
        Collection<String> properties = ctx.jsonProvider().getPropertyKeys(model);
        for (String property : properties) {
            String evalPath = currentPath + "['" + property + "']";
            Object propertyModel = ctx.jsonProvider().getPDXValue(model, property);
            this.walk(evalPath, propertyModel, ctx, predicate, predicateMatches);
        }
    }

    private Predicate createScanPredicate(final PathToken target, final EvaluationContextImpl ctx) {
        if (target instanceof PropertyPathToken) {
            return new Predicate(){
                private PropertyPathToken propertyPathToken;
                {
                    this.propertyPathToken = (PropertyPathToken)target;
                }

                @Override
                public Class<?> clazz() {
                    return PropertyPathToken.class;
                }

                @Override
                public boolean matches(Object model) {
                    Collection<String> keys = ctx.jsonProvider().getPropertyKeys(model);
                    return keys.containsAll(this.propertyPathToken.getProperties());
                }
            };
        }
        if (target instanceof ArrayPathToken) {
            return new Predicate(){

                @Override
                public Class<?> clazz() {
                    return ArrayPathToken.class;
                }

                @Override
                public boolean matches(Object model) {
                    return ctx.jsonProvider().isArray(model);
                }
            };
        }
        if (target instanceof WildcardPathToken) {
            return new Predicate(){

                @Override
                public Class<?> clazz() {
                    return WildcardPathToken.class;
                }

                @Override
                public boolean matches(Object model) {
                    return true;
                }
            };
        }
        if (target instanceof FilterPathToken) {
            return new Predicate(){
                private FilterPathToken filterPathToken;
                {
                    this.filterPathToken = (FilterPathToken)target;
                }

                @Override
                public Class<?> clazz() {
                    return FilterPathToken.class;
                }

                @Override
                public boolean matches(Object model) {
                    return this.filterPathToken.accept(model, ctx.configuration());
                }
            };
        }
        return new Predicate(){

            @Override
            public Class<?> clazz() {
                return null;
            }

            @Override
            public boolean matches(Object model) {
                return false;
            }
        };
    }

    @Override
    boolean isTokenDefinite() {
        return false;
    }

    @Override
    public String getPathFragment() {
        return "..";
    }

    private static interface Predicate {
        public Class<?> clazz();

        public boolean matches(Object var1);
    }
}

