/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.utils;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.IsolationLevel;
import com.gemstone.gemfire.cache.LockTimeoutException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TransactionFlag;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.ServerLocator;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalPartitionResolver;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.VMIdAdvisor;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.locks.ExclusiveSharedLockObject;
import com.gemstone.gemfire.internal.cache.locks.ExclusiveSharedSynchronizer;
import com.gemstone.gemfire.internal.cache.locks.LockMode;
import com.gemstone.gemfire.internal.cache.locks.LockingPolicy;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreFilter;
import com.gemstone.gemfire.internal.cache.persistence.OplogType;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.HostLocationBase;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gemfire.internal.shared.StringPrintWriter;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.util.ArraySortedCollectionWithOverflow;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gemfire.management.internal.JmxManagerAdvisor;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.GfxdSystemProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.messages.GfxdSystemProcedureMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.GfxdBulkDMLCommand;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.WBCLEventImpl;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.GfxdCBArgForSynchPrms;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdSingleResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdConfigMessage;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.jdbc.GfxdDDLReplayInProgressException;
import com.pivotal.gemfirexd.internal.engine.locks.DefaultGfxdLockable;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdDRWLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLocalLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockSet;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockable;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.CompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.engine.store.entry.GfxdObjectFactoriesProvider;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.ShutdownException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.StatementReader;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.AssertFailure;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.AutoExpandingBufferWriteTransport;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;

public final class GemFireXDUtils {
    public static final int IntegerBytesLen = 4;
    private static boolean optimizerTrace = Boolean.getBoolean("gemfirexd.optimizer.trace");
    private static final ConcurrentHashMap<Object, GfxdLockable> lockableMap = new ConcurrentHashMap();
    private static long defaultRecoveryDelay = -1L;
    private static long defaultStartupRecoveryDelay = 0L;
    private static int defaultInitialCapacity = 10000;
    public static long DML_MAX_CHUNK_SIZE = 0x400000L;
    public static long DML_MIN_SIZE_FOR_STREAMING = 524288L;
    public static int DML_MAX_CHUNK_MILLIS = 8;
    public static int DML_SAMPLE_INTERVAL = 16;
    public static int DML_BULK_FETCH_SIZE = 32;
    public static boolean PROCEDURE_ORDER_RESULTS = false;
    public static boolean IS_TEST_MODE = false;
    private static VMIdAdvisor vmIdAdvisor;
    public static final Object MIN_KEY;
    public static final Object MAX_KEY;
    private static final ThreadLocal<EmbedConnection> tssConn;
    public static final SortedSet<String> SET_MAX;
    private static final Pattern USER_PASSWORD_PATTERN;
    private static final String delimiters = ")\\]},;";
    private static final Pattern GENERIC_PASSWORD_PATTERN;
    private static final String randChooseStr = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final char[] randChooseChars;
    public static final SharedUtils.CSVVisitor<Set<ServerLocation>, int[]> addServerLocations;
    public static boolean TraceExecution;
    public static boolean TraceQuery;
    public static boolean TraceIndex;
    public static boolean TraceLock;
    public static boolean TraceConglom;
    public static boolean TraceConglomUpdate;
    public static boolean TraceConglomRead;
    public static boolean TraceTran;
    public static boolean TraceTranVerbose;
    public static boolean TraceRSIter;
    public static boolean TraceAggreg;
    public static boolean TraceGroupByQI;
    public static boolean TraceGroupByIter;
    public static boolean TraceActivation;
    public static boolean TraceAuthentication;
    public static boolean TraceHeapThresh;
    public static boolean TraceMembers;
    public static boolean TraceDDLQueue;
    public static boolean TraceDDLReplay;
    public static boolean TraceConflation;
    public static boolean TraceDBSynchronizer;
    public static boolean TraceDBSynchronizerHA;
    public static boolean TraceSysProcedures;
    public static boolean TraceFabricServiceBoot;
    public static boolean TraceFunctionException;
    public static boolean TraceProcedureExecution;
    public static boolean TraceStatementMatching;
    public static boolean TraceConnectionSignaller;
    public static boolean TraceTrigger;
    public static boolean TraceByteComparisonOptimization;
    public static boolean TracePlanGeneration;
    public static boolean TracePlanAssertion;
    public static boolean TraceStatsGeneration;
    public static boolean TraceRowFormatter;
    public static boolean TraceCM;
    public static boolean TraceTempFileIO;
    public static boolean TraceApplicationJars;
    public static boolean TraceOuterJoin;
    public static boolean TraceSortTuning;
    public static boolean TraceImport;
    public static boolean TraceNCJ;
    public static boolean TraceNCJIter;
    public static boolean TraceNCJDump;
    public static boolean TracePersistIndex;
    public static boolean TracePersistIndexFiner;
    public static boolean TracePersistIndexFinest;
    public static boolean TraceThriftAPI;
    public static boolean TraceSavePoints;
    public static boolean TraceParseTree;
    public static boolean TraceStopAfterParse;

    private GemFireXDUtils() {
    }

    public static void initConstants(GemFireStore store) throws StandardException {
        String defaultRecoveryDelayStr = PropertyUtil.getSystemProperty(GfxdConstants.DEFAULT_RECOVERY_DELAY_SYSPROP);
        if (defaultRecoveryDelayStr == null) {
            defaultRecoveryDelayStr = store.getBootProperty("default-recovery-delay");
        }
        try {
            defaultRecoveryDelay = defaultRecoveryDelayStr != null ? Long.parseLong(defaultRecoveryDelayStr) : -1L;
        }
        catch (Exception ex) {
            throw StandardException.newException("22018", new GemFireXDRuntimeException("unexpected format for boot/sys property default-recovery-delay where a long was expected: " + defaultRecoveryDelayStr), (Object)"BIGINT", (Object)null);
        }
        String defaultStartupRecoveryDelayStr = PropertyUtil.getSystemProperty(GfxdConstants.DEFAULT_STARTUP_RECOVERY_DELAY_SYSPROP);
        if (defaultStartupRecoveryDelayStr == null) {
            defaultStartupRecoveryDelayStr = store.getBootProperty("default-startup-recovery-delay");
        }
        try {
            if (defaultStartupRecoveryDelayStr != null) {
                GemFireXDUtils.setDefaultStartupRecoveryDelay(Long.parseLong(defaultStartupRecoveryDelayStr));
            } else {
                GemFireXDUtils.setDefaultStartupRecoveryDelay(0L);
            }
        }
        catch (Exception ex) {
            throw StandardException.newException("22018", new GemFireXDRuntimeException("unexpected format for boot/sys property default-startup-recovery-delay where a long was expected: " + defaultStartupRecoveryDelayStr), (Object)"BIGINT", (Object)null);
        }
        String defaultInitialCapacityStr = PropertyUtil.getSystemProperty(GfxdConstants.DEFAULT_INITIAL_CAPACITY_SYSPROP);
        if (defaultInitialCapacityStr == null) {
            defaultInitialCapacityStr = store.getBootProperty("default-initial-capacity");
        }
        try {
            defaultInitialCapacity = defaultInitialCapacityStr != null ? Integer.parseInt(defaultInitialCapacityStr) : 10000;
        }
        catch (Exception ex) {
            throw StandardException.newException("22018", new GemFireXDRuntimeException("unexpected format for boot/sys property default-initial-capacity where an integer was expected: " + defaultInitialCapacityStr), (Object)"INTEGER", (Object)null);
        }
        String propStr = PropertyUtil.getServiceProperty(store, GfxdConstants.DML_MAX_CHUNK_SIZE_PROP);
        if (propStr != null) {
            try {
                DML_MAX_CHUNK_SIZE = Long.parseLong(propStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((propStr = PropertyUtil.getServiceProperty(store, GfxdConstants.DML_MIN_SIZE_FOR_STREAMING_PROP)) != null) {
            try {
                DML_MIN_SIZE_FOR_STREAMING = Long.parseLong(propStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        DML_MAX_CHUNK_MILLIS = PropertyUtil.getServiceInt(store, GfxdConstants.DML_MAX_CHUNK_MILLIS_PROP, 0, Integer.MAX_VALUE, 8);
        DML_SAMPLE_INTERVAL = PropertyUtil.getServiceInt(store, GfxdConstants.DML_SAMPLE_INTERVAL_PROP, 0, Integer.MAX_VALUE, 16);
        DML_BULK_FETCH_SIZE = PropertyUtil.getServiceInt(store, "gemfirexd.language.bulkFetchDefault", 0, Integer.MAX_VALUE, 32);
        PROCEDURE_ORDER_RESULTS = PropertyUtil.getServiceBoolean(store, GfxdConstants.PROCEDURE_ORDER_RESULTS_PROP, false);
        GemFireCacheImpl cache = store.getGemFireCache();
        vmIdAdvisor = cache.getDistributedSystem().getVMIdAdvisor();
        LogWriterI18n logger = cache.getLoggerI18n();
        SanityManager.isFineEnabled = false;
        SanityManager.isFinerEnabled = false;
        if (logger.fineEnabled()) {
            SanityManager.isFineEnabled = true;
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceDDLQueue");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceDDLReplay");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceConflation");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceConglom");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceConglomUpdate");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceFabricServiceBoot");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceFunctionException");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceProcedureExecution");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceJars");
            SanityManager.TRACE_SET_IF_ABSENT((String)"QueryDistribution");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceExecution");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceSystemProcedures");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceByteCompareOptimization");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceClientHA");
            SanityManager.TRACE_SET_IF_ABSENT((String)"StatementMatching");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TracePlanGeneration");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceStatsGeneration");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TracePersistIndex");
            SanityManager.TRACE_SET_IF_ABSENT((String)"TraceThriftAPI");
            if (logger.finerEnabled()) {
                SanityManager.isFinerEnabled = true;
                SanityManager.TRACE_SET_IF_ABSENT((String)"TraceActivation");
                SanityManager.TRACE_SET_IF_ABSENT((String)"TraceDBSynchronizer");
                SanityManager.TRACE_SET_IF_ABSENT((String)"TraceTran");
                SanityManager.TRACE_SET_IF_ABSENT((String)"TraceAuthentication");
                SanityManager.TRACE_SET_IF_ABSENT((String)"TraceTempFileIO");
                SanityManager.TRACE_SET_IF_ABSENT((String)"TraceConnectionSignaller");
                SanityManager.TRACE_SET_IF_ABSENT((String)"TraceTrigger");
                SanityManager.TRACE_SET_IF_ABSENT((String)"TraceLock_DD");
                SanityManager.TRACE_SET_IF_ABSENT((String)"TraceNCJ");
                SanityManager.TRACE_SET_IF_ABSENT((String)"TracePersistIndexFiner");
                SanityManager.TRACE_SET_IF_ABSENT((String)"traceSavepoints");
                if (logger.finestEnabled()) {
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceAggregation");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceConglomRead");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceGroupByRSIteration");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceGroupByQI");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceHeapThreshold");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceIndex");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceLock_*");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceMembers");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceRSIteration");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceNCJIter");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceTranVerbose");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TraceCM");
                    SanityManager.TRACE_SET_IF_ABSENT((String)"TracePersistIndexFinest");
                }
            }
        }
        GemFireXDUtils.initFlags();
        GfxdObjectFactoriesProvider.dummy();
        GfxdBulkDMLCommand.dummy();
    }

    public static RegionKey convertIntoGemfireRegionKey(DataValueDescriptor dvd, GemFireContainer container, boolean doClone) throws StandardException {
        if (container.isByteArrayStore()) {
            return new CompactCompositeRegionKey(dvd, container.getExtraTableInfo());
        }
        if (container.isObjectStore()) {
            return container.getRowEncoder().fromRowToKey(new DataValueDescriptor[]{dvd}, container);
        }
        return doClone ? dvd.getClone() : dvd;
    }

    public static RegionKey convertIntoGemfireRegionKey(DataValueDescriptor[] compositeKeys, GemFireContainer container, boolean doClone) throws StandardException {
        if (container.isByteArrayStore()) {
            return new CompactCompositeRegionKey(compositeKeys, container.getExtraTableInfo());
        }
        if (container.isObjectStore()) {
            return container.getRowEncoder().fromRowToKey(compositeKeys, container);
        }
        if (compositeKeys.length == 1) {
            return doClone ? compositeKeys[0].getClone() : compositeKeys[0];
        }
        if (doClone) {
            for (int index = 0; index < compositeKeys.length; ++index) {
                DataValueDescriptor clone;
                compositeKeys[index] = clone = compositeKeys[index].getClone();
            }
        }
        return new CompositeRegionKey(compositeKeys);
    }

    public static RegionKey convertIntoGemFireRegionKey(ExecRow row, GemFireContainer gfContainer, ExtraTableInfo tableInfo, int[] pkCols) throws StandardException {
        if (row instanceof AbstractCompactExecRow) {
            AbstractCompactExecRow crow = (AbstractCompactExecRow)row;
            Object keyRow = crow.getByteSource();
            if (keyRow == null || keyRow.getClass() == byte[].class) {
                byte[] keyBytes = (byte[])keyRow;
                if (tableInfo == null) {
                    tableInfo = gfContainer.getExtraTableInfo(keyBytes);
                }
                return new CompactCompositeRegionKey(keyBytes, tableInfo);
            }
            OffHeapByteSource keyBS = (OffHeapByteSource)((Object)keyRow);
            if (tableInfo == null) {
                tableInfo = gfContainer.getExtraTableInfo(keyBS);
            }
            return new CompactCompositeRegionKey(keyBS, tableInfo);
        }
        if (pkCols == null) {
            if (tableInfo == null) {
                tableInfo = gfContainer.getExtraTableInfo();
            }
            pkCols = tableInfo.getPrimaryKeyColumns();
        }
        if (pkCols.length == 1) {
            DataValueDescriptor dvd = row.getColumn(pkCols[0] + 1);
            if (dvd != null) {
                return GemFireXDUtils.convertIntoGemfireRegionKey(dvd, gfContainer, true);
            }
            return null;
        }
        DataValueDescriptor[] dvdarr = new DataValueDescriptor[pkCols.length];
        for (int i = 0; i < pkCols.length; ++i) {
            dvdarr[i] = row.getColumn(pkCols[i] + 1);
            if (dvdarr[i] != null) continue;
            return null;
        }
        return GemFireXDUtils.convertIntoGemfireRegionKey(dvdarr, gfContainer, true);
    }

    public static Object compare(Object obj1, Object obj2, int compOp) throws StandardException {
        if (obj1 == null || obj2 == null) {
            Boolean result = GemFireXDUtils.nullCompare(obj1, obj2, compOp);
            return result;
        }
        if (!(obj1 instanceof Comparable) || !(obj2 instanceof Comparable)) {
            if (compOp == 1) {
                return obj1.equals(obj2);
            }
            if (compOp == 2) {
                return !obj1.equals(obj2);
            }
            throw StandardException.newException("XCL15.S", obj1, (Object)ClassInspector.readableClassName(obj2.getClass()));
        }
        int r = ((Comparable)obj1).compareTo(obj2);
        switch (compOp) {
            case 1: {
                return r == 0;
            }
            case 5: {
                return r < 0;
            }
            case 6: {
                return r <= 0;
            }
            case 3: {
                return r > 0;
            }
            case 4: {
                return r >= 0;
            }
            case 2: {
                return r != 0;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + compOp);
    }

    public static int fetchValue(DataValueDescriptor[] key, DataValueDescriptor[] keyValues, int[] keyScanList) throws StandardException {
        if (keyScanList == null) {
            for (int index = 0; index < key.length; ++index) {
                assert (keyValues[index] != null);
                keyValues[index].setValue(key[index]);
            }
            return key.length;
        }
        for (int index = 0; index < keyScanList.length; ++index) {
            assert (keyScanList[index] < key.length);
            assert (keyValues[keyScanList[index]] != null);
            keyValues[keyScanList[index]].setValue(key[keyScanList[index]]);
        }
        return keyScanList.length;
    }

    public static int fetchValue(CompactCompositeIndexKey key, DataValueDescriptor[] keyValues, int[] keyScanList) throws StandardException {
        if (keyScanList == null) {
            int nCols = key.nCols();
            for (int index = 0; index < nCols; ++index) {
                assert (keyValues[index] != null);
                key.setKeyColumn(keyValues[index], index);
            }
            return nCols;
        }
        for (int colIndex : keyScanList) {
            assert (colIndex < key.nCols());
            assert (keyValues[colIndex] != null);
            key.setKeyColumn(keyValues[colIndex], colIndex);
        }
        return keyScanList.length;
    }

    private static Boolean nullCompare(Object obj1, Object obj2, int compOp) {
        switch (compOp) {
            case 1: {
                if (obj1 == null) {
                    return obj2 == null;
                }
                return false;
            }
            case 2: {
                if (obj1 == null) {
                    return obj2 != null;
                }
                return true;
            }
        }
        return null;
    }

    public static int compareKeys(Object firstKey, Object secondKey) {
        if (firstKey == secondKey) {
            return 0;
        }
        if (firstKey == MIN_KEY || firstKey == null) {
            return -1;
        }
        if (secondKey == MIN_KEY || secondKey == null) {
            return 1;
        }
        if (secondKey == MAX_KEY) {
            return -1;
        }
        if (firstKey == MAX_KEY) {
            return 1;
        }
        if (secondKey.getClass().isInstance(firstKey)) {
            if (firstKey instanceof Comparable) {
                return ((Comparable)firstKey).compareTo(secondKey);
            }
            if (firstKey.equals(secondKey)) {
                return 0;
            }
        }
        return firstKey.hashCode() < secondKey.hashCode() ? -1 : 1;
    }

    public static GfxdDistributionAdvisor getGfxdAdvisor() {
        GfxdDistributionAdvisor advisor = Misc.getMemStoreBooting().getDistributionAdvisor();
        if (advisor != null) {
            return advisor;
        }
        throw new CacheClosedException("GemFireXDUtils#getGfxdAdvisor: no advisor found. GemFireXD not booted or closed down.");
    }

    public static GfxdDistributionAdvisor.GfxdProfile getGfxdProfile(DistributedMember member) {
        return GemFireXDUtils.getGfxdAdvisor().getProfile((InternalDistributedMember)member);
    }

    public static GemFireStore.VMKind getVMKind(DistributedMember member) {
        GfxdDistributionAdvisor.GfxdProfile profile = GemFireXDUtils.getGfxdProfile(member);
        if (profile != null) {
            return profile.getVMKind();
        }
        return null;
    }

    public static String getManagerInfo(DistributedMember member) {
        List willingToManager;
        GemFireCacheImpl gfc = GemFireCacheImpl.getExisting();
        if (null == gfc) {
            return "Managed Node";
        }
        List alreadyManaging = gfc.getJmxManagerAdvisor().adviseAlreadyManaging();
        if (!alreadyManaging.isEmpty()) {
            for (JmxManagerAdvisor.JmxManagerProfile p : alreadyManaging) {
                if (!p.getDistributedMember().equals((Object)member)) continue;
                return "Manager Node: Running";
            }
        }
        if (!(willingToManager = gfc.getJmxManagerAdvisor().adviseWillingToManage()).isEmpty()) {
            for (JmxManagerAdvisor.JmxManagerProfile p : willingToManager) {
                if (!p.getDistributedMember().equals((Object)member)) continue;
                return "Manager Node: Not Running";
            }
        }
        return "Managed Node";
    }

    public static GemFireStore.VMKind getMyVMKind() {
        GemFireStore store = GemFireStore.getBootingInstance();
        return store != null ? store.getMyVMKind() : null;
    }

    public static GfxdDistributionAdvisor.GfxdProfile getMyProfile(boolean throwIfAbsent) {
        GfxdDistributionAdvisor.GfxdProfile profile;
        GemFireStore store = GemFireStore.getBootingInstance();
        GfxdDistributionAdvisor.GfxdProfile gfxdProfile = profile = store != null ? store.getDistributionAdvisor().getMyProfile() : null;
        if (profile == null && throwIfAbsent) {
            throw new CacheClosedException("GemFireXDUtils.getMyProfile: no store found. GemFireXD not booted or closed down.");
        }
        return profile;
    }

    public static long newUUID() throws IllegalStateException {
        long retVal = vmIdAdvisor != null ? vmIdAdvisor.newUUID(false) : Misc.getDistributedSystem().newUUID(false);
        GemFireXDQueryObserver sqo = GemFireXDQueryObserverHolder.getInstance();
        if (sqo != null) {
            retVal = sqo.overrideUniqueID(retVal, false);
        }
        return retVal;
    }

    public static long newUUIDForDD() throws IllegalStateException, StandardException {
        return Misc.getMemStoreBooting().getDDLStmtQueue().newUUID();
    }

    public static InternalDistributedMember getDistributedMemberFromUUID(long uuid) {
        int vmUniqueId = (int)(uuid >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        return vmIdAdvisor.adviseDistributedMember((long)vmUniqueId, false);
    }

    public static InternalDistributedMember getDistributedMemberFromVMId(int vmUniqueId) {
        return vmIdAdvisor.adviseDistributedMember((long)vmUniqueId, false);
    }

    public static int getVMUniqueIdFromUUid(long uuid) {
        return (int)(uuid >>> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    public static int newShortUUID() throws IllegalStateException {
        return vmIdAdvisor.newShortUUID();
    }

    public static final byte set(byte flags, byte mask, boolean on) {
        return (byte)(on ? flags | mask : flags & ~mask);
    }

    public static final byte set(byte flags, byte mask) {
        return (byte)(flags | mask);
    }

    public static final byte clear(byte flags, byte mask) {
        return (byte)(flags & ~mask);
    }

    public static final boolean isSet(byte flags, byte mask) {
        return (flags & mask) != 0;
    }

    public static final short set(short flags, short mask, boolean on) {
        return (short)(on ? flags | mask : flags & ~mask);
    }

    public static final short set(short flags, short mask) {
        return (short)(flags | mask);
    }

    public static final short clear(short flags, short mask) {
        return (short)(flags & ~mask);
    }

    public static final boolean isSet(short flags, short mask) {
        return (flags & mask) != 0;
    }

    public static final int set(int flags, int mask, boolean on) {
        return on ? flags | mask : flags & ~mask;
    }

    public static final int set(int flags, int mask) {
        return flags | mask;
    }

    public static final int clear(int flags, int mask) {
        return flags & ~mask;
    }

    public static final boolean isSet(int flags, int mask) {
        return (flags & mask) == mask;
    }

    public static EmbedConnection getTSSConnection(boolean skipLocks, boolean remoteConnection, boolean remoteConnectionForDDL) throws StandardException {
        EmbedConnection conn = tssConn.get();
        if (conn == null || conn.isClosed()) {
            conn = GemFireXDUtils.createNewInternalConnection(remoteConnection);
            tssConn.set(conn);
        }
        LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
        lcc.setIsConnectionForRemote(remoteConnection);
        lcc.setIsConnectionForRemoteDDL(remoteConnectionForDDL);
        lcc.setSkipLocks(skipLocks);
        GemFireTransaction tran = (GemFireTransaction)lcc.getTransactionExecute();
        tran.resetActiveTXState(true);
        return conn;
    }

    public static EmbedConnection getTSSConnection() throws StandardException {
        EmbedConnection conn = tssConn.get();
        if (conn == null || conn.isClosed()) {
            conn = GemFireXDUtils.createNewInternalConnection(true);
            tssConn.set(conn);
        }
        LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
        GemFireTransaction tran = (GemFireTransaction)lcc.getTransactionExecute();
        tran.resetActiveTXState(true);
        return conn;
    }

    public static EmbedConnection createNewInternalConnection(boolean remoteConnection) throws StandardException {
        return GemFireXDUtils.createNewInternalConnection(remoteConnection, -2L);
    }

    public static EmbedConnection createNewInternalConnection(boolean remoteConnection, long connId) throws StandardException {
        try {
            Properties props = new Properties();
            GemFireStore memStore = Misc.getMemStoreBooting();
            props.putAll((Map<?, ?>)memStore.getDatabase().getAuthenticationService().getBootCredentials());
            String protocol = memStore.isSnappyStore() ? "jdbc:snappydata:" : "jdbc:gemfirexd:";
            EmbedConnection conn = InternalDriver.activeDriver().connect(protocol, props, connId, connId, remoteConnection, 0);
            if (conn != null) {
                conn.setInternalConnection();
                ConnectionStats stats = InternalDriver.activeDriver().getConnectionStats();
                if (stats != null) {
                    stats.incInternalConnectionsOpen();
                    stats.incInternalConnectionsOpened();
                }
                return conn;
            }
        }
        catch (Throwable t) {
            Error err;
            if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                SystemFailure.initiateFailure((Error)err);
                throw err;
            }
            SystemFailure.checkFailure();
            Misc.checkIfCacheClosing(t);
            throw StandardException.newException("08003", t);
        }
        throw StandardException.newException("08003", new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString()));
    }

    public static Object getRoutingObjectFromGlobalIndex(LocalRegion region, Object key, Object value) throws StandardException {
        GfxdPartitionResolver resolver = GemFireXDUtils.getResolver((AbstractRegion)region);
        if (resolver != null && (resolver.requiresGlobalIndex() || resolver.requiresConnectionContext())) {
            try {
                return resolver.getRoutingObject(key, value, (Region<?, ?>)region);
            }
            catch (GemFireException gfeex) {
                throw Misc.processGemFireException(gfeex, gfeex, "lookup of global index for key " + key, true);
            }
        }
        return null;
    }

    public static boolean isGlobalIndexCase(AbstractRegion region) {
        GfxdPartitionResolver resolver = GemFireXDUtils.getResolver(region);
        return resolver != null && resolver.requiresGlobalIndex();
    }

    public static Object getRoutingObjectFromGlobalIndex(Object key, RegionEntry entry, LocalRegion region) throws EntryDestroyedException, StandardException {
        GfxdPartitionResolver resolver = GemFireXDUtils.getResolver((AbstractRegion)region);
        if (resolver != null && (resolver.requiresGlobalIndex() || resolver.requiresConnectionContext())) {
            Object value = entry.getValueOffHeapOrDiskWithoutFaultIn(region);
            if (value == null || Token.isRemoved((Object)value)) {
                throw new EntryDestroyedException("getRoutingObjectFromGlobalIndex for key=" + key + " cannot be done as the value is destroyed");
            }
            try {
                Object object = resolver.getRoutingObject(key, value, (Region<?, ?>)region);
                return object;
            }
            catch (GemFireException gfeex) {
                throw Misc.processGemFireException(gfeex, gfeex, "lookup of global index for key " + key, true);
            }
            finally {
                OffHeapHelper.release((Object)value);
            }
        }
        return null;
    }

    public static GfxdPartitionResolver getResolver(AbstractRegion region) {
        PartitionResolver resolver;
        PartitionAttributes pattrs = region.getPartitionAttributes();
        if (pattrs != null && (resolver = pattrs.getPartitionResolver()) instanceof GfxdPartitionResolver) {
            return (GfxdPartitionResolver)resolver;
        }
        return null;
    }

    public static InternalPartitionResolver<?, ?> getInternalResolver(AbstractRegion region) {
        PartitionResolver resolver;
        PartitionAttributes pattrs = region.getPartitionAttributes();
        if (pattrs != null && (resolver = pattrs.getPartitionResolver()) instanceof InternalPartitionResolver) {
            return (InternalPartitionResolver)resolver;
        }
        return null;
    }

    public static Object getRoutingObject(int bucketId) {
        if (bucketId >= 0) {
            return bucketId;
        }
        return null;
    }

    private static <T> int setCompareNoSubset(SortedSet<T> groups1, SortedSet<T> groups2) {
        int groups2size;
        int groups1size;
        if (groups1 == groups2) {
            return 0;
        }
        if (groups1 != null) {
            if (groups1 == SET_MAX) {
                return 1;
            }
            groups1size = groups1.size();
        } else {
            groups1size = 0;
        }
        if (groups2 != null) {
            if (groups2 == SET_MAX) {
                return -1;
            }
            groups2size = groups2.size();
        } else {
            groups2size = 0;
        }
        if (groups1size == groups2size) {
            if (groups1size > 0) {
                Iterator iter1 = groups1.iterator();
                Iterator iter2 = groups2.iterator();
                while (iter1.hasNext()) {
                    if (iter1.next().equals(iter2.next())) continue;
                    return -2;
                }
            }
            return 0;
        }
        if (groups1size > groups2size) {
            return groups2size > 0 ? 3 : 1;
        }
        return groups1size > 0 ? -3 : -1;
    }

    public static <T> boolean setEquals(SortedSet<T> groups1, SortedSet<T> groups2) {
        return GemFireXDUtils.setCompareNoSubset(groups1, groups2) == 0;
    }

    public static <T> int setCompare(SortedSet<T> groups1, SortedSet<T> groups2) {
        int res = GemFireXDUtils.setCompareNoSubset(groups1, groups2);
        if (res == 3) {
            if (groups1.containsAll(groups2)) {
                return 1;
            }
        } else if (res == -3) {
            if (groups2.containsAll(groups1)) {
                return -1;
            }
        } else {
            return res;
        }
        return -2;
    }

    public static <S, T extends S> boolean setIntersect(Set<T> groups1, Set<T> groups2, Set<S> intersection) {
        if (groups1 == null || groups2 == null) {
            return false;
        }
        boolean intersect = false;
        if (groups1.size() > groups2.size()) {
            Set<T> tmp = groups1;
            groups1 = groups2;
            groups2 = tmp;
        }
        for (T obj : groups1) {
            if (!groups2.contains(obj)) continue;
            intersect = true;
            if (intersection == null) break;
            intersection.add(obj);
        }
        return intersect;
    }

    public static int setCompare(int[] left, int[] right) {
        if (left == right) {
            return 0;
        }
        if (left == null || right == null) {
            return -2;
        }
        TreeSet<Integer> leftSet = new TreeSet<Integer>();
        TreeSet<Integer> rightSet = new TreeSet<Integer>();
        for (int i : left) {
            leftSet.add(i);
        }
        for (int i : right) {
            rightSet.add(i);
        }
        return GemFireXDUtils.setCompare(leftSet, rightSet);
    }

    public static void sortColumns(int[] columnPositions, String[] columnNames) {
        int index;
        int len = columnPositions.length;
        if (len == 1) {
            return;
        }
        int[] originalPos = (int[])columnPositions.clone();
        String[] newColumns = new String[len];
        Arrays.sort(columnPositions);
        for (index = 0; index < len; ++index) {
            int newIndex = Arrays.binarySearch(columnPositions, originalPos[index]);
            newColumns[newIndex] = columnNames[index];
        }
        for (index = 0; index < len; ++index) {
            columnNames[index] = newColumns[index];
        }
    }

    public static int lockObjectNoThrow(GfxdLockable lockable, Object lockObject, boolean forUpdate, boolean localOnly, TransactionController tc, long maxWaitMillis) throws StandardException {
        GemFireTransaction tran;
        int success = 2;
        if (!(tc != null && Misc.initialDDLReplayInProgress() || (tran = (GemFireTransaction)tc) != null && tran.skipLocks(lockObject, lockable))) {
            if (tran != null) {
                tran.setActiveState();
            }
            if (lockable == null) {
                lockable = GemFireXDUtils.getOrCreateLockable(lockObject);
            }
            if (lockable.traceLock()) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("lockObject: acquiring " + (forUpdate ? "write" : "read") + " lock on object " + lockable + " [TX " + tran + "] for lock " + lockable.getReadWriteLock()));
            }
            if (tran != null) {
                success = tran.getLockSpace().acquireLock(lockable, maxWaitMillis, forUpdate, localOnly, forUpdate);
            } else {
                Object lockOwner;
                GfxdDRWLockService lockService = Misc.getMemStoreBooting().getDDLLockService();
                int n = success = GfxdLockSet.lock(lockService, lockable, lockOwner = lockService.newCurrentOwner(), maxWaitMillis, forUpdate, localOnly) ? 1 : 0;
            }
            if (success != 0) {
                if (lockable.traceLock()) {
                    SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("lockObject: acquired " + (forUpdate ? "write" : "read") + " lock on object " + lockable + " [TX " + tran + "] for lock " + lockable.getReadWriteLock()));
                }
            } else if (lockable.traceLock()) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("lockObject: FAILED " + (forUpdate ? "write" : "read") + " lock on object " + lockable + " [TX " + tran + "] for lock " + lockable.getReadWriteLock() + " in " + maxWaitMillis + "ms"));
            }
        }
        return success;
    }

    public static boolean lockObject(GfxdLockable lockable, Object lockObject, boolean forUpdate, TransactionController tc) throws StandardException {
        return GemFireXDUtils.lockObject(lockable, lockObject, forUpdate, false, tc, GfxdLockSet.MAX_LOCKWAIT_VAL);
    }

    public static boolean lockObject(GfxdLockable lockable, Object lockObject, boolean forUpdate, boolean localOnly, TransactionController tc, long maxWaitMillis) throws StandardException {
        int status = GemFireXDUtils.lockObjectNoThrow(lockable, lockObject, forUpdate, localOnly, tc, maxWaitMillis);
        if (status == 0) {
            GfxdLockService lockService = tc != null ? ((GemFireTransaction)tc).getLockSpace().getLockService() : Misc.getMemStoreBooting().getDDLLockService();
            throw lockService.getLockTimeoutException(lockable != null ? lockable : lockObject, tc != null ? ((GemFireTransaction)tc).getLockSpace().getOwner() : null, true);
        }
        return status == 1;
    }

    public static boolean unlockObject(GfxdLockable lockable, Object lockObject, boolean forUpdate, boolean localOnly, TransactionController tc) {
        GemFireTransaction tran;
        if (!(tc != null && Misc.initialDDLReplayInProgress() || (tran = (GemFireTransaction)tc) != null && tran.skipLocks())) {
            if (lockable == null) {
                lockable = GemFireXDUtils.getOrCreateLockable(lockObject);
            }
            if (lockable.traceLock()) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("unlockObject: releasing " + (forUpdate ? "write" : "read") + " lock on object " + lockable + " [TX " + tran + ']'));
            }
            if (tran != null) {
                return tran.getLockSpace().releaseLock(lockable, forUpdate, localOnly);
            }
            GfxdDRWLockService lockService = Misc.getMemStoreBooting().getDDLLockService();
            Object lockOwner = lockService.newCurrentOwner();
            GfxdLockSet.unlock(lockService, lockable, lockOwner, forUpdate, localOnly);
            return true;
        }
        return false;
    }

    public static void freeLockResources(Object lockObject, TransactionController tc) throws StandardException {
        GfxdLockable lockable = lockableMap.remove(lockObject);
        if (lockable != null) {
            GfxdLockSet lockSet = ((GemFireTransaction)tc).getLockSpace();
            lockSet.addToFreeResources(lockable);
        }
    }

    private static GfxdLockable getOrCreateLockable(Object lockObject) {
        GfxdLockable oldLockable;
        GfxdLockable lockable = lockableMap.get(lockObject);
        if (lockable == null && (oldLockable = lockableMap.putIfAbsent(lockObject, lockable = new DefaultGfxdLockable(lockObject, null))) != null) {
            lockable = oldLockable;
        }
        return lockable;
    }

    public static boolean lockForRead(TXState tx, LockingPolicy lockPolicy, LockMode mode, int lockFlags, RegionEntry entry, GemFireContainer container, LocalRegion dataRegion, GemFireXDQueryObserver observer) {
        assert (dataRegion != null) : "unexpected null data region for " + entry + " in container " + container;
        TXId txId = tx.getTransactionId();
        if (observer != null) {
            observer.lockingRowForTX(tx.getProxy(), container, entry, false);
        }
        lockPolicy.acquireLock((ExclusiveSharedLockObject)entry, mode, lockFlags, (Object)txId, (Object)dataRegion, null);
        if (!entry.isDestroyedOrRemoved()) {
            return true;
        }
        GemFireXDUtils.unlockEntryAfterRead(txId, lockPolicy, mode, entry, container, dataRegion);
        return false;
    }

    public static boolean releaseLockForReadOnPreviousEntry(RegionEntry currEntry, TXState localTXState, TXId txId, LockingPolicy lockPolicy, LockMode readLockMode, GemFireContainer container, LocalRegion currentDataRegion, Object lockContext) {
        LocalRegion dataRegion = localTXState.removeReadLockForScan((ExclusiveSharedLockObject)currEntry, lockContext);
        if (dataRegion != null) {
            assert (currentDataRegion == null || dataRegion == currentDataRegion) : "unexpected mismatch of dataRegion, provided=" + currentDataRegion + ", recorded=" + dataRegion;
            GemFireXDUtils.unlockEntryAfterRead(txId, lockPolicy, readLockMode, currEntry, container, dataRegion);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockEntryAfterRead(TXId txId, LockingPolicy lockPolicy, LockMode mode, RegionEntry entry, GemFireContainer container, LocalRegion dataRegion) {
        assert (dataRegion != null) : "unexpected null data region for " + entry + " in container " + container;
        boolean entryRemoved = false;
        if (dataRegion.isHDFSReadWriteRegion() && entry.isMarkedForEviction() && !lockPolicy.lockedForWrite((ExclusiveSharedLockObject)entry, null, (Object)dataRegion)) {
            try {
                lockPolicy.acquireLock((ExclusiveSharedLockObject)entry, lockPolicy.getWriteLockMode(), 0, (Object)txId, (Object)dataRegion, null);
                dataRegion.entries.removeEntry(entry.getKey(), entry, false);
                entryRemoved = true;
            }
            finally {
                lockPolicy.releaseLock((ExclusiveSharedLockObject)entry, lockPolicy.getWriteLockMode(), (Object)txId, false, (Object)dataRegion);
            }
        }
        lockPolicy.releaseLock((ExclusiveSharedLockObject)entry, mode, (Object)txId, false, (Object)dataRegion);
        if (dataRegion.getEnableOffHeapMemory() && entryRemoved && entry.isOffHeap()) {
            ((OffHeapRegionEntry)entry).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forAllContexts(Visitor<LanguageConnectionContext> action) {
        ContextService factory = ContextService.getFactory();
        if (factory != null) {
            ContextService contextService = factory;
            synchronized (contextService) {
                for (ContextManager cm : factory.getAllContexts()) {
                    LanguageConnectionContext lcc;
                    if (cm == null || (lcc = (LanguageConnectionContext)cm.getContext("LanguageConnectionContext")) == null || action.visit(lcc)) continue;
                    return;
                }
            }
        }
    }

    public static EnumSet<TransactionFlag> addTXFlag(TransactionFlag flag, EnumSet<TransactionFlag> flagSingleton, EnumSet<TransactionFlag> currentFlags) {
        if (currentFlags == null) {
            return flagSingleton;
        }
        if (((AbstractCollection)currentFlags).size() == 1) {
            currentFlags = ((EnumSet)currentFlags).clone();
        }
        ((AbstractCollection)currentFlags).add((TransactionFlag)flag);
        return currentFlags;
    }

    public static void writeCompressedHighLow(DataOutput out, long val) throws IOException {
        InternalDataSerializer.writeVLHighLow((long)val, (DataOutput)out);
    }

    public static long readCompressedHighLow(DataInput in) throws IOException {
        return InternalDataSerializer.readVLHighLow((DataInput)in);
    }

    public static void executeSQLScripts(Connection conn, String[] scripts, boolean continueOnError, LogWriter logger, String cmdReplace, String cmdReplaceWith, boolean verbose) throws SQLException, IOException, PrivilegedActionException, StandardException {
        GemFireXDUtils.executeSQLScripts(conn, scripts, continueOnError, logger, null, cmdReplace, cmdReplaceWith, verbose);
    }

    public static void executeSQLScripts(Connection conn, String[] scripts, boolean continueOnError, Logger logger, String cmdReplace, String cmdReplaceWith, boolean verbose) throws SQLException, IOException, PrivilegedActionException, StandardException {
        GemFireXDUtils.executeSQLScripts(conn, scripts, continueOnError, null, logger, cmdReplace, cmdReplaceWith, verbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executeSQLScripts(Connection conn, String[] scripts, boolean continueOnError, LogWriter logger, Logger logger2, String cmdReplace, String cmdReplaceWith, boolean verbose) throws SQLException, IOException, PrivilegedActionException, StandardException {
        TransactionResourceImpl tr;
        EmbedConnection embedConn;
        Reader scriptReader;
        boolean fineEnabled = verbose || (logger != null ? logger.fineEnabled() : logger2.isTraceEnabled());
        Reader[] scriptReaders = new Reader[scripts.length];
        for (int index = 0; index < scripts.length; ++index) {
            InputStream sqlStream;
            String scriptPath = scripts[index].trim();
            try {
                sqlStream = SharedUtils.openURL((String)scriptPath);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("SQLConnection: failed to load initial SQL script: " + scriptPath, ex);
            }
            scriptReaders[index] = scriptReader = new BufferedReader(new InputStreamReader(sqlStream));
        }
        if (conn instanceof EmbedConnection) {
            embedConn = (EmbedConnection)conn;
            tr = embedConn.getTR();
        } else {
            embedConn = null;
            tr = null;
        }
        for (int index = 0; index < scripts.length; ++index) {
            scriptReader = scriptReaders[index];
            Statement stmt = conn.createStatement();
            try {
                String command;
                StatementReader commandFinder = new StatementReader(scriptReader);
                String logPrefix = "SQLConnection: [script: " + scripts[index] + "] ";
                while ((command = commandFinder.nextStatement()) != null) {
                    block26: {
                        if (fineEnabled) {
                            if (logger != null) {
                                logger.info(logPrefix + "Starting execution of command: " + command);
                            } else {
                                logger2.info((Object)(logPrefix + "Starting execution of command: " + command));
                            }
                        }
                        try {
                            if (cmdReplace != null && cmdReplaceWith != null) {
                                command = command.replace(cmdReplace, cmdReplaceWith);
                            }
                            stmt.execute(command);
                            if (stmt.getWarnings() != null && logger != null) {
                                GfxdMessage.logWarnings(stmt, command, logPrefix + "SQL warning in execution of command: ", logger);
                            }
                        }
                        catch (SQLException sqle) {
                            if (continueOnError) {
                                if (logger != null) {
                                    logger.error("Exception in execution of command: " + command, (Throwable)sqle);
                                } else {
                                    logger2.error((Object)("Exception in execution of command: " + command), (Throwable)sqle);
                                }
                                break block26;
                            }
                            throw sqle;
                        }
                        finally {
                            if (embedConn != null) {
                                tr.commit(embedConn);
                                embedConn.clearLOBMapping();
                            } else {
                                conn.commit();
                            }
                        }
                    }
                    if (!fineEnabled) continue;
                    if (logger != null) {
                        logger.info(logPrefix + "Successfully executed command: " + command);
                        continue;
                    }
                    logger2.info((Object)(logPrefix + "Successfully executed command: " + command));
                }
                continue;
            }
            finally {
                scriptReader.close();
                stmt.close();
            }
        }
    }

    public static String encrypt(String msg, String transformation, byte[] keyBytes) throws Exception {
        return GemFireXDUtils.encryptBytes(msg.getBytes(ClientSharedData.UTF8), transformation, keyBytes);
    }

    public static String encryptBytes(byte[] bytes, String transformation, byte[] keyBytes) throws Exception {
        String algo;
        if (transformation == null) {
            algo = "AES";
            transformation = "AES";
        } else {
            algo = GemFireXDUtils.getPrivateKeyAlgorithm(transformation);
        }
        Cipher c = Cipher.getInstance(transformation);
        SecretKeySpec secKey = new SecretKeySpec(keyBytes, algo);
        c.init(1, secKey);
        byte[] enc = c.doFinal(bytes);
        AlgorithmParameters params = c.getParameters();
        String encMsg = ClientSharedUtils.toHexString((byte[])enc, (int)0, (int)enc.length);
        if (params != null) {
            byte[] paramsBytes = params.getEncoded();
            return encMsg + ':' + ClientSharedUtils.toHexString((byte[])paramsBytes, (int)0, (int)paramsBytes.length);
        }
        return encMsg;
    }

    public static String decrypt(String encMsg, String transformation, byte[] keyBytes) throws Exception {
        return new String(GemFireXDUtils.decryptBytes(encMsg, transformation, keyBytes), ClientSharedData.UTF8);
    }

    public static byte[] decryptBytes(String encMsg, String transformation, byte[] keyBytes) throws Exception {
        int encMsgLen;
        String algo;
        if (transformation == null) {
            algo = "AES";
            transformation = "AES";
        } else {
            algo = GemFireXDUtils.getPrivateKeyAlgorithm(transformation);
        }
        Cipher c = Cipher.getInstance(transformation);
        SecretKeySpec secKey = new SecretKeySpec(keyBytes, algo);
        int paramIndex = encMsg.indexOf(58);
        if (paramIndex > 0) {
            AlgorithmParameters params = AlgorithmParameters.getInstance(algo);
            params.init(ClientSharedUtils.fromHexString((String)encMsg, (int)(paramIndex + 1), (int)(encMsg.length() - paramIndex - 1)));
            c.init(2, (Key)secKey, params);
            encMsgLen = paramIndex;
        } else {
            c.init(2, secKey);
            encMsgLen = encMsg.length();
        }
        return c.doFinal(ClientSharedUtils.fromHexString((String)encMsg, (int)0, (int)encMsgLen));
    }

    public static void updateCipherKeyBytes(byte[] keyBytes, byte[] salt) {
        if (salt != null && keyBytes != null && keyBytes.length > 0) {
            for (int index = 0; index < salt.length; ++index) {
                int bytesIndex;
                int n = bytesIndex = index * 3 % keyBytes.length;
                keyBytes[n] = (byte)(keyBytes[n] ^ salt[index]);
            }
        }
    }

    private static String getPrivateKeyDBKey(String algo, int keySize) {
        return "_GFXD_INTERNAL_PVT_KEY__" + algo + "__" + keySize;
    }

    public static String getPrivateKeyAlgorithm(String transformation) {
        int sidx = transformation.indexOf(47);
        if (sidx > 0) {
            return transformation.substring(0, sidx);
        }
        return transformation;
    }

    public static byte[] getUserPasswordCipherKeyBytes(String user, String transformation, int keySize) throws Exception {
        String secret;
        String algo = transformation == null ? "AES" : GemFireXDUtils.getPrivateKeyAlgorithm(transformation);
        if (keySize <= 0) {
            keySize = 128;
        }
        if ((secret = PropertyUtil.getDatabaseProperty(Misc.getMemStoreBooting(), GemFireXDUtils.getPrivateKeyDBKey(algo, keySize))) == null) {
            throw new IllegalStateException("No private key found in the distributed system for algo=" + algo + " keysize=" + keySize + " !");
        }
        byte[] keyBytes = ClientSharedUtils.fromHexString((String)secret, (int)0, (int)secret.length());
        if (user == null || user.length() == 0) {
            user = "USER";
        }
        GemFireXDUtils.updateCipherKeyBytes(keyBytes, user.getBytes(ClientSharedData.UTF8));
        return keyBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String initializePrivateKey(String algo, int keySize, LanguageConnectionContext lcc) throws Exception {
        String secretProp;
        String secret;
        GemFireStore store = Misc.getMemStoreBooting();
        if (algo == null) {
            algo = "AES";
        }
        if (keySize <= 0) {
            keySize = 128;
        }
        if ((secret = PropertyUtil.getDatabaseProperty(store, secretProp = GemFireXDUtils.getPrivateKeyDBKey(algo, keySize))) == null) {
            GfxdDataDictionary dd = store.getDatabase().getDataDictionary();
            TransactionController tc = lcc != null ? lcc.getTransactionExecute() : null;
            boolean ddLocked = dd.lockForWriting(tc, false);
            try {
                secret = PropertyUtil.getDatabaseProperty(store, secretProp);
                if (secret == null) {
                    KeyGenerator gen = KeyGenerator.getInstance(algo);
                    gen.init(keySize);
                    byte[] key = gen.generateKey().getEncoded();
                    secret = ClientSharedUtils.toHexString((byte[])key, (int)0, (int)key.length);
                    store.setProperty(secretProp, (Serializable)((Object)secret), false);
                    GfxdSystemProcedures.publishMessage(new Object[]{secretProp, secret}, false, GfxdSystemProcedureMessage.SysProcMethod.setDatabaseProperty, true, true);
                }
            }
            finally {
                if (ddLocked) {
                    dd.unlockAfterWriting(tc, false);
                }
            }
        }
        return secret;
    }

    public static String maskCreateUserPasswordFromSQLString(String sql) {
        Matcher m = USER_PASSWORD_PATTERN.matcher(sql);
        if (m.find()) {
            int groupNo = 2;
            String pwd = m.group(groupNo);
            if (pwd == null || pwd.isEmpty()) {
                pwd = m.group(++groupNo);
            }
            if ("?".equals(pwd.trim())) {
                return null;
            }
            return sql.substring(0, m.start(groupNo)) + "'***'" + sql.substring(m.end(groupNo));
        }
        return sql;
    }

    public static String maskGenericPasswordFromSQLString(String sql) {
        return GENERIC_PASSWORD_PATTERN.matcher(sql).replaceAll("password ***");
    }

    public static void throwAssert(String msg) throws AssertFailure {
        SanityManager.THROWASSERT((String)msg);
    }

    private static boolean checkSQLStateForRetry(String sqlState) {
        return "X0Z01".equals(sqlState) || "X0Z18".equals(sqlState) || "08003".equals(sqlState) || "XJ004.C".substring(0, 5).equals(sqlState) || "XJ040.C".substring(0, 5).equals(sqlState) || "XJ041.C".substring(0, 5).equals(sqlState) || "X0RQ3.C".substring(0, 5).equals(sqlState);
    }

    private static boolean checkExceptionForRetry(Throwable t) {
        if (t instanceof CancelException || t instanceof FunctionInvocationTargetException || t instanceof ForceReattemptException || t instanceof DataLocationException || t instanceof ShutdownException || t instanceof BucketMovedException || t instanceof PrimaryBucketException || t instanceof GfxdDDLReplayInProgressException) {
            return true;
        }
        if (t instanceof RegionDestroyedException && ((RegionDestroyedException)t).isRemote()) {
            return true;
        }
        if (t instanceof DiskAccessException && ((DiskAccessException)t).isRemote()) {
            return true;
        }
        if (t instanceof GemFireXDRuntimeException) {
            return GemFireXDUtils.checkIfGfxdRuntimeProperForRetry((GemFireXDRuntimeException)t);
        }
        if (t instanceof StandardException) {
            StandardException se = (StandardException)t;
            String sqlState = se.getSQLState();
            return GemFireXDUtils.checkSQLStateForRetry(sqlState) || se.getErrorCode() >= 45000 && ("08006".equals(sqlState) || "XJ015".equals(sqlState));
        }
        if (t instanceof SQLException) {
            SQLException sqle = (SQLException)t;
            String sqlState = sqle.getSQLState();
            return GemFireXDUtils.checkSQLStateForRetry(sqlState) || sqle.getErrorCode() >= 45000 && ("08006".equals(sqlState) || "XJ015".equals(sqlState));
        }
        return false;
    }

    private static boolean checkNodeUnstableException(Throwable t, boolean checkRemote) {
        if (t instanceof ShutdownException || t instanceof CancelException || checkRemote && t instanceof GfxdDDLReplayInProgressException) {
            return true;
        }
        if (t instanceof StandardException) {
            StandardException se = (StandardException)t;
            String sqlState = se.getSQLState();
            if ("X0Z01".equals(sqlState)) {
                return true;
            }
            return se.getErrorCode() >= 45000 && ("08006".equals(sqlState) || "XJ015".equals(sqlState));
        }
        if (t instanceof SQLException) {
            SQLException sqle = (SQLException)t;
            String sqlState = sqle.getSQLState();
            if ("X0Z01".equals(sqlState)) {
                return true;
            }
            return sqle.getErrorCode() >= 45000 && ("08006".equals(sqlState) || "XJ015".equals(sqlState));
        }
        return false;
    }

    private static boolean checkIfGfxdRuntimeProperForRetry(GemFireXDRuntimeException sqle) {
        SQLException e;
        boolean ret = false;
        SQLException sQLException = e = sqle.getCause() != null && sqle.getCause() instanceof SQLException ? (SQLException)sqle.getCause() : null;
        while (e != null && !(ret = "XCL16".equals(e.getSQLState()))) {
            e = e.getCause() != null && e.getCause() instanceof SQLException ? (SQLException)e.getCause() : null;
        }
        return ret;
    }

    public static void processCancelException(String method, Throwable remoteEx, DistributedMember member) throws StandardException {
        StandardException stdEx = null;
        SQLException sqle = null;
        for (Throwable t = remoteEx; t != null; t = t.getCause()) {
            if (GemFireXDUtils.retryToBeDone(t)) {
                member = StandardException.fixUpRemoteException(t, member);
                throw StandardException.newException("X0Z01.S", t, (Object)member, (Object)method);
            }
            if (stdEx == null && t instanceof StandardException) {
                stdEx = (StandardException)t;
            }
            if (sqle != null || !(t instanceof SQLException)) continue;
            sqle = (SQLException)t;
        }
        if (stdEx != null) {
            member = StandardException.fixUpRemoteException(remoteEx, member);
            throw StandardException.newException(stdEx.getMessageId(), remoteEx, stdEx.getArguments());
        }
        if (sqle != null) {
            throw Misc.wrapRemoteSQLException(sqle, remoteEx, member);
        }
    }

    public static void throwIfRuntimeException(Throwable t) {
        RuntimeException runtimeEx = GemFireXDRuntimeException.newRuntimeException(null, t);
        if (!(runtimeEx instanceof GemFireXDRuntimeException)) {
            throw runtimeEx;
        }
    }

    public static StandardException newDuplicateKeyViolation(String constraintType, String indexName, Object newValue, EntryExistsException cause) {
        return GemFireXDUtils.newDuplicateKeyViolation(constraintType, indexName, cause.getLocalizedMessage(), cause.getOldValue(), newValue, cause);
    }

    public static StandardException newDuplicateKeyViolation(String constraintType, String indexName, String msg, Object oldValue, Object newValue, EntryExistsException cause) {
        EntryExistsException eee = new EntryExistsException(msg + (newValue != null ? "; for " + ArrayUtils.objectStringNonRecursive((Object)newValue) : "") + "; myID: " + Misc.getGemFireCache().getMyId(), cause != null ? null : oldValue);
        eee.setOldValue(oldValue);
        if (cause != null) {
            eee.initCause((Throwable)cause);
        }
        if (TraceIndex | TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("throwing " + constraintType + " violation for (" + msg + "), oldValue=(" + oldValue + ") index=" + indexName), (Throwable)eee);
        }
        StandardException se = StandardException.newException("23505", eee, (Object)constraintType, (Object)indexName);
        if (!TraceExecution) {
            se.setReport(1);
        }
        return se;
    }

    public static StandardException newPutPartitionColumnViolation(String constraintType, String indexName, String msg, Object oldValue, Object newValue, EntryExistsException cause) {
        EntryExistsException eee = new EntryExistsException(msg + (newValue != null ? "; for " + ArrayUtils.objectStringNonRecursive((Object)newValue) : "") + "; myID: " + Misc.getGemFireCache().getMyId(), cause != null ? null : oldValue);
        eee.setOldValue(oldValue);
        if (cause != null) {
            eee.initCause((Throwable)cause);
        }
        if (TraceIndex | TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("throwing " + constraintType + " violation for (" + msg + "), oldValue=(" + oldValue + ") index=" + indexName), (Throwable)eee);
        }
        StandardException se = StandardException.newException("0A000.S", (Throwable)eee, (Object)"Modification of partitioning column in PUT INTO");
        se.setReport(1);
        return se;
    }

    public static StandardException newDuplicateEntryViolation(String indexName, Object oldValue, Object newValue) {
        String constraintType = "duplicate entry";
        EntryExistsException eee = new EntryExistsException("duplicate entry for " + newValue, oldValue);
        if (TraceIndex | TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("throwing duplicate entry violation for (" + newValue + "), oldValue=(" + oldValue + ") index=" + indexName), (Throwable)eee);
        }
        return StandardException.newException("23505", eee, (Object)"duplicate entry", (Object)indexName);
    }

    public static StandardException newOldValueNotFoundException(Object key, Object oldValue, Object currentValue, GemFireContainer container) {
        return StandardException.newException("XSDAO.S", GemFireXDRuntimeException.newRuntimeException("index replace: value to be replaced not found [" + oldValue + "] with existing [" + ArrayUtils.objectStringNonRecursive((Object)currentValue) + "] for key [" + key + "] in: " + container, null));
    }

    public static boolean getOptimizerTrace() {
        return optimizerTrace;
    }

    public static void setOptimizerTrace(boolean onOrOff) {
        optimizerTrace = onOrOff;
    }

    public static Event convertToEvent(AsyncEvent<Object, Object> event) {
        if (event.getKey() != null) {
            return new WBCLEventImpl(event);
        }
        return (GfxdCBArgForSynchPrms)event.getCallbackArgument();
    }

    public static GfxdCallbackArgument wrapCallbackArgs(Object rtObject, LanguageConnectionContext lcc, boolean isTransactional, boolean threadLocalType, boolean isCacheLoaded, boolean isPkBased, boolean skipListeners, boolean bulkFkChecksEnabled, boolean skipConstraintChecks) {
        if (rtObject == null && lcc == null && !bulkFkChecksEnabled && !skipConstraintChecks) {
            if (isTransactional) {
                if (!isCacheLoaded && !skipListeners) {
                    return isPkBased ? GfxdCallbackArgument.getFixedInstanceTransactional() : GfxdCallbackArgument.getFixedInstanceTransactionalNoPkBased();
                }
            } else if (isCacheLoaded) {
                if (isPkBased) {
                    return skipListeners ? GfxdCallbackArgument.getFixedInstanceCacheLoadedSkipListeners() : GfxdCallbackArgument.getFixedInstanceCacheLoaded();
                }
            } else if (!skipListeners) {
                return isPkBased ? GfxdCallbackArgument.getFixedInstance() : GfxdCallbackArgument.getFixedInstanceNoPkBased();
            }
        }
        GfxdCallbackArgument cbArg = threadLocalType ? GfxdCallbackArgument.getThreadLocalInstance() : GfxdCallbackArgument.getWithInfoFieldsType();
        cbArg.setRoutingObject((Integer)rtObject);
        if (lcc != null) {
            cbArg.setConnectionProperties(lcc.getConnectionId());
        }
        if (isCacheLoaded) {
            cbArg.setCacheLoaded();
        }
        if (isTransactional) {
            cbArg.setTransactional();
        }
        if (isPkBased) {
            cbArg.setPkBased();
        }
        if (skipListeners) {
            cbArg.setSkipListeners();
        }
        if (bulkFkChecksEnabled) {
            cbArg.setBulkFkChecksEnabled();
        }
        if (skipConstraintChecks) {
            cbArg.setSkipConstraintChecks();
        }
        return cbArg;
    }

    public static long getDefaultRecoveryDelay() {
        return defaultRecoveryDelay;
    }

    public static long getDefaultStartupRecoveryDelay() {
        return defaultStartupRecoveryDelay;
    }

    public static void setDefaultStartupRecoveryDelay(long delay) {
        defaultStartupRecoveryDelay = delay;
    }

    public static int getDefaultInitialCapacity() {
        return defaultInitialCapacity;
    }

    public static boolean isDefaultRecoveryDelay(long delay) {
        return delay == -1L;
    }

    public static final boolean isPersistent(LocalRegion r) {
        if (r.getDataPolicy().withPersistence()) {
            return true;
        }
        GemFireContainer container = (GemFireContainer)r.getUserAttribute();
        if (container == null) {
            return false;
        }
        if (container.getDistributionDescriptor() != null) {
            return container.getDistributionDescriptor().getPersistence();
        }
        TableDescriptor td = container.getTableDescriptor();
        try {
            DistributionDescriptor desc;
            if (td != null && (desc = td.getDistributionDescriptor()) != null) {
                return desc.getPersistence();
            }
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("unexpected exception in getting DistributionDescriptor", se);
        }
        return false;
    }

    public static String getRandomString(boolean randomNull) {
        Random rnd = PartitionedRegion.rand;
        if (!randomNull || rnd.nextBoolean()) {
            char[] userBytes;
            do {
                int numBytes = rnd.nextInt(10) + 3;
                userBytes = new char[numBytes];
                for (int index = 0; index < numBytes; ++index) {
                    userBytes[index] = randChooseChars[rnd.nextInt(randChooseChars.length)];
                }
            } while (Character.toUpperCase(userBytes[0]) == 'S' && Character.toUpperCase(userBytes[1]) == 'Y' && Character.toUpperCase(userBytes[2]) == 'S');
            return String.valueOf(userBytes);
        }
        return null;
    }

    public static TableDescriptor getTableDescriptor(String schemaName, String tableName, LanguageConnectionContext lcc) {
        GemFireContainer container = GemFireXDUtils.getGemFireContainer(schemaName, tableName, lcc);
        if (container != null) {
            return container.getTableDescriptor();
        }
        return null;
    }

    public static GemFireContainer getGemFireContainer(String schemaName, String tableName, LanguageConnectionContext lcc) {
        Region region;
        if (tableName != null && (region = Misc.getRegionByPath(Misc.getRegionPath(schemaName, tableName, lcc), false)) != null) {
            return (GemFireContainer)region.getUserAttribute();
        }
        return null;
    }

    public static GemFireContainer getGemFireContainer(String tableName, boolean throwIfNotFound) {
        return (GemFireContainer)Misc.getRegionForTable(tableName, throwIfNotFound).getUserAttribute();
    }

    public static int[] getPrimaryKeyColumns(TableDescriptor td) throws StandardException {
        ReferencedKeyConstraintDescriptor rkcd;
        if (td != null && (rkcd = td.getPrimaryKey()) != null) {
            return rkcd.getReferencedColumns();
        }
        return null;
    }

    public static HashMap<String, Integer> getColumnNamesToIndexMap(TableDescriptor td, boolean primaryKeyIncluded) throws StandardException {
        HashMap<String, Integer> nameToIdxMap = new HashMap<String, Integer>();
        ColumnDescriptorList colDescpList = td.getColumnDescriptorList();
        Iterator csItr = colDescpList.iterator();
        int[] pkIndexes = null;
        if (!primaryKeyIncluded) {
            pkIndexes = GemFireXDUtils.getPrimaryKeyColumns(td);
        }
        while (csItr.hasNext()) {
            ColumnDescriptor cd = (ColumnDescriptor)csItr.next();
            int idx = cd.getPosition();
            if (pkIndexes != null && !primaryKeyIncluded && GemFireXDUtils.checkIfPartOfPrimary(idx, pkIndexes)) continue;
            nameToIdxMap.put(cd.getColumnName(), cd.getPosition());
        }
        return nameToIdxMap;
    }

    private static boolean checkIfPartOfPrimary(int idx, int[] pkIndexes) {
        boolean retVal = false;
        for (int i = 0; i < pkIndexes.length; ++i) {
            if (idx != pkIndexes[i]) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public static Map<String, Integer> getPrimaryKeyColumnNamesToIndexMap(TableDescriptor td, LanguageConnectionContext lcc) throws StandardException {
        String[] columnNames;
        ReferencedKeyConstraintDescriptor rkcd = td.getPrimaryKey();
        if (rkcd == null) {
            TransactionController tc = lcc.getTransactionExecute();
            DataDictionary dd = lcc.getDataDictionary();
            ConstraintDescriptorList constraints = dd.getConstraintDescriptors(dd.getTableDescriptor(td.getName(), dd.getSchemaDescriptor(td.getSchemaName(), tc, false), tc));
            rkcd = constraints.getPrimaryKey();
            if (rkcd == null) {
                return null;
            }
        }
        LinkedHashMap<String, Integer> nameToIdxMap = new LinkedHashMap<String, Integer>();
        int[] pkIndexes = rkcd.getKeyColumns();
        String[] pkColNames = new String[pkIndexes.length];
        if (pkColNames.length > (columnNames = td.getColumnDescriptorList().getColumnNames()).length) {
            return null;
        }
        for (int i = 0; i < pkIndexes.length; ++i) {
            nameToIdxMap.put(columnNames[pkIndexes[i] - 1], pkIndexes[i]);
        }
        return nameToIdxMap;
    }

    public static final int[] getColumnPositionsFromBitSet(FormatableBitSet bitSet) {
        int columns = bitSet.getNumBitsSet();
        if (columns > 0) {
            int[] columnPositions = new int[columns];
            int i = 0;
            int pos = bitSet.anySetBit();
            while (pos != -1) {
                columnPositions[i] = pos;
                pos = bitSet.anySetBit(pos);
                ++i;
            }
            assert (i == columns);
            return columnPositions;
        }
        return null;
    }

    public static final FormatableBitSet getColumnBitSetFromPosition(int[] cols) {
        int len = cols[cols.length - 1];
        FormatableBitSet bitSet = new FormatableBitSet(len);
        for (int col : cols) {
            if (col > len) {
                bitSet.grow(col);
                len = col;
            }
            bitSet.set(col - 1);
        }
        return bitSet;
    }

    public static final void dropColumnAdjustColumnPositions(int[] pkCols, int columnPos) {
        if (pkCols != null) {
            for (int i = 0; i < pkCols.length; ++i) {
                if (pkCols[i] <= columnPos) continue;
                int n = i;
                pkCols[n] = pkCols[n] - 1;
            }
        }
    }

    public static boolean retryToBeDone(Throwable t, int tryCnt) {
        boolean retry = false;
        for (Throwable exp = t; exp != null && !retry; exp = exp.getCause()) {
            retry = GemFireXDUtils.checkExceptionForRetry(exp);
        }
        if (retry) {
            if (TraceFunctionException) {
                SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)("GemFireXDUtils#retryToBeDone: retry called for " + (tryCnt + 1) + "th time and retry=" + retry + " with exception"), (Throwable)new Throwable(t));
            }
            return true;
        }
        return false;
    }

    public static boolean retryToBeDone(Throwable t) {
        for (Throwable exp = t; exp != null; exp = exp.getCause()) {
            if (!GemFireXDUtils.checkExceptionForRetry(exp)) continue;
            if (TraceFunctionException) {
                SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)"GemFireXDUtils#retryToBeDone: retry called with exception", (Throwable)new Throwable(t));
            }
            return true;
        }
        return false;
    }

    public static boolean nodeFailureException(Throwable t) {
        return GemFireXDUtils.nodeFailureException(t, true);
    }

    public static boolean nodeFailureException(Throwable t, boolean checkRemote) {
        for (Throwable exp = t; exp != null; exp = exp.getCause()) {
            if (!GemFireXDUtils.checkNodeUnstableException(exp, checkRemote)) continue;
            return true;
        }
        return false;
    }

    public static TXAbortState isTXAbort(Throwable t) {
        while (t != null) {
            LanguageConnectionContext lcc;
            String sqlState;
            if (t instanceof StandardException) {
                StandardException se = (StandardException)t;
                sqlState = se.getSQLState();
                lcc = Misc.getLanguageConnectionContext();
                if (lcc != null) {
                    EmbedConnection.abortForConstraintViolationInTX(se, lcc);
                }
                if ("X0Z02".equals(sqlState)) {
                    return TXAbortState.CONFLICT;
                }
                if ("40XL1".equals(sqlState)) {
                    return TXAbortState.TIMEOUT;
                }
                if (se.getSeverity() >= 30000) {
                    return TXAbortState.OTHER;
                }
            } else {
                if (t instanceof ConflictException) {
                    return TXAbortState.CONFLICT;
                }
                if (t instanceof LockTimeoutException) {
                    return TXAbortState.TIMEOUT;
                }
                if (t instanceof SQLException) {
                    SQLException sqle = (SQLException)t;
                    sqlState = sqle.getSQLState();
                    lcc = Misc.getLanguageConnectionContext();
                    int errorCode = sqle.getErrorCode();
                    if ("X0Z02".equals(sqlState)) {
                        return TXAbortState.CONFLICT;
                    }
                    if ("40XL1".equals(sqlState)) {
                        return TXAbortState.TIMEOUT;
                    }
                    if (lcc != null && (EmbedConnection.abortForConstraintViolationInTX(sqlState, errorCode, lcc) || errorCode >= 30000)) {
                        return TXAbortState.OTHER;
                    }
                }
            }
            t = t.getCause();
        }
        return TXAbortState.NOT_ABORTED;
    }

    public static String getCurrentDrivePrefix() {
        if (NativeCalls.getInstance().getOSType().isWindows()) {
            try {
                String drivePrefix = new File(".").getCanonicalPath().substring(0, 2);
                char driveC = drivePrefix.charAt(0);
                if (driveC != '/' && driveC != '\\' && drivePrefix.charAt(1) == ':') {
                    return drivePrefix;
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Failed in setting the overflow directory", ex);
            }
        }
        return null;
    }

    public static String getExpectedExceptionString(Object exObj, boolean forRemove) {
        String exStr = exObj instanceof Class ? ((Class)exObj).getName() : exObj.toString();
        exStr = exStr.replace('$', '.');
        if (forRemove) {
            return "<ExpectedException action=remove>" + exStr + "</ExpectedException>";
        }
        return "<ExpectedException action=add>" + exStr + "</ExpectedException>";
    }

    public static void sleepForRetry(int numTries) {
        try {
            if (numTries % 5 != 0) {
                Thread.sleep(10L);
            } else {
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            Misc.checkIfCacheClosing(ie);
        }
    }

    public static <T> String toCSV(T[] array) {
        StringBuilder csv = new StringBuilder();
        if (array != null) {
            for (T obj : array) {
                if (csv.length() > 0) {
                    csv.append(',');
                }
                csv.append(obj);
            }
        }
        return csv.toString();
    }

    public static byte[] writeThriftObject(@Nonnull TBase<?, ?> obj) throws TException {
        AutoExpandingBufferWriteTransport transport = new AutoExpandingBufferWriteTransport(128, 1.5);
        obj.write((TProtocol)new TCompactProtocol((TTransport)transport));
        byte[] bytes = transport.getBuf().array();
        int size = transport.getPos();
        return size == bytes.length ? bytes : Arrays.copyOf(bytes, size);
    }

    public static int readThriftObject(@Nonnull TBase<?, ?> obj, byte[] bytes) throws TException {
        TMemoryInputTransport transport = new TMemoryInputTransport(bytes);
        obj.read((TProtocol)new TCompactProtocol((TTransport)transport));
        return transport.getBytesRemainingInBuffer();
    }

    public static ServerLocation getPreferredServer(Collection<String> serverGroups, Collection<String> intersectGroups, String excludedServers, boolean allowRedirect) throws SQLException {
        THashSet excludedServerSet;
        if (excludedServers == null || excludedServers.length() == 0) {
            excludedServerSet = Collections.emptySet();
        } else {
            excludedServerSet = new THashSet(4);
            int[] port = new int[1];
            SharedUtils.splitCSV((String)excludedServers, addServerLocations, (Object)excludedServerSet, (Object)port);
        }
        return GemFireXDUtils.getPreferredServer(serverGroups, intersectGroups, excludedServerSet, excludedServers, allowRedirect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerLocation getPreferredServer(Collection<String> serverGroups, Collection<String> intersectGroups, Set<? extends HostLocationBase<?>> excludedServerSet, String excludedServers, boolean allowRedirect) throws SQLException {
        allowRedirect = allowRedirect && GemFireXDUtils.getMyVMKind() != GemFireStore.VMKind.LOCATOR;
        try {
            ServerLocation server;
            ServerLocator serverLoc;
            Locator loc;
            GfxdDistributionAdvisor gfxdAdvisor = GemFireXDUtils.getGfxdAdvisor();
            if (SanityManager.TraceClientHA) {
                SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("getPreferredServer(): full excluded server list: " + excludedServerSet));
            }
            if ((loc = Locator.getLocator()) != null && (serverLoc = ((InternalLocator)loc).getServerLocatorAdvisee()) != null && (server = serverLoc.getLoadSnapshot().getServerForGroups(serverGroups, intersectGroups, excludedServerSet)) != null) {
                if (!SanityManager.TraceClientHA) return server;
                SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("getPreferredServer(): returning preferred server: " + server));
                return server;
            }
            if (!allowRedirect) return null;
            Set<DistributedMember> locatorMembers = gfxdAdvisor.adviseServerLocators(true);
            Iterator<DistributedMember> locators = locatorMembers.iterator();
            while (locators.hasNext()) {
                try {
                    GfxdConfigMessage<Object> msg;
                    ServerLocation prefServer;
                    GfxdSingleResultCollector rc = new GfxdSingleResultCollector();
                    if (excludedServers == null) {
                        excludedServers = SharedUtils.toCSV(excludedServerSet);
                    }
                    if ((prefServer = (ServerLocation)(msg = new GfxdConfigMessage<Object>(rc, Collections.singleton(locators.next()), GfxdConfigMessage.Operation.GET_PREFERREDSERVER, new Object[]{serverGroups != null && !serverGroups.isEmpty() ? new ArrayList<String>(serverGroups) : null, intersectGroups != null && !intersectGroups.isEmpty() ? new ArrayList<String>(intersectGroups) : null, excludedServers}, false)).executeFunction()) == null) return null;
                    return prefServer;
                }
                catch (Exception e) {
                    if (locators.hasNext()) continue;
                    throw e;
                    return null;
                }
            }
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    public static synchronized void reset(boolean forBoot) {
        vmIdAdvisor = null;
        lockableMap.clear();
        optimizerTrace = Boolean.getBoolean("gemfirexd.optimizer.trace");
        defaultRecoveryDelay = -1L;
        SanityManager.clearFlags((boolean)forBoot);
    }

    public static PrintWriter dumpProperties(Properties p, String msg, String debugflag, boolean debugTraceOn, PrintWriter writer) {
        if (!debugTraceOn) {
            return writer;
        }
        boolean isForWriteToStream = writer == null || !(writer instanceof StringPrintWriter);
        PrintWriter pw = isForWriteToStream ? new StringPrintWriter() : writer;
        if (p == null) {
            pw.print("--- ");
            pw.print(msg);
            pw.println(" ---");
            pw.println("--- EMPTY ---");
        } else {
            pw.print("--- ");
            pw.print(msg);
            pw.println(" ---");
            Enumeration<?> e = p.propertyNames();
            ArrayList<String> sortedProps = new ArrayList<String>();
            while (e.hasMoreElements()) {
                sortedProps.add((String)e.nextElement());
            }
            Collections.sort(sortedProps);
            for (String key : sortedProps) {
                Object val;
                Object propval = p.getProperty(key);
                if (propval == null) {
                    propval = p.get(key);
                }
                if ((val = AuthenticationServiceBase.maskProperty(key, propval)) == "_!_-p-h-_!_") continue;
                pw.print(" ");
                pw.print(key);
                pw.print("=\"");
                pw.print(val);
                pw.println("\"");
            }
            pw.println("--- end --");
        }
        if (!isForWriteToStream) {
            return pw;
        }
        SanityManager.DEBUG_PRINT((String)debugflag, (String)pw.toString(), null, (PrintWriter)writer);
        return null;
    }

    public static void dumpStacks(GemFireStore memStore, String header) {
        try {
            if (memStore == null) {
                throw new ShutdownException();
            }
            memStore.getDDLLockService().dumpAllRWLocks(header, false, false, true);
        }
        catch (Exception ex) {
            String marker = "=================================================================\n";
            StringBuilder msg = new StringBuilder("=================================================================\n");
            msg.append(header).append(":\n\n");
            GfxdLocalLockService.generateThreadDump(msg);
            msg.append("=================================================================\n");
            SanityManager.DEBUG_PRINT((String)"DumpThreads", (String)msg.toString());
        }
    }

    public static void checkForInsufficientDataStore(LocalRegion region) throws StandardException {
        if (!region.hasDataStores()) {
            if (region.getDataPolicy().withPersistence()) {
                throw StandardException.newException("X0Z09.S");
            }
            throw StandardException.newException("X0Z08.S", "execution on table " + ((GemFireContainer)region.getUserAttribute()).getQualifiedTableName());
        }
    }

    public static void waitForNodeInitialization() {
        GemFireXDUtils.waitForNodeInitialization(-1L, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitForNodeInitialization(long timeout, boolean waitForRegionInitializations, boolean endOnDDLReplayDDLockWaiting) {
        Object sync;
        GemFireStore memStore = GemFireStore.getBootingInstance();
        if (memStore == null) {
            throw new CacheClosedException("GemFireXDUtils#waitForNodeInitialization: no store found. GemFireXD not booted or closed down.");
        }
        if (GemFireXDUtils.ddlReplayDone(memStore, waitForRegionInitializations)) {
            return true;
        }
        SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("waitForNodeInitialization: waiting for this node to initialize for " + timeout + "ms, waitForRegions=" + waitForRegionInitializations));
        long waitMillis = 500L;
        long start = 0L;
        if (timeout >= 0L) {
            start = System.currentTimeMillis();
        }
        Object object = sync = memStore.getInitialDDLReplaySync();
        synchronized (object) {
            while (!GemFireXDUtils.ddlReplayDone(memStore, waitForRegionInitializations)) {
                InterruptedException t = null;
                try {
                    if (!memStore.initialDDLReplayInProgress()) {
                        sync.wait(500L);
                        if (timeout < 0L || System.currentTimeMillis() - start < timeout) continue;
                        break;
                    }
                    if (endOnDDLReplayDDLockWaiting && memStore.initialDDLReplayWaiting()) break;
                    sync.wait(500L);
                    if (timeout >= 0L && System.currentTimeMillis() - start >= timeout) {
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    t = ie;
                }
                Misc.checkIfCacheClosing(t);
            }
        }
        boolean replayDone = GemFireXDUtils.ddlReplayDone(memStore, waitForRegionInitializations);
        SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("waitForNodeInitialization: ending wait for this node to initialize, replayDone=" + replayDone));
        return replayDone;
    }

    private static final boolean ddlReplayDone(GemFireStore memStore, boolean waitForRegionInitializations) {
        return waitForRegionInitializations ? memStore.initialDDLReplayDone() : memStore.initialDDLReplayPart1Done();
    }

    public static final String addressOf(Object o) {
        if (o == null) {
            return " [NULL] ";
        }
        return o.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    public static final boolean hasTable(Connection conn, String tablename) throws SQLException {
        return GemFireXDUtils.hasTable(conn, null, SharedUtils.SQLToUpperCase((String)tablename));
    }

    public static boolean isExecRowDetachedFromOffHeapByteSource(ExecRow row) {
        AbstractCompactExecRow acr;
        boolean detached = false;
        if (!(row instanceof AbstractCompactExecRow)) {
            detached = true;
        } else if (row instanceof AbstractCompactExecRow && !((acr = (AbstractCompactExecRow)row).getBaseByteSource() instanceof OffHeapByteSource)) {
            detached = true;
        }
        return detached;
    }

    public static boolean forceReleaseByteSourceFromExecRow(ExecRow row) {
        Object byteSource;
        return row != null && row instanceof AbstractCompactExecRow && OffHeapHelper.release((Object)(byteSource = ((AbstractCompactExecRow)row).getByteSource()));
    }

    public static final boolean hasTable(Connection conn, String schema, String tableName) throws SQLException {
        if (conn instanceof EmbedConnection) {
            return GemFireXDUtils.hasTable((EmbedConnection)conn, schema, tableName);
        }
        ResultSet rs = conn.getMetaData().getTables(null, schema, tableName.toUpperCase(), new String[]{"TABLE"});
        boolean found = rs.next();
        rs.close();
        conn.commit();
        return found;
    }

    public static final boolean isOffHeapEnabled() {
        return SimpleMemoryAllocatorImpl.getAllocatorNoThrow() != null;
    }

    public static final IsolationLevel getIsolationLevel(int jdbcIsolationLevel, EnumSet<TransactionFlag> txFlags) throws StandardException {
        try {
            return IsolationLevel.fromJdbcIsolationLevel((int)jdbcIsolationLevel, null);
        }
        catch (UnsupportedOperationException e) {
            throw StandardException.newException("XJ045.S", (Throwable)e, (Object)(String.valueOf(jdbcIsolationLevel) + (txFlags != null ? " with flags " + txFlags : "")));
        }
    }

    public static final boolean hasTable(EmbedConnection conn, String schema, String tableName) throws SQLException {
        return Misc.getRegionByPath(Misc.getRegionPath(schema, tableName, conn.getLanguageConnectionContext()), false) != null;
    }

    public static final List<File> listFiles(String diskstoreName, List<String> diskDirs) {
        ArrayList<File> files = new ArrayList<File>();
        for (String d : diskDirs) {
            DiskStoreFilter diskFileFilter = new DiskStoreFilter(OplogType.BACKUP, true, diskstoreName){

                protected boolean selected(String fileName) {
                    return super.selected(fileName) || fileName.endsWith(".if");
                }
            };
            File directory = new File(d);
            File[] f = FileUtil.listFiles((File)directory, (FilenameFilter)diskFileFilter);
            files.addAll(Arrays.asList(f));
        }
        return files;
    }

    public static final void renameFiles(List<File> files) {
        Object[] targetFiles = new File[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            File dest = new File(files.get(i).getAbsolutePath().replaceAll("BACKUPSQLF", "BACKUPGFXD"));
            if (dest.exists()) {
                throw new GemFireIOException("Couldn't rename to destination file as it already exists " + dest);
            }
            targetFiles[i] = dest;
        }
        String logMsg = "Renaming diskstore files from " + files + " to " + Arrays.toString(targetFiles);
        LogWriter logger = Misc.getCacheLogWriterNoThrow();
        if (logger != null) {
            logger.info(logMsg);
        } else {
            System.out.println(logMsg);
        }
        for (int i = 0; i < files.size(); ++i) {
            files.get(i).renameTo((File)targetFiles[i]);
        }
    }

    public static final Version getCurrentDDLVersion() {
        return GemFireXDUtils.checkUsingGFXD1302Hashing() ? Version.CURRENT : Version.GFXD_13;
    }

    private static boolean checkUsingGFXD1302Hashing() {
        Version min;
        DM dm;
        if (ResolverUtils.isGFXD1302HashingStateSet()) {
            return ResolverUtils.isUsingGFXD1302Hashing();
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && (dm = cache.getDistributionManager()) != null && (min = dm.leastCommonVersion((Collection)dm.getOtherNormalDistributionManagerIds())) != null && min.compareTo(Version.GFXD_1302) < 0) {
            ResolverUtils.setUsePre1302Hashing((boolean)true);
            return false;
        }
        ResolverUtils.setUseGFXD1302Hashing((boolean)true);
        return true;
    }

    public static void initFlags() {
        TraceQuery = SanityManager.TRACE_ON((String)"QueryDistribution");
        TraceIndex = SanityManager.TRACE_ON((String)"TraceIndex");
        TraceLock = SanityManager.TRACE_ON((String)"TraceLock_*");
        TraceTran = SanityManager.TRACE_ON((String)"TraceTran");
        TraceTranVerbose = SanityManager.TRACE_ON((String)"TraceTranVerbose");
        TraceConglomRead = SanityManager.TRACE_ON((String)"TraceConglomRead");
        TraceConglomUpdate = TraceConglomRead || SanityManager.TRACE_ON((String)"TraceConglomUpdate");
        TraceRowFormatter = SanityManager.TRACE_ON((String)"TraceRowFormatter");
        TraceCM = SanityManager.TRACE_ON((String)"TraceCM");
        TraceRSIter = TraceRowFormatter || SanityManager.TRACE_ON((String)"TraceRSIteration");
        TraceAggreg = SanityManager.TRACE_ON((String)"TraceAggregation");
        TraceGroupByQI = SanityManager.TRACE_ON((String)"TraceGroupByQI");
        TraceGroupByIter = TraceRowFormatter || SanityManager.TRACE_ON((String)"TraceGroupByRSIteration");
        TraceActivation = SanityManager.TRACE_ON((String)"TraceActivation");
        TraceAuthentication = SanityManager.TRACE_ON((String)"TraceAuthentication");
        TraceHeapThresh = SanityManager.TRACE_ON((String)"TraceHeapThreshold");
        TraceMembers = SanityManager.TRACE_ON((String)"TraceMembers");
        TraceDDLQueue = SanityManager.TRACE_ON((String)"TraceDDLQueue");
        TraceConglom = TraceQuery || TraceIndex || TraceDDLQueue || SanityManager.TRACE_ON((String)"TraceConglom");
        TraceDDLReplay = TraceDDLQueue || SanityManager.TRACE_ON((String)"TraceDDLReplay");
        TraceConflation = TraceDDLQueue || SanityManager.TRACE_ON((String)"TraceConflation");
        TraceDBSynchronizer = SanityManager.TRACE_ON((String)"TraceDBSynchronizer");
        TraceDBSynchronizerHA = SanityManager.TRACE_ON((String)"TraceDBSynchronizerHA");
        TraceFunctionException = (TraceQuery || DistributionManager.VERBOSE || SanityManager.TRACE_ON((String)"TraceFunctionException")) && !SanityManager.TRACE_OFF((String)"TraceFunctionException");
        TraceProcedureExecution = (TraceQuery || DistributionManager.VERBOSE || SanityManager.TRACE_ON((String)"TraceProcedureExecution")) && !SanityManager.TRACE_OFF((String)"TraceProcedureExecution");
        TraceStatementMatching = SanityManager.TRACE_ON((String)"StatementMatching");
        TraceFabricServiceBoot = SanityManager.TRACE_ON((String)"TraceFabricServiceBoot");
        TraceConnectionSignaller = SanityManager.TRACE_ON((String)"TraceConnectionSignaller");
        TraceTrigger = SanityManager.TRACE_ON((String)"TraceTrigger");
        TraceByteComparisonOptimization = SanityManager.TRACE_ON((String)"TraceByteCompareOptimization");
        TracePlanGeneration = SanityManager.TRACE_ON((String)"TracePlanGeneration");
        TracePlanAssertion = SanityManager.TRACE_ON((String)"TracePlanAssertion");
        TraceStatsGeneration = SanityManager.TRACE_ON((String)"TraceStatsGeneration");
        TraceTempFileIO = SanityManager.TRACE_ON((String)"TraceTempFileIO");
        SanityManager.TraceClientHA = SanityManager.TRACE_ON((String)"TraceClientHA");
        TraceApplicationJars = (TraceQuery || DistributionManager.VERBOSE || SanityManager.TRACE_ON((String)"TraceProcedureExecution") || SanityManager.TRACE_ON((String)"TraceJars")) && !SanityManager.TRACE_OFF((String)"TraceJars");
        TraceOuterJoin = SanityManager.TRACE_ON((String)"TraceOuterJoinMerge");
        TraceSortTuning = SanityManager.TRACE_ON((String)"SortTuning");
        TraceImport = SanityManager.TRACE_ON((String)"TraceImport");
        TraceNCJ = SanityManager.TRACE_ON((String)"TraceNCJ");
        TraceNCJIter = SanityManager.TRACE_ON((String)"TraceNCJIter");
        TraceNCJDump = SanityManager.TRACE_ON((String)"TraceNCJDump");
        TracePersistIndexFinest = SanityManager.TRACE_ON((String)"TracePersistIndexFinest");
        TracePersistIndexFiner = TracePersistIndexFinest || SanityManager.TRACE_ON((String)"TracePersistIndexFiner");
        boolean bl = TracePersistIndex = TracePersistIndexFiner || SanityManager.TRACE_ON((String)"TracePersistIndex");
        if (TracePersistIndex) {
            DiskStoreImpl.INDEX_LOAD_DEBUG = true;
            DiskStoreImpl.INDEX_LOAD_PERF_DEBUG = true;
        }
        TraceThriftAPI = SanityManager.TRACE_ON((String)"TraceThriftAPI");
        TraceSavePoints = SanityManager.TRACE_ON((String)"traceSavepoints");
        TraceParseTree = SanityManager.TRACE_ON((String)"DumpParseTree");
        TraceStopAfterParse = SanityManager.TRACE_ON((String)"StopAfterParsing");
        if (TraceQuery || TraceIndex) {
            SanityManager.TRACE_SET_IF_ABSENT((String)"AssertFailureTrace");
        }
        GemFireXDUtils.initGFEFlags();
        GemFireXDUtils.setTraceExecution(SanityManager.TRACE_ON((String)"TraceExecution"));
        TraceSysProcedures = SanityManager.TRACE_ON((String)"TraceSystemProcedures") || TraceExecution && !SanityManager.TRACE_OFF((String)"TraceSystemProcedures") || GfxdSystemProcedures.logger.isDebugEnabled();
    }

    private static void setTraceExecution(boolean force) {
        TraceExecution = force || TraceQuery || SanityManager.isFineEnabled || TXStateProxy.TRACE_EXECUTE || DistributionManager.VERBOSE || TraceDBSynchronizer || TraceDBSynchronizerHA || TraceActivation || TraceLock || ExclusiveSharedSynchronizer.TRACE_LOCK_COMPACT || TraceNCJ;
    }

    private static void initGFEFlags() {
        ExclusiveSharedSynchronizer.initProperties();
        if (TraceLock || SanityManager.TRACE_ON((String)"gemfire.TRACE_LOCKING")) {
            ExclusiveSharedSynchronizer.TRACE_LOCK = true;
        }
        if (SanityManager.TRACE_ON((String)"DistributionManager.VERBOSE")) {
            DistributionManager.VERBOSE = true;
        } else if (SanityManager.TRACE_OFF((String)"DistributionManager.VERBOSE")) {
            DistributionManager.VERBOSE = false;
        }
        if (TracePersistIndex) {
            DiskStoreImpl.INDEX_LOAD_DEBUG = true;
            DiskStoreImpl.INDEX_LOAD_PERF_DEBUG = true;
        }
        if (TracePersistIndexFiner) {
            DiskStoreImpl.INDEX_LOAD_DEBUG = true;
            DiskStoreImpl.INDEX_LOAD_DEBUG_FINER = true;
            DiskStoreImpl.INDEX_LOAD_PERF_DEBUG = true;
        }
        if (SanityManager.isFineEnabled || TraceTempFileIO) {
            ArraySortedCollectionWithOverflow.TRACE_TEMP_FILE_IO = true;
        }
        TXStateProxy.TRACE_SET((TraceTran || TXStateProxy.VERBOSE_ON() || SanityManager.TRACE_ON((String)"TX.VERBOSE") ? 1 : 0) != 0, (TraceTranVerbose || TXStateProxy.VERBOSEVERBOSE_ON() || SanityManager.TRACE_ON((String)"TX.VERBOSEVERBOSE") ? 1 : 0) != 0, (boolean)TraceQuery, (GemFireCacheImpl)GemFireCacheImpl.getInstance());
        ReplyProcessor21.WAIT_ON_EXCEPTION = true;
    }

    static {
        MIN_KEY = new Object();
        MAX_KEY = new Object();
        tssConn = new ThreadLocal();
        SET_MAX = new TreeSet<String>();
        USER_PASSWORD_PATTERN = Pattern.compile("\\b(CREATE_USER\\s*\\([^,]*,([^\\)]*)\\)|ENCRYPT_PASSWORD\\s*\\([^,]*,([^,]*),.*\\))", 34);
        GENERIC_PASSWORD_PATTERN = Pattern.compile("\\b(PASSWORD|PWD)\\w*[^)\\]},;]*(?=[)\\]},;])", 34);
        randChooseChars = randChooseStr.toCharArray();
        addServerLocations = new SharedUtils.CSVVisitor<Set<ServerLocation>, int[]>(){

            public void visit(String str, Set<ServerLocation> excludedServerSet, int[] port) {
                String serverName = SharedUtils.getHostPort((String)str, (int[])port);
                excludedServerSet.add(new ServerLocation(serverName, port[0]));
            }
        };
        GemFireXDUtils.initFlags();
    }

    public static final class Pair<K, V>
    implements Comparable<K>,
    Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 8864720955309084190L;
        private final K key;
        private final V val;

        public Pair(K k, V v) {
            this.key = k;
            this.val = v;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            long h1 = this.key != null ? (long)this.key.hashCode() : 0L;
            long h2 = this.val != null ? (long)this.val.hashCode() : 0L;
            return Murmur3_x86_32.hashLong((long)(h1 | h2 << 32), (int)42);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Pair) {
                Pair other = (Pair)o;
                return ArrayUtils.objectEquals(this.key, other.key) && ArrayUtils.objectEquals(this.val, other.val);
            }
            return false;
        }

        @Override
        public int compareTo(K o) {
            if (this.key instanceof Comparable) {
                return ((Comparable)this.key).compareTo(o);
            }
            throw new IllegalArgumentException("key " + this.key + " not comparable");
        }

        public String toString() {
            return "Pair<key=" + this.key + ",val=" + this.val + '>';
        }
    }

    public static enum TXAbortState {
        NOT_ABORTED,
        CONFLICT,
        TIMEOUT,
        OTHER;

    }

    public static interface Visitor<T> {
        public boolean visit(T var1);
    }
}

