/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.Scope;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SubQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OptimizerImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Stack;

public final class QueryInfoContext {
    private final int paramCount;
    private final Stack<Scope> scopes;
    private DMLQueryInfo rootQueryInfo;
    private int scopeLevel = -1;
    private final int absoluteStart;
    private String virtualTable;
    private boolean isVTIDistributable;
    private byte flags;
    public static final byte PREP_STATEMENT = 1;
    public static final byte HAS_DSID = 2;
    public static final byte CREATE_QUERY_INFO = 4;
    public static final byte IS_ORIGINALLY_SUBQUERY = 16;
    public static final byte WITH_SECONDARIES = 32;
    public static final byte DISABLE_COLOCATION_CHECK = 64;
    private final byte[] querySectionForParameter;
    private byte currentQuerySection;
    private OptimizerImpl optimizer;

    public QueryInfoContext(boolean createQueryInfo, int paramCount, boolean isPrepStatement) throws StandardException {
        this.flags = GemFireXDUtils.set(this.flags, (byte)4, createQueryInfo);
        this.flags = GemFireXDUtils.set(this.flags, (byte)1, isPrepStatement);
        this.paramCount = paramCount;
        this.scopes = new Stack();
        this.absoluteStart = 0;
        this.querySectionForParameter = new byte[this.paramCount];
        this.currentQuerySection = DMLQueryInfo.DEFAULT_DML_SECTION;
    }

    public QueryInfoContext(boolean createQueryInfo, int paramCount, int absoluteStart, boolean isPrepStatement) throws StandardException {
        this.flags = GemFireXDUtils.set(this.flags, (byte)4, createQueryInfo);
        this.flags = GemFireXDUtils.set(this.flags, (byte)1, isPrepStatement);
        this.paramCount = paramCount;
        this.scopes = new Stack();
        this.absoluteStart = absoluteStart;
        this.querySectionForParameter = new byte[this.paramCount];
        this.currentQuerySection = DMLQueryInfo.DEFAULT_DML_SECTION;
    }

    public int getParamerCount() {
        return this.paramCount;
    }

    void pushScope(DMLQueryInfo top) {
        this.scopes.push(new Scope(top, ++this.scopeLevel));
    }

    public Scope popScope() {
        Scope poppedScope = this.scopes.pop();
        --this.scopeLevel;
        assert (this.scopeLevel == 0 && this.scopes.isEmpty() || !this.scopes.isEmpty());
        if (poppedScope.getScopeLevel() > 0) {
            ((SubQueryInfo)poppedScope.getDMLQueryInfo()).cleanUp();
        }
        poppedScope.unsetLevel();
        return poppedScope;
    }

    public void setRootQueryInfo(DMLQueryInfo root) {
        this.rootQueryInfo = root;
    }

    public DMLQueryInfo getRootQueryInfo() {
        return this.rootQueryInfo;
    }

    public final boolean createQueryInfo() {
        return GemFireXDUtils.isSet(this.flags, (byte)4);
    }

    public void addToPRTableCount(int cnt) {
        this.scopes.peek().addToPRTableCount(cnt);
    }

    DMLQueryInfo getLastPushedIndependentQueryInfo() {
        assert (this.scopes.size() > 1);
        ListIterator scopeItr = this.scopes.listIterator(this.scopeLevel);
        DMLQueryInfo found = null;
        while (scopeItr.hasPrevious()) {
            Scope scope = (Scope)scopeItr.previous();
            DMLQueryInfo dqi = scope.getDMLQueryInfo();
            if (dqi.isSubQueryInfo()) {
                if (!((SubQueryInfo)dqi).isIndependent()) continue;
                found = dqi;
                break;
            }
            found = dqi;
            break;
        }
        return found;
    }

    public void addToTableCount(int cnt) {
        this.scopes.peek().addToTableCount(cnt);
    }

    public int getPRTableCount() {
        return this.scopes.peek().getPRTableCount();
    }

    public int getTableCount() {
        return this.scopes.peek().getTableCount();
    }

    void setParentPRN(ProjectRestrictNode prn) {
        this.scopes.peek().setParentPRN(prn);
    }

    public ProjectRestrictNode getParentPRN() {
        return this.scopes.peek().getParentPRN();
    }

    public void cleanUp() {
        this.scopes.peek().setParentPRN(null);
    }

    int getNestingLevelOfScope() {
        return this.scopes.size() - 1;
    }

    DMLQueryInfo getCurrentScopeQueryInfo() {
        return this.scopes.peek().getDMLQueryInfo();
    }

    Scope findOwningScope(int actualTableNumber) {
        if (actualTableNumber == 0) {
            return this.getScopeAt(0);
        }
        ListIterator scopeItr = this.scopes.listIterator(this.scopeLevel);
        Scope found = null;
        while (scopeItr.hasPrevious()) {
            Scope scope = (Scope)scopeItr.previous();
            DMLQueryInfo dqi = scope.getDMLQueryInfo();
            if (dqi.getTableQueryInfo(actualTableNumber) == null) continue;
            found = scope;
            break;
        }
        return found;
    }

    int getLastPushedPRBasedIndependentScope() {
        assert (this.scopes.size() > 1);
        ListIterator scopeItr = this.scopes.listIterator(this.scopeLevel);
        int found = -1;
        while (scopeItr.hasPrevious()) {
            Scope scope = (Scope)scopeItr.previous();
            DMLQueryInfo dqi = scope.getDMLQueryInfo();
            int subqueryPRScopeLevel = -1;
            if (dqi.isSubQueryInfo() && (subqueryPRScopeLevel = ((SubQueryInfo)dqi).getLastPushedPRBasedIndependentScopeLevel()) != -1) {
                found = subqueryPRScopeLevel;
                break;
            }
            if (!dqi.getRegion().getDataPolicy().withPartitioning()) continue;
            found = scope.getScopeLevel();
            break;
        }
        return found;
    }

    Scope getScopeAt(int index) {
        return (Scope)this.scopes.elementAt(index);
    }

    public int getAbsoluteStart() {
        return this.absoluteStart;
    }

    public final boolean optimizeForWrite() {
        return GemFireXDUtils.isSet(this.flags, (byte)2);
    }

    public boolean withSecondaries() {
        return GemFireXDUtils.isSet(this.flags, (byte)32);
    }

    public final void setOptimizeForWrite(boolean flag) {
        this.flags = GemFireXDUtils.set(this.flags, (byte)2, flag);
    }

    public final void setWithSecondaries(boolean flag) {
        this.flags = GemFireXDUtils.set(this.flags, (byte)32, flag);
    }

    public final void setOptimizer(Optimizer opt) {
        this.optimizer = (OptimizerImpl)opt;
    }

    public final boolean isColocationCheckDisabled() {
        return GemFireXDUtils.isSet(this.flags, (byte)64);
    }

    public final ArrayList<THashSet> getTableColocationPrCorrName() {
        return this.optimizer.getBestJoinOrderColocationPrCorrName();
    }

    public final int getDriverTablePrID() {
        return this.optimizer.getBestJoinOrderDriverTablePrID();
    }

    public final String virtualTable() {
        return this.virtualTable;
    }

    public final boolean isVTIDistributable() {
        return this.isVTIDistributable;
    }

    public final void setHasVirtualTable(String tableName, boolean isVTIDistributable) {
        if (isVTIDistributable || !this.isVTIDistributable) {
            this.virtualTable = tableName;
            this.isVTIDistributable = isVTIDistributable;
        }
    }

    public boolean isPreparedStatementQuery() {
        return GemFireXDUtils.isSet(this.flags, (byte)1);
    }

    void setQuerySectionUnderAnalysis(byte querySection) {
        this.currentQuerySection = querySection;
    }

    public void foundParameter(int paramNumber) {
        this.querySectionForParameter[paramNumber] = this.currentQuerySection;
    }

    byte getQuerySectionForParameter(int paramNumber) {
        return this.querySectionForParameter[paramNumber];
    }
}

