/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;

public class InsertQueryInfo
extends DMLQueryInfo {
    private static final long serialVersionUID = 1L;
    private final SelectQueryInfo subSelectInfo;
    private boolean isPutDml = false;
    private String schema;
    private String tableName;
    private LocalRegion region;

    public InsertQueryInfo(QueryInfoContext qic, SelectQueryInfo selectInfo, Boolean isPutDml) throws StandardException {
        super(qic);
        this.subSelectInfo = selectInfo;
        this.isPutDml = isPutDml;
    }

    @Override
    public boolean isInsert() {
        return true;
    }

    public boolean isPutDML() {
        return this.isPutDml;
    }

    @Override
    public boolean hasSubSelect() {
        return this.subSelectInfo != null;
    }

    public static void checkSupportedInsertSubSelect(SelectQueryInfo sInfo) throws StandardException {
        if (!(!sInfo.hasUnionNode() && !sInfo.hasIntersectOrExceptNode() || sInfo.getDriverTableQueryInfo() != null && sInfo.getDriverTableQueryInfo().isPartitionedRegion())) {
            return;
        }
        if (sInfo.isQuery(8, 16, 2, 1) || sInfo.isOuterJoinSpecialCase() || sInfo.hasIntersectOrExceptNode() || sInfo.isRemoteGfxdSubActivationNeeded()) {
            throw StandardException.newException("0A000.S", "inserts as sub selects not supported for selects which needs aggregation");
        }
    }

    public SelectQueryInfo getSubSelectQueryInfo() {
        if (this.hasSubSelect()) {
            return this.subSelectInfo;
        }
        throw new UnsupportedOperationException("InsertQueryInfo is used for SubSelect only");
    }

    @Override
    public void setInsertAsSubSelect(boolean b, String targetTableName) {
        if (this.hasSubSelect()) {
            this.subSelectInfo.setInsertAsSubSelect(b, targetTableName);
            return;
        }
        throw new UnsupportedOperationException("InsertQueryInfo is used for SubSelect only");
    }

    @Override
    public boolean isInsertAsSubSelect() {
        if (this.hasSubSelect()) {
            return this.subSelectInfo.isInsertAsSubSelect();
        }
        return false;
    }

    @Override
    public String getTargetTableName() {
        if (this.hasSubSelect()) {
            return this.subSelectInfo.getTargetTableName();
        }
        throw new UnsupportedOperationException("InsertQueryInfo is used for SubSelect only");
    }

    @Override
    public boolean isTableVTI() {
        if (this.hasSubSelect()) {
            return this.subSelectInfo.isTableVTI();
        }
        throw new UnsupportedOperationException("InsertQueryInfo is used for SubSelect only");
    }

    @Override
    public boolean routeQueryToAllNodes() {
        if (this.hasSubSelect()) {
            return this.subSelectInfo.routeQueryToAllNodes();
        }
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return false;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        return node;
    }

    @Override
    public LocalRegion getRegion() {
        if (this.region != null) {
            return this.region;
        }
        if (this.hasSubSelect()) {
            this.region = this.subSelectInfo.getRegion();
            return this.region;
        }
        throw new UnsupportedOperationException("InsertQueryInfo is used for SubSelect only");
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setSchemaTableAndRegion(String schema, String table, LocalRegion lr) {
        this.schema = schema;
        this.tableName = table;
        this.region = lr;
    }
}

