/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.catalog;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.IsolationLevel;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.ProxyBucketRegion;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.locks.LockingPolicy;
import com.gemstone.gemfire.internal.cache.persistence.query.CloseableIterator;
import com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider;
import com.gemstone.gemfire.internal.snappy.ColumnTableEntry;
import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.auth.callback.UserAuthenticator;
import com.pivotal.gemfirexd.internal.catalog.ExternalCatalog;
import com.pivotal.gemfirexd.internal.catalog.SystemProcedures;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLQueueEntry;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.CallbackProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.messages.GfxdSystemProcedureMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractGfxdReplayableMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.QueryCancelFunction;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GetLeadNodeInfoAsStringMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.SecurityUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.CustomRowsResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.db.PropertyInfo;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementColumnPermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementPermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementRoutinePermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementTablePermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialBlob;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialClob;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.LDAPAuthenticationSchemeImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.conn.GenericLanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.JarUtil;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.GfxdJarMessage;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.load.Import;
import io.snappydata.thrift.BucketOwners;
import io.snappydata.thrift.CatalogMetadataDetails;
import io.snappydata.thrift.CatalogMetadataRequest;
import io.snappydata.thrift.CatalogTableObject;
import io.snappydata.thrift.ServerType;
import io.snappydata.thrift.internal.ClientBlob;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;

public class GfxdSystemProcedures
extends SystemProcedures {
    public static final Logger logger = Logger.getLogger(GfxdSystemProcedures.class);
    private static final ResultColumnDescriptor[] usersColumnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("NAME", 12, false, 256), EmbedResultSetMetaData.getResultColumnDescriptor("TYPE", 12, false, 8)};
    private static final ResultColumnDescriptor[] encryptColumnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("ENCRYPTED_PASSWORD", 12, false, 32672)};
    private static final ResultColumnDescriptor[] exportDDLsColumnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("SCHEMANAME", 12, true, 256), EmbedResultSetMetaData.getResultColumnDescriptor("OBJECTNAME", 12, true, 256), EmbedResultSetMetaData.getResultColumnDescriptor("SQLTEXT", 2005, false)};
    private static final SharedUtils.CSVVisitor<TIntArrayList, Void> projectionAgg = (str, projection, context) -> projection.add(Integer.parseInt(str.trim()));
    private static final ResultColumnDescriptor[] columnScanInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("UUID", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("BUCKETID", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("COLUMNPOSITION", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("DATA", 2004, false)};

    public static void CREATE_USER(String userID, String password) throws SQLException {
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("executing SYS.CREATE_USER for " + userID));
        }
        if (userID == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("28502", "null"));
        }
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        boolean ddLocked = false;
        boolean cleanupOnError = false;
        try {
            ddLocked = lcc.getDataDictionary().lockForWriting(tc, false);
            boolean isBUILTIN = AuthenticationServiceBase.isAuthenticationBUILTIN(null);
            userID = IdUtil.getDBUserId(userID, isBUILTIN);
            AuthenticationServiceBase.validateUserPassword(userID, password, !isBUILTIN);
            String oldValue = GfxdSystemProcedures.GET_DATABASE_PROPERTY(userID);
            if (oldValue != null && oldValue.length() > 0) {
                throw StandardException.newException("28504", userID);
            }
            PropertyInfo.setDatabaseProperty(userID, password, true);
            cleanupOnError = true;
            String encryptedpwd = GfxdSystemProcedures.GET_DATABASE_PROPERTY(userID);
            if (encryptedpwd == null) {
                encryptedpwd = "--W-O-NTS-TOR-E-" + userID;
            }
            if (isBUILTIN && encryptedpwd.equals(password) && !AuthenticationServiceBase.isEncrypted(password)) {
                SanityManager.THROWASSERT((String)("shouldn't have stored the password in clear text '" + encryptedpwd + "' for user '" + userID + "'"));
            }
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("publishing SYS.CREATE_USER(" + userID + "," + encryptedpwd + ")"));
            }
            GfxdSystemProcedures.publishMessage(new Object[]{userID, encryptedpwd}, false, GfxdSystemProcedureMessage.SysProcMethod.createUser, true, true);
            cleanupOnError = false;
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("returning from SYS.CREATE_USER(" + userID + "," + encryptedpwd + ")"));
                SanityManager.ASSERT((PropertyUtil.whereSet(userID, null) != 0 ? 1 : 0) != 0, (String)("Cannot be a system user " + userID));
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        finally {
            if (cleanupOnError) {
                PropertyInfo.setDatabaseProperty(userID, null, false);
            }
            if (ddLocked) {
                try {
                    lcc.getDataDictionary().unlockAfterWriting(tc, false);
                }
                catch (StandardException se) {
                    SanityManager.DEBUG_PRINT((String)"warning:EXCEPTION", (String)"Failed to unlock DataDictionary for writing", (Throwable)se);
                }
            }
        }
    }

    public static void CHANGE_PASSWORD(String userID, String oldPassword, String newPassword) throws SQLException {
        boolean ddLocked;
        TransactionController tc;
        DataDictionary dd;
        block26: {
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("executing SYS.CHANGE_PASSWORD for " + userID));
            }
            if (userID == null) {
                throw PublicAPI.wrapStandardException(StandardException.newException("28502", "null"));
            }
            AuthenticationService[] otherService = new AuthenticationService[1];
            boolean isBUILTIN = AuthenticationServiceBase.isAuthenticationBUILTIN(otherService);
            if (!isBUILTIN) {
                throw PublicAPI.wrapStandardException(StandardException.newException("0A000.S.26", otherService[0]));
            }
            String origUserName = userID;
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            dd = lcc.getDataDictionary();
            tc = lcc.getTransactionExecute();
            ddLocked = false;
            boolean cleanupOnError = false;
            boolean validateOldPassword = true;
            String oldValue = null;
            try {
                ddLocked = dd.lockForWriting(tc, false);
                String authorizationId = lcc.getAuthorizationId();
                String userName = GfxdSystemProcedures.getBUILTINUserName(userID);
                if (lcc.usesSqlAuthorization() && !authorizationId.equals(IdUtil.getUserAuthorizationId(userName))) {
                    List list = dd.getRoutineList(dd.getSystemSchemaDescriptor().getUUID().toString(), "CHANGE_PASSWORD", 'P');
                    if (list.size() > 1) {
                        throw StandardException.newException("42X47", "SYS.CHANGE_PASSWORD");
                    }
                    if (list.size() != 1) {
                        throw StandardException.newException("42Y03", (Object)"SYS.CHANGE_PASSWORD", (Object)"");
                    }
                    StatementRoutinePermission.check(((AliasDescriptor)list.get(0)).getUUID(), authorizationId, false, dd, tc);
                    validateOldPassword = oldPassword != null && oldPassword.length() > 0;
                } else if (!lcc.usesSqlAuthorization() && authorizationId.equals(dd.getAuthorizationDatabaseOwner())) {
                    validateOldPassword = oldPassword != null && oldPassword.length() > 0;
                }
                userID = IdUtil.getDBUserId(userID, true);
                AuthenticationServiceBase.validateUserPassword(userID, newPassword, false);
                oldValue = GfxdSystemProcedures.GET_DATABASE_PROPERTY(userID);
                if (oldValue == null || oldValue.length() <= 0) {
                    throw StandardException.newException("28502", userID);
                }
                if (validateOldPassword) {
                    Properties info = new Properties();
                    info.setProperty("user", userName);
                    info.setProperty("password", oldPassword);
                    info.setProperty(SecurityUtils.GFXD_SEC_PREFIX + "opType", "old_password_validation");
                    String failure = InternalDriver.activeDriver().getAuthenticationService().authenticate(lcc.getDbname(), info);
                    if (failure != null) {
                        throw StandardException.newException("08004.S.12", (Object)origUserName, (Object)failure);
                    }
                }
                PropertyInfo.setDatabaseProperty(userID, newPassword, true);
                cleanupOnError = true;
                String encryptedpwd = GfxdSystemProcedures.GET_DATABASE_PROPERTY(userID);
                if (encryptedpwd == null) {
                    encryptedpwd = "--W-O-NTS-TOR-E-" + userID;
                }
                if (encryptedpwd.equals(newPassword) && !AuthenticationServiceBase.isEncrypted(newPassword)) {
                    SanityManager.THROWASSERT((String)("shouldn't have stored the password in clear text '" + encryptedpwd + "' for user '" + userID + "'"));
                }
                if (GemFireXDUtils.TraceAuthentication) {
                    SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("publishing SYS.CHANGE_PASSWORD(" + userID + "," + encryptedpwd + ")"));
                }
                GfxdSystemProcedures.publishMessage(new Object[]{userID, oldPassword, encryptedpwd}, false, GfxdSystemProcedureMessage.SysProcMethod.changePassword, true, true);
                cleanupOnError = false;
                if (GemFireXDUtils.TraceAuthentication) {
                    SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("returning from SYS.CHANGE_PASSWORD(" + userID + "," + encryptedpwd + ")"));
                    SanityManager.ASSERT((PropertyUtil.whereSet(userID, null) != 0 ? 1 : 0) != 0, (String)("Cannot be a system user " + userID));
                }
                if (!cleanupOnError) break block26;
            }
            catch (StandardException se) {
                try {
                    throw PublicAPI.wrapStandardException(se);
                }
                catch (Throwable throwable) {
                    if (cleanupOnError) {
                        PropertyInfo.setDatabaseProperty(userID, oldValue, false);
                    }
                    if (ddLocked) {
                        try {
                            dd.unlockAfterWriting(tc, false);
                        }
                        catch (StandardException se2) {
                            SanityManager.DEBUG_PRINT((String)"warning:EXCEPTION", (String)"Failed to unlock DataDictionary for writing", (Throwable)se2);
                        }
                    }
                    throw throwable;
                }
            }
            PropertyInfo.setDatabaseProperty(userID, oldValue, false);
        }
        if (ddLocked) {
            try {
                dd.unlockAfterWriting(tc, false);
            }
            catch (StandardException se) {
                SanityManager.DEBUG_PRINT((String)"warning:EXCEPTION", (String)"Failed to unlock DataDictionary for writing", (Throwable)se);
            }
        }
    }

    public static void DROP_USER(String userID) throws SQLException {
        boolean ddLocked;
        TransactionController tc;
        LanguageConnectionContext lcc;
        block15: {
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("executing SYS.DROP_USER(" + userID + ")"));
            }
            if (userID == null) {
                throw PublicAPI.wrapStandardException(StandardException.newException("28502", "null"));
            }
            String origUser = userID;
            lcc = ConnectionUtil.getCurrentLCC();
            tc = lcc.getTransactionExecute();
            ddLocked = false;
            String oldValue = null;
            boolean resetOldValue = false;
            try {
                ddLocked = lcc.getDataDictionary().lockForWriting(tc, false);
                boolean isAuthBuiltIn = AuthenticationServiceBase.isAuthenticationBUILTIN(null);
                userID = IdUtil.getDBUserId(userID, isAuthBuiltIn);
                oldValue = GfxdSystemProcedures.GET_DATABASE_PROPERTY(userID);
                if (oldValue == null && isAuthBuiltIn) {
                    throw PublicAPI.wrapStandardException(StandardException.newException("28502", origUser));
                }
                resetOldValue = true;
                Object[] params = new Object[]{userID};
                GfxdSystemProcedureMessage.SysProcMethod.dropUser.processMessage(params, (DistributedMember)Misc.getMyId());
                GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.dropUser, true, true);
                resetOldValue = false;
                if (GemFireXDUtils.TraceAuthentication) {
                    SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("returning from SYS.DROP_USER(" + userID + ")"));
                }
                if (!resetOldValue || oldValue == null) break block15;
            }
            catch (StandardException se) {
                try {
                    throw PublicAPI.wrapStandardException(se);
                }
                catch (Throwable throwable) {
                    if (resetOldValue && oldValue != null) {
                        PropertyInfo.setDatabaseProperty(userID, oldValue, false);
                    }
                    if (ddLocked) {
                        try {
                            lcc.getDataDictionary().unlockAfterWriting(tc, false);
                        }
                        catch (StandardException se2) {
                            SanityManager.DEBUG_PRINT((String)"warning:EXCEPTION", (String)"Failed to unlock DataDictionary for writing", (Throwable)se2);
                        }
                    }
                    throw throwable;
                }
            }
            PropertyInfo.setDatabaseProperty(userID, oldValue, false);
        }
        if (ddLocked) {
            try {
                lcc.getDataDictionary().unlockAfterWriting(tc, false);
            }
            catch (StandardException se) {
                SanityManager.DEBUG_PRINT((String)"warning:EXCEPTION", (String)"Failed to unlock DataDictionary for writing", (Throwable)se);
            }
        }
    }

    private static String getBUILTINUserName(String userID) {
        if (userID.startsWith("gemfirexd.user.")) {
            userID = userID.substring("gemfirexd.user.".length());
        } else if (userID.startsWith("sqlfire.user.")) {
            userID = userID.substring("sqlfire.user.".length());
        }
        return userID;
    }

    public static void SHOW_USERS(ResultSet[] users) throws SQLException {
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)"executing SYS.SHOW_USERS()");
        }
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        try {
            final Properties allProps = lcc.getTransactionExecute().getProperties();
            final String dbOwner = lcc.getDataDictionary().getAuthorizationDatabaseOwner();
            CustomRowsResultSet.FetchDVDRows fetchRows = new CustomRowsResultSet.FetchDVDRows(){
                final Iterator<String> keys;
                {
                    this.keys = allProps.stringPropertyNames().iterator();
                }

                @Override
                public boolean getNext(DataValueDescriptor[] template) throws StandardException {
                    while (this.keys.hasNext()) {
                        String key = this.keys.next();
                        if (key != null && key.startsWith("gemfirexd.user.")) {
                            String user = key.substring("gemfirexd.user.".length());
                            template[0].setValue(user);
                            template[1].setValue(user.equals(dbOwner) ? "DBA" : "USER");
                            return true;
                        }
                        if (key == null || !key.startsWith("sqlfire.user.")) continue;
                        String user = key.substring("sqlfire.user.".length());
                        template[0].setValue(user);
                        template[1].setValue(user.equals(dbOwner) ? "DBA" : "USER");
                        return true;
                    }
                    return false;
                }
            };
            users[0] = new CustomRowsResultSet(fetchRows, usersColumnInfo);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void ENCRYPT_PASSWORD(final String userID, String password, String transformation, int keySize, ResultSet[] encryptedPwdRs) throws SQLException {
        if (GemFireXDUtils.TraceAuthentication || GemFireXDUtils.TraceSysProcedures) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("executing SYS.ENCRYPT_PASSWORD(), userID=" + userID + ", transformation=" + transformation + ", keySize=" + keySize));
        }
        try {
            String algo;
            String user = IdUtil.getDBUserId(userID, false);
            String string = algo = transformation == null ? "AES" : GemFireXDUtils.getPrivateKeyAlgorithm(transformation);
            if (keySize <= 0) {
                keySize = 128;
            }
            GemFireXDUtils.initializePrivateKey(algo, keySize, null);
            final String encryptedString = "v13b607k2j6" + GemFireXDUtils.encrypt(password, transformation, GemFireXDUtils.getUserPasswordCipherKeyBytes(user, transformation, keySize));
            CustomRowsResultSet.FetchDVDRows fetchRows = new CustomRowsResultSet.FetchDVDRows(){
                boolean resultReturned = false;

                @Override
                public boolean getNext(DataValueDescriptor[] template) throws StandardException {
                    if (!this.resultReturned) {
                        template[0].setValue(userID + " = " + encryptedString);
                        this.resultReturned = true;
                        return true;
                    }
                    return false;
                }
            };
            encryptedPwdRs[0] = new CustomRowsResultSet(fetchRows, encryptColumnInfo);
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    public static void SET_CRITICAL_HEAP_PERCENTAGE(float heapPercentage) {
        InternalResourceManager rmgr = Misc.getGemFireCache().getResourceManager();
        rmgr.setCriticalHeapPercentage(heapPercentage);
        SanityManager.DEBUG_PRINT((String)"info:TraceSystemProcedures", (String)("configured critical heap percentage to " + rmgr.getCriticalHeapPercentage()));
    }

    public static void SET_CRITICAL_OFFHEAP_PERCENTAGE(float offHeapPercentage) {
        InternalResourceManager rmgr = Misc.getGemFireCache().getResourceManager();
        rmgr.setCriticalOffHeapPercentage(offHeapPercentage);
        SanityManager.DEBUG_PRINT((String)"info:TraceSystemProcedures", (String)("configured critical off heap percentage to " + rmgr.getCriticalOffHeapPercentage()));
    }

    public static void SET_CRITICAL_HEAP_PERCENTAGE_SG(float heapPercentage, String serverGroups) throws SQLException, StandardException {
        Object[] args = new Object[]{Float.valueOf(heapPercentage), serverGroups};
        GfxdSystemProcedureMessage.SysProcMethod.setCriticalHeapPercentage.processMessage(args, (DistributedMember)Misc.getMyId());
        GfxdSystemProcedures.publishMessage(args, true, GfxdSystemProcedureMessage.SysProcMethod.setCriticalHeapPercentage, true, true);
    }

    public static void SET_CRITICAL_OFFHEAP_PERCENTAGE_SG(float offHeapPercentage, String serverGroups) throws SQLException, StandardException {
        Object[] args = new Object[]{Float.valueOf(offHeapPercentage), serverGroups};
        GfxdSystemProcedureMessage.SysProcMethod.setCriticalOffHeapPercentage.processMessage(args, (DistributedMember)Misc.getMyId());
        GfxdSystemProcedures.publishMessage(args, true, GfxdSystemProcedureMessage.SysProcMethod.setCriticalOffHeapPercentage, true, true);
    }

    public static float GET_CRITICAL_HEAP_PERCENTAGE() {
        return Misc.getGemFireCache().getResourceManager().getCriticalHeapPercentage();
    }

    public static float GET_CRITICAL_OFFHEAP_PERCENTAGE() {
        return Misc.getGemFireCache().getResourceManager().getCriticalOffHeapPercentage();
    }

    public static void SET_EVICTION_HEAP_PERCENTAGE(float heapPercentage) {
        InternalResourceManager rmgr = Misc.getGemFireCache().getResourceManager();
        rmgr.setEvictionHeapPercentage(heapPercentage);
        SanityManager.DEBUG_PRINT((String)"info:TraceSystemProcedures", (String)("configured eviction heap percentage to " + rmgr.getEvictionHeapPercentage()));
    }

    public static void SET_EVICTION_OFFHEAP_PERCENTAGE(float offHeapPercentage) {
        InternalResourceManager rmgr = Misc.getGemFireCache().getResourceManager();
        rmgr.setEvictionOffHeapPercentage(offHeapPercentage);
        SanityManager.DEBUG_PRINT((String)"info:TraceSystemProcedures", (String)("configured eviction off heap percentage to " + rmgr.getEvictionOffHeapPercentage()));
    }

    public static void SET_EVICTION_HEAP_PERCENTAGE_SG(float heapPercentage, String serverGroups) throws SQLException, StandardException {
        Object[] args = new Object[]{Float.valueOf(heapPercentage), serverGroups};
        GfxdSystemProcedureMessage.SysProcMethod.setEvictionHeapPercentage.processMessage(args, (DistributedMember)Misc.getMyId());
        GfxdSystemProcedures.publishMessage(args, true, GfxdSystemProcedureMessage.SysProcMethod.setEvictionHeapPercentage, true, true);
    }

    public static void SET_EVICTION_OFFHEAP_PERCENTAGE_SG(float offHeapPercentage, String serverGroups) throws SQLException, StandardException {
        Object[] args = new Object[]{Float.valueOf(offHeapPercentage), serverGroups};
        GfxdSystemProcedureMessage.SysProcMethod.setEvictionOffHeapPercentage.processMessage(args, (DistributedMember)Misc.getMyId());
        GfxdSystemProcedures.publishMessage(args, true, GfxdSystemProcedureMessage.SysProcMethod.setEvictionOffHeapPercentage, true, true);
    }

    public static float GET_EVICTION_HEAP_PERCENTAGE() {
        return Misc.getGemFireCache().getResourceManager().getEvictionHeapPercentage();
    }

    public static float GET_EVICTION_OFFHEAP_PERCENTAGE() {
        return Misc.getGemFireCache().getResourceManager().getEvictionOffHeapPercentage();
    }

    public static void GET_ALLSERVERS_AND_PREFSERVER(String excludedServers, String[] prefServerName, int[] prefServerPort, String[] allNetServers) throws SQLException {
        String servers = GemFireXDUtils.getGfxdAdvisor().getAllDRDAServers();
        allNetServers[0] = servers.length() < 32695 ? servers : null;
        GfxdSystemProcedures.GET_PREFSERVER(excludedServers, prefServerName, prefServerPort);
    }

    public static void GET_ALLSERVERS_AND_PREFSERVER2(String excludedServers, String[] prefServerName, int[] prefServerPort, Clob[] allNetServers) throws SQLException {
        String[] allServers = new String[1];
        GfxdSystemProcedures.GET_ALLSERVERS_AND_PREFSERVER(excludedServers, prefServerName, prefServerPort, allServers);
        allNetServers[0] = allServers[0] != null ? new HarmonySerialClob(allServers[0]) : null;
    }

    public static void GET_PREFSERVER(String excludedServers, String[] prefServerName, int[] prefServerPort) throws SQLException {
        prefServerName[0] = null;
        prefServerPort[0] = -1;
        ServerLocation server = GemFireXDUtils.getPreferredServer(Collections.singletonList(ServerType.DRDA.getServerGroupName()), null, excludedServers, true);
        if (server != null) {
            prefServerName[0] = server.getHostName();
            prefServerPort[0] = server.getPort();
        }
    }

    public static void SET_STATEMENT_STATISTICS(int enable) throws SQLException, StandardException {
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("GfxdSystemProcedure: Switching " + (enable == 0 ? "Off" : "On") + " statement statistics collection. "));
        }
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        lcc.setStatsEnabled(enable == 1, lcc.getStatisticsTiming(), lcc.explainConnection());
        String key = "gemfirexd.distributedsystem.statement-statistics-mode";
        String value = enable == 0 ? null : "TRUE";
        GfxdSystemProcedures.publishMessage(new Object[]{"gemfirexd.distributedsystem.statement-statistics-mode", value}, false, GfxdSystemProcedureMessage.SysProcMethod.setDatabaseProperty, false, false);
    }

    public static void SET_GLOBAL_STATEMENT_STATISTICS(Boolean enableStats, Boolean enableTimeStats) throws SQLException, StandardException {
        Object[] params = new Object[]{enableStats, enableTimeStats};
        GfxdSystemProcedureMessage.SysProcMethod.setStatementStats.processMessage(params, (DistributedMember)Misc.getMyId());
        GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.setStatementStats, false, false);
    }

    public static void SET_STATISTICS_SUMMARY(String archiveFile) throws SQLException {
        String key = "gemfirexd.distributedsystem.statistics-summary-mode";
        String value = archiveFile != null && archiveFile.length() > 0 ? archiveFile : null;
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        boolean ddLocked = false;
        try {
            ddLocked = lcc.getDataDictionary().lockForWriting(tc, false);
            PropertyInfo.setDatabaseProperty("gemfirexd.distributedsystem.statistics-summary-mode", value, value != null);
            GfxdSystemProcedures.publishMessage(new Object[]{"gemfirexd.distributedsystem.statistics-summary-mode", value}, false, GfxdSystemProcedureMessage.SysProcMethod.setDatabaseProperty, true, false);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        finally {
            if (ddLocked) {
                try {
                    lcc.getDataDictionary().unlockAfterWriting(tc, false);
                }
                catch (StandardException se) {
                    SanityManager.DEBUG_PRINT((String)"warning:EXCEPTION", (String)"Failed to unlock DataDictionary for writing", (Throwable)se);
                }
            }
        }
    }

    public static void SET_EXPLAIN_CONNECTION(int enable) throws SQLException, StandardException {
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("GfxdSystemProcedure: Switching " + (enable == 0 ? "Off" : "On") + " connection level plan collection "));
        }
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        if (enable == 0) {
            lcc.setStatsEnabled(lcc.statsEnabled(), lcc.getStatisticsTiming(), false);
        } else {
            lcc.setStatsEnabled(lcc.statsEnabled(), lcc.getStatisticsTiming(), true);
        }
        String key = "gemfirexd.distributedsystem.statement-explain-mode";
        String value = enable == 0 ? null : "TRUE";
        PropertyInfo.setDatabaseProperty("gemfirexd.distributedsystem.statement-explain-mode", value, value != null);
        GfxdSystemProcedures.publishMessage(new Object[]{"gemfirexd.distributedsystem.statement-explain-mode", value}, false, GfxdSystemProcedureMessage.SysProcMethod.setDatabaseProperty, false, false);
    }

    public static int GET_EXPLAIN_CONNECTION() throws SQLException {
        return ConnectionUtil.getCurrentLCC().explainConnection() ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void EXPORT_DDLS(final Boolean exportAll, ResultSet[] rs) throws SQLException, StandardException, CacheException, InterruptedException {
        GemFireStore memStore = Misc.getMemStore();
        GfxdDataDictionary dd = memStore.getDatabase().getDataDictionary();
        if (dd == null) {
            throw Util.generateCsSQLException("08006.D", "gemfirexd");
        }
        dd.lockForReadingRT(null);
        try {
            final GfxdDDLRegionQueue ddlQ = new GfxdDDLRegionQueue(memStore.getDDLStmtQueue().getRegion());
            ddlQ.initializeQueue(dd);
            CustomRowsResultSet.FetchDVDRows fetchRows = new CustomRowsResultSet.FetchDVDRows(){
                private final List<GfxdDDLQueueEntry> allDDLs;
                private final Iterator<GfxdDDLQueueEntry> ddlIter;
                {
                    this.allDDLs = ddlQ.peekAndRemoveFromQueue(-1, -1);
                    this.ddlIter = ddlQ.getPreprocessedDDLQueue(this.allDDLs, null, null, null, false).iterator();
                }

                @Override
                public boolean getNext(DataValueDescriptor[] template) throws StandardException {
                    boolean debugOn = SanityManager.DEBUG_ON((String)"ExportDDLs");
                    while (this.ddlIter.hasNext()) {
                        AbstractGfxdReplayableMessage msg;
                        String sql;
                        GfxdDDLQueueEntry entry = this.ddlIter.next();
                        Object val = entry.getValue();
                        if (debugOn) {
                            SanityManager.DEBUG_PRINT((String)"ExportDDLs", (String)("Read queue entry " + val + " of type " + val.getClass()));
                        }
                        if (val instanceof DDLConflatable) {
                            DDLConflatable ddl = (DDLConflatable)val;
                            String currentSchema = ddl.getCurrentSchema();
                            if (currentSchema == null) {
                                currentSchema = "APP";
                            }
                            template[0].setValue(currentSchema);
                            String objectName = ddl.getKeyToConflate();
                            if (objectName == null) {
                                objectName = ddl.getRegionToConflate();
                            }
                            template[1].setValue(objectName);
                            template[2].setValue(ddl.getValueToConflate());
                            return true;
                        }
                        if (exportAll == null || !exportAll.booleanValue() || (sql = (msg = (AbstractGfxdReplayableMessage)val).getSQLStatement()) == null) continue;
                        String currentSchema = msg.getSchemaName();
                        if (currentSchema == null) {
                            template[0].setToNull();
                        } else {
                            template[0].setValue(currentSchema);
                        }
                        template[1].setToNull();
                        template[2].setValue(sql);
                        return true;
                    }
                    return false;
                }
            };
            rs[0] = new CustomRowsResultSet(fetchRows, exportDDLsColumnInfo);
        }
        finally {
            dd.unlockAfterReading(null);
        }
    }

    public static void INSTALL_JAR_BYTES(Blob jarBlob, String jarName) throws SQLException {
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("INSTALL_JAR_BYTES called for alias " + jarName));
        }
        try {
            if (jarBlob == null || jarName == null) {
                throw StandardException.newException("XIE06.S");
            }
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String[] st = GfxdJarMessage.getSchemaName(jarName.trim(), lcc);
            JarUtil.install(lcc, st[0], st[1], jarBlob);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void REPLACE_JAR_BYTES(Blob jarBlob, String jarName) throws SQLException {
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("REPLACE_JAR_BYTES called for alias " + jarName));
        }
        try {
            if (jarBlob == null || jarName == null) {
                throw StandardException.newException("XIE06.S");
            }
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String[] st = GfxdJarMessage.getSchemaName(jarName.trim(), lcc);
            JarUtil.replace(lcc, st[0], st[1], jarBlob);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void REBALANCE_ALL_BUCKETS() throws SQLException {
        try {
            RebalanceOperation rebalanceOp = Misc.getGemFireCache().getResourceManager().createRebalanceFactory().start();
            rebalanceOp.getResults();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            Misc.checkIfCacheClosing(ie);
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    public static void GET_CATALOG_METADATA(int operation, Blob args, Blob[] outMetadata) throws SQLException {
        try {
            CatalogMetadataRequest request = new CatalogMetadataRequest();
            Assert.assertTrue((GemFireXDUtils.readThriftObject(request, args.getBytes(1L, (int)args.length())) == 0 ? 1 : 0) != 0);
            args.free();
            if (GemFireXDUtils.TraceSysProcedures) {
                logger.info((Object)("Executing GET_CATALOG_METADATA operation=" + operation + ": " + request));
            }
            ExternalCatalog catalog = Misc.getMemStore().getExistingExternalCatalog();
            CatalogMetadataDetails result = new CatalogMetadataDetails();
            LocalRegion region = catalog.fillCatalogMetadata(operation, request, result);
            if (operation == 4 && result.isSetCatalogTable() && region != null) {
                CatalogTableObject catalogTable = result.getCatalogTable();
                String schema = request.getSchemaName();
                String table = request.getNameOrPattern();
                if (region.getAttributes().getPartitionAttributes() != null) {
                    GfxdSystemProcedures.getBucketToServerMapping((PartitionedRegion)region, catalogTable);
                } else {
                    GfxdSystemProcedures.getReplicaServerMapping((DistributedRegion)region, catalogTable);
                }
            }
            outMetadata[0] = new HarmonySerialBlob(GemFireXDUtils.writeThriftObject(result));
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    public static void UPDATE_CATALOG_METADATA(int operation, Blob args) throws SQLException {
        try {
            CatalogMetadataDetails request = new CatalogMetadataDetails();
            Assert.assertTrue((GemFireXDUtils.readThriftObject(request, args.getBytes(1L, (int)args.length())) == 0 ? 1 : 0) != 0);
            args.free();
            if (GemFireXDUtils.TraceSysProcedures) {
                logger.info((Object)("Executing UPDATE_CATALOG_METADATA operation=" + operation + ": " + request));
            }
            ExternalCatalog catalog = Misc.getMemStore().getExistingExternalCatalog();
            String currentUser = ((GenericLanguageConnectionContext)ConnectionUtil.getCurrentLCC()).getUserName();
            catalog.updateCatalogMetadata(operation, request, currentUser);
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    private static void getReplicaServerMapping(DistributedRegion region, CatalogTableObject catalogTable) {
        UnifiedSet owners = new UnifiedSet();
        Set replicas = region.getDistributionAdvisor().adviseInitializedReplicates();
        Map<InternalDistributedMember, String> mbrToServerMap = GemFireXDUtils.getGfxdAdvisor().getAllNetServersWithMembers();
        ArrayList<String> replicaOwners = new ArrayList<String>(owners.size());
        if (ServerGroupUtils.isDataStore()) {
            owners.add(Misc.getGemFireCache().getMyId());
        }
        owners.addAll(replicas);
        for (InternalDistributedMember node : owners) {
            String netServer = mbrToServerMap.get(node);
            if (netServer == null) continue;
            replicaOwners.add(netServer);
        }
        BucketOwners bucketOwners = new BucketOwners(-1);
        bucketOwners.setSecondaries(replicaOwners);
        catalogTable.setBucketOwners(Collections.singletonList(bucketOwners));
    }

    public static List<String> getIndexColumns(LocalRegion region) throws StandardException {
        GemFireContainer container = (GemFireContainer)region.getUserAttribute();
        TableDescriptor td = container.getTableDescriptor();
        ArrayList<String> cols = new ArrayList<String>(2);
        if (td != null) {
            int[] pkCols;
            ReferencedKeyConstraintDescriptor primaryKey;
            String[] baseColumns = td.getColumnNamesArray();
            GfxdIndexManager im = container.getIndexManager();
            if (im != null && im.getIndexConglomerateDescriptors() != null) {
                for (ConglomerateDescriptor cd : im.getIndexConglomerateDescriptors()) {
                    int[] indexCols = cd.getIndexDescriptor().baseColumnPositions();
                    cols.add(baseColumns[indexCols[0] - 1]);
                }
            }
            if ((primaryKey = td.getPrimaryKey()) != null && (pkCols = primaryKey.getKeyColumns()) != null && pkCols.length > 0) {
                cols.add(baseColumns[pkCols[0] - 1]);
            }
        }
        return cols;
    }

    public static List<String> getPKColumns(LocalRegion region) throws StandardException {
        GemFireContainer container = (GemFireContainer)region.getUserAttribute();
        TableDescriptor td = container.getTableDescriptor();
        ArrayList<String> cols = new ArrayList<String>(2);
        if (td != null) {
            int[] pkCols;
            String[] baseColumns = td.getColumnNamesArray();
            ReferencedKeyConstraintDescriptor primaryKey = td.getPrimaryKey();
            if (primaryKey != null && (pkCols = primaryKey.getKeyColumns()) != null) {
                for (int pkCol : pkCols) {
                    cols.add(baseColumns[pkCol - 1]);
                }
            }
        }
        return cols;
    }

    public static void GET_DEPLOYED_JARS(String[] jarStrings) throws SQLException {
        try {
            String resJarStrings;
            if (GemFireXDUtils.TraceSysProcedures) {
                SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)"executing GET_DEPLOYED_JARS");
            }
            GfxdListResultCollector collector = new GfxdListResultCollector();
            GetLeadNodeInfoAsStringMessage msg = new GetLeadNodeInfoAsStringMessage(collector, GetLeadNodeInfoAsStringMessage.DataReqType.GET_JARS, null);
            msg.executeFunction();
            Object result = collector.getResult();
            jarStrings[0] = resJarStrings = (String)((ArrayList)result).get(0);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void CREATE_OR_DROP_RESERVOIR_REGION(String reservoirRegionName, String resolvedBaseName, Boolean isDrop) throws SQLException {
        try {
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String currentUser = ((GenericLanguageConnectionContext)lcc).getUserName();
            int dotIndex = resolvedBaseName.indexOf(46);
            if (dotIndex == -1) {
                throw new UnsupportedOperationException("Cannot created reservoir region for base name = " + resolvedBaseName + " having no schema");
            }
            String schema = resolvedBaseName.substring(0, dotIndex);
            CallbackFactoryProvider.getStoreCallbacks().checkSchemaPermission(schema, currentUser);
            if (GfxdSystemProcedures.createOrDropReservoirRegion(reservoirRegionName, resolvedBaseName, isDrop)) {
                Object[] args = new Object[]{reservoirRegionName, resolvedBaseName, isDrop};
                GfxdSystemProcedures.publishMessage(args, false, GfxdSystemProcedureMessage.SysProcMethod.createOrDropReservoirRegion, true, false);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    public static boolean createOrDropReservoirRegion(String reservoirRegionName, String resolvedBaseName, boolean isDrop) {
        PartitionedRegion existingRegion = Misc.getReservoirRegionForSampleTable(reservoirRegionName);
        if (isDrop) {
            CallbackFactoryProvider.getStoreCallbacks().removeSampler(resolvedBaseName);
            if (existingRegion != null) {
                existingRegion.destroyRegion(null);
                return true;
            }
            return false;
        }
        if (existingRegion == null) {
            PartitionedRegion region = Misc.createReservoirRegionForSampleTable(reservoirRegionName, resolvedBaseName);
            if (Misc.initialDDLReplayDone()) {
                Assert.assertTrue((region != null ? 1 : 0) != 0);
            }
            return true;
        }
        return false;
    }

    public static void CREATE_ALL_BUCKETS(String tableName) throws SQLException {
        String table;
        String schema;
        if (tableName == null) {
            throw Util.generateCsSQLException("XIE06.S");
        }
        int dotIndex = tableName.indexOf(46);
        if (dotIndex >= 0) {
            schema = tableName.substring(0, dotIndex);
            table = tableName.substring(dotIndex + 1);
        } else {
            schema = Misc.getDefaultSchemaName(ConnectionUtil.getCurrentLCC());
            table = tableName;
        }
        try {
            GemFireContainer container = CallbackProcedures.getContainerForTable(schema, table);
            GfxdSystemProcedures.CREATE_ALL_BUCKETS_INTERNAL(container.getRegion(), tableName);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void REMOVE_METASTORE_ENTRY(String fqtn, Boolean forceDrop) throws SQLException {
        String table;
        String schema;
        if (fqtn == null) {
            throw Util.generateCsSQLException("XIE06.S");
        }
        int dotIndex = fqtn.indexOf(46);
        if (dotIndex >= 0) {
            schema = fqtn.substring(0, dotIndex);
            table = fqtn.substring(dotIndex + 1);
        } else {
            schema = Misc.getDefaultSchemaName(ConnectionUtil.getCurrentLCC());
            table = fqtn;
        }
        ExternalCatalog catalog = Misc.getMemStore().getExistingExternalCatalog();
        catalog.removeTableUnsafeIfExists(schema, table, forceDrop);
        CallbackFactoryProvider.getStoreCallbacks().registerCatalogSchemaChange();
    }

    private static void assignBucketsToPartitions(PartitionedRegion pr) {
        ExecutorService executor = pr.getCache().getDistributionManager().getFunctionExcecutor();
        int numBuckets = pr.getTotalNumberOfBuckets();
        Future[] bucketCreates = new Future[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            int bucketId = i;
            bucketCreates[i] = executor.submit(() -> pr.createBucket(bucketId, 0, null));
        }
        Throwable failure = null;
        for (int i = 0; i < numBuckets; ++i) {
            try {
                bucketCreates[i].get();
                continue;
            }
            catch (InterruptedException ie) {
                pr.getCancelCriterion().checkCancelInProgress((Throwable)ie);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e) {
                pr.getCancelCriterion().checkCancelInProgress((Throwable)e);
                failure = e.getCause();
            }
        }
        if (failure != null) {
            throw new GemFireXDRuntimeException(failure);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void CREATE_ALL_BUCKETS_INTERNAL(LocalRegion region, String tableName) throws SQLException {
        if (region.getAttributes().getPartitionAttributes() == null) throw Util.generateCsSQLException("X0Z15.S", (Object)tableName, "SYS.CREATE_ALL_BUCKETS");
        try {
            List<GemFireContainer> indexContainers;
            GfxdSystemProcedures.assignBucketsToPartitions((PartitionedRegion)region);
            GfxdIndexManager indexManager = (GfxdIndexManager)region.getIndexUpdater();
            if (indexManager == null || (indexContainers = indexManager.getIndexContainers()) == null) return;
            for (GemFireContainer indexContainer : indexContainers) {
                if (!indexContainer.isGlobalIndex()) continue;
                GfxdSystemProcedures.assignBucketsToPartitions((PartitionedRegion)indexContainer.getRegion());
            }
            return;
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    private static void getBucketToServerMapping(PartitionedRegion region, CatalogTableObject catalogTable) throws SQLException {
        Map bidToAdvsrMap = region.getRegionAdvisor().getAllBucketAdvisorsHostedAndProxies();
        int totalBuckets = region.getTotalNumberOfBuckets();
        int redundancy = region.getRedundantCopies();
        if (SanityManager.TraceSingleHop || logger.isDebugEnabled()) {
            logger.info((Object)("getBucketToServerMapping called for region: " + region.getName() + ", with total buckets = " + totalBuckets + " and redundancy = " + redundancy + " and bidToAdvsrMap size = " + bidToAdvsrMap.size() + ", full map: " + bidToAdvsrMap));
        }
        ArrayList<BucketOwners> allBucketOwners = new ArrayList<BucketOwners>(totalBuckets);
        Map<InternalDistributedMember, String> mbrToServerMap = GemFireXDUtils.getGfxdAdvisor().getAllNetServersWithMembers();
        for (Map.Entry entry : bidToAdvsrMap.entrySet()) {
            BucketOwners bucketOwners = new BucketOwners(((Integer)entry.getKey()).intValue());
            BucketAdvisor advisor = (BucketAdvisor)entry.getValue();
            ProxyBucketRegion pbr = advisor.getProxyBucketRegion();
            try {
                pbr.checkBucketRedundancyBeforeGrab(null, false);
            }
            catch (Exception e) {
                throw TransactionResourceImpl.wrapInSQLException(e);
            }
            InternalDistributedMember pmbr = advisor.getPrimary();
            Set bOwners = pbr.getBucketOwners();
            if (pmbr != null) {
                bOwners.remove(pmbr);
                String primaryServer = mbrToServerMap.get(pmbr);
                if (primaryServer != null && primaryServer.length() > 0) {
                    bucketOwners.setPrimary(primaryServer);
                }
            }
            List secondaries = Collections.emptyList();
            for (InternalDistributedMember mbr : bOwners) {
                String secondary = mbrToServerMap.get(mbr);
                if (secondary == null || secondary.length() <= 0) continue;
                if (secondaries.isEmpty()) {
                    secondaries = new ArrayList(bOwners.size());
                }
                secondaries.add(secondary);
            }
            bucketOwners.setSecondaries(secondaries);
            allBucketOwners.add(bucketOwners);
        }
        catalogTable.setRedundancy(redundancy).setBucketOwners(allBucketOwners);
    }

    public static void GET_BUCKET_TO_SERVER_MAPPING(String fqtn, String[] bktToServerMapping) throws SQLException {
        String table;
        String schema;
        int dotIndex = fqtn.indexOf(46);
        if (dotIndex >= 0) {
            schema = fqtn.substring(0, dotIndex);
            table = fqtn.substring(dotIndex + 1);
        } else {
            schema = Misc.getDefaultSchemaName(ConnectionUtil.getCurrentLCC());
            table = fqtn;
        }
        CatalogTableObject catalogTable = new CatalogTableObject();
        PartitionedRegion region = (PartitionedRegion)Misc.getRegionForTable(Misc.getRegionPath(schema, table, null), true);
        GfxdSystemProcedures.getBucketToServerMapping(region, catalogTable);
        StringBuilder bucketInfo = new StringBuilder();
        bucketInfo.append(region.getTotalNumberOfBuckets());
        bucketInfo.append(':');
        bucketInfo.append(catalogTable.getRedundancy());
        bucketInfo.append(':');
        int sz = catalogTable.getBucketOwners().size();
        int cnt = 0;
        for (BucketOwners bucketOwners : catalogTable.getBucketOwners()) {
            ++cnt;
            bucketInfo.append(bucketOwners.getBucketId());
            bucketInfo.append(';');
            String primaryServer = bucketOwners.getPrimary();
            if (primaryServer == null) {
                bucketInfo.append("null");
            } else {
                bucketInfo.append(primaryServer);
            }
            int idx = 0;
            for (String secondary : bucketOwners.getSecondaries()) {
                bucketInfo.append(';');
                if (secondary == null) {
                    bucketInfo.append("null");
                } else {
                    bucketInfo.append(secondary);
                }
                ++idx;
            }
            int shortfall = catalogTable.getRedundancy() - idx;
            if (shortfall != 0) {
                for (int i = 0; i < shortfall; ++i) {
                    bucketInfo.append(";null");
                }
            }
            if (cnt == sz) continue;
            bucketInfo.append('|');
        }
        bktToServerMapping[0] = bucketInfo.toString();
    }

    public static void GET_BUCKET_TO_SERVER_MAPPING2(String fqtn, Clob[] bktToServerMapping) throws SQLException {
        String[] mapping = new String[1];
        GfxdSystemProcedures.GET_BUCKET_TO_SERVER_MAPPING(fqtn, mapping);
        bktToServerMapping[0] = mapping[0] != null ? new HarmonySerialClob(mapping[0]) : null;
    }

    public static void publishMessage(Object[] args, boolean lastArgServerGroups, GfxdSystemProcedureMessage.SysProcMethod systemProcedure, boolean persistent, boolean includeLocators) throws SQLException, StandardException {
        try {
            Set<DistributedMember> locatorMembers;
            LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
            GemFireCacheImpl cache = Misc.getGemFireCache();
            InternalDistributedMember myId = cache.getMyId();
            Set<DistributedMember> members = GfxdMessage.getOtherMembers();
            if (lastArgServerGroups) {
                SortedSet groups = SharedUtils.toSortedSet((String)((String)args[args.length - 1]), (boolean)false);
                args[args.length - 1] = SharedUtils.toCSV((Collection)groups);
            }
            GfxdSystemProcedureMessage msg = new GfxdSystemProcedureMessage(systemProcedure, args, lcc != null ? lcc.getCurrentSchemaName() : null, 1L, 1L, (DistributedMember)myId);
            if (includeLocators && (locatorMembers = GemFireXDUtils.getGfxdAdvisor().adviseServerLocators(true)) != null) {
                members.addAll(locatorMembers);
            }
            members.remove(myId);
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("publishing " + Arrays.toString(args) + " to " + members));
            }
            if (persistent) {
                Misc.getMemStore().getDDLQueueNoThrow().put(msg);
            }
            msg.send(cache.getDistributedSystem(), members, true);
        }
        catch (StandardException | SQLException se) {
            throw se;
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    public static void IMPORT_TABLE_EX(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, short lockTable, int numThreads, short caseSensitiveNames, String importClassName, String errorFile) throws SQLException {
        Misc.invalidSnappyDataFeature("IMPORT_TABLE_EX procedure");
        Connection conn = GfxdSystemProcedures.getDefaultConn();
        try {
            if (schemaName == null) {
                LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
                schemaName = lcc.getDefaultSchema().getSchemaName();
            }
            if (schemaName != null && caseSensitiveNames == 0) {
                schemaName = StringUtil.SQLToUpperCase(schemaName);
            }
            if (tableName != null && caseSensitiveNames == 0) {
                tableName = StringUtil.SQLToUpperCase(tableName);
            }
            if (importClassName == null) {
                importClassName = "com.pivotal.gemfirexd.load.Import";
            }
            Import.importTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset, replace, lockTable != 0, numThreads, importClassName, false, errorFile);
        }
        catch (SQLException se) {
            GfxdSystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    public static void IMPORT_DATA_EX(String schemaName, String tableName, String insertColumnList, String columnIndexes, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, short lockTable, int numThreads, short caseSensitiveNames, String importClassName, String errorFile) throws SQLException {
        Misc.invalidSnappyDataFeature("IMPORT_DATA_EX procedure");
        Connection conn = GfxdSystemProcedures.getDefaultConn();
        try {
            if (schemaName != null && caseSensitiveNames == 0) {
                schemaName = StringUtil.SQLToUpperCase(schemaName);
            }
            if (tableName != null && caseSensitiveNames == 0) {
                tableName = StringUtil.SQLToUpperCase(tableName);
            }
            if (importClassName == null) {
                importClassName = "com.pivotal.gemfirexd.load.Import";
            }
            Import.importData(conn, schemaName, tableName, insertColumnList, columnIndexes, fileName, columnDelimiter, characterDelimiter, codeset, replace, lockTable != 0, numThreads, importClassName, false, errorFile);
        }
        catch (SQLException se) {
            GfxdSystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    public static void IMPORT_TABLE_LOBS_FROM_EXTFILE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, short lockTable, int numThreads, short caseSensitiveNames, String importClassName, String errorFile) throws SQLException {
        Misc.invalidSnappyDataFeature("IMPORT_TABLE_LOBS_FROM_EXTFILE procedure");
        Connection conn = GfxdSystemProcedures.getDefaultConn();
        try {
            if (schemaName != null && caseSensitiveNames == 0) {
                schemaName = StringUtil.SQLToUpperCase(schemaName);
            }
            if (tableName != null && caseSensitiveNames == 0) {
                tableName = StringUtil.SQLToUpperCase(tableName);
            }
            if (importClassName == null) {
                importClassName = "com.pivotal.gemfirexd.load.Import";
            }
            Import.importTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset, replace, lockTable != 0, numThreads, importClassName, true, errorFile);
        }
        catch (SQLException se) {
            GfxdSystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    public static void IMPORT_DATA_LOBS_FROM_EXTFILE(String schemaName, String tableName, String insertColumnList, String columnIndexes, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, short lockTable, int numThreads, short caseSensitiveNames, String importClassName, String errorFile) throws SQLException {
        Misc.invalidSnappyDataFeature("IMPORT_DATA_LOBS_FROM_EXTFILE procedure");
        Connection conn = GfxdSystemProcedures.getDefaultConn();
        try {
            if (schemaName != null && caseSensitiveNames == 0) {
                schemaName = StringUtil.SQLToUpperCase(schemaName);
            }
            if (tableName != null && caseSensitiveNames == 0) {
                tableName = StringUtil.SQLToUpperCase(tableName);
            }
            if (importClassName == null) {
                importClassName = "com.pivotal.gemfirexd.load.Import";
            }
            Import.importData(conn, schemaName, tableName, insertColumnList, columnIndexes, fileName, columnDelimiter, characterDelimiter, codeset, replace, lockTable != 0, numThreads, importClassName, true, errorFile);
        }
        catch (SQLException se) {
            GfxdSystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    public static void SET_LOG_LEVEL(String logClass, String level) throws SQLException, StandardException {
        Object[] params = new Object[]{logClass, level};
        GfxdSystemProcedureMessage.SysProcMethod.setLogLevel.processMessage(params, (DistributedMember)Misc.getMyId());
        GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.setLogLevel, false, true);
    }

    public static void SET_TRACE_FLAG(String traceFlag, Boolean on) throws SQLException, StandardException {
        Object[] params = new Object[]{traceFlag, on};
        GfxdSystemProcedureMessage.SysProcMethod.setTraceFlag.processMessage(params, (DistributedMember)Misc.getMyId());
        GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.setTraceFlag, false, true);
    }

    public static void SET_GATEWAY_FK_CHECKS(Boolean on) throws SQLException, StandardException {
        Object[] params = new Object[]{on};
        GfxdSystemProcedureMessage.SysProcMethod.setGatewayFKChecks.processMessage(params, (DistributedMember)Misc.getMyId());
        GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.setGatewayFKChecks, true, false);
    }

    public static void WAIT_FOR_SENDER_QUEUE_FLUSH(String id, Boolean isAsyncListener, int maxWaitTime) throws SQLException, StandardException {
        Object[] params = new Object[]{id, isAsyncListener, maxWaitTime};
        GfxdSystemProcedureMessage.SysProcMethod.waitForSenderQueueFlush.processMessage(params, (DistributedMember)Misc.getMyId());
        GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.waitForSenderQueueFlush, false, false);
    }

    public static int GET_TABLE_VERSION(String schemaName, String tableName) throws SQLException {
        try {
            GemFireContainer container = GemFireXDUtils.getGemFireContainer(schemaName, tableName, null);
            if (container == null) {
                throw StandardException.newException("42X05", Misc.getFullTableName(schemaName, tableName, null));
            }
            return container.getCurrentSchemaVersion();
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    public static void INCREMENT_TABLE_VERSION(String schemaName, String tableName, int increment) throws SQLException, StandardException {
        if (increment <= 0) {
            throw StandardException.newException("0A000.S", "decrementing table version by " + increment);
        }
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        boolean ddLocked = false;
        try {
            schemaName = Misc.getSchemaName(schemaName, lcc);
            ddLocked = lcc.getDataDictionary().lockForWriting(tc, false);
            Object[] params = new Object[]{schemaName, tableName, increment};
            GfxdSystemProcedureMessage.SysProcMethod.incrementTableVersion.processMessage(params, (DistributedMember)Misc.getMyId());
            GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.incrementTableVersion, true, false);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
        finally {
            if (ddLocked) {
                lcc.getDataDictionary().unlockAfterWriting(tc, false);
            }
        }
    }

    public static void DISKSTORE_FSYNC(String diskStoreName) throws SQLException, StandardException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        boolean ddLocked = false;
        try {
            ddLocked = lcc.getDataDictionary().lockForWriting(tc, false);
            Object[] params = new Object[]{diskStoreName};
            GfxdSystemProcedureMessage.SysProcMethod.diskStoreFsync.processMessage(params, (DistributedMember)Misc.getMyId());
            GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.diskStoreFsync, false, false);
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
        finally {
            if (ddLocked) {
                lcc.getDataDictionary().unlockAfterWriting(tc, false);
            }
        }
    }

    public static void FIX_PREVIOUS_OPS_COUNT(String tableName) {
        Region region = Misc.getRegionForTable(tableName, true);
        if (region != null) {
            if (region instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)region;
                for (BucketRegion br : pr.getDataStore().getAllLocalBucketRegions()) {
                    br.getBucketAdvisor().resetPrevOpCount();
                }
            } else if (region instanceof DistributedRegion) {
                ((DistributedRegion)region).getDistributionAdvisor().resetPrevOpCount();
            }
        }
    }

    public static void DUMP_STACKS(Boolean all) throws SQLException, StandardException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        Object[] params = new Object[]{lcc.getAuthorizationId()};
        GfxdSystemProcedureMessage.SysProcMethod.dumpStacks.processMessage(params, (DistributedMember)Misc.getMyId());
        if (Boolean.TRUE.equals(all)) {
            GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.dumpStacks, false, true);
        }
    }

    public static void setBucketsForLocalExecution(String tableName, Set<Integer> bucketSet, boolean retain, @Nonnull LanguageConnectionContext lcc) {
        Region region = Misc.getRegionForTable(tableName, true);
        lcc.setExecuteLocally(bucketSet, region, false, null);
        lcc.setBucketRetentionForLocalExecution(retain);
    }

    public static void SET_BUCKETS_FOR_LOCAL_EXECUTION(String tableName, String buckets, long catalogSchemaVersion) throws SQLException, StandardException {
        if (tableName == null) {
            throw Util.generateCsSQLException("XIE06.S");
        }
        ExternalCatalog catalog = Misc.getMemStore().getExistingExternalCatalog();
        long actualVersion = catalog.getCatalogSchemaVersion();
        if (catalogSchemaVersion != -1L && actualVersion != catalogSchemaVersion) {
            throw StandardException.newException("X0Z39", (Object)actualVersion, (Object)catalogSchemaVersion);
        }
        Region region = Misc.getRegionForTable(tableName, true);
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        UnifiedSet bucketSet = new UnifiedSet();
        StringTokenizer st = new StringTokenizer(buckets, ",");
        while (st.hasMoreTokens()) {
            bucketSet.add(Integer.parseInt(st.nextToken()));
        }
        GfxdSystemProcedures.setBucketsForLocalExecution(tableName, (Set<Integer>)bucketSet, true, lcc);
    }

    public static void SET_NANOTIMER_TYPE(Boolean useNativeTimer, String nativeTimerType) throws SQLException, StandardException {
        Object[] params = new Object[]{useNativeTimer, nativeTimerType};
        GfxdSystemProcedureMessage.SysProcMethod.setNanoTimerType.processMessage(params, (DistributedMember)Misc.getMyId());
        GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.setNanoTimerType, false, true);
    }

    public static void flushLocalBuckets(String resolvedName, boolean forceFlush) {
        PartitionedRegionDataStore ds;
        PartitionedRegion pr = (PartitionedRegion)Misc.getRegionForTable(resolvedName, false);
        if (pr != null && (ds = pr.getDataStore()) != null) {
            TXStateInterface tx = pr.getTXState();
            for (BucketRegion bucketRegion : ds.getAllLocalPrimaryBucketRegions()) {
                if (!forceFlush && !bucketRegion.checkForColumnBatchCreation(null)) continue;
                bucketRegion.createAndInsertColumnBatch(tx, forceFlush);
            }
        }
    }

    public static Boolean ACQUIRE_REGION_LOCK(String lockName, int timeout) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        GemFireTransaction tr = (GemFireTransaction)lcc.getTransactionExecute();
        PartitionedRegion.RegionLock lock = PartitionedRegion.getRegionLock((String)lockName, (GemFireCacheImpl)GemFireCacheImpl.getExisting());
        if (GemFireXDUtils.TraceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("in procedure ACQUIRE_REGION_LOCK() for lockName:  " + lockName + " timeout=" + timeout));
        }
        try {
            lock.lock(timeout);
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
        if (lock != null) {
            tr.addTableLock(lock);
        }
        return true;
    }

    public static Boolean RELEASE_REGION_LOCK(String lockName) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        GemFireTransaction tr = (GemFireTransaction)lcc.getTransactionExecute();
        PartitionedRegion.RegionLock lock = tr.getRegionLock(lockName);
        if (GemFireXDUtils.TraceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("in procedure RELEASE_REGION_LOCK() for lockName:  " + lockName));
        }
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (Throwable t) {
                throw TransactionResourceImpl.wrapInSQLException(t);
            }
            tr.removeTableLock(lock);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void COMMIT_SNAPSHOT_TXID(String txId, String rolloverTable) throws SQLException {
        try {
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
            if (GemFireXDUtils.TraceExecution) {
                SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("in procedure COMMIT_SNAPSHOT_TXID()  " + txId + " rolloverTable=" + rolloverTable + " for connid " + tc.getConnectionID() + " rolloverTable=" + rolloverTable + " TxManager " + TXManagerImpl.getCurrentTXId() + " snapshot tx = " + TXManagerImpl.getCurrentSnapshotTXState()));
            }
            boolean success = false;
            try {
                if (!rolloverTable.isEmpty()) {
                    GfxdSystemProcedures.flushLocalBuckets(rolloverTable, false);
                }
                success = true;
            }
            finally {
                if (success) {
                    GfxdSystemProcedures.commitSnapShotTXId(txId, lcc, tc);
                } else {
                    GfxdSystemProcedures.rollbackSnapshotTXId(txId, lcc, tc);
                }
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    private static void commitSnapShotTXId(String txId, LanguageConnectionContext lcc, GemFireTransaction tc) {
        TXStateInterface txState = null;
        TXManagerImpl txManager = tc.getTransactionManager();
        if (!txId.isEmpty()) {
            StringTokenizer st = new StringTokenizer(txId, ":");
            long memberId = Long.parseLong(st.nextToken());
            int uniqId = Integer.parseInt(st.nextToken());
            TXId txId1 = TXId.valueOf((long)memberId, (int)uniqId);
            txState = txManager.getHostedTXState(txId1);
        }
        tc.clearActiveTXState(false, true);
        lcc.clearExecuteLocally();
        if (txState != null && txState.isInProgress()) {
            txManager.masqueradeAs(txState);
            txManager.commit();
        } else {
            TXManagerImpl.TXContext context = TXManagerImpl.currentTXContext();
            TXStateInterface tXStateInterface = txState = context != null ? context.getSnapshotTXState() : null;
            if (txState != null) {
                txManager.removeHostedTXState(txState.getTransactionId(), Boolean.TRUE);
            }
            if (GemFireXDUtils.TraceExecution) {
                SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("in procedure COMMIT_SNAPSHOT_TXID()  afer commit" + txId + " for connid " + tc.getConnectionID() + " TxManager " + TXManagerImpl.getCurrentTXId() + " snapshot tx : " + txState + " else part. "));
            }
            if (context != null) {
                context.clearTXStateAll();
            }
        }
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("in procedure COMMIT_SNAPSHOT_TXID()  afer commit" + txId + " for connid " + tc.getConnectionID() + " TxManager " + TXManagerImpl.getCurrentTXId() + " snapshot tx : " + txState));
        }
    }

    public static void ROLLBACK_SNAPSHOT_TXID(String txId) throws SQLException {
        try {
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
            GfxdSystemProcedures.rollbackSnapshotTXId(txId, lcc, tc);
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    private static void rollbackSnapshotTXId(String txId, LanguageConnectionContext lcc, GemFireTransaction tc) {
        TXStateProxy txState = null;
        TXManagerImpl txManager = tc.getTransactionManager();
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("in procedure ROLLBACK_SNAPSHOT_TXID()  " + txId + " for connid " + tc.getConnectionID() + " TxManager " + TXManagerImpl.getCurrentTXId() + " snapshot tx : " + TXManagerImpl.getCurrentSnapshotTXState()));
        }
        if (!txId.isEmpty()) {
            StringTokenizer st = new StringTokenizer(txId, ":");
            long memberId = Long.parseLong(st.nextToken());
            int uniqId = Integer.parseInt(st.nextToken());
            TXId txId1 = TXId.valueOf((long)memberId, (int)uniqId);
            txState = txManager.getHostedTXState(txId1);
        }
        tc.clearActiveTXState(false, true);
        lcc.clearExecuteLocally();
        if (txState != null && txState.isInProgress()) {
            txManager.masqueradeAs(txState);
            txManager.rollback();
        } else {
            TXManagerImpl.TXContext context = TXManagerImpl.currentTXContext();
            if (context != null) {
                context.clearTXStateAll();
            }
        }
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("in procedure ROLLBACK_SNAPSHOT_TXID()  afer commit" + txId + " for connid " + tc.getConnectionID() + " TxManager " + TXManagerImpl.getCurrentTXId() + " snapshot tx : " + TXManagerImpl.getCurrentSnapshotTXState()));
        }
    }

    public static String GET_SNAPSHOT_TXID_AND_HOSTURL(Boolean delayRollover) throws SQLException {
        String txIdAndHostUrl;
        TXStateInterface tx;
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
        TXManagerImpl.TXContext context = TXManagerImpl.currentTXContext();
        TXStateInterface tXStateInterface = tx = context != null ? context.getSnapshotTXState() : null;
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("in function GET_SNAPSHOT_TXID_AND_HOSTURL()  for conn " + tc.getConnectionID() + " delayRollover=" + delayRollover + " tc id" + tc.getTransactionIdString() + " TxManager " + TXManagerImpl.getCurrentTXId() + " snapshot tx : " + tx));
        }
        if (tx != null && !tx.isClosed()) {
            tx.getProxy().setColumnRolloverDisabled(delayRollover.booleanValue());
            txIdAndHostUrl = tx.getTransactionId().stringFormat() + '@' + GemFireXDUtils.getGfxdAdvisor().getOwnNetServers();
        } else {
            txIdAndHostUrl = "@";
        }
        tc.clearActiveTXState(true, true);
        if (context != null) {
            context.setSnapshotTXState(null);
        }
        return txIdAndHostUrl;
    }

    public static void START_SNAPSHOT_TXID(Boolean delayRollover, String[] txid) throws SQLException {
        TXManagerImpl txManager = Misc.getGemFireCache().getCacheTransactionManager();
        TXManagerImpl.TXContext context = TXManagerImpl.getOrCreateTXContext();
        TXStateInterface oldTX = context.getTXState();
        if (oldTX != null) {
            try {
                txManager.rollback(oldTX, null, false);
            }
            catch (TransactionException transactionException) {
                // empty catch block
            }
        }
        context.clearTXStateAll();
        TXStateProxy tx = txManager.beginTX(context, IsolationLevel.SNAPSHOT, null, null);
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
        tc.setActiveTXState((TXStateInterface)tx, false);
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("in procedure START_SNAPSHOT_TXID()  for conn " + tc.getConnectionID() + " delayRollover=" + delayRollover + " tc id" + tc.getTransactionIdString() + " TxManager " + TXManagerImpl.getCurrentTXId() + " snapshot tx : " + tx));
        }
        if (!tx.isClosed()) {
            tx.getProxy().setColumnRolloverDisabled(delayRollover.booleanValue());
            txid[0] = tx.getTransactionId().stringFormat();
        } else {
            txid[0] = "";
        }
    }

    public static void USE_SNAPSHOT_TXID(String txId) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        GfxdSystemProcedures.useSnapshotTXId(txId, lcc);
    }

    public static void useSnapshotTXId(String txId, LanguageConnectionContext lcc) throws SQLException {
        int splitAt = txId.indexOf(58);
        if (splitAt == -1) {
            throw PublicAPI.wrapStandardException(StandardException.newException("X0Z16.T", "Invalid snapshot transaction ID = " + txId));
        }
        long memberId = Long.parseLong(txId.substring(0, splitAt));
        int uniqId = Integer.parseInt(txId.substring(splitAt + 1));
        TXId txId1 = TXId.valueOf((long)memberId, (int)uniqId);
        GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
        TXManagerImpl txManager = tc.getTransactionManager();
        TXStateProxy state = txManager.getHostedTXState(txId1);
        TXManagerImpl.TXContext context = TXManagerImpl.getOrCreateTXContext();
        if (state == null) {
            if (GemFireXDUtils.TraceExecution) {
                SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("In useSnapshotTXId() creating a txState for conn " + tc.getConnectionID() + " tc id" + tc.getTransactionIdString() + " for " + txId1.shortToString()));
            }
            state = txManager.getOrCreateHostedTXState(txId1, LockingPolicy.SNAPSHOT, true);
        }
        txManager.setTXState((TXStateInterface)state, context);
        context.setSnapshotTXState((TXStateInterface)state);
        tc.setActiveTXState((TXStateInterface)state, false);
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("In useSnapshotTXId() for txid " + txId1 + " txState : " + state + " connId" + tc.getConnectionID()));
        }
    }

    public static Boolean GET_IS_NATIVE_NANOTIMER() {
        return NanoTimer.getIsNativeTimer();
    }

    public static String GET_NATIVE_NANOTIMER_TYPE() {
        return NanoTimer.getNativeTimerType();
    }

    public static void REPAIR_CATALOG(Boolean removeInconsistentEntries, Boolean removeTablesWithData) throws SQLException, StandardException {
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("in procedure REPAIR_CATALOG() removeInconsistentEntries=" + removeInconsistentEntries + " removeTablesWithData=" + removeTablesWithData));
        }
        GfxdSystemProcedures.runCatalogConsistencyChecks(removeInconsistentEntries, removeTablesWithData);
    }

    private static void runCatalogConsistencyChecks(boolean removeInconsistentEntries, boolean removeTablesWithData) throws SQLException, StandardException {
        try (EmbedConnection conn = GemFireXDUtils.createNewInternalConnection(false);){
            FabricDatabase.checkSnappyCatalogConsistency(conn, removeInconsistentEntries, removeTablesWithData);
            CallbackFactoryProvider.getStoreCallbacks().registerCatalogSchemaChange();
        }
    }

    public static void CANCEL_STATEMENT(String statementUUID) throws StandardException {
        if (statementUUID == null || !statementUUID.matches("[0-9]+-[0-9]+-[0-9]+")) {
            throw StandardException.newException("22008.S", (Object)statementUUID, (Object)"CANCEL_STATEMENT");
        }
        String[] s = statementUUID.split("-");
        long connectionId = Long.parseLong(s[0]);
        long statementId = Long.parseLong(s[1]);
        long executionID = Long.parseLong(s[2]);
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("CANCEL_STATEMENT connectionId=" + connectionId + " statementId=" + statementId + " executionID=" + executionID));
        }
        QueryCancelFunction.QueryCancelFunctionArgs args = QueryCancelFunction.newQueryCancelFunctionArgs(statementId, connectionId);
        Set<DistributedMember> otherMembers = GfxdMessage.getAllGfxdServers();
        if (otherMembers.size() > 0) {
            FunctionService.onMembers(otherMembers).withArgs((Object)args).execute("gfxd-QueryCancelFunction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int CHECK_TABLE_EX(String schema, String table) throws SQLException, StandardException, InterruptedException {
        Object[] params;
        boolean isStore;
        if (schema == null || table == null) {
            throw StandardException.newException("22008.S", (Object)"NULL", (Object)"CHECK_TABLE_EX");
        }
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("CHECK_TABLE_EX schema:" + schema + "table: " + table));
        }
        if (isStore = ServerGroupUtils.isDataStore()) {
            params = new Object[]{schema, table, Misc.getMyId()};
        } else {
            Set<DistributedMember> dataStores = GfxdMessage.getAllDataStores();
            DistributedMember targetNode = dataStores.iterator().next();
            params = new Object[]{schema, table, targetNode};
        }
        Thread thread = null;
        StandardException[] failure = new StandardException[1];
        try {
            if (isStore) {
                thread = new Thread(() -> {
                    try {
                        GfxdSystemProcedureMessage.SysProcMethod.checkTableEx.processMessage(params, (DistributedMember)Misc.getMyId());
                    }
                    catch (StandardException s) {
                        failure[0] = s;
                    }
                }, "CHECK_TABLE_EX sys proc executor");
                thread.start();
            }
            GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.checkTableEx, false, false);
        }
        finally {
            if (thread != null) {
                thread.join();
            }
        }
        if (failure[0] != null) {
            throw failure[0];
        }
        return 1;
    }

    public static void REFRESH_LDAP_GROUP(String ldapGroup) throws SQLException {
        Set<String> currentMembers;
        if (ldapGroup == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("22008.S", null, (Object)"REFRESH_LDAP_GROUP"));
        }
        ldapGroup = StringUtil.SQLToUpperCase(ldapGroup);
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("REFRESH_LDAP_GROUP ldapGroup=" + ldapGroup));
        }
        try {
            AuthenticationServiceBase authService = Misc.getMemStoreBooting().getDatabase().getAuthenticationService();
            if (authService == null) {
                throw new NameNotFoundException("Require LDAP authentication scheme for LDAP group support no authentication is disabled");
            }
            UserAuthenticator auth = authService.getAuthenticationScheme();
            if (!(auth instanceof LDAPAuthenticationSchemeImpl)) {
                throw new NameNotFoundException("Require LDAP authentication scheme for LDAP group support but is " + auth);
            }
            LDAPAuthenticationSchemeImpl ldapAuth = (LDAPAuthenticationSchemeImpl)auth;
            currentMembers = ldapAuth.getLDAPGroupMembers(ldapGroup);
        }
        catch (NamingException ne) {
            throw PublicAPI.wrapStandardException(StandardException.newException("4251B", (Throwable)ne, (Object)ldapGroup));
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        TransactionController tc = lcc.getTransactionExecute();
        boolean ddLocked = false;
        try {
            ddLocked = lcc.getDataDictionary().lockForWriting(tc, false);
            UnifiedSet origMembers = new UnifiedSet(currentMembers);
            Object[] params = new Object[]{ldapGroup, currentMembers};
            GfxdSystemProcedureMessage.SysProcMethod.refreshLdapGroup.processMessage(params, (DistributedMember)Misc.getMyId());
            params[1] = origMembers;
            GfxdSystemProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.refreshLdapGroup, false, false);
            CallbackFactoryProvider.getStoreCallbacks().clearConnectionPools();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        finally {
            if (ddLocked) {
                try {
                    lcc.getDataDictionary().unlockAfterWriting(tc, false);
                }
                catch (StandardException se) {
                    SanityManager.DEBUG_PRINT((String)"warning:EXCEPTION", (String)"Failed to unlock DataDictionary for writing", (Throwable)se);
                }
            }
        }
    }

    public static void GET_COLUMN_TABLE_SCHEMA(String schema, String table, Clob[] schemaAsJson) throws SQLException {
        String schemaString = Misc.getMemStore().getExistingExternalCatalog().getColumnTableSchemaAsJson(schema, table);
        if (schemaString == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0M.S", table));
        }
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("GET_COLUMN_TABLE_SCHEMA table=" + table + " schema=" + schemaString));
        }
        schemaAsJson[0] = new HarmonySerialClob(schemaString);
    }

    public static void COLUMN_TABLE_SCAN(String columnTable, String projection, Blob filters, ResultSet[] result) throws SQLException {
        try {
            TIntArrayList columnsList = new TIntArrayList(4);
            SharedUtils.splitCSV((String)projection, projectionAgg, (Object)columnsList, null);
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            int[] columns = columnsList.toNativeArray();
            String rowBufferTable = GemFireContainer.getRowBufferTableName(columnTable);
            GfxdSystemProcedures.authorizeTableOperation(lcc, rowBufferTable, columns, 0, 1);
            byte[] batchFilters = null;
            if (filters != null) {
                batchFilters = filters.getBytes(1L, (int)filters.length());
                filters.free();
            }
            Set<Integer> bucketIds = lcc.getBucketIdsForLocalExecution();
            final CloseableIterator iter = CallbackFactoryProvider.getStoreCallbacks().columnTableScan(columnTable, columns, batchFilters, bucketIds);
            if (GemFireXDUtils.TraceExecution) {
                SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)("COLUMN_TABLE_SCAN table=" + columnTable + " projection=" + projection));
            }
            result[0] = new CustomRowsResultSet(new CustomRowsResultSet.FetchDVDRows(){

                @Override
                public boolean getNext(DataValueDescriptor[] template) throws StandardException {
                    if (iter.hasNext()) {
                        ColumnTableEntry entry = (ColumnTableEntry)iter.next();
                        template[0].setValue(entry.uuid);
                        template[1].setValue(entry.bucketId);
                        template[2].setValue(entry.columnPosition);
                        ClientBlob blob = new ClientBlob(entry.columnValue);
                        if (!blob.getCurrentChunk().initChunkFromReference()) {
                            throw StandardException.newException("XSDA4.S", new IllegalStateException("failed to initialize chunk with buffer"));
                        }
                        template[3].setValue((Blob)blob);
                        return true;
                    }
                    return false;
                }

                @Override
                public void close() {
                    iter.close();
                }
            }, columnScanInfo);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    public static void authorizeTableOperation(LanguageConnectionContext lcc, String tableName, int[] columns, int authType, int opType) throws StandardException {
        if (lcc.usesSqlAuthorization()) {
            int numColumns = columns.length;
            ArrayList<StatementPermission> permissions = new ArrayList<StatementPermission>(numColumns + 1);
            GemFireContainer rowContainer = (GemFireContainer)Misc.getRegionForTable(tableName, true).getUserAttribute();
            TableDescriptor td = rowContainer.getTableDescriptor();
            if (td == null) {
                throw StandardException.newException("42X05", tableName);
            }
            permissions.add(new StatementTablePermission(td.getUUID(), authType));
            if (numColumns > 0) {
                FormatableBitSet bitSet = new FormatableBitSet(td.getNumberOfColumns());
                for (int col : columns) {
                    ColumnDescriptor cd = td.getColumnDescriptor(col);
                    if (cd == null) {
                        throw StandardException.newException("42X04", tableName + '.' + col);
                    }
                    bitSet.set(col - 1);
                }
                permissions.add(new StatementColumnPermission(td.getUUID(), authType, bitSet));
            }
            lcc.getAuthorizer().authorize(null, null, permissions, opType);
        }
    }

    private static Connection getDefaultConn() throws SQLException {
        Connection conn;
        InternalDriver id = InternalDriver.activeDriver();
        if (id != null && (conn = id.connect("jdbc:default:connection", null)) != null) {
            return conn;
        }
        throw Util.noCurrentConnection();
    }

    private static void rollBackAndThrowSQLException(Connection conn, SQLException se) throws SQLException {
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            se.setNextException(e);
        }
        throw se;
    }
}

