/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.LogWriter;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.CallbackProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractGfxdReplayableMessage;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GfxdRemoveLoaderMessage
extends AbstractGfxdReplayableMessage {
    private static final long serialVersionUID = 9042246545142608810L;
    private String schema;
    private String table;

    public GfxdRemoveLoaderMessage() {
    }

    public GfxdRemoveLoaderMessage(String schema, String table) {
        this.schema = schema;
        this.table = table;
    }

    @Override
    public void execute() throws StandardException {
        LogWriter logger = Misc.getGemFireCache().getLoggerI18n().convertToLogWriter();
        if (logger.infoEnabled()) {
            logger.info("GfxdRemoveLoaderMessage: Executing with fields as: " + this.toString());
        }
        CallbackProcedures.removeGfxdCacheLoaderLocally(CallbackProcedures.getContainerForTable(this.schema, this.table));
    }

    @Override
    public byte getGfxdID() {
        return 32;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString((String)this.schema, (DataOutput)out);
        DataSerializer.writeString((String)this.table, (DataOutput)out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.schema = DataSerializer.readString((DataInput)in);
        this.table = DataSerializer.readString((DataInput)in);
    }

    @Override
    public void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append("; schema = ");
        sb.append(this.schema);
        sb.append("; table = ");
        sb.append(this.table);
    }

    public boolean shouldBeConflated() {
        return true;
    }

    public String getRegionToConflate() {
        return this.schema + '.' + this.table;
    }

    public Object getKeyToConflate() {
        return "__GFXD_INTERNAL_GFXDLOADER.";
    }

    public Object getValueToConflate() {
        return null;
    }

    @Override
    public String getSQLStatement() {
        StringBuilder sb = new StringBuilder();
        return sb.append("CALL SYS.REMOVE_LOADER('").append(this.schema).append("','").append(this.table).append("')").toString();
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }
}

