/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.IOException;

public class DiskStoreDropOperation
extends MemOperation {
    private String storeName;

    protected DiskStoreDropOperation(String storeName) {
        super(null);
        this.storeName = storeName;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        GemFireTransaction tc = (GemFireTransaction)xact;
        LanguageConnectionContext lcc = tc.getLanguageConnectionContext();
        DataDictionaryImpl dd = (DataDictionaryImpl)lcc.getDataDictionary();
        dd.startWriting(lcc);
        this.storeName = SharedUtils.SQLToUpperCase((String)this.storeName);
        DiskStoreImpl store = Misc.getGemFireCache().findDiskStore(this.storeName);
        try {
            if (store != null) {
                store.destroy();
            }
        }
        catch (Exception e) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)"DropDiskStore :: got Exception", (Throwable)e);
        }
        ExecIndexRow keyRow = dd.getExecutionFactory().getIndexableRow(1);
        keyRow.setColumn(1, new SQLVarchar(this.storeName));
        TabInfoImpl ti = dd.getNonCoreTI(20);
        ti.deleteRow(tc, keyRow, 0);
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("DropDiskStore :: removed DiskStore " + this.storeName + " from SYS table"));
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        throw new UnsupportedOperationException("DiskStoreDropOperation: undo unimplemented; require GFE diskstore rename support");
    }
}

