/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.DiskStoreDropOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdDiskStoreDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.IOException;

public class DiskStoreCreateOperation
extends MemOperation {
    private final DiskStoreFactory dsf;
    private final String storeName;
    private String dirPathsAndSizes;

    public DiskStoreCreateOperation(DiskStoreFactory dsf, String storeName, String dirPathsAndSizes) {
        super(null);
        this.dsf = dsf;
        this.storeName = storeName;
        this.dirPathsAndSizes = dirPathsAndSizes;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        GemFireTransaction tc = (GemFireTransaction)xact;
        LanguageConnectionContext lcc = tc.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        dd.startWriting(lcc);
        GemFireCacheImpl cache = Misc.getGemFireCache();
        if (cache.findDiskStore(this.storeName) != null) {
            throw StandardException.newException("X0Y68.S", (Object)"DISKSTORE", (Object)this.storeName);
        }
        DiskStore ds = GemFireStore.createDiskStore(this.dsf, SharedUtils.SQLToUpperCase((String)this.storeName), cache.getCancelCriterion());
        UUIDFactory factory = dd.getUUIDFactory();
        String diskStoreName = ds.getName();
        UUID id = factory.recreateUUID(diskStoreName);
        GfxdDiskStoreDescriptor dsd = new GfxdDiskStoreDescriptor(dd, id, ds, this.dirPathsAndSizes);
        dd.addDescriptor(dsd, null, 20, false, tc);
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("CreateDiskStoreNode: added diskstore configuration for " + diskStoreName + " in SYS table"));
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        return new DiskStoreDropOperation(this.storeName);
    }
}

