/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.heap;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.IsolationLevel;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.gemstone.gemfire.internal.cache.locks.ExclusiveSharedLockObject;
import com.gemstone.gemfire.internal.cache.locks.LockMode;
import com.gemstone.gemfire.internal.cache.partitioned.PREntriesIterator;
import com.gemstone.gemfire.internal.cache.persistence.query.CloseableIterator;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.MemScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalExecRowLocation;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdFunctionMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapResourceHolder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.BackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowCountable;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MemHeapScanController
implements MemScanController,
RowCountable,
ScanInfo {
    private Qualifier[][] init_qualifier;
    private Iterator<?> entryIterator;
    private PREntriesIterator<?> prEntryIterator;
    private RowLocation currentRowLocation;
    private int bucketId = -1;
    private ExecRow currentExecRow;
    private AbstractCompactExecRow templateCompactExecRow;
    private boolean byteArrayStore;
    private LocalRegion currentDataRegion;
    protected GemFireTransaction tran;
    private Set<Integer> bucketSet;
    private boolean hasNext = true;
    protected long numRows = -1L;
    private int rowlength = -1;
    protected int openMode;
    protected int forUpdate;
    protected GemFireContainer gfContainer;
    protected boolean isOffHeap;
    private boolean addRegionAndKey = false;
    private boolean addKeyForSelectForUpdate = false;
    private String regionName = "";
    GemFireXDQueryObserver observer;
    private LanguageConnectionContext lcc;
    private Activation activation;
    private TXStateInterface txState;
    private TXId txId;
    private boolean snashotTxStarted;
    private com.gemstone.gemfire.internal.cache.locks.LockingPolicy lockPolicy;
    private LockMode readLockMode;
    private TXState localTXState;
    private TXStateInterface localSnapshotTXState;
    private Object lockContext;
    private boolean restoreBatching = true;
    private int statNumRowsVisited;
    private int statNumRowsQualified;
    private int statNumDeletedRowsVisited;
    private FormatableBitSet statValidColumns;
    private static CountDownLatch testLatchAfterFirstQualify;
    private static CountDownLatch testBarrierBeforeFirstScan;
    private OffHeapResourceHolder offheapOwner;
    private static final ThreadLocal<Integer> waitForLatch;
    private boolean queryHDFS = false;

    public static synchronized void setWaitForLatchForTEST(int sleepSecs) {
        waitForLatch.set(sleepSecs);
    }

    public static void setWaitObjectAfterFirstQualifyForTEST(CountDownLatch latch) {
        testLatchAfterFirstQualify = latch;
    }

    public static void setWaitBarrierBeforeFirstScanForTEST(CountDownLatch barrier) {
        testBarrierBeforeFirstScan = barrier;
    }

    protected void init(GemFireTransaction tran, MemConglomerate conglomerate, int openMode, int lockLevel, LockingPolicy locking) throws StandardException {
        this.gfContainer = conglomerate.getGemFireContainer();
        assert (this.gfContainer != null);
        this.isOffHeap = this.gfContainer.isOffHeap();
        conglomerate.openContainer(tran, openMode, lockLevel, locking);
        this.tran = tran;
        this.openMode = openMode;
        this.observer = GemFireXDQueryObserverHolder.getInstance();
    }

    public final GemFireContainer getGemFireContainer() {
        return this.gfContainer;
    }

    @Override
    public final boolean isKeyed() {
        return false;
    }

    @Override
    public final void init(GemFireTransaction tran, MemConglomerate conglomerate, int openMode, int lockLevel, LockingPolicy locking, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, Activation act) throws StandardException {
        this.init(tran, conglomerate, openMode, lockLevel, locking);
        this.lcc = this.tran.getLanguageConnectionContext();
        this.statValidColumns = this.lcc != null && this.lcc.getRunTimeStatisticsMode() ? (scanColumnList != null ? scanColumnList.clone() : null) : null;
        this.statNumRowsVisited = 0;
        this.statNumDeletedRowsVisited = 0;
        this.statNumRowsQualified = 0;
        if (this.observer != null) {
            this.observer.scanControllerOpened(this, conglomerate);
        }
        this.activation = act;
        this.positionAtInitScan(startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, act);
    }

    @Override
    public final int getType() {
        return 0;
    }

    @Override
    public final boolean isScanClosed() {
        return this.tran == null;
    }

    protected final void positionAtInitScan(DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, Activation act) throws StandardException {
        RowFormatter rf;
        if (this.lcc != null) {
            this.queryHDFS = this.lcc.getQueryHDFS();
        }
        if (act != null && act.getHasQueryHDFS()) {
            this.queryHDFS = act.getQueryHDFS();
        }
        this.forUpdate = (this.openMode & 4) != 0 ? 128 : 0;
        LocalRegion region = this.gfContainer.getRegion();
        if (region == null) {
            return;
        }
        if (region instanceof PartitionedRegion) {
            if (this.forUpdate != 0) {
                this.queryHDFS = true;
            }
            ((PartitionedRegion)region).setQueryHDFS(this.queryHDFS);
        }
        this.regionName = this.gfContainer.getQualifiedTableName();
        FunctionContext fc = null;
        if (GemFireXDUtils.TraceOuterJoin) {
            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("MemHeapScanController::positionAtInitScan this is: " + System.identityHashCode(this) + " activation is: " + (act != null ? Integer.valueOf(System.identityHashCode(act)) : "null") + " addregionandkey info is: " + (act != null ? Boolean.valueOf(act.isSpecialCaseOuterJoin()) : "null")));
        }
        if (act != null) {
            this.addRegionAndKey = act.isSpecialCaseOuterJoin();
            this.addKeyForSelectForUpdate = act.needKeysForSelectForUpdate();
            fc = act.getFunctionContext();
        }
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("MemHeapScanController scanning table: " + this.regionName + ", openMode=" + this.openMode + " startKey=" + ArrayUtils.objectString((Object)startKeyValue) + " startOp=" + startSearchOperator + " stopKey=" + ArrayUtils.objectString((Object)startKeyValue) + " stopOp=" + stopSearchOperator + " qualifier=" + ArrayUtils.objectString((Object)qualifier) + ", and the function context: " + fc));
        }
        this.txState = this.gfContainer.getActiveTXState(this.tran);
        boolean restoreBatching = false;
        if (this.txState != null) {
            this.txId = this.txState.getTransactionId();
            this.lockPolicy = this.txState.getLockingPolicy();
            if (this.forUpdate != 0) {
                this.readLockMode = LockMode.SH;
                this.localTXState = this.txState.getTXStateForWrite();
                this.lockContext = this.localTXState.getReadLocksForScanContext((Object)this.lcc);
                restoreBatching = this.localTXState.getProxy().remoteBatching(true);
            } else if (this.lockPolicy.zeroDurationReadLocks()) {
                this.readLockMode = null;
                this.localTXState = this.txState.getLocalTXState();
                this.lockContext = null;
                restoreBatching = true;
            } else {
                this.readLockMode = this.lockPolicy.getReadLockMode();
                this.localTXState = this.txState.getTXStateForRead();
                if (this.localTXState == null) {
                    Assert.fail((Object)("unexpected null local read TXState lockingPolicy=" + this.lockPolicy + " for " + this.txState));
                }
                this.lockContext = this.localTXState.getReadLocksForScanContext((Object)this.lcc);
                restoreBatching = this.localTXState.getProxy().remoteBatching(true);
            }
        } else if (this.gfContainer.isRowBuffer() || region.getCache().snapshotEnabledForTest() && region.getConcurrencyChecksEnabled()) {
            if (region.getConcurrencyChecksEnabled() && region.getCache().getCacheTransactionManager().getTXState() == null) {
                if (GemFireXDUtils.TraceQuery) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("MemHeapScanController scanning table: " + this.regionName + ", openMode=" + this.openMode + " starting the gemfire snapshot tx."));
                }
                region.getCache().getCacheTransactionManager().begin(IsolationLevel.SNAPSHOT, null);
                if (region.getCache().getRowScanTestHook() != null) {
                    region.getCache().notifyScanTestHook();
                    region.getCache().waitOnRowScanTestHook();
                }
                this.txState = region.getCache().getCacheTransactionManager().getTXState();
                this.localTXState = this.txState.getTXStateForRead();
                this.snashotTxStarted = true;
                this.txId = this.txState.getTransactionId();
                this.lockPolicy = this.txState.getLockingPolicy();
                this.readLockMode = this.lockPolicy.getReadLockMode();
                this.lockContext = null;
                restoreBatching = true;
            }
        } else {
            this.txId = null;
            this.readLockMode = null;
            this.localTXState = null;
            this.lockContext = null;
            restoreBatching = true;
        }
        if (!restoreBatching && this.restoreBatching) {
            this.restoreBatching = false;
        }
        this.currentDataRegion = null;
        if (fc != null) {
            if (fc instanceof RegionFunctionContext) {
                InternalRegionFunctionContext rfc = (InternalRegionFunctionContext)fc;
                boolean primaryOnly = true;
                if (fc instanceof GfxdFunctionMessage) {
                    primaryOnly = ((GfxdFunctionMessage)fc).optimizeForWrite();
                }
                this.entryIterator = this.gfContainer.getEntrySetIteratorForFunctionContext(rfc, this.tran, this.txState, this.openMode, primaryOnly);
                this.bucketSet = rfc.getLocalBucketSet((Region)region);
            } else {
                SanityManager.THROWASSERT((Throwable)new UnsupportedOperationException("unexpected function context: " + fc));
            }
        } else if (this.lcc != null && this.lcc.getHDFSSplit() != null) {
            this.entryIterator = this.gfContainer.getEntrySetIteratorHDFSSplit(this.lcc.getHDFSSplit());
        } else {
            Set<Integer> bset = this.lcc == null ? null : this.lcc.getBucketIdsForLocalExecution();
            Region<?, ?> regionForBSet = null;
            boolean prpLEItr = false;
            if (bset != null && (regionForBSet = this.lcc.getRegionForBucketSet()) == this.gfContainer.getRegion()) {
                prpLEItr = true;
            }
            if (prpLEItr) {
                if (GemFireXDUtils.TraceQuery || SanityManager.TraceSingleHop) {
                    SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("MemHeapScanController::positionAtInitScan bucketSet: " + bset + " and forUpdate=" + (this.forUpdate != 0) + " this table: " + this.gfContainer.getQualifiedTableName() + " and lcc is: " + this.lcc + " region is: " + (regionForBSet != null ? regionForBSet.getName() : "(null)")));
                }
                this.bucketSet = bset;
                this.entryIterator = this.gfContainer.getEntrySetIteratorForBucketSet(bset, this.tran, this.txState, this.openMode, this.forUpdate != 0, Misc.getMemStore().isSnappyStore());
            } else {
                boolean useOnlyPrimaryBuckets = (this.openMode & 0x200000) == 0 || act != null && act.getUseOnlyPrimaryBuckets();
                this.entryIterator = this.gfContainer.getEntrySetIterator(this.txState, useOnlyPrimaryBuckets, this.openMode, true);
            }
        }
        this.prEntryIterator = this.entryIterator instanceof PREntriesIterator ? (PREntriesIterator)this.entryIterator : null;
        if (qualifier != null && qualifier.length == 0) {
            qualifier = null;
        }
        this.init_qualifier = qualifier;
        if (this.init_qualifier != null && (rf = this.gfContainer.getCurrentRowFormatter()) != null) {
            for (int idx = this.init_qualifier.length - 1; idx >= 0; --idx) {
                for (Qualifier q : this.init_qualifier[idx]) {
                    if (GemFireXDUtils.TraceByteComparisonOptimization) {
                        SanityManager.DEBUG_PRINT((String)"TraceByteCompareOptimization", (String)("attempting to re-align qualifier " + q));
                    }
                    q.alignOrderableCache(rf.getColumnDescriptor(q.getColumnId()), this.gfContainer);
                }
            }
        }
        this.templateCompactExecRow = (this.byteArrayStore = this.gfContainer.isByteArrayStore()) ? (AbstractCompactExecRow)this.gfContainer.newTemplateRow() : null;
        if (this.snashotTxStarted) {
            TXManagerImpl.TXContext context = TXManagerImpl.getOrCreateTXContext();
            context.clearTXState();
            if (!this.getGemFireContainer().isRowBuffer() || fc != null) {
                if (GemFireXDUtils.TraceQuery) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("MemHeapScanController::positionAtInitScan bucketSet:  lcc.isSkipConstraintChecks " + this.lcc.isSkipConstraintChecks() + " Setting snapshotTxStae to NULL."));
                }
                context.setSnapshotTXState(null);
                this.localSnapshotTXState = this.txState;
            }
            this.txState = null;
            this.localTXState = null;
            this.txId = null;
            this.lockPolicy = null;
            this.readLockMode = null;
            this.lockContext = null;
            restoreBatching = true;
            this.snashotTxStarted = false;
        }
    }

    @Override
    public final boolean delete() throws StandardException {
        assert (this.currentRowLocation != null);
        RegionEntry entry = this.currentRowLocation.getRegionEntry();
        return MemHeapScanController.delete(this.tran, this.txState, this.gfContainer, entry, this.bucketId);
    }

    static boolean delete(GemFireTransaction tran, TXStateInterface tx, GemFireContainer container, RegionEntry entry, int bucketId) throws StandardException {
        boolean deleted = true;
        try {
            if (entry == null || entry.isDestroyedOrRemoved()) {
                return false;
            }
            Object regionKey = entry.getKeyCopy();
            Object routingObject = GemFireXDUtils.getRoutingObject(bucketId);
            if (routingObject == null && container.isPartitioned()) {
                routingObject = GemFireXDUtils.getRoutingObjectFromGlobalIndex(regionKey, entry, container.getRegion());
            }
            container.delete(regionKey, routingObject, false, tran, tx, GemFireTransaction.getLanguageConnectionContext(tran), false);
        }
        catch (EntryNotFoundException enfe) {
            deleted = false;
        }
        catch (EntryDestroyedException ede) {
            deleted = false;
        }
        return deleted;
    }

    @Override
    public final boolean doesCurrentPositionQualify() throws StandardException {
        return true;
    }

    @Override
    public final void fetch(ExecRow destRow) throws StandardException {
        assert (this.currentRowLocation != null);
        assert (this.currentExecRow != null);
        if (destRow instanceof ValueRow) {
            DataValueDescriptor[] destDvds = destRow.getRowArray();
            int len = destDvds.length;
            int nCols = this.currentExecRow.nColumns();
            if (nCols < len) {
                len = nCols;
            }
            for (int i = 0; i < len; ++i) {
                if (destDvds[i] == null) continue;
                destDvds[i].setValue(this.currentExecRow.getColumn(i + 1));
            }
        } else {
            int nCols = destRow.nColumns();
            if (nCols >= this.currentExecRow.nColumns()) {
                destRow.setRowArray(this.currentExecRow);
            } else if (nCols > 0) {
                destRow.setColumns(nCols, this.currentExecRow);
            }
        }
        if (this.addRegionAndKey) {
            assert (!this.addKeyForSelectForUpdate);
            destRow.clearAllRegionAndKeyInfo();
            destRow.addRegionAndKey(this.regionName, this.currentRowLocation.getKeyCopy(), !this.gfContainer.isPartitioned());
        }
        if (this.addKeyForSelectForUpdate) {
            assert (!this.addRegionAndKey);
            destRow.clearAllRegionAndKeyInfo();
            destRow.addRegionAndKey(null, this.currentRowLocation.getKeyCopy(), !this.gfContainer.isPartitioned());
        }
    }

    public void setAddRegionAndKey() {
        this.addRegionAndKey = true;
    }

    @Override
    public ExecRow fetchRow(ExecRow destRow) throws StandardException {
        throw new AssertionError((Object)"should not be called");
    }

    @Override
    public final void fetchWithoutQualify(ExecRow destRow) throws StandardException {
        this.fetch(destRow);
    }

    @Override
    public final RowLocation fetchLocation(RowLocation destRowLocation) throws StandardException {
        if (destRowLocation == null || !(destRowLocation instanceof GlobalExecRowLocation)) {
            assert (this.currentRowLocation.getUnderlyingRegionEntry() != DataValueFactory.DUMMY);
            return this.currentRowLocation;
        }
        GlobalExecRowLocation destloc = (GlobalExecRowLocation)destRowLocation;
        destloc.setFrom(this.currentRowLocation.getUnderlyingRegionEntry());
        return destRowLocation;
    }

    @Override
    public final boolean fetchNext(ExecRow destRow) throws StandardException {
        if (this.next() && this.currentRowLocation != null) {
            this.fetch(destRow);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean next() throws StandardException {
        entryIterator = this.entryIterator;
        prEntryIterator = this.prEntryIterator;
        if (entryIterator == null) {
            return false;
        }
        isGlobalScan = (this.openMode & 0x100000) != 0;
        owner = null;
        entry = null;
        while (true) lbl-1000:
        // 28 sources

        {
            block59: {
                block60: {
                    block55: {
                        block56: {
                            block58: {
                                block57: {
                                    block54: {
                                        block53: {
                                            if (!entryIterator.hasNext()) {
                                                Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
                                                this.currentRowLocation = null;
                                                this.currentExecRow = null;
                                                this.currentDataRegion = null;
                                                this.bucketId = -1;
                                                if (entryIterator instanceof CloseableIterator == false) return false;
                                                ((CloseableIterator)entryIterator).close();
                                                return false;
                                            }
                                            row /* !! */  = null;
                                            try {
                                                this.currentDataRegion = null;
                                                this.currentRowLocation = (RowLocation)entryIterator.next();
                                                ++this.statNumRowsVisited;
                                                if (this.currentRowLocation != null) {
                                                    owner = this.gfContainer.getRegion();
                                                    if (prEntryIterator != null) {
                                                        this.bucketId = prEntryIterator.getBucketId();
                                                        if (this.bucketId >= 0) {
                                                            owner = prEntryIterator.getHostedBucketRegion();
                                                        }
                                                    }
                                                    if (GemFireXDUtils.TraceConglomRead) {
                                                        SanityManager.DEBUG_PRINT((String)"TraceConglomRead", (String)("MemHeapScanController#next: current entry=" + this.currentRowLocation + " bucketId=" + this.bucketId + ", isIterOnPR=" + this.gfContainer.isPartitioned() + (owner != null ? ", owner=" + owner.getFullPath() : "")));
                                                    }
                                                    if (owner == null && !isGlobalScan && !Misc.getMemStore().isSnappyStore()) {
                                                        SanityManager.DEBUG_PRINT((String)"TraceConglomRead", (String)("MemHeapScanController#next: entry=" + this.currentRowLocation + " bucketId=" + this.bucketId + ", isOnPR=" + this.gfContainer.isPartitioned() + " but the Bucket obtained is a ProxyBucketRegion {2}"));
                                                        if (this.currentDataRegion == null || row /* !! */  != null) continue;
                                                        break block53;
                                                    }
                                                    if (this.readLockMode != null && this.currentRowLocation.getTXId() == null) {
                                                        entry = this.currentRowLocation.getUnderlyingRegionEntry();
                                                        if (!GemFireXDUtils.lockForRead(this.localTXState, this.lockPolicy, this.readLockMode, this.forUpdate, entry, this.gfContainer, owner, this.observer)) {
                                                            ++this.statNumDeletedRowsVisited;
                                                            if (this.currentDataRegion == null) continue;
                                                            break block54;
                                                        }
                                                        this.currentDataRegion = owner;
                                                    }
                                                    if ((row /* !! */  = this.templateCompactExecRow != null ? (RegionEntryUtils.fillRowWithoutFaultIn(this.gfContainer, owner, this.currentRowLocation.getRegionEntry(), this.templateCompactExecRow) != false ? this.templateCompactExecRow : null) : RegionEntryUtils.getRowWithoutFaultIn(this.gfContainer, owner, this.currentRowLocation.getRegionEntry(), this.currentRowLocation.getTableInfo(this.gfContainer))) != null) {
                                                        this.currentExecRow = row /* !! */ ;
                                                        if (this.currentDataRegion == null) break block55;
                                                        break block56;
                                                    }
                                                    ++this.statNumDeletedRowsVisited;
                                                    if (this.currentDataRegion == null) continue;
                                                    break block57;
                                                }
                                                if (GemFireXDUtils.TraceConglomRead) {
                                                    SanityManager.DEBUG_PRINT((String)"TraceConglomRead", (String)("MemHeapScanController#next: current entry null for bucketId=" + this.bucketId + ", isIterOnPR=" + this.gfContainer.isPartitioned()));
                                                }
                                                ++this.statNumDeletedRowsVisited;
                                                if (this.currentDataRegion == null) continue;
                                                break block58;
                                            }
                                            catch (EntryDestroyedException e) {
                                                if (this.currentDataRegion == null || row /* !! */  != null) continue;
                                                GemFireXDUtils.unlockEntryAfterRead(this.txId, this.lockPolicy, this.readLockMode, entry, this.gfContainer, this.currentDataRegion);
                                                this.currentDataRegion = null;
                                                continue;
                                            }
                                            catch (EntryNotFoundException e) {
                                                if (this.currentDataRegion == null || row /* !! */  != null) continue;
                                                GemFireXDUtils.unlockEntryAfterRead(this.txId, this.lockPolicy, this.readLockMode, entry, this.gfContainer, this.currentDataRegion);
                                                this.currentDataRegion = null;
                                                continue;
                                            }
                                            catch (GemFireXDRuntimeException e) {
                                                t = e.getCause();
                                                if (t instanceof EntryDestroyedException) continue;
                                                if (t instanceof EntryNotFoundException == false) throw e;
                                                continue;
                                            }
                                        }
                                        GemFireXDUtils.unlockEntryAfterRead(this.txId, this.lockPolicy, this.readLockMode, entry, this.gfContainer, this.currentDataRegion);
                                        this.currentDataRegion = null;
                                        continue;
                                    }
                                    if (row /* !! */  != null) continue;
                                    GemFireXDUtils.unlockEntryAfterRead(this.txId, this.lockPolicy, this.readLockMode, entry, this.gfContainer, this.currentDataRegion);
                                    this.currentDataRegion = null;
                                    continue;
                                }
                                if (row /* !! */  != null) continue;
                                GemFireXDUtils.unlockEntryAfterRead(this.txId, this.lockPolicy, this.readLockMode, entry, this.gfContainer, this.currentDataRegion);
                                this.currentDataRegion = null;
                                continue;
                            }
                            if (row /* !! */  != null) continue;
                            GemFireXDUtils.unlockEntryAfterRead(this.txId, this.lockPolicy, this.readLockMode, entry, this.gfContainer, this.currentDataRegion);
                            this.currentDataRegion = null;
                            continue;
                        }
                        if (row /* !! */  != null) break block55;
                        GemFireXDUtils.unlockEntryAfterRead(this.txId, this.lockPolicy, this.readLockMode, entry, this.gfContainer, this.currentDataRegion);
                        this.currentDataRegion = null;
                        break block55;
                        finally {
                            if (this.currentDataRegion == null || row /* !! */  != null) continue;
                            GemFireXDUtils.unlockEntryAfterRead(this.txId, this.lockPolicy, this.readLockMode, entry, this.gfContainer, this.currentDataRegion);
                            this.currentDataRegion = null;
                            continue;
                        }
                    }
                    if (MemHeapScanController.testBarrierBeforeFirstScan != null) {
                        try {
                            MemHeapScanController.testBarrierBeforeFirstScan.countDown();
                            MemHeapScanController.testBarrierBeforeFirstScan.await();
                        }
                        catch (InterruptedException ie) {
                            throw new InternalGemFireError((Throwable)ie);
                        }
                    }
                    rowQualified = false;
                    try {
                        if (this.init_qualifier != null && !RowFormatter.qualifyRow(this.currentExecRow, this.byteArrayStore, this.init_qualifier)) break block59;
                        rowQualified = true;
                        ++this.statNumRowsQualified;
                        if (this.currentDataRegion != null) {
                            this.localTXState.addReadLockForScan((ExclusiveSharedLockObject)entry, this.readLockMode, owner, this.lockContext);
                        }
                        if (MemHeapScanController.testLatchAfterFirstQualify != null && MemHeapScanController.waitForLatch.get() > 0) {
                            try {
                                MemHeapScanController.testLatchAfterFirstQualify.await(MemHeapScanController.waitForLatch.get().intValue(), TimeUnit.SECONDS);
                            }
                            catch (InterruptedException ie) {
                                throw new InternalGemFireError((Throwable)ie);
                            }
                        }
                        ie = true;
                        if (rowQualified) break block60;
                    }
                    catch (Throwable var12_20) {
                        if (!rowQualified) {
                            try {
                                if (this.currentDataRegion == null) throw var12_20;
                                GemFireXDUtils.unlockEntryAfterRead(this.txId, this.lockPolicy, this.readLockMode, entry, this.gfContainer, this.currentDataRegion);
                                this.currentDataRegion = null;
                                throw var12_20;
                            }
                            finally {
                                if (this.currentExecRow != null) {
                                    this.currentExecRow.releaseByteSource();
                                    this.currentExecRow = null;
                                }
                            }
                        }
                        if (this.isOffHeap == false) throw var12_20;
                        v0 = offheapOwner = this.offheapOwner != null ? this.offheapOwner : this.tran;
                        if (this.currentExecRow == null) {
                            offheapOwner.addByteSource(null);
                            throw var12_20;
                        }
                        bs = this.currentExecRow.getByteSource();
                        if (bs instanceof OffHeapByteSource) {
                            offheapOwner.addByteSource((OffHeapByteSource)bs);
                            throw var12_20;
                        }
                        offheapOwner.addByteSource(null);
                        throw var12_20;
                    }
                    try {
                        if (this.currentDataRegion == null) return ie;
                        GemFireXDUtils.unlockEntryAfterRead(this.txId, this.lockPolicy, this.readLockMode, entry, this.gfContainer, this.currentDataRegion);
                        this.currentDataRegion = null;
                        return ie;
                    }
                    finally {
                        if (this.currentExecRow != null) {
                            this.currentExecRow.releaseByteSource();
                            this.currentExecRow = null;
                        }
                    }
                }
                if (this.isOffHeap == false) return ie;
                v1 = offheapOwner = this.offheapOwner != null ? this.offheapOwner : this.tran;
                if (this.currentExecRow == null) {
                    offheapOwner.addByteSource(null);
                    return ie;
                }
                bs = this.currentExecRow.getByteSource();
                if (bs instanceof OffHeapByteSource) {
                    offheapOwner.addByteSource((OffHeapByteSource)bs);
                    return ie;
                }
                offheapOwner.addByteSource(null);
                return ie;
            }
            if (!rowQualified) {
                try {
                    if (this.currentDataRegion == null) ** GOTO lbl-1000
                    GemFireXDUtils.unlockEntryAfterRead(this.txId, this.lockPolicy, this.readLockMode, entry, this.gfContainer, this.currentDataRegion);
                    this.currentDataRegion = null;
                }
                finally {
                    if (this.currentExecRow == null) ** GOTO lbl-1000
                    this.currentExecRow.releaseByteSource();
                    this.currentExecRow = null;
                }
                continue;
            }
            if (!this.isOffHeap) continue;
            v2 = offheapOwner = this.offheapOwner != null ? this.offheapOwner : this.tran;
            if (this.currentExecRow != null) {
                bs = this.currentExecRow.getByteSource();
                if (bs instanceof OffHeapByteSource) {
                    offheapOwner.addByteSource((OffHeapByteSource)bs);
                    continue;
                }
                offheapOwner.addByteSource(null);
                continue;
            }
            offheapOwner.addByteSource(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean replace(DataValueDescriptor[] row, FormatableBitSet validColumns) throws StandardException {
        RegionEntry regionEntry = this.currentRowLocation.getRegionEntry();
        assert (regionEntry != null) : "Replacing a null RegionEntry is not allowed!";
        boolean updated = true;
        try {
            this.gfContainer.replacePartialRow(regionEntry, validColumns, row, this.bucketId, this.tran, this.txState, this.tran.getLanguageConnectionContext());
        }
        catch (EntryDestroyedException ede) {
            updated = false;
        }
        catch (EntryNotFoundException enfe) {
            updated = false;
        }
        finally {
            if (this.currentExecRow != null) {
                // empty if block
            }
        }
        return updated;
    }

    private final void closeScan() throws StandardException {
        if (this.tran != null) {
            this.tran.closeMe(this);
            this.tran = null;
            if (this.localTXState != null) {
                if (this.lockContext != null) {
                    if (this.forUpdate != 0) {
                        this.localTXState.pendingReadLocksCleanup(this.lockPolicy, this.lockContext, (Object)this.lcc);
                    } else {
                        this.localTXState.pendingReadLocksToTXState(this.lockPolicy, this.lockContext, (Object)this.lcc);
                    }
                }
                if (!this.restoreBatching) {
                    this.localTXState.getProxy().remoteBatching(false);
                    this.restoreBatching = true;
                }
            }
        }
        this.activation = null;
        if (this.localSnapshotTXState != null) {
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"TraceTran", (String)"MemHeapScanController::closeScan :  Commiting snapshotTxStae. ");
            }
            this.localSnapshotTXState.commit(null);
        }
        this.lcc = null;
        this.txId = null;
        this.txState = null;
        this.localSnapshotTXState = null;
        this.readLockMode = null;
        this.localTXState = null;
        this.lockContext = null;
        this.init_qualifier = null;
        if (this.entryIterator instanceof CloseableIterator) {
            ((CloseableIterator)this.entryIterator).close();
        }
        this.entryIterator = null;
        this.prEntryIterator = null;
        this.currentRowLocation = null;
        this.currentExecRow = null;
        this.templateCompactExecRow = null;
        this.byteArrayStore = false;
        this.currentDataRegion = null;
        this.bucketId = -1;
        this.bucketSet = null;
        this.observer = null;
        this.hasNext = true;
        this.numRows = -1L;
        this.rowlength = -1;
    }

    @Override
    public final void close() throws StandardException {
        if (!this.isScanClosed()) {
            this.closeScan();
        }
        this.offheapOwner = null;
    }

    @Override
    public final ScanInfo getScanInfo() throws StandardException {
        return this;
    }

    @Override
    public final boolean isTableLocked() {
        return false;
    }

    @Override
    public final RowLocation newRowLocationTemplate() throws StandardException {
        return MemHeapScanController.newRowLocationTemplate(this.gfContainer, this.openMode);
    }

    static RowLocation newRowLocationTemplate(GemFireContainer container, int openMode) throws StandardException {
        if ((openMode & 0x100000) > 0) {
            return new GlobalExecRowLocation();
        }
        return DataValueFactory.DUMMY;
    }

    @Override
    public final void reopenScan(DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, Activation activation) throws StandardException {
        this.positionAtInitScan(startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, this.activation);
        this.hasNext = true;
    }

    @Override
    public final void reopenScanByRowLocation(RowLocation startRowLocation, Qualifier[][] qualifier) throws StandardException {
    }

    static final boolean isForUpdate(int openMode) {
        return (openMode & 4) != 0;
    }

    @Override
    public final long getEstimatedRowCount() throws StandardException {
        if (this.numRows == -1L) {
            this.numRows = this.bucketSet != null ? (long)this.gfContainer.getRegion().entryCountEstimate(this.txState, this.bucketSet, this.queryHDFS) : this.gfContainer.getEstimatedRowCount(0);
        }
        return this.numRows;
    }

    @Override
    public final void setEstimatedRowCount(long count) throws StandardException {
        this.numRows = count;
    }

    @Override
    public final boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        if (!this.isScanClosed() && closeHeldScan) {
            this.closeScan();
            return true;
        }
        return false;
    }

    @Override
    public int getScanKeyGroupID() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    @Override
    public final void fetchSet(long max_rowcnt, int[] key_column_numbers, BackingStoreHashtable hash_table) throws StandardException {
        boolean isReplicated;
        if (max_rowcnt == 0L) {
            return;
        }
        assert (this.entryIterator != null);
        this.hasNext = this.next();
        if (!this.hasNext) {
            return;
        }
        assert (this.currentExecRow != null);
        assert (this.currentRowLocation != null);
        if (this.rowlength < 0) {
            this.rowlength = this.currentExecRow.nColumns();
        }
        ExecRow row = this.gfContainer.newTemplateRow();
        this.fetch(row);
        RegionAndKey rak = null;
        boolean bl = isReplicated = !this.gfContainer.isPartitioned();
        if (this.addRegionAndKey) {
            rak = new RegionAndKey(this.regionName, this.currentRowLocation.getKeyCopy(), isReplicated);
        }
        if (this.addKeyForSelectForUpdate) {
            assert (!this.addRegionAndKey);
            rak = new RegionAndKey(null, this.currentRowLocation.getKeyCopy(), isReplicated);
        }
        hash_table.putRow(false, row.getRowArray(), rak);
        long count = 1L;
        if (max_rowcnt == -1L) {
            max_rowcnt = Long.MAX_VALUE;
        }
        while (count++ < max_rowcnt) {
            row = this.gfContainer.newTemplateRow();
            this.hasNext = this.fetchNext(row);
            if (!this.hasNext) break;
            if (this.addRegionAndKey) {
                assert (!this.addKeyForSelectForUpdate);
                rak = null;
                rak = new RegionAndKey(this.regionName, this.currentRowLocation.getKeyCopy(), isReplicated);
            } else if (this.addKeyForSelectForUpdate) {
                assert (!this.addRegionAndKey);
                rak = new RegionAndKey(null, this.currentRowLocation.getKeyCopy(), isReplicated);
            }
            hash_table.putRow(false, row.getRowArray(), rak);
        }
        if (count == max_rowcnt && this.hasNext) {
            return;
        }
    }

    @Override
    public final void savePosition(Conglomerate conglom, Page page) throws StandardException {
    }

    @Override
    public final int fetchNextGroup(ExecRow[] row_array, RowLocation[] rowloc_array, Object[] indexKeys, int[] nodeVersions, int[] scanKeyGroupID, LocalRegion[] dataRegions) throws StandardException {
        int i;
        boolean setRowLocation;
        if (!this.hasNext) {
            return 0;
        }
        boolean bl = setRowLocation = rowloc_array != null;
        assert (row_array.length > 0 && row_array[0] != null);
        int max_rowcnt = row_array.length;
        for (i = 0; i < max_rowcnt; ++i) {
            ExecRow row = row_array[i];
            if (row == null) {
                row = row_array[0].getNewNullRow();
            }
            this.hasNext = this.fetchNext(row);
            if (!this.hasNext) break;
            if (setRowLocation) {
                rowloc_array[i] = this.fetchLocation(rowloc_array[i]);
            }
            if (dataRegions != null) {
                dataRegions[i] = this.currentDataRegion;
            }
            if (row_array[i] != null) continue;
            row_array[i] = row;
        }
        return i;
    }

    @Override
    public final Properties getAllScanInfo(Properties prop) throws StandardException {
        if (prop == null) {
            prop = new Properties();
        }
        prop.setProperty(MessageService.getTextMessage("XSAJ0.U"), MessageService.getTextMessage("XSAJG.U"));
        prop.setProperty(MessageService.getTextMessage("XSAJ2.U"), Integer.toString(this.statNumRowsVisited));
        prop.setProperty(MessageService.getTextMessage("XSAJ3.U"), Integer.toString(this.statNumDeletedRowsVisited));
        prop.setProperty(MessageService.getTextMessage("XSAJ4.U"), Integer.toString(this.statNumRowsQualified));
        if (this.gfContainer.isByteArrayStore()) {
            prop.setProperty(MessageService.getTextMessage("XSAJ5.U"), Integer.toString(this.statValidColumns != null ? this.statValidColumns.getNumBitsSet() : this.gfContainer.getNumColumns()));
        }
        prop.setProperty(MessageService.getTextMessage("XSAJ6.U"), this.statValidColumns == null ? MessageService.getTextMessage("XSAJE.U") : this.statValidColumns.toString());
        return prop;
    }

    @Override
    public int fetchNextGroup(DataValueDescriptor[][] row_array, RowLocation[] rowloc_array) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    @Override
    public int fetchNextGroup(DataValueDescriptor[][] row_array, RowLocation[] oldrowloc_array, RowLocation[] newrowloc_array) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    @Override
    public void fetchWithoutQualify(DataValueDescriptor[] destRow) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    @Override
    public final boolean fetchNext(DataValueDescriptor[] destRow) throws StandardException {
        ValueRow row = new ValueRow(destRow);
        return this.fetchNext(row);
    }

    @Override
    public final boolean positionAtRowLocation(RowLocation rl) throws StandardException {
        return false;
    }

    @Override
    public void didNotQualify() throws StandardException {
        throw new AssertionError((Object)"not expected to be called");
    }

    @Override
    public final boolean isCurrentPositionDeleted() throws StandardException {
        return false;
    }

    @Override
    public boolean isHeldAfterCommit() throws StandardException {
        throw new AssertionError((Object)"not expected to be called");
    }

    @Override
    public void fetch(DataValueDescriptor[] destRow) throws StandardException {
        throw new AssertionError((Object)"not expected to be called");
    }

    @Override
    public final RowLocation getCurrentRowLocation() {
        return this.currentRowLocation;
    }

    @Override
    public final void upgradeCurrentRowLocationLockToWrite() throws StandardException {
        if (this.currentRowLocation != null && this.currentDataRegion != null) {
            RegionEntry entry = this.currentRowLocation.getUnderlyingRegionEntry();
            TXStateProxy txProxy = this.localTXState.getProxy();
            if (this.observer != null) {
                this.observer.lockingRowForTX(txProxy, this.gfContainer, entry, true);
            }
            try {
                txProxy.lockEntry(entry, entry.getKey(), GemFireXDUtils.getRoutingObject(this.currentRowLocation.getBucketID()), this.gfContainer.getRegion(), this.currentDataRegion, true, TXEntryState.getLockForUpdateOp());
            }
            finally {
                GemFireXDUtils.releaseLockForReadOnPreviousEntry(entry, this.localTXState, this.txId, this.lockPolicy, this.readLockMode, this.gfContainer, this.currentDataRegion, this.lockContext);
            }
            this.currentDataRegion = null;
        }
    }

    @Override
    public final void releaseCurrentRowLocationReadLock() throws StandardException {
        if (this.currentRowLocation != null && this.currentDataRegion != null) {
            GemFireXDUtils.releaseLockForReadOnPreviousEntry(this.currentRowLocation.getUnderlyingRegionEntry(), this.localTXState, this.txId, this.lockPolicy, this.readLockMode, this.gfContainer, this.currentDataRegion, this.lockContext);
            this.currentDataRegion = null;
        }
    }

    public void setOffHeapOwner(OffHeapResourceHolder offHeapResourceHolder) {
        this.offheapOwner = offHeapResourceHolder;
    }

    static {
        waitForLatch = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
    }
}

