/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.heap;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapScanController;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostController;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostResult;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

public final class MemHeapCostController
extends MemHeapScanController
implements StoreCostController {
    long row_size;

    @Override
    public void init(GemFireTransaction tran, MemConglomerate conglomerate, int openMode, int lockLevel, LockingPolicy locking) throws StandardException {
        super.init(tran, conglomerate, openMode, lockLevel, locking);
        boolean queryHDFS = false;
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        if (lcc != null) {
            queryHDFS = lcc.getQueryHDFS();
            CompilerContext cc = (CompilerContext)lcc.getContextManager().getContext("CompilerContext");
            LocalRegion region = this.gfContainer.getRegion();
            if (region != null && region instanceof PartitionedRegion) {
                if (cc.getHasQueryHDFS()) {
                    ((PartitionedRegion)region).setQueryHDFS(cc.getQueryHDFS());
                } else {
                    ((PartitionedRegion)region).setQueryHDFS(queryHDFS);
                }
            }
        }
        this.numRows = this.gfContainer.getNumRows();
        this.row_size = this.gfContainer.getRowSize();
        if (this.numRows < 1L) {
            this.numRows = 1L;
        }
        if (this.row_size < 1L) {
            this.row_size = 1L;
        }
    }

    @Override
    public double getFetchFromRowLocationCost(FormatableBitSet validColumns, int access_type) throws StandardException {
        return (double)this.row_size * 0.004 + 0.17;
    }

    @Override
    public void getScanCost(int scan_type, long row_count, int group_size, boolean forUpdate, FormatableBitSet scanColumnList, DataValueDescriptor[] template, DataValueDescriptor[] startKeyValue, int startSearchOperator, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, boolean reopen_scan, int access_type, StoreCostResult cost_result) throws StandardException {
        SanityManager.ASSERT((scan_type == 2 || scan_type == 1 || scan_type == 4 ? 1 : 0) != 0);
        long estimated_row_count = row_count < 0L ? this.numRows : row_count;
        double cost = (double)(estimated_row_count * this.row_size) * 0.004;
        if (scan_type == 1) {
            cost += (double)estimated_row_count * 0.14;
        } else if (scan_type == 4) {
            double remote_cost_multiplier = 0.0;
            if (scanColumnList != null) {
                TableDescriptor td = this.gfContainer.getTableDescriptor();
                assert (td != null) : "table descriptor is found null for " + this.gfContainer;
                ReferencedKeyConstraintDescriptor pk = td.getPrimaryKey();
                if (pk != null) {
                    int[] scanCols = new int[scanColumnList.getNumBitsSet()];
                    int pos = scanColumnList.anySetBit();
                    int j = 0;
                    while (pos != -1) {
                        scanCols[j] = pos;
                        pos = scanColumnList.anySetBit(pos);
                        ++j;
                    }
                    boolean isPrimaryKeyGetAll = pk.columnIntersects(scanCols);
                    if (isPrimaryKeyGetAll) {
                        remote_cost_multiplier += 2.0;
                        GfxdPartitionResolver resolver = td.getGfxdPartitionResolver(null);
                        assert (resolver != null) : "Remote fetch shouldn't happen for non-partitioned table" + td;
                        if (resolver.requiresGlobalIndex()) {
                            remote_cost_multiplier += 1.5;
                        }
                    }
                }
            }
            if (remote_cost_multiplier == 0.0) {
                remote_cost_multiplier = 5.0;
            }
            cost += (double)estimated_row_count * remote_cost_multiplier;
        } else {
            cost += (double)estimated_row_count * 0.12;
        }
        GemFireXDQueryObserver sqo = GemFireXDQueryObserverHolder.getInstance();
        if (sqo != null) {
            cost = sqo.overrideDerbyOptimizerCostForMemHeapScan(this.gfContainer, cost);
        }
        cost_result.setEstimatedCost(cost);
        cost_result.setEstimatedRowCount(estimated_row_count + 1L);
    }

    @Override
    public double getFetchFromFullKeyCost(FormatableBitSet validColumns, int access_type, CostEstimate costEstimate) throws StandardException {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }
}

