/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.server;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TLongHashSet;
import com.gemstone.gnu.trove.TLongProcedure;
import com.pivotal.gemfirexd.internal.engine.Misc;
import io.snappydata.thrift.server.SnappyDataServiceImpl;
import org.apache.thrift.transport.TTransport;

public class ClientTracker
extends SystemTimer.SystemTimerTask {
    private final SnappyDataServiceImpl service;
    private final String clientHostId;
    private final TLongHashSet connectionIds;
    private final THashSet clientSockets;
    private boolean cleanupScheduled;

    public ClientTracker(SnappyDataServiceImpl service, String clientHostId) {
        this.service = service;
        this.clientHostId = clientHostId;
        this.connectionIds = new TLongHashSet(8);
        this.clientSockets = new THashSet(8);
    }

    public static String getClientHostId(String clientHost, String clientId) {
        if (clientHost != null && clientHost.length() > 0 && clientId != null && clientId.length() > 0) {
            int pipeIndex = clientId.indexOf(124);
            if (pipeIndex >= 0 && (pipeIndex = clientId.indexOf(124, pipeIndex + 1)) > 0) {
                return clientHost + ':' + clientId.substring(0, pipeIndex);
            }
            return clientHost + ':' + clientId;
        }
        return null;
    }

    public static ClientTracker addOrGetTracker(String clientHostId, SnappyDataServiceImpl service) {
        if (clientHostId != null && clientHostId.length() > 0) {
            ClientTracker tracker = new ClientTracker(service, clientHostId);
            ClientTracker currentTracker = service.clientTrackerMap.putIfAbsent(clientHostId, tracker);
            return currentTracker == null ? tracker : currentTracker;
        }
        return null;
    }

    public synchronized void addClientConnection(long connId) {
        this.connectionIds.add(connId);
    }

    public synchronized void addClientSocket(TTransport transport, SnappyDataServiceImpl service) {
        this.clientSockets.add((Object)transport);
        service.clientSocketTrackerMap.put(transport, this);
    }

    public synchronized boolean removeClientConnection(long connId) {
        this.connectionIds.remove(connId);
        return this.connectionIds.isEmpty();
    }

    public static void removeClientSocket(TTransport transport, SnappyDataServiceImpl service) {
        ClientTracker tracker = service.clientSocketTrackerMap.remove(transport);
        if (tracker != null) {
            try {
                tracker.removeClientSocket(transport);
            }
            catch (CancelException ce) {
                tracker.run();
            }
        }
    }

    public synchronized void removeClientSocket(TTransport transport) {
        if (this.clientSockets.isEmpty()) {
            return;
        }
        this.clientSockets.remove((Object)transport);
        if (this.clientSockets.isEmpty()) {
            if (this.connectionIds.isEmpty()) {
                this.service.clientTrackerMap.remove(this.clientHostId);
            } else if (!this.cleanupScheduled) {
                try {
                    Misc.getGemFireCache().getCCPTimer().schedule((SystemTimer.SystemTimerTask)this, 3000L);
                    this.cleanupScheduled = true;
                }
                catch (IllegalStateException e) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        Misc.checkIfCacheClosing(ie);
                    }
                    try {
                        Misc.getGemFireCache().getCCPTimer().schedule((SystemTimer.SystemTimerTask)this, 3000L);
                        this.cleanupScheduled = true;
                    }
                    catch (IllegalStateException ie) {
                        this.service.clientTrackerMap.remove(this.clientHostId);
                        this.cleanupScheduled = false;
                    }
                }
            }
        }
    }

    public synchronized void run2() {
        if (this.clientSockets.isEmpty()) {
            this.service.clientTrackerMap.remove(this.clientHostId);
            if (this.connectionIds.size() > 0) {
                this.connectionIds.forEach(new TLongProcedure(){

                    public boolean execute(long connId) {
                        ClientTracker.this.service.forceCloseConnection(connId);
                        return true;
                    }
                });
            }
        } else {
            this.cleanupScheduled = false;
        }
    }

    public LogWriterI18n getLoggerI18n() {
        return Misc.getI18NLogWriter();
    }
}

