/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.xact;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerLock;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RowLock;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.NoLocking;

public class RowLocking3
extends NoLocking {
    private static final LockingPolicy NO_LOCK = new NoLocking();
    protected final LockFactory lf;

    protected RowLocking3(LockFactory lf) {
        this.lf = lf;
    }

    protected RowLock getReadLockType() {
        return RowLock.RS3;
    }

    protected RowLock getUpdateLockType() {
        return RowLock.RU3;
    }

    protected RowLock getWriteLockType() {
        return RowLock.RX3;
    }

    @Override
    public boolean lockContainer(Transaction t, ContainerHandle container, boolean waitForLock, boolean forUpdate) throws StandardException {
        ContainerLock qualifier = forUpdate ? ContainerLock.CIX : ContainerLock.CIS;
        boolean gotLock = this.lf.lockObject(t.getCompatibilitySpace(), t, container.getId(), qualifier, waitForLock ? -2 : 0);
        if (gotLock && (this.lf.isLockHeld(t.getCompatibilitySpace(), t, container.getId(), ContainerLock.CX) || !forUpdate && this.lf.isLockHeld(t.getCompatibilitySpace(), t, container.getId(), ContainerLock.CS))) {
            container.setLockingPolicy(NO_LOCK);
        }
        return gotLock;
    }

    @Override
    public boolean lockRecordForRead(Transaction t, ContainerHandle container_handle, RecordHandle record, boolean waitForLock, boolean forUpdate) throws StandardException {
        RowLock qualifier = forUpdate ? this.getUpdateLockType() : this.getReadLockType();
        return this.lf.lockObject(t.getCompatibilitySpace(), t, record, qualifier, waitForLock ? -2 : 0);
    }

    @Override
    public boolean zeroDurationLockRecordForWrite(Transaction t, RecordHandle record, boolean lockForInsertPreviousKey, boolean waitForLock) throws StandardException {
        return this.lf.zeroDurationlockObject(t.getCompatibilitySpace(), record, lockForInsertPreviousKey ? RowLock.RIP : this.getWriteLockType(), waitForLock ? -2 : 0);
    }

    @Override
    public boolean lockRecordForWrite(Transaction t, RecordHandle record, boolean lockForInsert, boolean waitForLock) throws StandardException {
        return this.lf.lockObject(t.getCompatibilitySpace(), t, record, lockForInsert ? RowLock.RI : this.getWriteLockType(), waitForLock ? -2 : 0);
    }

    @Override
    public int getMode() {
        return 1;
    }
}

