/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.Hash1IndexScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexScanController;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.GroupFetchScanController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.FKInfo;

public class RIBulkChecker {
    private static final int EQUAL = 0;
    private static final int GREATER_THAN = 1;
    private static final int LESS_THAN = -1;
    private FKInfo fkInfo;
    private GroupFetchScanController referencedKeyScan;
    private GroupFetchScanController foreignKeyScan;
    private DataValueDescriptor[][] foreignKeyRowArray;
    private DataValueDescriptor[] referenceIndexKey;
    private ConglomerateController unreferencedCC;
    private int failedCounter;
    private boolean quitOnFirstFailure;
    private int numColumns;
    private int currRefRowIndex;
    private int currFKRowIndex;
    private int lastRefRowIndex;
    private int lastFKRowIndex;
    private ExecRow firstRowToFail;
    private final int[] partitionColIndexInRefKeyForSelectiveCheck;
    private final PartitionedRegion refTablePr;

    public RIBulkChecker(GroupFetchScanController referencedKeyScan, GroupFetchScanController foreignKeyScan, ExecRow templateRow, boolean quitOnFirstFailure, ConglomerateController unreferencedCC, ExecRow firstRowToFail, int[] partitionColIndexInRefKeyForSelectiveCheck, PartitionedRegion refTablePr) {
        this.referencedKeyScan = referencedKeyScan;
        this.foreignKeyScan = foreignKeyScan;
        this.quitOnFirstFailure = quitOnFirstFailure;
        this.unreferencedCC = unreferencedCC;
        this.firstRowToFail = firstRowToFail;
        this.partitionColIndexInRefKeyForSelectiveCheck = partitionColIndexInRefKeyForSelectiveCheck;
        this.refTablePr = refTablePr;
        this.foreignKeyRowArray = new DataValueDescriptor[GemFireXDUtils.DML_BULK_FETCH_SIZE][];
        this.foreignKeyRowArray[0] = templateRow.getRowArrayClone();
        this.failedCounter = 0;
        this.numColumns = templateRow.getRowArray().length - 1;
        this.referenceIndexKey = new DataValueDescriptor[this.numColumns];
        this.currFKRowIndex = -1;
        this.currRefRowIndex = -1;
    }

    public int doCheck() throws StandardException {
        DataValueDescriptor[] foreignKey;
        if (Misc.initialDDLReplayInProgress()) {
            return 0;
        }
        DataValueDescriptor[] partitionCols = this.partitionColIndexInRefKeyForSelectiveCheck != null ? new DataValueDescriptor[this.partitionColIndexInRefKeyForSelectiveCheck.length] : null;
        GfxdPartitionResolver refTableResolver = this.partitionColIndexInRefKeyForSelectiveCheck != null ? (GfxdPartitionResolver)this.refTablePr.getPartitionResolver() : null;
        int indexScanType = -1;
        if (this.referencedKeyScan instanceof MemIndexScanController) {
            indexScanType = ((MemIndexScanController)this.referencedKeyScan).getType();
        }
        while ((foreignKey = this.getNextFK()) != null) {
            int partColCounter = 0;
            for (int i = 0; i < this.numColumns; ++i) {
                this.referenceIndexKey[i] = foreignKey[i];
                if (this.partitionColIndexInRefKeyForSelectiveCheck == null || partColCounter >= this.partitionColIndexInRefKeyForSelectiveCheck.length || i != this.partitionColIndexInRefKeyForSelectiveCheck[partColCounter]) continue;
                partitionCols[partColCounter++] = foreignKey[i];
            }
            if (this.partitionColIndexInRefKeyForSelectiveCheck != null) {
                Object routingObject = refTableResolver.getRoutingObjectsForPartitioningColumns(partitionCols);
                int bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)this.refTablePr, (Object)routingObject);
                RegionAdvisor advisor = this.refTablePr.getRegionAdvisor();
                if (!advisor.isPrimaryForBucket(bucketId) && advisor.isStorageAssignedForBucket(bucketId)) continue;
            }
            this.referencedKeyScan.reopenScan(this.referenceIndexKey, 1, null, this.referenceIndexKey, -1, null);
            if (this.referencedKeyScan.next()) continue;
            if (indexScanType == 1 || indexScanType == 2) {
                foreignKey = ((Hash1IndexScanController)this.referencedKeyScan).getFailedKey();
            }
            if (this.anyNull(foreignKey)) continue;
            do {
                this.failure(foreignKey);
                if (!this.quitOnFirstFailure) continue;
                return 1;
            } while ((foreignKey = this.getNextFK()) != null);
            return this.failedCounter;
        }
        if (!(indexScanType != 1 && indexScanType != 2 || ((Hash1IndexScanController)this.referencedKeyScan).checkAnyAccumulatedKeys() || this.anyNull(foreignKey = ((Hash1IndexScanController)this.referencedKeyScan).getFailedKey()))) {
            do {
                this.failure(foreignKey);
                if (!this.quitOnFirstFailure) continue;
                return 1;
            } while ((foreignKey = this.getNextFK()) != null);
            return this.failedCounter;
        }
        return this.failedCounter;
    }

    private DataValueDescriptor[] getNextFK() throws StandardException {
        if (this.currFKRowIndex > this.lastFKRowIndex || this.currFKRowIndex == -1) {
            int rowCount = this.foreignKeyScan.fetchNextGroup(this.foreignKeyRowArray, null);
            if (rowCount == 0) {
                this.currFKRowIndex = -1;
                return null;
            }
            this.lastFKRowIndex = rowCount - 1;
            this.currFKRowIndex = 0;
        }
        return this.foreignKeyRowArray[this.currFKRowIndex++];
    }

    private void failure(DataValueDescriptor[] foreignKeyRow) throws StandardException {
        if (this.failedCounter == 0 && this.firstRowToFail != null) {
            this.firstRowToFail.setRowArray(foreignKeyRow);
            this.firstRowToFail.setRowArray(this.firstRowToFail.getRowArrayClone());
        }
        ++this.failedCounter;
        if (this.unreferencedCC != null) {
            this.unreferencedCC.insert(foreignKeyRow);
        }
    }

    private boolean anyNull(DataValueDescriptor[] fkRowArray) throws StandardException {
        for (int i = 0; i < this.numColumns; ++i) {
            DataValueDescriptor fkCol = fkRowArray[i];
            if (!fkCol.isNull()) continue;
            return true;
        }
        return false;
    }

    private int greaterThan(DataValueDescriptor[] fkRowArray, DataValueDescriptor[] refRowArray) throws StandardException {
        if (this.anyNull(fkRowArray)) {
            return 0;
        }
        for (int i = 0; i < this.numColumns; ++i) {
            DataValueDescriptor fkCol = fkRowArray[i];
            DataValueDescriptor refCol = refRowArray[i];
            int result = fkCol.compare(refCol);
            if (result == 1) {
                return 1;
            }
            if (result != -1) continue;
            return -1;
        }
        return 0;
    }
}

