/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DMLWriteResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UpdatableVTIConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

abstract class DMLVTIResultSet
extends DMLWriteResultSet {
    NoPutResultSet sourceResultSet;
    NoPutResultSet savedSource;
    UpdatableVTIConstantAction constants;
    TransactionController tc;
    private int numOpens;
    boolean firstExecute;

    DMLVTIResultSet(NoPutResultSet source, Activation activation) throws StandardException {
        super(activation);
        this.sourceResultSet = source;
        this.constants = (UpdatableVTIConstantAction)this.constantAction;
        this.tc = activation.getTransactionController();
    }

    @Override
    public void open() throws StandardException {
        this.setup();
        this.firstExecute = this.numOpens == 0;
        this.rowCount = 0;
        if (this.numOpens++ == 0) {
            this.sourceResultSet.openCore();
        } else {
            this.sourceResultSet.reopenCore();
        }
        this.openCore();
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.sourceResultSet;
        }
        this.cleanUp(false);
        this.endTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
    }

    protected abstract void openCore() throws StandardException;

    @Override
    public void cleanUp(boolean cleanupOnError) throws StandardException {
        if (null != this.sourceResultSet) {
            this.sourceResultSet.close(cleanupOnError);
        }
        this.numOpens = 0;
        super.close(cleanupOnError);
    }

    @Override
    public void finish() throws StandardException {
        this.sourceResultSet.finish();
        super.finish();
    }
}

