/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CustomEvictionAttributes;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.management.GfxdManagementService;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ColumnInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateConstraintConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateIndexConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public final class CreateTableConstantAction
extends DDLConstantAction {
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private String tableName;
    private String schemaName;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private CreateConstraintConstantAction[] constraintActions;
    private Properties properties;
    private String generatedSqlTextForCTAS;
    private String colocatedWithTable;

    CreateTableConstantAction(String schemaName, String tableName, int tableType, ColumnInfo[] columnInfo, CreateConstraintConstantAction[] constraintActions, Properties properties, char lockGranularity, boolean onCommitDeleteRows, boolean onRollbackDeleteRows, String generatedSqlTextForCTAS) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tableType = tableType;
        this.columnInfo = columnInfo;
        if (Misc.getMemStoreBooting().isHadoopGfxdLonerMode() && constraintActions != null) {
            ArrayList<CreateConstraintConstantAction> pkConstraints = new ArrayList<CreateConstraintConstantAction>(1);
            for (CreateConstraintConstantAction constraint : constraintActions) {
                if (constraint.getConstraintType() != 2) continue;
                pkConstraints.add(constraint);
            }
            this.constraintActions = pkConstraints.toArray(new CreateConstraintConstantAction[pkConstraints.size()]);
        } else {
            this.constraintActions = constraintActions;
        }
        this.properties = properties;
        this.lockGranularity = lockGranularity;
        this.onCommitDeleteRows = onCommitDeleteRows;
        this.onRollbackDeleteRows = onRollbackDeleteRows;
        this.generatedSqlTextForCTAS = generatedSqlTextForCTAS;
        if ((tableType == 0 || tableType == 6) && lockGranularity != 'T' && lockGranularity != 'R') {
            SanityManager.THROWASSERT((String)("Unexpected value for lockGranularity = " + lockGranularity));
        }
        if (tableType == 3 && !onRollbackDeleteRows) {
            SanityManager.THROWASSERT((String)("Unexpected value for onRollbackDeleteRows = " + onRollbackDeleteRows));
        }
        SanityManager.ASSERT((schemaName != null ? 1 : 0) != 0, (String)"SchemaName is null");
    }

    public String toString() {
        if (this.tableType == 3) {
            return this.constructToString("DECLARE GLOBAL TEMPORARY TABLE ", this.tableName);
        }
        return this.constructToString("CREATE TABLE ", this.tableName);
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TableDescriptor td;
        RegionAttributes regionAttributes;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        activation.setForCreateTable();
        ExecRow template = RowUtil.getEmptyValueRow(this.columnInfo.length, lcc);
        int[] collation_ids = new int[this.columnInfo.length];
        for (int ix = 0; ix < this.columnInfo.length; ++ix) {
            ColumnInfo col_info = this.columnInfo[ix];
            if (col_info.defaultValue != null) {
                template.setColumn(ix + 1, col_info.defaultValue);
            } else {
                template.setColumn(ix + 1, col_info.dataType.getNull());
            }
            collation_ids[ix] = col_info.dataType.getCollationType();
            if (col_info.dataType.getTypeId() != TypeId.CHAR_ID || col_info.dataType.getMaximumWidth() != 0) continue;
            throw StandardException.newException("42X44", "0");
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put("com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary", dd);
        DistributionDescriptor distributionDesc = (DistributionDescriptor)this.properties.get("GEMFIREXD_DISTRIBUTION_DESCRIPTOR");
        if (this.tableType != 3) {
            assert (distributionDesc != null);
            dd.startWriting(lcc);
        } else {
            this.properties.put(GfxdConstants.PROPERTY_SCHEMA_NAME, this.schemaName);
            this.properties.put(GfxdConstants.PROPERTY_TABLE_NAME, this.tableName);
        }
        boolean isHadoopLoner = Misc.getMemStoreBooting().isHadoopGfxdLonerMode();
        if (isHadoopLoner) {
            regionAttributes = (RegionAttributes)this.properties.get("GEMFIRE_REGION_ATTRIBUTES");
            AttributesFactory attribFactory = new AttributesFactory();
            attribFactory.setHDFSStoreName(regionAttributes.getHDFSStoreName());
            DataPolicy dp = regionAttributes.getDataPolicy();
            if (dp == DataPolicy.HDFS_PERSISTENT_PARTITION) {
                dp = DataPolicy.HDFS_PARTITION;
            }
            attribFactory.setDataPolicy(dp);
            EvictionAttributesImpl ea = new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_HEAP);
            attribFactory.setEvictionAttributes((EvictionAttributes)ea);
            PartitionAttributes prAttributes = regionAttributes.getPartitionAttributes();
            if (prAttributes != null) {
                PartitionAttributesFactory paf = new PartitionAttributesFactory(prAttributes);
                paf.setColocatedWith(null);
                attribFactory.setPartitionAttributes(paf.create());
            }
            RegionAttributes updatedregionAttributes = attribFactory.create();
            this.properties.put("GEMFIRE_REGION_ATTRIBUTES", updatedregionAttributes);
        }
        if ((regionAttributes = (RegionAttributes)this.properties.get("GEMFIRE_REGION_ATTRIBUTES")) != null) {
            DataPolicy dp = regionAttributes.getDataPolicy();
            if (!isHadoopLoner && dp == DataPolicy.HDFS_PARTITION && !distributionDesc.getPersistence()) {
                activation.addWarning(StandardException.newWarning("0150A", this.tableName));
            }
        }
        long conglomId = tc.createConglomerate("heap", template.getRowArray(), null, collation_ids, this.properties, this.tableType == 3 ? 3 : 0);
        SchemaDescriptor sd = this.tableType == 3 ? dd.getSchemaDescriptor(this.schemaName, tc, true) : this.getSchemaDescriptorForCreate(dd, activation, this.schemaName);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        if (this.tableType != 3) {
            td = ddg.newTableDescriptor(this.tableName, sd, this.tableType, this.lockGranularity, false);
            td.setDistributionDescriptor(distributionDesc);
            dd.addDescriptor(td, sd, 1, false, tc);
        } else {
            td = ddg.newTableDescriptor(this.tableName, sd, this.tableType, this.onCommitDeleteRows, this.onRollbackDeleteRows);
            td.setDistributionDescriptor(distributionDesc);
            td.setUUID(dd.getUUIDFactory().createUUID());
        }
        UUID toid = td.getUUID();
        activation.setDDLTableDescriptor(td);
        int index = 1;
        TupleDescriptor[] cdlArray = new ColumnDescriptor[this.columnInfo.length];
        for (int ix = 0; ix < this.columnInfo.length; ++ix) {
            ColumnDescriptor columnDescriptor;
            UUID defaultUUID = this.columnInfo[ix].newDefaultUUID;
            if (this.columnInfo[ix].defaultInfo != null && defaultUUID == null) {
                defaultUUID = dd.getUUIDFactory().createUUID();
            }
            if (this.columnInfo[ix].autoincInc != 0L) {
                if (this.columnInfo[ix].hasAutoIncInc && !this.columnInfo[ix].isGeneratedByDefault) {
                    activation.addWarning(StandardException.newWarning("X0Z12.S", this.columnInfo[ix].autoincInc, td.getQualifiedName()));
                }
                columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, index++, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoinc_create_or_modify_Start_Increment, this.columnInfo[ix].isGeneratedByDefault);
            } else {
                columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, index++, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].isGeneratedByDefault);
            }
            cdlArray[ix] = columnDescriptor;
        }
        if (this.tableType != 3) {
            dd.addDescriptorArray(cdlArray, td, 2, false, tc);
        }
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        for (int i = 0; i < cdlArray.length; ++i) {
            cdl.add(cdlArray[i]);
        }
        ConglomerateDescriptor cgd = ddg.newConglomerateDescriptor(conglomId, this.schemaName + "." + this.tableName, false, null, false, null, toid, sd.getUUID());
        if (this.tableType != 3) {
            dd.addDescriptor(cgd, sd, 0, false, tc);
        }
        ConglomerateDescriptorList conglomList = td.getConglomerateDescriptorList();
        conglomList.add(cgd);
        if (this.tableType != 3) {
            distributionDesc.resolveColumnPositions(td);
            ExtraTableInfo.newExtraTableInfo(dd, td, lcc.getContextManager(), 1, null, true);
        }
        boolean hasFk = false;
        if (this.constraintActions != null) {
            int conIndex;
            for (conIndex = 0; conIndex < this.constraintActions.length; ++conIndex) {
                if (this.constraintActions[conIndex].isForeignKeyConstraint()) continue;
                this.constraintActions[conIndex].setSkipPopulatingIndexes(true);
                this.constraintActions[conIndex].executeConstantAction(activation);
            }
            for (conIndex = 0; conIndex < this.constraintActions.length; ++conIndex) {
                if (!this.constraintActions[conIndex].isForeignKeyConstraint()) continue;
                hasFk = true;
                this.constraintActions[conIndex].setSkipPopulatingIndexes(true);
                this.constraintActions[conIndex].executeConstantAction(activation);
            }
        }
        this.adjustUDTDependencies(lcc, dd, td, this.columnInfo, false);
        if (this.tableType == 3) {
            lcc.addDeclaredGlobalTempTable(td, conglomId);
        }
        if (this.tableType != 3) {
            String colocatedWith;
            PartitionAttributes pattrs;
            GemFireTransaction tran = (GemFireTransaction)tc;
            GemFireContainer container = GemFireContainer.getGemFireContainer(td, tran);
            GfxdIndexManager indexManager = container.setup(td, dd, lcc, tran, hasFk, distributionDesc, activation, cdl);
            CustomEvictionAttributes customEvictionAttrs = container.getRegionAttributes().getCustomEvictionAttributes();
            if (customEvictionAttrs != null && hasFk) {
                throw StandardException.newException("0A000.S.30");
            }
            if (container.getRegion() != null && (pattrs = container.getRegion().getPartitionAttributes()) != null && (colocatedWith = pattrs.getColocatedWith()) != null && colocatedWith.length() > 0) {
                this.colocatedWithTable = Misc.getFullTableNameFromRegionPath(colocatedWith);
            }
            if (GemFireXDUtils.TraceIndex) {
                GfxdIndexManager.traceIndex("CreateTable::executeConstantAction indexManager=%s, constraintAction=%s and skipRegionInit=%s for table=%s", indexManager, this.constraintActions, lcc.skipRegionInitialization(), td.getQualifiedName());
            }
            if (indexManager != null && this.constraintActions != null) {
                if (lcc.skipRegionInitialization()) {
                    indexManager.invalidateFor(lcc);
                } else {
                    boolean lockedForIndexes = false;
                    for (CreateConstraintConstantAction action : this.constraintActions) {
                        Collection<LoadIndexData> loadData = action.getLoadIndexData();
                        if (loadData == null) continue;
                        for (LoadIndexData load : loadData) {
                            if (!lockedForIndexes) {
                                lockedForIndexes = true;
                                indexManager.invalidateFor(lcc);
                            }
                            load.loadIndexConglomerate(lcc, tc, td, indexManager);
                        }
                        loadData.clear();
                    }
                }
            }
            dm.addDependency(activation.getPreparedStatement(), td, lcc.getContextManager());
            if (!container.isAccessorForRegion()) {
                GemFireCacheImpl cache = Misc.getGemFireCache();
                for (String id : container.getRegionAttributes().getGatewaySenderIds()) {
                    if (cache.getGatewaySender(id) != null) continue;
                    StringBuilder sb = new StringBuilder();
                    for (GatewaySender s : cache.getAllGatewaySenders()) {
                        sb.append(s.getId()).append(",");
                    }
                    activation.addWarning(StandardException.newWarning("01507", new Object[]{id, container.getQualifiedTableName(), "GatewaySenders", sb.toString()}, null));
                }
                for (String id : container.getRegionAttributes().getAsyncEventQueueIds()) {
                    if (cache.getAsyncEventQueue(id) != null) continue;
                    StringBuilder sb = new StringBuilder();
                    for (AsyncEventQueue q : cache.getAsyncEventQueues()) {
                        sb.append(q.getId()).append(",");
                    }
                    activation.addWarning(StandardException.newWarning("01507", new Object[]{id, container.getQualifiedTableName(), "AsyncEventListeners", sb.toString()}, null));
                }
            }
            if (!container.getRegionAttributes().getGatewaySenderIds().isEmpty()) {
                for (ColumnDescriptor cd : td.getColumnDescriptorList()) {
                    if (!cd.isAutoincAlways() || cd.getType().getJDBCTypeId() != 4) continue;
                    throw StandardException.newException("42Z28", cd.getColumnName());
                }
            }
            if (container.isApplicationTable()) {
                GfxdManagementService.handleEvent(5, new Object[]{container});
            }
        }
        if (!("SYSSTAT".equalsIgnoreCase(this.schemaName) || Misc.isSnappyHiveMetaTable(this.schemaName) || GemFireXDUtils.TraceConglom)) {
            SanityManager.DEBUG_PRINT((String)"info:TraceConglom", (String)("Created table " + td.getQualifiedName() + " with UUID: " + td.getUUID()));
        }
        if (GemFireXDUtils.TraceConglom) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("Created table with descriptor:\n" + td));
        }
    }

    @Override
    public boolean isReplayable() {
        return this.tableType == 0 || this.tableType == 6;
    }

    @Override
    public final String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    public final String getColocatedWithTable() {
        return this.colocatedWithTable;
    }

    public String getSQLTextForCTAS() {
        return this.generatedSqlTextForCTAS;
    }

    public static final class LoadIndexData {
        private final CreateIndexConstantAction indexAction;
        private final FormatableBitSet zeroBasedBitSet;
        private final ExecRow[] baseRows;
        private final ExecIndexRow[] indexRows;
        private final RowLocation[] rl;

        public LoadIndexData(CreateIndexConstantAction indexAction, FormatableBitSet zeroBasedBitSet, ExecRow[] baseRows, ExecIndexRow[] indexRows, RowLocation[] rl) {
            this.indexAction = indexAction;
            this.zeroBasedBitSet = zeroBasedBitSet;
            this.baseRows = baseRows;
            this.indexRows = indexRows;
            this.rl = rl;
        }

        private final void loadIndexConglomerate(LanguageConnectionContext lcc, TransactionController tc, TableDescriptor td, GfxdIndexManager indexManager) throws StandardException {
            this.indexAction.loadIndexConglomerate(lcc, tc, td, indexManager, this.zeroBasedBitSet, this.baseRows, this.indexRows, this.rl, false);
        }
    }
}

