/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.MemScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalExecRowLocation;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2Index;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.GroupFetchScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AlterTableConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicSortObserver;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateTableConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexColumnOrder;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UniqueIndexSortObserver;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UniqueWithDuplicateNullsIndexSortObserver;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public final class CreateIndexConstantAction
extends IndexConstantAction {
    private final boolean forCreateTable;
    private boolean unique;
    private boolean uniqueWithDuplicateNulls;
    private String indexType;
    private String[] columnNames;
    private boolean[] isAscending;
    private boolean isConstraint;
    private UUID conglomerateUUID;
    private Properties properties;
    private ExecRow indexTemplateRow;
    private long conglomId;
    private long droppedConglomNum;
    private boolean createIRF;
    private GemFireContainer indexContainer;
    private boolean skipLoadConglom = false;
    private final Collection<CreateTableConstantAction.LoadIndexData> loadIndexData = new ArrayList<CreateTableConstantAction.LoadIndexData>();
    private boolean throughConstraint;

    public GemFireContainer getIndexContainer() {
        return this.indexContainer;
    }

    CreateIndexConstantAction(boolean forCreateTable, boolean unique, boolean uniqueWithDuplicateNulls, String indexType, String schemaName, String indexName, String tableName, UUID tableId, String[] columnNames, boolean[] isAscending, boolean isConstraint, UUID conglomerateUUID, Properties properties) {
        super(tableId, indexName, tableName, schemaName);
        SanityManager.ASSERT((schemaName != null ? 1 : 0) != 0, (String)"Schema name is null");
        this.forCreateTable = forCreateTable;
        this.unique = unique;
        this.uniqueWithDuplicateNulls = uniqueWithDuplicateNulls;
        this.indexType = indexType;
        this.columnNames = columnNames;
        this.isAscending = isAscending;
        this.isConstraint = isConstraint;
        this.conglomerateUUID = conglomerateUUID;
        this.properties = properties;
        this.conglomId = -1L;
        this.droppedConglomNum = -1L;
    }

    CreateIndexConstantAction(ConglomerateDescriptor srcCD, TableDescriptor td, Properties properties) {
        super(td.getUUID(), srcCD.getConglomerateName(), td.getName(), td.getSchemaName());
        this.forCreateTable = false;
        this.droppedConglomNum = srcCD.getConglomerateNumber();
        IndexRowGenerator irg = srcCD.getIndexDescriptor();
        this.unique = irg.isUnique();
        this.uniqueWithDuplicateNulls = irg.isUniqueWithDuplicateNulls();
        this.indexType = irg.indexType();
        this.columnNames = null;
        String name = properties.getProperty(GfxdConstants.PROPERTY_TABLE_NAME);
        if (name != null && name.length() > 0) {
            this.indexName = name;
        }
        this.isAscending = irg.isAscending();
        this.isConstraint = srcCD.isConstraint();
        this.conglomerateUUID = srcCD.getUUID();
        this.properties = properties;
        this.conglomId = -1L;
        if (this.columnNames == null) {
            int[] baseCols = irg.baseColumnPositions();
            this.columnNames = new String[baseCols.length];
            ColumnDescriptorList colDL = td.getColumnDescriptorList();
            for (int i = 0; i < baseCols.length; ++i) {
                this.columnNames[i] = colDL.elementAt(baseCols[i] - 1).getColumnName();
            }
        }
    }

    public String toString() {
        return "CREATE INDEX " + this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        boolean regionInitialized;
        GemFireContainer baseContainer;
        RegionAttributes<?, ?> rattrs;
        IndexRowGenerator indexRowGenerator = null;
        GroupFetchScanController scan = null;
        int maxBaseColumnPosition = -1;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, true);
        TableDescriptor td = activation.getDDLTableDescriptor();
        if (td == null) {
            td = this.tableId != null ? dd.getTableDescriptor(this.tableId) : dd.getTableDescriptor(this.tableName, sd, tc);
        }
        if (td == null) {
            throw StandardException.newException("X0Y38.S", (Object)this.indexName, (Object)this.tableName);
        }
        if (td.getTableType() == 1) {
            throw StandardException.newException("X0Y28.S", (Object)this.indexName, (Object)this.tableName);
        }
        if (!this.forCreateTable) {
            lcc.verifyNoOpenResultSets(null, td, 3);
        }
        if (!this.isConstraint) {
            this.lockTableForDDL(tc, td.getHeapConglomerateId(), true);
            if (this.tableId != null) {
                td = dd.getTableDescriptor(this.tableId);
                if (td == null) {
                    throw StandardException.newException("X0Y38.S", (Object)this.indexName, (Object)this.tableName);
                }
                DistributionDescriptor desc = td.getDistributionDescriptor();
                DistributionDescriptor.checkAvailableDataStore(lcc, desc.getServerGroups(), "CREATE INDEX for table " + Misc.getFullTableName(td, lcc));
            }
        }
        GemFireStore memStore = Misc.getMemStoreBooting();
        boolean persistIndexes = memStore.isPersistIndexes();
        if (GemFireXDUtils.TraceIndex || GemFireXDUtils.TracePersistIndex) {
            GfxdIndexManager.traceIndex("CreateIndexConstantAction::executeConstantAction persist-indexes=%s, this.forCreateTable=%s", persistIndexes, this.createIRF);
        }
        if (persistIndexes) {
            Region region = Misc.getRegionForTableByPath(Misc.getFullTableName(td, lcc), false);
            if (region == null) {
                if (!this.forCreateTable) {
                    throw new IllegalStateException("region cannot be null here");
                }
            } else {
                int numBuckets = AlterTableConstantAction.getNumBucketsOrSize(region, lcc);
                if (numBuckets > 0) {
                    this.createIRF = true;
                }
                if (GemFireXDUtils.TraceIndex || GemFireXDUtils.TracePersistIndex) {
                    GfxdIndexManager.traceIndex("CreateIndexConstantAction::executeConstantAction numBuckets=%s, createIRF=%s", numBuckets, this.createIRF);
                }
            }
        }
        if (!this.forCreateTable) {
            dm.invalidateFor(td, 3, lcc);
        }
        int[] baseColumnPositions = new int[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            ClassFactory cf;
            ColumnDescriptor columnDescriptor = td.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", (Object)this.columnNames[i], (Object)this.tableName);
            }
            TypeId typeId = columnDescriptor.getType().getTypeId();
            boolean isIndexable = typeId.orderable(cf = lcc.getLanguageConnectionFactory().getClassFactory());
            if (isIndexable && typeId.userType()) {
                String userClass = typeId.getCorrespondingJavaTypeName();
                try {
                    if (cf.isApplicationClass(cf.loadApplicationClass(userClass))) {
                        isIndexable = false;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    isIndexable = false;
                }
            }
            if (!isIndexable) {
                throw StandardException.newException("X0X67.S", typeId.getSQLTypeName());
            }
            baseColumnPositions[i] = columnDescriptor.getPosition();
            if (maxBaseColumnPosition >= baseColumnPositions[i]) continue;
            maxBaseColumnPosition = baseColumnPositions[i];
        }
        ConglomerateDescriptor[] congDescs = td.getConglomerateDescriptors();
        boolean shareExisting = false;
        if (this.isConstraint || this.unique || this.uniqueWithDuplicateNulls) {
            this.indexType = this.getConstraintIndexType(lcc, td, baseColumnPositions, this.properties);
        }
        if (this.indexType.equals("LOCALSORTEDMAP") && (rattrs = (baseContainer = memStore.getContainer(ContainerKey.valueOf(0L, td.getHeapConglomerateId()))).getRegionAttributes()).getDataPolicy().withHDFS() && rattrs.getEvictionAttributes() != null && !rattrs.getEvictionAttributes().getAlgorithm().isNone() && !rattrs.getEvictionAttributes().getAction().isOverflowToDisk()) {
            throw StandardException.newException("0A000.S.27", (Object)this.indexName, (Object)td.getQualifiedName(), (Object)rattrs.getEvictionAttributes().getAction());
        }
        for (int i = 0; i < congDescs.length; ++i) {
            boolean possibleShare;
            ConglomerateDescriptor cd = congDescs[i];
            if (!cd.isIndex()) continue;
            String otherIndexType = cd.getIndexDescriptor().indexType();
            boolean existsStrongerIndex = false;
            if (otherIndexType.equals(this.indexType)) {
                existsStrongerIndex = true;
            } else if (this.indexType.equals("GLOBALHASH")) {
                existsStrongerIndex = true;
            }
            if (!existsStrongerIndex || this.droppedConglomNum == cd.getConglomerateNumber()) continue;
            IndexRowGenerator irg = cd.getIndexDescriptor();
            int[] bcps = irg.baseColumnPositions();
            boolean[] ia = irg.isAscending();
            int j = 0;
            boolean bl = possibleShare = (irg.isUnique() || !this.unique) && bcps.length == baseColumnPositions.length;
            if (possibleShare && !irg.isUnique()) {
                boolean bl2 = possibleShare = irg.isUniqueWithDuplicateNulls() || !this.uniqueWithDuplicateNulls;
            }
            if (possibleShare && existsStrongerIndex) {
                while (j < bcps.length && bcps[j] == baseColumnPositions[j] && ia[j] == this.isAscending[j]) {
                    ++j;
                }
            }
            if (j != baseColumnPositions.length) continue;
            if (!this.isConstraint) {
                activation.addWarning(StandardException.newWarning("01504", cd.getConglomerateName()));
                return;
            }
            this.conglomId = cd.getConglomerateNumber();
            indexRowGenerator = new IndexRowGenerator(this.indexType, this.unique, this.uniqueWithDuplicateNulls, baseColumnPositions, this.isAscending, baseColumnPositions.length);
            this.conglomerateUUID = dd.getUUIDFactory().createUUID();
            shareExisting = true;
            break;
        }
        boolean alreadyHaveConglomDescriptor = this.droppedConglomNum > -1L;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        if (shareExisting && !alreadyHaveConglomDescriptor) {
            ConglomerateDescriptor cgd = ddg.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, td.getUUID(), sd.getUUID());
            dd.addDescriptor(cgd, sd, 0, false, tc);
            ConglomerateDescriptorList cdl = td.getConglomerateDescriptorList();
            cdl.add(cgd);
        }
        Properties indexProperties = this.properties != null ? this.properties : new Properties();
        indexProperties.put("baseConglomerateId", Long.toString(td.getHeapConglomerateId()));
        if (this.uniqueWithDuplicateNulls) {
            if (lcc.getDataDictionary().checkVersion(160, null)) {
                indexProperties.put("uniqueWithDuplicateNulls", Boolean.toString(true));
            } else if (this.uniqueWithDuplicateNulls) {
                this.unique = true;
            }
        }
        indexProperties.put("nUniqueColumns", Integer.toString(this.unique ? baseColumnPositions.length : baseColumnPositions.length + 1));
        indexProperties.put("rowLocationColumn", Integer.toString(baseColumnPositions.length));
        indexProperties.put("nKeyFields", Integer.toString(baseColumnPositions.length + 1));
        if (!shareExisting) {
            indexRowGenerator = lcc.getDataDictionary().checkVersion(160, null) ? new IndexRowGenerator(this.indexType, this.unique, this.uniqueWithDuplicateNulls, baseColumnPositions, this.isAscending, baseColumnPositions.length) : new IndexRowGenerator(this.indexType, this.unique, baseColumnPositions, this.isAscending, baseColumnPositions.length);
        }
        RowSource rowSource = null;
        long sortId = 0L;
        boolean needToDropSort = false;
        int bulkFetchSize = this.forCreateTable ? 1 : 16;
        int numColumns = td.getNumberOfColumns();
        int approximateRowSize = 0;
        FormatableBitSet bitSet = new FormatableBitSet(numColumns + 1);
        for (int index = 0; index < baseColumnPositions.length; ++index) {
            bitSet.set(baseColumnPositions[index]);
        }
        FormatableBitSet zeroBasedBitSet = RowUtil.shift(bitSet, 1);
        boolean bl = regionInitialized = !lcc.skipRegionInitialization();
        if (regionInitialized) {
            scan = tc.openGroupFetchScan(td.getHeapConglomerateId(), false, 0, 7, 5, zeroBasedBitSet, null, 0, null, null, 0);
        }
        ExecRow[] baseRows = new ExecRow[bulkFetchSize];
        ExecIndexRow[] indexRows = new ExecIndexRow[bulkFetchSize];
        ExecRow[] compactBaseRows = new ExecRow[bulkFetchSize];
        RowLocation[] rl = null;
        try {
            for (int i = 0; i < bulkFetchSize; ++i) {
                baseRows[i] = activation.getExecutionFactory().getValueRow(maxBaseColumnPosition);
                indexRows[i] = indexRowGenerator.getIndexRowTemplate();
                compactBaseRows[i] = activation.getExecutionFactory().getValueRow(baseColumnPositions.length);
            }
            this.indexTemplateRow = indexRows[0];
            ColumnDescriptorList cdl = td.getColumnDescriptorList();
            int cdlSize = cdl.size();
            int numSet = 0;
            for (int index = 0; index < cdlSize; ++index) {
                if (!zeroBasedBitSet.get(index)) continue;
                ++numSet;
                ColumnDescriptor cd = cdl.elementAt(index);
                DataTypeDescriptor dts = cd.getType();
                for (int i = 0; i < bulkFetchSize; ++i) {
                    baseRows[i].setColumn(index + 1, dts.getNull());
                    compactBaseRows[i].setColumn(numSet, baseRows[i].getColumn(index + 1));
                }
                approximateRowSize += dts.getTypeId().getApproximateLengthInBytes(dts);
            }
            rl = new RowLocation[bulkFetchSize];
            for (int i = 0; i < bulkFetchSize; ++i) {
                rl[i] = this.indexType.equals("GLOBALHASH") ? new GlobalExecRowLocation() : (scan != null ? scan.newRowLocationTemplate() : DataValueFactory.DUMMY);
                indexRowGenerator.getIndexRow(compactBaseRows[i], rl[i], indexRows[i], bitSet);
            }
            if (shareExisting) {
                return;
            }
            int numColumnOrderings = 0;
            BasicSortObserver sortObserver = null;
            Properties sortProperties = null;
            if (this.unique || this.uniqueWithDuplicateNulls) {
                if (!this.indexType.equals("GLOBALHASH")) {
                    String indexOrConstraintName = this.indexName;
                    if (this.conglomerateUUID != null) {
                        ConglomerateDescriptor cd = dd.getConglomerateDescriptor(this.conglomerateUUID);
                        if (this.isConstraint && cd != null && cd.getUUID() != null && td != null) {
                            ConstraintDescriptor conDesc = dd.getConstraintDescriptor(td, cd.getUUID());
                            indexOrConstraintName = conDesc.getConstraintName();
                        }
                    }
                    if (this.unique) {
                        numColumnOrderings = baseColumnPositions.length;
                        sortObserver = new UniqueIndexSortObserver(true, this.isConstraint, indexOrConstraintName, this.indexTemplateRow, true, td.getName());
                    } else {
                        numColumnOrderings = baseColumnPositions.length + 1;
                        sortProperties = new Properties();
                        sortProperties.put("implType", "sort almost unique external");
                        sortObserver = new UniqueWithDuplicateNullsIndexSortObserver(true, this.isConstraint, indexOrConstraintName, this.indexTemplateRow, true, td.getName());
                    }
                }
            } else {
                numColumnOrderings = baseColumnPositions.length + 1;
                sortObserver = new BasicSortObserver(true, false, this.indexTemplateRow, true);
            }
            ColumnOrdering[] order = new ColumnOrdering[numColumnOrderings];
            for (int i = 0; i < numColumnOrderings; ++i) {
                order[i] = new IndexColumnOrder(i, this.unique || i < numColumnOrderings - 1 ? this.isAscending[i] : true);
            }
            indexProperties.put("com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary", dd);
            indexProperties.setProperty(GfxdConstants.PROPERTY_SCHEMA_NAME, this.schemaName);
            indexProperties.setProperty(GfxdConstants.PROPERTY_TABLE_NAME, this.indexName);
            indexProperties.put(GfxdConstants.PROPERTY_INDEX_BASE_COL_POS, baseColumnPositions);
            indexProperties.put(GfxdConstants.PROPERTY_INDEX_BASE_TABLE_DESC, td);
            this.conglomId = tc.createConglomerate(this.indexType, this.indexTemplateRow.getRowArray(), order, indexRowGenerator.getColumnCollationIds(td.getColumnDescriptorList()), indexProperties, 0);
            if (GemFireXDUtils.TraceIndex || GemFireXDUtils.TracePersistIndex) {
                GfxdIndexManager.traceIndex("CreateIndexConstantAction::executeConstantAction persist-indexes=%s, this.throughConstraint=%s, conglomId=%s", persistIndexes, this.throughConstraint, this.conglomId);
            }
            if (persistIndexes && this.throughConstraint) {
                StaticCompiledOpenConglomInfo scoci = lcc.getTransactionCompile().getStaticCompiledConglomInfo(this.conglomId);
                DataValueDescriptor tmpdvd = scoci.getConglom();
                if (GemFireXDUtils.TraceIndex || GemFireXDUtils.TracePersistIndex) {
                    GfxdIndexManager.traceIndex("CreateIndexConstantAction::executeConstantAction tmpdvd=%s", tmpdvd);
                }
                this.indexContainer = tmpdvd instanceof SortedMap2Index ? ((SortedMap2Index)tmpdvd).getGemFireContainer() : null;
            }
        }
        finally {
            if (scan != null) {
                scan.close();
            }
            if (rowSource != null) {
                rowSource.closeRowSource();
            }
            if (needToDropSort) {
                tc.dropSort(sortId);
            }
        }
        ConglomerateController indexController = tc.openConglomerate(this.conglomId, false, 0, 7, 5);
        if (!indexController.isKeyed()) {
            indexController.close();
            throw StandardException.newException("X0X85.S", (Object)this.indexName, (Object)this.indexType);
        }
        indexController.close();
        if (!alreadyHaveConglomDescriptor) {
            ConglomerateDescriptor cgd = ddg.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, td.getUUID(), sd.getUUID());
            dd.addDescriptor(cgd, sd, 0, false, tc);
            ConglomerateDescriptorList cdl = td.getConglomerateDescriptorList();
            cdl.add(cgd);
            this.conglomerateUUID = cgd.getUUID();
        }
        ConglomerateDescriptor cd = dd.getConglomerateDescriptor(this.conglomerateUUID);
        try {
            GfxdIndexManager indexManager = GfxdIndexManager.getGfxdIndexManager(td, lcc);
            if (GemFireXDUtils.TraceIndex || GemFireXDUtils.TracePersistIndex) {
                GfxdIndexManager.traceIndex("CreateIndexConstantAction::executeConstantAction  skipLoadConglom=%s and regionInitialized=%s for table=%s and implicit indexContainer created=%s", this.skipLoadConglom, regionInitialized, td.getQualifiedName(), this.indexContainer != null ? this.indexContainer.getQualifiedTableName() : "null");
            }
            boolean ddlReplayInProgress = memStore.initialDDLReplayInProgress();
            if (GemFireXDUtils.TracePersistIndex) {
                GfxdIndexManager.traceIndex("CreateIndexConstantAction::executeConstantAction  replay in progress=%s, is connection for remote ddl=%s", ddlReplayInProgress, lcc.isConnectionForRemoteDDL());
            }
            if (!this.skipLoadConglom || !regionInitialized) {
                if (!ddlReplayInProgress || !this.indexType.equals("GLOBALHASH")) {
                    if (regionInitialized) {
                        this.loadIndexConglomerate(lcc, tc, td, indexManager, zeroBasedBitSet, baseRows, indexRows, rl, true);
                    } else if (indexManager != null) {
                        indexManager.invalidateFor(lcc);
                    }
                }
            } else if (this.indexType.equals("LOCALSORTEDMAP") && regionInitialized) {
                if (GemFireXDUtils.TraceConglomUpdate) {
                    SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("For table " + td.getQualifiedName() + " deferring index load after region's: " + this.indexName + ", columns: " + RowUtil.toString(this.columnNames)));
                }
                this.loadIndexData.add(new CreateTableConstantAction.LoadIndexData(this, zeroBasedBitSet, baseRows, indexRows, rl));
            }
        }
        finally {
            if (GemFireXDUtils.TraceConglom) {
                MemConglomerate conglom = memStore.findConglomerate(ContainerKey.valueOf(0L, this.conglomId));
                SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("CreateIndex: created indexConglom: " + conglom + ", with indexContainer: " + conglom.getGemFireContainer()));
            }
            GfxdIndexManager.setIndexInitialized(cd);
        }
        if (!"SYSSTAT".equalsIgnoreCase(this.schemaName) && !Misc.isSnappyHiveMetaTable(this.schemaName) || GemFireXDUtils.TraceConglom) {
            SanityManager.DEBUG_PRINT((String)"info:TraceConglom", (String)("Created index with descriptor: " + cd));
        }
    }

    String getConstraintIndexType(LanguageConnectionContext lcc, TableDescriptor td, int[] baseColumnPositions, Properties properties) throws StandardException {
        int policy;
        assert (this.isConstraint || this.unique);
        DistributionDescriptor distributionDesc = td.getDistributionDescriptor();
        assert (distributionDesc != null);
        int constraintType = -1;
        if (properties != null) {
            String value = properties.getProperty(GfxdConstants.PROPERTY_CONSTRAINT_TYPE, "-1");
            constraintType = Integer.parseInt(value);
        }
        if (constraintType == -1 && this.unique) {
            constraintType = 3;
        }
        if ((policy = distributionDesc.getPolicy()) == 1 || policy == 0) {
            if (constraintType == 2) {
                GemFireXDUtils.sortColumns(baseColumnPositions, this.columnNames);
                return "LOCALHASH1";
            }
            return "LOCALSORTEDMAP";
        }
        int[] partitionColumnPositions = distributionDesc.getColumnPositionsSorted();
        switch (constraintType) {
            case 2: {
                GemFireXDUtils.sortColumns(baseColumnPositions, this.columnNames);
                int val = GemFireXDUtils.setCompare(baseColumnPositions, partitionColumnPositions);
                if (val >= 0) {
                    return "LOCALHASH1";
                }
                return "GLOBALHASH";
            }
            case 3: {
                int val = GemFireXDUtils.setCompare(baseColumnPositions, partitionColumnPositions);
                if (val >= 0) {
                    if (this.isGlobalIndexRequiredForHDFS(td)) {
                        return "GLOBALHASH";
                    }
                    return "LOCALSORTEDMAP";
                }
                return "GLOBALHASH";
            }
            case 6: {
                return "LOCALSORTEDMAP";
            }
        }
        SanityManager.THROWASSERT((String)("unknown constraintType=" + constraintType));
        return null;
    }

    ExecRow getIndexTemplateRow() {
        return this.indexTemplateRow;
    }

    long getCreatedConglomNumber() {
        if (this.conglomId == -1L) {
            SanityManager.THROWASSERT((String)"Called getCreatedConglomNumber() on a CreateIndexConstantAction before the action was executed.");
        }
        return this.conglomId;
    }

    long getReplacedConglomNumber() {
        return this.droppedConglomNum;
    }

    UUID getCreatedUUID() {
        return this.conglomerateUUID;
    }

    public final void loadIndexConglomerate(LanguageConnectionContext lcc, TransactionController tc, TableDescriptor td, GfxdIndexManager indexManager, FormatableBitSet zeroBasedBitSet, ExecRow[] baseRows, ExecIndexRow[] indexRows, RowLocation[] rl, boolean refreshIndexList) throws StandardException {
        if (GemFireXDUtils.TraceIndex) {
            GfxdIndexManager.traceIndex("CreateIndexConstantAction::loadIndexConglomerate called for table=%s and index=%s", td.getQualifiedName(), this.indexName);
        }
        if (indexManager != null) {
            if (refreshIndexList) {
                indexManager.invalidateFor(lcc);
            }
            if (this.indexType.equals("LOCALHASH1")) {
                return;
            }
            GemFireContainer container = indexManager.getContainer();
            GemFireTransaction tran = (GemFireTransaction)tc;
            boolean needLogging = false;
            try {
                needLogging = tran.needLogging();
                tran.disableLogging();
                boolean isLocalIndex = this.indexType.equals("LOCALSORTEDMAP");
                MemScanController scan = tran.openGroupFetchScan(td.getHeapConglomerateId(), false, isLocalIndex ? 0x200000 : 0, 7, 5, zeroBasedBitSet, null, 0, null, null, 0);
                this.loadIndexConglomerate(baseRows, indexRows, lcc, tran, scan, this.conglomId, rl, container, indexManager);
            }
            catch (Throwable t) {
                SanityManager.DEBUG_PRINT((String)"error:TraceIndex", (String)"unexpected exception in index load", (Throwable)t);
                if (t instanceof StandardException) {
                    throw (StandardException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw StandardException.plainWrapException(t);
            }
            finally {
                if (tran != null && needLogging) {
                    tran.enableLogging();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndexConglomerate(ExecRow[] baseRows, ExecIndexRow[] indexRows, LanguageConnectionContext lcc, TransactionController tc, GroupFetchScanController scan, long conglomId, RowLocation[] rlArray, GemFireContainer container, GfxdIndexManager indexManager) throws StandardException {
        long rowCount = 0L;
        boolean byteStore = container.isByteArrayStore();
        try (ConglomerateController cc = byteStore ? null : tc.openConglomerate(conglomId, false, 4, 7, 2);){
            int bulkFetchSize = baseRows.length;
            SanityManager.ASSERT((bulkFetchSize == indexRows.length ? 1 : 0) != 0, (String)"number of base rows and index rows does not match");
            SanityManager.ASSERT((bulkFetchSize == rlArray.length ? 1 : 0) != 0, (String)"number of base rows and row locations does not match");
            ExecRow[] baseRowArray = new ExecRow[bulkFetchSize];
            for (int i = 0; i < bulkFetchSize; ++i) {
                baseRowArray[i] = byteStore ? container.newTemplateRow() : baseRows[i];
            }
            boolean isLocalIndex = this.indexType.equals("LOCALSORTEDMAP");
            int bulkFetched = 0;
            if (byteStore) {
                MemConglomerate conglom = Misc.getMemStoreBooting().findConglomerate(ContainerKey.valueOf(0L, conglomId));
                GemFireContainer indexContainer = conglom.getGemFireContainer();
                boolean skipConstraintChecks = lcc != null && lcc.isSkipConstraintChecks();
                boolean loadIndex = true;
                LocalRegion baseRegion = indexManager.getContainer().getRegion();
                if (GemFireXDUtils.TracePersistIndex) {
                    GfxdIndexManager.traceIndex("CreateIndexConstantAction::loadIndexConglomerate: create IRF = " + this.createIRF + ", region is: " + baseRegion, new Object[0]);
                }
                if (isLocalIndex && !indexContainer.isGlobalIndex()) {
                    if (this.createIRF && baseRegion.getDataPolicy().withPersistence()) {
                        DiskStoreImpl dsImpl = baseRegion.getDiskStore();
                        if (GemFireXDUtils.TracePersistIndex) {
                            GfxdIndexManager.traceIndex("CreateIndexConstantAction::loadIndexConglomerate: for table: " + this.tableName + " diskstore is: " + dsImpl + ", region: " + baseRegion, new Object[0]);
                        }
                        if (dsImpl == null) {
                            SanityManager.THROWASSERT((String)("unexpected null disk store for persistent region: " + baseRegion));
                        }
                        rowCount = indexManager.writeNewIndexRecords(indexContainer, dsImpl);
                        loadIndex = false;
                    } else {
                        if (GemFireXDUtils.TraceQuery || GemFireXDUtils.TraceIndex) {
                            GfxdIndexManager.traceIndex("CreateIndexConstantAction::loadIndexConglomerate: for table: " + this.tableName + ", region: " + baseRegion, new Object[0]);
                        }
                        rowCount = indexManager.loadLocalIndexRecords(indexContainer);
                        loadIndex = false;
                    }
                }
                if (loadIndex) {
                    EntryEventImpl event = EntryEventImpl.create(null, (Operation)Operation.CREATE, null, null, null, (boolean)false, null);
                    event.disallowOffHeapValues();
                    LocalRegion[] owners = new LocalRegion[bulkFetchSize];
                    while ((bulkFetched = scan.fetchNextGroup(baseRowArray, rlArray, null, null, null, owners)) > 0) {
                        for (int i = 0; i < bulkFetched; ++i) {
                            RowLocation rl = rlArray[i];
                            if (!isLocalIndex && rl instanceof GlobalExecRowLocation) {
                                rl = (RowLocation)((GlobalExecRowLocation)rl).getRegionEntry();
                            }
                            indexManager.insertIntoIndex(null, null, owners[i], event, false, false, rl, baseRowArray[i], null, null, rl.getBucketID(), indexContainer, null, skipConstraintChecks, skipConstraintChecks, GfxdIndexManager.Index.BOTH, false);
                            ++rowCount;
                        }
                        Misc.checkIfCacheClosing(null);
                    }
                }
            } else {
                while ((bulkFetched = scan.fetchNextGroup(baseRowArray, rlArray, null, null, null, null)) > 0) {
                    int i;
                    if (isLocalIndex) {
                        for (i = 0; i < bulkFetched; ++i) {
                            indexRows[i].setColumn(indexRows[i].nColumns(), rlArray[i]);
                        }
                    }
                    for (i = 0; i < bulkFetched; ++i) {
                        if (GemFireXDUtils.TraceIndex) {
                            GfxdIndexManager.traceIndex("CreateIndexConstantAction::loadIndexConglomerate inserting=%s for %s", indexRows[i].getRowArray(), this);
                        }
                        cc.insert(indexRows[i].getRowArray());
                        ++rowCount;
                    }
                }
            }
            scan.setEstimatedRowCount(rowCount);
            if (!("SYSSTAT".equalsIgnoreCase(this.schemaName) || Misc.isSnappyHiveMetaTable(this.schemaName) || GemFireXDUtils.TraceConglom)) {
                SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("CreateIndex: loaded " + rowCount + " rows in index: " + this.indexName));
            }
        }
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getObjectName() {
        return this.indexName;
    }

    public void clearDroppedConglomerateNumber() {
        this.droppedConglomNum = -1L;
    }

    public void skipLoadConglomerate() {
        this.skipLoadConglom = true;
    }

    public final Collection<CreateTableConstantAction.LoadIndexData> getLoadIndexData() {
        return this.loadIndexData;
    }

    public void setThroughConstraint() {
        this.throughConstraint = true;
    }

    private boolean isGlobalIndexRequiredForHDFS(TableDescriptor td) throws StandardException {
        GemFireContainer baseContainer = Misc.getMemStoreBooting().getContainer(ContainerKey.valueOf(0L, td.getHeapConglomerateId()));
        RegionAttributes<?, ?> rattrs = baseContainer.getRegionAttributes();
        if (rattrs.getDataPolicy().withHDFS()) {
            boolean skip;
            LogWriterI18n log = InternalDistributedSystem.getLoggerI18n();
            boolean bl = skip = rattrs.getCustomEvictionAttributes() == null && td.getDistributionDescriptor().getPersistence() && Version.GFXD_13.compareTo(GemFireXDUtils.getCurrentDDLVersion()) < 0;
            if (log.fineEnabled() && skip) {
                log.fine("Creating local index instead of global index for table " + td.getName());
            }
            return !skip;
        }
        return false;
    }
}

