/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecAggregator;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.SystemAggregator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class CountAggregator
extends SystemAggregator {
    private long value;
    private boolean isCountStar;

    @Override
    public void setup(String aggregateName, AggregatorInfo aggInfo) {
        this.isCountStar = aggregateName.equals("COUNT(*)");
        if (aggInfo != null) {
            super.setup(aggInfo);
        }
    }

    @Override
    public void setup(String aggregateName, DataValueDescriptor initValue) throws StandardException {
        this.setup(aggregateName, (AggregatorInfo)null);
        this.value = initValue.getLong();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void accumulate(ExecRow inputRow) throws StandardException {
        if (this.isCountStar) {
            ++this.value;
        } else if (inputRow.isNull(this.inputColumnPos) != -7L) {
            ++this.value;
        } else if (!this.eliminatedNulls) {
            this.eliminatedNulls = true;
        }
    }

    @Override
    public void setResult(ExecRow row, int columnPos) throws StandardException {
        DataValueDescriptor outputColumn = row.getColumn(columnPos);
        outputColumn.setValue(this.value);
    }

    @Override
    public boolean finish(ExecRow row, boolean isByteArray) throws StandardException {
        boolean eliminatedNulls = this.eliminatedNulls;
        long result = this.value;
        this.value = 0L;
        this.eliminatedNulls = false;
        if (this.isAccumulateDistinctValues) {
            SanityManager.ASSERT((boolean)DVDSet.class.isInstance(row.getColumn(this.resultColumnPos)), (String)"ExecAggregator must be of type DVDSet");
            return false;
        }
        if (isByteArray) {
            row.setValue(this.resultColumnPos - 1, new SQLLongint(result));
        } else {
            DataValueDescriptor outputColumn = row.getColumn(this.resultColumnPos);
            outputColumn.setValue(result);
        }
        return eliminatedNulls;
    }

    @Override
    public void clear() {
        this.value = 0L;
        super.clear();
    }

    @Override
    public void merge(ExecAggregator addend) throws StandardException {
        SanityManager.ASSERT((boolean)(addend instanceof CountAggregator), (String)"addend is supposed to be the same type of aggregator for the merge operator");
        this.value += ((CountAggregator)addend).value;
    }

    @Override
    public DataValueDescriptor getResult() {
        if (this.value >= Integer.MIN_VALUE && this.value <= Integer.MAX_VALUE) {
            return new SQLInteger((int)this.value);
        }
        return new SQLLongint(this.value);
    }

    @Override
    public void accumulate(DataValueDescriptor addend) throws StandardException {
        if (this.isCountStar) {
            ++this.value;
        } else if (addend != null && !addend.isNull()) {
            ++this.value;
        } else if (!this.eliminatedNulls) {
            this.eliminatedNulls = true;
        }
    }

    @Override
    protected final void basicAccumulate(DataValueDescriptor addend) {
        ++this.value;
    }

    @Override
    public ExecAggregator newAggregator() {
        CountAggregator ca = new CountAggregator();
        ca.isCountStar = this.isCountStar;
        return ca;
    }

    public boolean isCountStar() {
        return this.isCountStar;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.isCountStar);
        out.writeLong(this.value);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.isCountStar = in.readBoolean();
        this.value = in.readLong();
    }

    @Override
    public int getTypeFormatId() {
        return 151;
    }

    @Override
    public int compareTo(Object o) {
        long otherValue = ((CountAggregator)o).value;
        return this.value == otherValue ? 0 : (this.value < otherValue ? -1 : 1);
    }
}

