/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.hdfs.HDFSStoreMutator;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.HDFSStoreAlterOperation;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

public class AlterHDFSStoreConstantAction
extends DDLConstantAction {
    private final String hdfsStoreName;
    private final HDFSStoreMutator mutator;
    public static final String REGION_PREFIX_FOR_CONFLATION = "__GFXD_INTERNAL_HDFSSTORE_";

    AlterHDFSStoreConstantAction(String hdfsStoreName, HDFSStoreMutator hsm) {
        this.hdfsStoreName = hdfsStoreName;
        this.mutator = hsm;
    }

    @Override
    public final String getSchemaName() {
        return "SYS";
    }

    @Override
    public final String getTableName() {
        return REGION_PREFIX_FOR_CONFLATION + this.hdfsStoreName;
    }

    public String toString() {
        return this.constructToString("ALTER HDFSSTORE ", this.hdfsStoreName);
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        HDFSStoreAlterOperation startOp = new HDFSStoreAlterOperation(this.mutator, this.hdfsStoreName);
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        GemFireTransaction gft = (GemFireTransaction)lcc.getTransactionExecute();
        gft.logAndDo(startOp);
    }

    public final String getHDFSStoreName() {
        return this.hdfsStoreName;
    }
}

