/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.NcjHashMapWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ExplainResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NcjSQLGeneratorVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SingleChildResultSetNode;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class NcjPullScanNode
extends SingleChildResultSetNode {
    private boolean isRemoteScan = true;
    private boolean isAtSecondPosition = false;
    private boolean hasVarLengthInList = true;

    public boolean isAtSecondPosition() {
        return this.isAtSecondPosition;
    }

    @Override
    public void init(Object childResult, Object isRemoteScan, Object isAtSecondPosition, Object tableProperties) throws StandardException {
        super.init(childResult, tableProperties);
        if (!(childResult instanceof ProjectRestrictNode)) {
            SanityManager.THROWASSERT((String)("childResult, " + childResult.getClass().getName() + ", expected to be instanceof ProjectRestrictNode"));
        }
        ResultColumnList prRCList = this.childResult.getResultColumns().copyListAndObjects();
        this.resultColumns = this.childResult.getResultColumns();
        this.childResult.setResultColumns(prRCList);
        this.resultColumns.genVirtualColumnNodes(this, prRCList);
        this.isRemoteScan = (Boolean)isRemoteScan;
        this.isAtSecondPosition = (Boolean)isAtSecondPosition;
        this.hasVarLengthInList = !this.isAtSecondPosition;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.childResult.assertProjectRestrictNode();
        ProjectRestrictNode childPrn = (ProjectRestrictNode)this.childResult;
        FromBaseTable fbt = childPrn.ncjGetOnlyOneFBTNode();
        SanityManager.ASSERT((fbt != null ? 1 : 0) != 0);
        if (fbt.resultSetNumber < 1) {
            fbt.resultSetNumber = this.getCompilerContext().getNextResultSetNumber();
        }
        if (childPrn.getRemoteInListCols() == null) {
            this.hasVarLengthInList = false;
        }
        NcjSQLGeneratorVisitor ncjVisitor = new NcjSQLGeneratorVisitor(this.hasVarLengthInList);
        childPrn.accept(ncjVisitor);
        ArrayList<Integer> params = new ArrayList<Integer>();
        String sqlString = ncjVisitor.getGeneratedSql(params);
        boolean generateInList = ncjVisitor.isGenerateInList();
        String corrName = fbt.ncjGetCorrelationName();
        int prID = NcjHashMapWrapper.MINUS_ONE;
        if (fbt.isPartitionedRegion()) {
            prID = ((PartitionedRegion)fbt.getRegion(false)).getPRId();
        }
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullScanNode::generate. SQL=" + sqlString + " ,params=" + params.toString() + " ,is-remote-scan=" + this.isRemoteScan + " ,hasVarLengthInList=" + this.hasVarLengthInList + " ,childPrnHasVarLengthInList=" + (childPrn.getRemoteInListCols() != null) + " ,generateInList=" + generateInList + " ,tab-corr-name=" + corrName + " ,prID=" + prID));
        }
        childPrn.generateNOPProjectRestrict();
        childPrn.assignResultSetNumber(fbt.resultSetNumber);
        fbt.assignResultSetNumber(fbt.resultSetNumber);
        childPrn.childResult.assignResultSetNumber(fbt.resultSetNumber);
        NcjPullScanNode.generateRemoteResultSet(acb, mb, fbt.resultSetNumber, sqlString, params, this.getContextManager(), this.isRemoteScan, this.hasVarLengthInList && generateInList, prID);
    }

    public static void generateRemoteResultSet(ExpressionClassBuilder acb, MethodBuilder mb, int rsNum, String sqlString, List<Integer> params, ContextManager ctx, boolean isRemoteScan, boolean hasVarLengthInList, int prId) throws StandardException {
        GenericPreparedStatement gps;
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.push(sqlString);
        try {
            EmbedConnectionContext eCtx = (EmbedConnectionContext)ctx.getContext("JDBC_ConnectionContext");
            EmbedConnection nestedConn = ExplainResultSet.createNestedConnection(eCtx.getEmbedConnection());
            PreparedStatement ps = nestedConn.prepareStatement(sqlString, isRemoteScan);
            EmbedPreparedStatement eps = (EmbedPreparedStatement)ps;
            gps = eps.getGPS();
            SanityManager.ASSERT((gps != null ? 1 : 0) != 0);
        }
        catch (SQLException e) {
            throw StandardException.unexpectedUserException(e);
        }
        QueryInfo qinfo = gps.getQueryInfo();
        if (isRemoteScan) {
            if (qinfo != null) {
                if (qinfo instanceof SelectQueryInfo) {
                    if (hasVarLengthInList) {
                        ((SelectQueryInfo)qinfo).setNcjLevelTwoQueryWithVarIN(true);
                    }
                } else {
                    SanityManager.THROWASSERT((String)("Query Info must be for type SelectQueryInfo, and not " + qinfo.getClass().getSimpleName()));
                }
            } else {
                SanityManager.THROWASSERT((String)"Query Info must not be Null");
            }
        } else if (qinfo != null) {
            SanityManager.THROWASSERT((String)("Query Info must be Null, and not " + qinfo.getClass().getSimpleName()));
        }
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullScanNode::generateRemoteResultSet. SQL=" + sqlString + " ,is remote scan=" + isRemoteScan + " ,qinfo=" + qinfo + " ,hasVarLengthInList=" + hasVarLengthInList));
        }
        mb.push(acb.addItem(params));
        CompilerContext cc = (CompilerContext)ctx.getContext("CompilerContext");
        gps.setParentPS(cc.getParentPS());
        if (gps.getStatementStats() != null && cc.getStatementStats() != null) assert (gps.getStatementStats() == cc.getStatementStats());
        gps.setStatementStats(cc.getStatementStats());
        mb.push(acb.addItem(gps));
        mb.push(rsNum);
        mb.push(isRemoteScan);
        mb.push(hasVarLengthInList);
        mb.push(prId);
        mb.callMethod((short)185, null, "getNcjPullResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 8);
    }

    @Override
    public int convertAbsoluteToRelativeColumnPosition(int absolutePosition, ColumnReference ref) {
        if (ref != null) {
            int colLength = this.getNumColumnsReturned();
            for (int colCtr = 0; colCtr < colLength; ++colCtr) {
                ResultColumn resCol = (ResultColumn)this.resultColumns.elementAt(colCtr);
                try {
                    if (resCol.getTableNumber() == ref.getTableNumber() && resCol.getColumnPosition() == ref.getColumnNumber()) {
                        return colCtr;
                    }
                    continue;
                }
                catch (StandardException e) {
                    e.printStackTrace();
                }
            }
        }
        return absolutePosition;
    }
}

