/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;

public class DropSchemaNode
extends DDLStatementNode {
    private int dropBehavior;
    private String schemaName;
    private boolean onlyIfExists;

    @Override
    public void init(Object schemaName, Object onlyIfExists, Object dropBehavior) throws StandardException {
        this.initAndCheck(null);
        this.schemaName = (String)schemaName;
        this.dropBehavior = (Integer)dropBehavior;
        this.onlyIfExists = (Boolean)onlyIfExists;
    }

    @Override
    public void bindStatement() throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        if (this.getDataDictionary().isSystemSchemaName(this.schemaName)) {
            throw StandardException.newException("42Y67", this.schemaName);
        }
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredSchemaPriv(this.schemaName, lcc.getAuthorizationId(), 18);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "dropBehavior: \n" + this.dropBehavior + "\nonlyIfExists: " + this.onlyIfExists + '\n';
    }

    @Override
    public String statementToString() {
        return "DROP SCHEMA";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropSchemaConstantAction(this.schemaName, this.onlyIfExists);
    }
}

