/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class CreateIndexNode
extends DDLStatementNode {
    boolean unique;
    DataDictionary dd = null;
    Properties properties;
    String indexType;
    TableName indexName;
    TableName tableName;
    Vector columnNameList;
    String[] columnNames = null;
    boolean[] isAscending;
    int[] boundColumnIDs;
    TableDescriptor td;

    @Override
    public void init(Object unique, Object indexType, Object indexName, Object tableName, Object columnNameList, Object properties) throws StandardException {
        this.initAndCheck(indexName);
        this.unique = (Boolean)unique;
        this.indexType = (String)indexType;
        this.indexName = (TableName)indexName;
        this.tableName = (TableName)tableName;
        this.columnNameList = (Vector)columnNameList;
        this.properties = (Properties)properties;
    }

    @Override
    public String toString() {
        return super.toString() + "unique: " + this.unique + "\nindexType: " + this.indexType + "\nindexName: " + this.indexName + "\ntableName: " + this.tableName + "\nproperties: " + this.properties + "\n";
    }

    @Override
    public String statementToString() {
        return "CREATE INDEX";
    }

    public boolean getUniqueness() {
        return this.unique;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public TableName getIndexName() {
        return this.indexName;
    }

    public UUID getBoundTableID() {
        return this.td.getUUID();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public TableName getIndexTableName() {
        return this.tableName;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int[] getKeyColumnIDs() {
        return this.boundColumnIDs;
    }

    public boolean[] getIsAscending() {
        return this.isAscending;
    }

    @Override
    public void bindStatement() throws StandardException {
        SchemaDescriptor sd = this.getSchemaDescriptor();
        this.td = this.getTableDescriptor(this.tableName);
        if (this.td.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        if (this.td.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", (Object)String.valueOf(this.td.getTotalNumberOfIndexes()), (Object)this.tableName, (Object)String.valueOf(Short.MAX_VALUE));
        }
        this.verifyAndGetUniqueNames();
        int columnCount = this.columnNames.length;
        this.boundColumnIDs = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", (Object)this.columnNames[i], (Object)this.tableName);
            }
            this.boundColumnIDs[i] = columnDescriptor.getPosition();
            if (!columnDescriptor.getType().getTypeId().orderable(this.getClassFactory())) {
                throw StandardException.newException("X0X67.S", columnDescriptor.getType().getTypeId().getSQLTypeName());
            }
            TypeId typeId = columnDescriptor.getType().getTypeId();
            if (!typeId.isLOBTypeId() && !typeId.isXMLTypeId()) continue;
            throw StandardException.newException("42832", (Object)columnDescriptor.getColumnName(), (Object)typeId.getSQLTypeName());
        }
        if (columnCount > 16) {
            throw StandardException.newException("54008");
        }
        this.getCompilerContext().createDependency(this.td);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.td.getSchemaName());
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        SchemaDescriptor sd = this.getSchemaDescriptor();
        int columnCount = this.columnNames.length;
        int approxLength = 0;
        boolean index_has_long_column = false;
        for (int i = 0; i < columnCount; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnNames[i]);
            DataTypeDescriptor dts = columnDescriptor.getType();
            approxLength += dts.getTypeId().getApproximateLengthInBytes(dts);
        }
        if (approxLength > 1024 && (this.properties == null || this.properties.get("gemfirexd.storage.pageSize") == null) && PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "gemfirexd.storage.pageSize") == null) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put("gemfirexd.storage.pageSize", "32768");
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(false, this.unique, false, this.indexType, sd.getSchemaName(), this.indexName.getTableName(), this.tableName.getTableName(), this.td.getUUID(), this.columnNames, this.isAscending, false, null, this.properties);
    }

    private void verifyAndGetUniqueNames() throws StandardException {
        int size = this.columnNameList.size();
        Hashtable<String, String> ht = new Hashtable<String, String>(size + 2, 0.999f);
        this.columnNames = new String[size];
        this.isAscending = new boolean[size];
        for (int index = 0; index < size; ++index) {
            this.columnNames[index] = (String)this.columnNameList.elementAt(index);
            if (this.columnNames[index].endsWith(" ")) {
                this.columnNames[index] = this.columnNames[index].substring(0, this.columnNames[index].length() - 1);
                this.isAscending[index] = false;
            } else {
                this.isAscending[index] = true;
            }
            String object = ht.put(this.columnNames[index], this.columnNames[index]);
            if (object == null || !object.equals(this.columnNames[index])) continue;
            throw StandardException.newException("42X66", this.columnNames[index]);
        }
    }
}

