/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.DefaultInfo;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.DefaultInfoImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DefaultNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SpecialFunctionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UntypedNullConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;

public class ColumnDefinitionNode
extends TableElementNode {
    boolean isAutoincrement;
    DataTypeDescriptor type;
    DataValueDescriptor defaultValue;
    DefaultInfoImpl defaultInfo;
    DefaultNode defaultNode;
    long autoincrementIncrement;
    long autoincrementStart;
    long autoinc_create_or_modify_Start_Increment;
    boolean autoincrementVerify;
    boolean hasAutoIncrementInc;
    boolean setAutoIncrement;
    boolean isGeneratedByDefault;
    public static final int CREATE_AUTOINCREMENT = 0;
    public static final int MODIFY_AUTOINCREMENT_RESTART_VALUE = 1;
    public static final int MODIFY_AUTOINCREMENT_INC_VALUE = 2;

    @Override
    public void init(Object name, Object defaultNode, Object dataTypeServices, Object autoIncrementInfo) throws StandardException {
        super.init(name);
        this.type = (DataTypeDescriptor)dataTypeServices;
        if (defaultNode instanceof UntypedNullConstantNode) {
            if (dataTypeServices != null) {
                this.defaultValue = ((UntypedNullConstantNode)defaultNode).convertDefaultNode(this.type);
            }
        } else {
            if (defaultNode != null && !(defaultNode instanceof DefaultNode)) {
                SanityManager.THROWASSERT((String)("defaultNode expected to be instanceof DefaultNode, not " + defaultNode.getClass().getName()));
            }
            this.defaultNode = (DefaultNode)defaultNode;
            if (autoIncrementInfo != null) {
                long[] aii = (long[])autoIncrementInfo;
                this.autoincrementStart = aii[0];
                this.autoincrementIncrement = aii[1];
                this.autoinc_create_or_modify_Start_Increment = aii[3];
                this.autoincrementVerify = aii[2] <= 0L;
                this.isAutoincrement = true;
                this.hasAutoIncrementInc = aii[4] != 0L;
                this.setAutoIncrement = aii[5] != 0L;
                boolean bl = this.isGeneratedByDefault = aii[6] != 0L;
                if (dataTypeServices != null) {
                    this.setNullability(false);
                }
            }
        }
    }

    @Override
    public String toString() {
        DataTypeDescriptor type = this.getType();
        return "type: " + (type != null ? type.toString() : "unknown type") + "\ndefaultValue: " + this.defaultValue + "\n" + super.toString();
    }

    public String getColumnName() {
        return this.name;
    }

    public final DataTypeDescriptor getType() {
        return this.type;
    }

    public void setType(DataTypeDescriptor dts) {
        this.type = dts;
    }

    void setNullability(boolean nullable) {
        this.type = this.getType().getNullabilityType(nullable);
    }

    void setCollationType(int collationType) {
        this.type = this.getType().getCollatedType(collationType, 1);
    }

    public DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    public DefaultInfo getDefaultInfo() {
        return this.defaultInfo;
    }

    public DefaultNode getDefaultNode() {
        return this.defaultNode;
    }

    public boolean isAutoincrementColumn() {
        if (this.isAutoincrement && this.autoincrementIncrement == 0L && (this.autoinc_create_or_modify_Start_Increment == 0L || this.autoinc_create_or_modify_Start_Increment == 2L)) {
            SanityManager.THROWASSERT((String)"autoincrementIncrement expected to be non-zero");
        }
        if (!(this.isAutoincrement || this.autoincrementStart == 0L && this.autoincrementIncrement == 0L)) {
            SanityManager.THROWASSERT((String)"both autoincrementStart and autoincrementIncrement expected to be 0");
        }
        return this.isAutoincrement;
    }

    boolean isGeneratedByDefault() {
        return this.isGeneratedByDefault;
    }

    long getAutoincrementStart() {
        SanityManager.ASSERT((boolean)this.isAutoincrement, (String)"isAutoincrement expected to be true");
        return this.autoincrementStart;
    }

    long getAutoincrementIncrement() {
        SanityManager.ASSERT((boolean)this.isAutoincrement, (String)"isAutoincrement expected to be true");
        return this.autoincrementIncrement;
    }

    long getAutoinc_create_or_modify_Start_Increment() {
        SanityManager.ASSERT((boolean)this.isAutoincrement, (String)"isAutoincrement expected to be true");
        return this.autoinc_create_or_modify_Start_Increment;
    }

    public void checkUserType(TableDescriptor td) throws StandardException {
        if (!this.getType().getTypeId().userType()) {
            return;
        }
        this.setType(this.bindUserType(this.getType()));
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String columnTypeName = this.getType().getTypeId().getCorrespondingJavaTypeName();
        boolean foundMatch = false;
        ClassNotFoundException reason = null;
        try {
            foundMatch = classInspector.accessible(columnTypeName);
        }
        catch (ClassNotFoundException cnfe) {
            reason = cnfe;
        }
        if (!foundMatch) {
            throw StandardException.newException("42X26", reason, (Object)columnTypeName, (Object)this.name);
        }
        if (!classInspector.assignableTo(columnTypeName, "java.io.Serializable") && !classInspector.assignableTo(columnTypeName, "java.sql.SQLData")) {
            this.getCompilerContext().addWarning(StandardException.newWarning("01J04", columnTypeName, this.name));
        }
    }

    UUID getOldDefaultUUID() {
        return null;
    }

    int getAction() {
        return 0;
    }

    void bindAndValidateDefault(DataDictionary dd, TableDescriptor td) throws StandardException {
        if (td != null && !this.getType().isNullable() && this.defaultNode == null && !this.isAutoincrement) {
            throw StandardException.newException("42601", this.getColumnName());
        }
        if (this.defaultNode == null) {
            return;
        }
        if (this.defaultValue != null) {
            return;
        }
        this.validateDefault(dd, td);
    }

    public void validateAutoincrement(DataDictionary dd, TableDescriptor td, int tableType) throws StandardException {
        if (!this.isAutoincrement) {
            return;
        }
        if (tableType == 3) {
            throw StandardException.newException("42995");
        }
        if (this.autoincrementIncrement == 0L && (this.autoinc_create_or_modify_Start_Increment == 0L || this.autoinc_create_or_modify_Start_Increment == 2L)) {
            throw StandardException.newException("42Z21", this.getColumnName());
        }
        int jdbctype = this.getType().getTypeId().getJDBCTypeId();
        switch (jdbctype) {
            case 4: {
                this.autoincrementCheckRange(Integer.MIN_VALUE, Integer.MAX_VALUE, "INTEGER");
                break;
            }
            case -5: {
                this.autoincrementCheckRange(Long.MIN_VALUE, Long.MAX_VALUE, "BIGINT");
                break;
            }
            default: {
                throw StandardException.newException("42Z22", this.getColumnName());
            }
        }
    }

    private void autoincrementCheckRange(long minValue, long maxValue, String typeName) throws StandardException {
        if (minValue > this.autoincrementIncrement || maxValue < this.autoincrementIncrement) {
            throw StandardException.newException("22003", (Object)typeName, (Object)this.name);
        }
        if (minValue > this.autoincrementStart || maxValue < this.autoincrementStart) {
            throw StandardException.newException("22003", (Object)typeName, (Object)this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateDefault(DataDictionary dd, TableDescriptor td) throws StandardException {
        if (this.defaultNode == null) {
            return;
        }
        if (this.isAutoincrement) {
            this.defaultInfo = ColumnDefinitionNode.createDefaultInfoOfAutoInc();
            return;
        }
        CompilerContext cc = this.getCompilerContext();
        ValueNode defaultTree = this.defaultNode.getDefaultTree();
        int previousReliability = cc.getReliability();
        try {
            ProviderList apl = null;
            ProviderList prevAPL = null;
            apl = new ProviderList();
            prevAPL = cc.getCurrentAuxiliaryProviderList();
            cc.setCurrentAuxiliaryProviderList(apl);
            cc.setReliability(1192);
            defaultTree = defaultTree.bindExpression((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), null, null);
            TypeId columnTypeId = this.getType().getTypeId();
            TypeId defaultTypeId = defaultTree.getTypeId();
            if (!this.defaultTypeIsValid(columnTypeId, this.getType(), defaultTypeId, defaultTree, this.defaultNode.getDefaultText())) {
                throw StandardException.newException("42894", this.name);
            }
            if (!this.getTypeCompiler(columnTypeId).storable(defaultTypeId, this.getClassFactory())) {
                throw StandardException.newException("42821", (Object)columnTypeId.getSQLTypeName(), (Object)defaultTypeId.getSQLTypeName(), (Object)this.defaultNode.getDefaultText());
            }
            this.defaultInfo = new DefaultInfoImpl(false, this.defaultNode.getDefaultText(), this.defaultValue);
            if (apl.size() > 0) {
                SanityManager.THROWASSERT((String)"DEFAULT clause has unexpected dependencies");
            }
            cc.setCurrentAuxiliaryProviderList(prevAPL);
        }
        finally {
            cc.setReliability(previousReliability);
        }
    }

    private static DefaultInfoImpl createDefaultInfoOfAutoInc() {
        return new DefaultInfoImpl(true, null, null);
    }

    public boolean defaultTypeIsValid(TypeId columnType, DataTypeDescriptor columnDesc, TypeId defaultType, ValueNode defaultNode, String defaultText) throws StandardException {
        int defType;
        if (defaultText.length() > 254) {
            return false;
        }
        int colType = columnType.getTypeFormatId();
        int n = defType = defaultType == null ? -1 : defaultType.getTypeFormatId();
        if (!defaultNode.isConstantExpression()) {
            boolean charCol;
            boolean bl = charCol = colType == 5 || colType == 13 || colType == 230;
            if (defaultNode instanceof SpecialFunctionNode) {
                switch (defaultNode.getNodeType()) {
                    case 109: 
                    case 110: 
                    case 125: 
                    case 126: 
                    case 210: {
                        return charCol && columnDesc.getMaximumWidth() >= 8;
                    }
                    case 6: {
                        return charCol && columnDesc.getMaximumWidth() >= 128;
                    }
                }
                return false;
            }
        }
        switch (colType) {
            case 7: {
                return defType == 7;
            }
            case 11: {
                return defType == 7 || defType == 11;
            }
            case 197: {
                if (defType == 197) {
                    DataTypeDescriptor defDesc = defaultNode.getTypeServices();
                    int len = defaultText.length();
                    int precision = defDesc.getPrecision();
                    int scale = defDesc.getScale();
                    int i = 1;
                    while (i <= scale && defaultText.charAt(len - i) == '0') {
                        --scale;
                        --precision;
                    }
                    return scale <= columnDesc.getScale() && precision - scale <= columnDesc.getPrecision() - columnDesc.getScale();
                }
                return defType == 11 || defType == 7;
            }
            case 5: 
            case 13: 
            case 230: {
                return defType == 5;
            }
            case 27: 
            case 29: 
            case 232: {
                return defType == 27;
            }
            case 267: {
                return defType == colType;
            }
            case 6: 
            case 8: 
            case 10: 
            case 35: 
            case 36: 
            case 40: 
            case 440: 
            case 444: {
                return true;
            }
        }
        return false;
    }
}

