/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdGatewaySenderDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

public class GfxdSysGatewaySenderRowFactory
extends CatalogRowFactory {
    public static final String TABLENAME_STRING = "GATEWAYSENDERS";
    public static final int GATEWAYSENDERS_COLUMN_COUNT = 15;
    public static final int SENDER_ID = 1;
    public static final int REMOTE_DS_ID = 2;
    public static final int SERVER_GROUPS = 3;
    public static final int SOCKET_BUFFER_SIZE = 4;
    public static final int MANUAL_START = 5;
    public static final int SOCKET_READ_TIMEOUT = 6;
    public static final int BATCH_CONFLATION = 7;
    public static final int BATCH_SIZE = 8;
    public static final int BATCH_TIME_INTERVAL = 9;
    public static final int IS_PERSISTENCE = 10;
    public static final int DISK_STORE_NAME = 11;
    public static final int MAX_QUEUE_MEMORY = 12;
    public static final int ALERT_THRESHOLD = 13;
    public static final int IS_STARTED = 14;
    public static final int DISK_SYNCHRONOUS = 15;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"g073400e-00b6-fdfc-71ce-000b0a763800", "g073400e-00b6-fbba-75d4-000b0a763800", "g073400e-00b6-00b9-bbde-000b0a763800"};

    GfxdSysGatewaySenderRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(15, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        UUID uuid = null;
        String senderId = null;
        Integer remoteDs = null;
        String serverGroup = null;
        Integer socketBufferSize = null;
        Boolean manualStart = null;
        Integer socketReadTimeout = null;
        Integer maximumQueueMemory = null;
        Integer batchSize = null;
        Integer batchTimeInterval = null;
        Boolean isBatchConflationEnabled = null;
        Boolean isPersistenceEnabled = null;
        Boolean diskSynchronous = null;
        String diskStoreName = null;
        Integer alertThreshold = null;
        Boolean isStarted = null;
        if (td != null) {
            GfxdGatewaySenderDescriptor dsd = (GfxdGatewaySenderDescriptor)td;
            uuid = dsd.getUUID();
            senderId = dsd.getSenderId();
            remoteDs = dsd.getRemoteDistributedSystemId();
            serverGroup = dsd.getServerGroup();
            socketBufferSize = dsd.getSocketBufferSize();
            manualStart = dsd.isManualStart();
            socketReadTimeout = dsd.getSocketReadTimeout();
            maximumQueueMemory = dsd.getMaximumQueueMemory();
            batchSize = dsd.getBatchSize();
            batchTimeInterval = dsd.getBatchTimeInterval();
            isBatchConflationEnabled = dsd.isBatchConflationEnabled();
            isPersistenceEnabled = dsd.isPersistenceEnabled();
            diskSynchronous = dsd.isDiskSynchronous();
            diskStoreName = dsd.getDiskStoreName();
            alertThreshold = dsd.getAlertThreshold();
            isStarted = dsd.isStarted();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(15);
        row.setColumn(1, new SQLChar(senderId));
        row.setColumn(2, new SQLInteger(remoteDs));
        row.setColumn(3, new SQLChar(serverGroup));
        row.setColumn(4, new SQLInteger(socketBufferSize));
        row.setColumn(5, new SQLBoolean(manualStart));
        row.setColumn(6, new SQLInteger(socketReadTimeout));
        row.setColumn(7, new SQLBoolean(isBatchConflationEnabled));
        row.setColumn(8, new SQLInteger(batchSize));
        row.setColumn(9, new SQLInteger(batchTimeInterval));
        row.setColumn(10, new SQLBoolean(isPersistenceEnabled));
        row.setColumn(11, new SQLChar(diskStoreName));
        row.setColumn(12, new SQLInteger(maximumQueueMemory));
        row.setColumn(13, new SQLInteger(alertThreshold));
        row.setColumn(14, new SQLBoolean(isStarted));
        row.setColumn(15, new SQLBoolean(diskSynchronous));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentDesc, DataDictionary dd) throws StandardException {
        SanityManager.ASSERT((row.nColumns() == 15 ? 1 : 0) != 0, (String)"Wrong number of columns for a GATEWAYSENDERS row");
        DataValueDescriptor col = row.getColumn(1);
        String senderId = col.getString();
        UUID id = this.getUUIDFactory().recreateUUID(senderId);
        col = row.getColumn(2);
        Integer remoteDsId = col.getInt();
        col = row.getColumn(3);
        String serverGroups = col.getString();
        col = row.getColumn(4);
        Integer socketBufferSize = col.getInt();
        col = row.getColumn(5);
        Boolean manualStart = col.getBoolean();
        col = row.getColumn(6);
        Integer socketReadTimeout = col.getInt();
        col = row.getColumn(7);
        Boolean batchConflation = col.getBoolean();
        col = row.getColumn(8);
        Integer batchSize = col.getInt();
        col = row.getColumn(9);
        Integer batchTimeInterval = col.getInt();
        col = row.getColumn(10);
        Boolean isPersistent = col.getBoolean();
        col = row.getColumn(15);
        Boolean diskSynchronous = col.getBoolean();
        col = row.getColumn(11);
        String diskStoreName = col.getString();
        col = row.getColumn(12);
        Integer maxQueueMemory = col.getInt();
        col = row.getColumn(13);
        Integer alertThreshold = col.getInt();
        col = row.getColumn(14);
        Boolean isStarted = col.getBoolean();
        return new GfxdGatewaySenderDescriptor(dd, id, senderId, remoteDsId, serverGroups, socketBufferSize, manualStart, socketReadTimeout, batchConflation, batchSize, batchTimeInterval, isPersistent, diskSynchronous, diskStoreName, maxQueueMemory, alertThreshold, isStarted);
    }

    @Override
    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getIdentifierColumn("SENDER_ID", false), SystemColumnImpl.getColumn("REMOTE_DS_ID", 4, false), SystemColumnImpl.getColumn("SERVER_GROUPS", 12, false), SystemColumnImpl.getColumn("SOCKET_BUFFER_SIZE", 4, false), SystemColumnImpl.getColumn("MANUAL_START", 16, false), SystemColumnImpl.getColumn("SOCKET_READ_TIMEOUT", 4, false), SystemColumnImpl.getColumn("BATCH_CONFLATION", 16, false), SystemColumnImpl.getColumn("BATCH_SIZE", 4, false), SystemColumnImpl.getColumn("BATCH_TIME_INTERVAL", 4, false), SystemColumnImpl.getColumn("IS_PERSISTENCE", 16, false), SystemColumnImpl.getColumn("DISK_STORE_NAME", 12, true), SystemColumnImpl.getColumn("MAX_QUEUE_MEMORY", 4, false), SystemColumnImpl.getColumn("ALERT_THRESHOLD", 4, false), SystemColumnImpl.getColumn("IS_STARTED", 16, false), SystemColumnImpl.getColumn("DISK_SYNCHRONOUS", 16, false)};
    }
}

