/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;

public final class StatementStats {
    private boolean enableClockStats = true;
    private final boolean isQueryNode;
    private final boolean createdWithExistingStats;
    private final Statistics stats;
    private static final StatisticsType type;
    public static final int numCompiledId = 0;
    public static final int numExecutionsId = 1;
    public static final int numExecutionsInProgressId = 2;
    public static final int numGlobalIndexLookupId = 3;
    public static final int numRowsModifiedId = 4;
    public static final int parseTimeId = 5;
    public static final int bindTimeId = 6;
    public static final int optimizeTimeId = 7;
    public static final int routingInfoTimeId = 8;
    public static final int generateTimeId = 9;
    public static final int totCompilationTimeId = 10;
    public static final int executeTimeId = 11;
    public static final int projectionTimeId = 12;
    public static final int totExecutionTimeId = 13;
    public static final int rowsModificationTimeId = 14;
    public static final int COMMON_STATS_END_OFFSET = 14;
    public static final int qn_numRowsSeenId = 15;
    public static final int qn_msgSendTime = 16;
    public static final int qn_msgSerTime = 17;
    public static final int qn_respDeSerTime = 18;
    public static final int QUERY_NODE_STATS_END_OFFSET = 18;
    public static final int dn_numRowsProjectedId = 15;
    public static final int dn_numNLJoinRowsReturnedId = 16;
    public static final int dn_numHASHJoinRowsReturnedId = 17;
    public static final int dn_numTableRowsScannedId = 18;
    public static final int dn_numRowsHashScannedId = 19;
    public static final int dn_numIndexRowsScannedId = 20;
    public static final int dn_numRowsSortedId = 21;
    public static final int dn_numSortRowsOverflowedId = 22;
    public static final int dn_numRowsGroupedAggregatedId = 23;
    public static final int dn_numSingleHopExecutions = 24;
    public static final int dn_numSubQueryRowsSeen = 25;
    public static final int dn_MsgDeSerTimeId = 26;
    public static final int dn_MsgProcessTimeId = 27;
    public static final int dn_ResultIterationTimeId = 28;
    public static final int dn_RespSerTimeId = 29;
    public static final int dn_ThrottleTimeId = 30;
    public static final int dn_nlJoinTimeId = 31;
    public static final int dn_hashJoinTimeId = 32;
    public static final int dn_tableScanTimeId = 33;
    public static final int dn_hashScanTimeId = 34;
    public static final int dn_indexScanTimeId = 35;
    public static final int dn_sortTimeId = 36;
    public static final int dn_groupedAggregationTimeId = 37;
    public static final int dn_subQueryScanTimeId = 38;
    public static final int DATA_NODE_STATS_END_OFFSET = 38;
    private static final int[] querynode_stats;
    private static final int[] datanode_stats;
    private static final StatisticDescriptor[] qnStatsDesc;
    private static final StatisticDescriptor[] dnStatsDesc;
    public static final String name = "StatementStats";

    private StatementStats(StatisticsFactory factory, String statementString, boolean queryNode, int uniqueId) {
        this.stats = factory.createAtomicStatistics(type, statementString, 0L, (long)uniqueId);
        this.isQueryNode = queryNode;
        this.createdWithExistingStats = false;
    }

    private StatementStats(Statistics s, boolean queryNode) {
        this.stats = s;
        this.isQueryNode = queryNode;
        this.createdWithExistingStats = true;
    }

    public static final StatementStats newInstance(String statementString, boolean queryNode, int uniqueId) {
        InternalDistributedSystem factory = Misc.getGemFireCache().getDistributedSystem();
        Statistics existingStat = factory.findStatisticsByUniqueId((long)uniqueId);
        if (existingStat != null) {
            if (!existingStat.getTextId().equals(statementString)) {
                SanityManager.THROWASSERT((String)(" uniqueId clashed with existing stat " + existingStat.getTextId() + " while creating statistics for " + statementString));
            }
            return new StatementStats(existingStat, queryNode);
        }
        return new StatementStats((StatisticsFactory)factory, statementString, queryNode, uniqueId);
    }

    public String getStatsId() {
        return this.stats.getTextId();
    }

    public Statistics getStatistics() {
        return this.stats;
    }

    public boolean isQueryNode() {
        return this.isQueryNode;
    }

    public boolean isCreatedWithExistingStats() {
        return this.createdWithExistingStats;
    }

    public final void incStat(int id, boolean queryNode, long value) {
        int finalid;
        int n = finalid = queryNode ? querynode_stats[id] : datanode_stats[id];
        if (GemFireXDUtils.TraceStatsGeneration && SanityManager.isFinerEnabled) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)("StatementStatisticsCollector: incrementing offset=" + finalid + " by " + value + " for " + this.stats.getTextId() + " id=" + id + " " + (queryNode ? qnStatsDesc[id].getName() : dnStatsDesc[id].getName())));
        }
        if (finalid == 0 && id != 0) {
            SanityManager.THROWASSERT((String)("incrementing offset=" + finalid + " by " + value + " for " + this.stats.getTextId() + " id=" + id + " " + (queryNode ? qnStatsDesc[id].getName() : dnStatsDesc[id].getName())));
        }
        this.stats.incLong(finalid, value);
    }

    public final long getLong(int id, boolean isQueryNode) {
        return this.stats.getLong(isQueryNode ? querynode_stats[id] : datanode_stats[id]);
    }

    public void incBindTime(long bindTime) {
        this.stats.incLong(6, bindTime);
    }

    public void incRoutingInfoTime(long begin) {
        if (this.enableClockStats) {
            long current = this.getStatTime();
            this.stats.incLong(8, current - begin);
        }
    }

    public void incExecuteTime(long begin) {
        if (this.enableClockStats) {
            long current = this.getStatTime();
            this.stats.incLong(13, current - begin);
        }
    }

    public void incOpenTime(long begin) {
        if (this.enableClockStats) {
            long current = this.getStatTime();
            this.stats.incLong(12, current - begin);
        }
    }

    public void incExecutionsStarted() {
    }

    public void incExecutionsEnded() {
    }

    public void incGetNextCoreDvdTime(long begin) {
        if (this.enableClockStats) {
            long current = this.getStatTime();
            long l = current - begin;
        }
    }

    public void incGetNextCoreByteTime(long begin) {
        if (this.enableClockStats) {
            long current = this.getStatTime();
            long l = current - begin;
        }
    }

    public void incNumGetsStartedDvd() {
    }

    public void incNumGetsStartedByte() {
    }

    public void incNumGetsEndedDvd() {
    }

    public void incNumGetsEndedByte() {
    }

    public void incNumTimesCompiled() {
        this.stats.incLong(0, 1L);
    }

    public void incOptimizeTime(long begin) {
        if (this.enableClockStats) {
            long current = this.getStatTime();
            this.stats.incLong(12, current - begin);
        }
    }

    public long getStatTime() {
        return this.enableClockStats ? NanoTimer.getTime() : 0L;
    }

    public void incRemoteExecutionTime(long begin) {
        if (this.enableClockStats) {
            long l = this.getStatTime();
        }
    }

    public void incNumRemoteExecution() {
    }

    public void incNumReloadArray() {
    }

    public void incNumRowsLoaded(int numRows) {
    }

    public void incExecutionTimeDataNode(long begin) {
        if (this.enableClockStats) {
            long l = this.getStatTime();
        }
    }

    public void incNumRowsReturnedFromDataNode(long numRows) {
    }

    public void incNumBytesWrittenPreQuery(long numBytes) {
    }

    public void incWriteResutlSetDataNode(long begin) {
        if (this.enableClockStats) {
            long l = this.getStatTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Statistics stats = this.stats;
        if (stats != null) {
            this.enableClockStats = false;
            Statistics statistics = stats;
            synchronized (statistics) {
                if (!stats.isClosed()) {
                    stats.close();
                    Misc.getDistributedSystem().destroyStatistics(stats);
                }
            }
        }
    }

    public String toString() {
        return GemFireXDUtils.addressOf(this) + " textId=" + this.stats.getTextId() + " uniqueId=" + this.stats.getUniqueId() + " isQueryNode=" + this.isQueryNode;
    }

    static {
        try {
            int i;
            int si;
            StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
            int numElementsAsStat = 3;
            String[] numDetails = new String[]{"NumTimesCompiled", "Number of times this statement is compiled (including recompilations)", "operations", "NumExecutions", "Number of times this statement is executed", "operations", "NumExecutionsInProgress", "Statements that are actively being processed during the statistics snapshot", "operations", "NumTimesGlobalIndexLookup", "Number of times global index lookup message exchanges occurred ", "operations", "NumRowsModified", "Number of rows modified by DML operation of insert/delete/update ", "operations"};
            String[] timeDetails = new String[]{"ParseTime", "Time spent in parsing the query string", "milliseconds", "BindTime", "Time spent mapping this statement with database object's metadata (bind)", "milliseconds", "OptimizeTime", "Time spent determining the best execution path for this statement (optimize) ", "milliseconds", "RoutingInfoTime", "Time spent compiling details about routing information of query strings to data node(s) (processQueryInfo) ", "milliseconds", "GenerateTime", "Time spent to generate query execution plan definition (activation class)", "milliseconds", "TotalCompilationTime", "Total compilation time of the statement on this node (prepMinion)", "milliseconds", "ExecuteTime", "Time spent in creation of all the layers of query processing (ac.execute)", "nanoseconds", "ProjectionTime", "Time to apply the projection and additional filters. (projectrestrict)", "nanoseconds", "TotalExecutionTime", "Total execution time taken to process the statement on this node (execute/open/next/close) ", "nanoseconds", "RowsModificationTime", "Time taken to modify rows by DML operation of insert/delete/update", "nanoseconds"};
            String[] numQueryNodeDetails = new String[]{"NumRowsSeen", "Number of rows returned from remote nodes (ResultHolder/Get convertibles)", "rowcounts"};
            String[] timeQueryNodeDetails = new String[]{"MsgSendTime", "TCP send time of all the messages including serialization time and queue wait time", "nanoseconds", "MsgSerTime", "Serialization time for all the messages while sending to remote node(s)", "nanoseconds", "RespDeSerTime", "Response message deserialization time from remote node(s) excluding resultset deserialization", "nanoseconds"};
            String[] numDataNodeDetails = new String[]{"NumProjectedRows", "Number of rows returned after applying projection at different stages of processing", "rowcounts", "NumNLJoinRowsReturned", "Number of rows output by nested loop joins of the query", "rowcounts", "NumHASHJoinRowsReturned", "Number of rows output by hash joins of the query", "rowcounts", "NumTableRowsScanned", "Number of rows returned from all the involved table scans ", "rowcounts", "NumRowsHashScanned", "Number of rows returned from a hash scan or distinct scan ", "rowcounts", "NumIndexRowsScanned", "Number of rows returned from all the involved index scans ", "rowcounts", "NumRowsSorted", "Number of rows that is sorted due to group by/order by clauses ", "rowcounts", "NumSortRowsOverflowed", "Number of rows overflowed to temporary files due to sorting ", "rowcounts", "NumRowsGroupedAggregated", "Number of rows returned after grouped aggregation", "rowcounts", "NumSingleHopExecutions", "Number of times the prepared statement executed locally due to single hop ", "rowcounts", "SubQueryNumRowsSeen", "Number of rows seen while subquery execution (by parent query) ", "rowcounts"};
            String[] timeDataNodeDetails = new String[]{"MsgDeSerTime", "Message deserialization time including parameters but excluding MsgProcessTime", "nanoseconds", "MsgProcessTime", "Message process time including local data set creation, query execute and response sending time", "nanoseconds", "ResultIterationTime", "Time to iterate through determined set of results on this node ", "nanoseconds", "RespSerTime", "Response message serialization time excluding ResultIterationTime", "nanoseconds", "ThrottleTime", "Response throttle wait time on data node", "nanoseconds", "NLJoinTime", "Time to process all the nested loop join relations of the query", "nanoseconds", "HASHJoinTime", "Time to process all the hash join relations of the query", "nanoseconds", "TableScanTime", "Time taken to scan all the tables involved in the query", "nanoseconds", "HashScanTime", "Time taken to build a hash table for distinct evaluation or other optimization purpose ", "nanoseconds", "IndexScanTime", "Time taken to scan all the indexes involved in the query", "nanoseconds", "SortTime", "Time taken to sort rows while applying group by or order by clause", "nanoseconds", "GroupedAggregationTime", "Time taken to aggregate with group by clause", "nanoseconds", "SubQueryExecutionTime", "Time taken to scan rows from Subquery (by parent query)", "nanoseconds"};
            int qnStatItems = (numDetails.length + timeDetails.length + numQueryNodeDetails.length + timeQueryNodeDetails.length) / 3;
            assert (qnStatItems == 19);
            qnStatsDesc = new StatisticDescriptor[qnStatItems];
            int endOffset = numDetails.length / 3;
            String QueryNodePrefix = "QN";
            int sd = 0;
            for (si = 0; si < endOffset; ++si) {
                StatementStats.qnStatsDesc[si] = numDetails[sd].endsWith("InProgress") ? f.createLongGauge("QN" + numDetails[sd], numDetails[sd + 1], numDetails[sd + 2]) : f.createLongCounter("QN" + numDetails[sd], numDetails[sd + 1], numDetails[sd + 2]);
                sd += 3;
            }
            endOffset += timeDetails.length / 3;
            sd = 0;
            while (si < endOffset) {
                StatementStats.qnStatsDesc[si] = f.createLongCounter("QN" + timeDetails[sd], timeDetails[sd + 1], timeDetails[sd + 2]);
                sd += 3;
                ++si;
            }
            endOffset += numQueryNodeDetails.length / 3;
            sd = 0;
            while (si < endOffset) {
                StatementStats.qnStatsDesc[si] = f.createLongCounter("QN" + numQueryNodeDetails[sd], numQueryNodeDetails[sd + 1], numQueryNodeDetails[sd + 2]);
                sd += 3;
                ++si;
            }
            endOffset += timeQueryNodeDetails.length / 3;
            sd = 0;
            while (si < endOffset) {
                StatementStats.qnStatsDesc[si] = f.createLongCounter("QN" + timeQueryNodeDetails[sd], timeQueryNodeDetails[sd + 1], timeQueryNodeDetails[sd + 2]);
                sd += 3;
                ++si;
            }
            int dnStatItems = (numDetails.length + timeDetails.length + numDataNodeDetails.length + timeDataNodeDetails.length) / 3;
            dnStatsDesc = new StatisticDescriptor[dnStatItems];
            endOffset = numDetails.length / 3;
            String DataNodePrefix = "DN";
            int sd2 = 0;
            for (si = 0; si < endOffset; ++si) {
                StatementStats.dnStatsDesc[si] = numDetails[sd2].endsWith("InProgress") ? f.createLongGauge("DN" + numDetails[sd2], numDetails[sd2 + 1], numDetails[sd2 + 2]) : f.createLongCounter("DN" + numDetails[sd2], numDetails[sd2 + 1], numDetails[sd2 + 2]);
                sd2 += 3;
            }
            endOffset += timeDetails.length / 3;
            sd2 = 0;
            while (si < endOffset) {
                StatementStats.dnStatsDesc[si] = f.createLongCounter("DN" + timeDetails[sd2], timeDetails[sd2 + 1], timeDetails[sd2 + 2]);
                sd2 += 3;
                ++si;
            }
            endOffset += numDataNodeDetails.length / 3;
            sd2 = 0;
            while (si < endOffset) {
                StatementStats.dnStatsDesc[si] = f.createLongCounter("DN" + numDataNodeDetails[sd2], numDataNodeDetails[sd2 + 1], numDataNodeDetails[sd2 + 2]);
                sd2 += 3;
                ++si;
            }
            endOffset += timeDataNodeDetails.length / 3;
            sd2 = 0;
            while (si < endOffset) {
                StatementStats.dnStatsDesc[si] = f.createLongCounter("DN" + timeDataNodeDetails[sd2], timeDataNodeDetails[sd2 + 1], timeDataNodeDetails[sd2 + 2]);
                sd2 += 3;
                ++si;
            }
            StatisticDescriptor[] statsDesc = new StatisticDescriptor[qnStatsDesc.length + dnStatsDesc.length];
            for (i = 0; i < qnStatsDesc.length; ++i) {
                statsDesc[i] = qnStatsDesc[i];
            }
            i = qnStatsDesc.length;
            int j = 0;
            while (i < qnStatsDesc.length + dnStatsDesc.length) {
                statsDesc[i] = dnStatsDesc[j];
                ++i;
                ++j;
            }
            type = f.createType(name, "Statistics of statement aggregated across self and remote execution", statsDesc);
            querynode_stats = new int[qnStatItems];
            StatementStats.querynode_stats[0] = type.nameToId(qnStatsDesc[0].getName());
            StatementStats.querynode_stats[5] = type.nameToId(qnStatsDesc[5].getName());
            StatementStats.querynode_stats[6] = type.nameToId(qnStatsDesc[6].getName());
            StatementStats.querynode_stats[7] = type.nameToId(qnStatsDesc[7].getName());
            StatementStats.querynode_stats[8] = type.nameToId(qnStatsDesc[8].getName());
            StatementStats.querynode_stats[9] = type.nameToId(qnStatsDesc[9].getName());
            StatementStats.querynode_stats[10] = type.nameToId(qnStatsDesc[10].getName());
            StatementStats.querynode_stats[1] = type.nameToId(qnStatsDesc[1].getName());
            StatementStats.querynode_stats[2] = type.nameToId(qnStatsDesc[2].getName());
            StatementStats.querynode_stats[3] = type.nameToId(qnStatsDesc[3].getName());
            StatementStats.querynode_stats[4] = type.nameToId(qnStatsDesc[4].getName());
            StatementStats.querynode_stats[11] = type.nameToId(qnStatsDesc[11].getName());
            StatementStats.querynode_stats[12] = type.nameToId(qnStatsDesc[12].getName());
            StatementStats.querynode_stats[13] = type.nameToId(qnStatsDesc[13].getName());
            StatementStats.querynode_stats[14] = type.nameToId(qnStatsDesc[14].getName());
            StatementStats.querynode_stats[15] = type.nameToId(qnStatsDesc[15].getName());
            datanode_stats = new int[dnStatItems];
            StatementStats.datanode_stats[0] = type.nameToId(dnStatsDesc[0].getName());
            StatementStats.datanode_stats[5] = type.nameToId(dnStatsDesc[5].getName());
            StatementStats.datanode_stats[6] = type.nameToId(dnStatsDesc[6].getName());
            StatementStats.datanode_stats[7] = type.nameToId(dnStatsDesc[7].getName());
            StatementStats.datanode_stats[8] = type.nameToId(dnStatsDesc[8].getName());
            StatementStats.datanode_stats[9] = type.nameToId(dnStatsDesc[9].getName());
            StatementStats.datanode_stats[10] = type.nameToId(dnStatsDesc[10].getName());
            StatementStats.datanode_stats[1] = type.nameToId(dnStatsDesc[1].getName());
            StatementStats.datanode_stats[2] = type.nameToId(dnStatsDesc[2].getName());
            StatementStats.datanode_stats[3] = type.nameToId(dnStatsDesc[3].getName());
            StatementStats.datanode_stats[4] = type.nameToId(dnStatsDesc[4].getName());
            StatementStats.datanode_stats[11] = type.nameToId(dnStatsDesc[11].getName());
            StatementStats.datanode_stats[12] = type.nameToId(dnStatsDesc[12].getName());
            StatementStats.datanode_stats[13] = type.nameToId(dnStatsDesc[13].getName());
            StatementStats.datanode_stats[14] = type.nameToId(dnStatsDesc[14].getName());
            StatementStats.datanode_stats[15] = type.nameToId(dnStatsDesc[15].getName());
            StatementStats.datanode_stats[16] = type.nameToId(dnStatsDesc[16].getName());
            StatementStats.datanode_stats[17] = type.nameToId(dnStatsDesc[17].getName());
            StatementStats.datanode_stats[18] = type.nameToId(dnStatsDesc[18].getName());
            StatementStats.datanode_stats[19] = type.nameToId(dnStatsDesc[19].getName());
            StatementStats.datanode_stats[20] = type.nameToId(dnStatsDesc[20].getName());
            StatementStats.datanode_stats[21] = type.nameToId(dnStatsDesc[21].getName());
            StatementStats.datanode_stats[22] = type.nameToId(dnStatsDesc[22].getName());
            StatementStats.datanode_stats[23] = type.nameToId(dnStatsDesc[23].getName());
            StatementStats.datanode_stats[24] = type.nameToId(dnStatsDesc[24].getName());
            StatementStats.datanode_stats[25] = type.nameToId(dnStatsDesc[25].getName());
            StatementStats.datanode_stats[26] = type.nameToId(dnStatsDesc[26].getName());
            StatementStats.datanode_stats[27] = type.nameToId(dnStatsDesc[27].getName());
            StatementStats.datanode_stats[28] = type.nameToId(dnStatsDesc[28].getName());
            StatementStats.datanode_stats[29] = type.nameToId(dnStatsDesc[29].getName());
            StatementStats.datanode_stats[30] = type.nameToId(dnStatsDesc[30].getName());
            StatementStats.datanode_stats[31] = type.nameToId(dnStatsDesc[31].getName());
            StatementStats.datanode_stats[32] = type.nameToId(dnStatsDesc[32].getName());
            StatementStats.datanode_stats[33] = type.nameToId(dnStatsDesc[33].getName());
            StatementStats.datanode_stats[34] = type.nameToId(dnStatsDesc[34].getName());
            StatementStats.datanode_stats[35] = type.nameToId(dnStatsDesc[35].getName());
            StatementStats.datanode_stats[36] = type.nameToId(dnStatsDesc[36].getName());
            StatementStats.datanode_stats[37] = type.nameToId(dnStatsDesc[37].getName());
            StatementStats.datanode_stats[38] = type.nameToId(dnStatsDesc[38].getName());
        }
        catch (Exception e) {
            SanityManager.DEBUG_PRINT((String)"warning:ClassLoad", (String)("Got exception while loading class " + StatementStats.class.getName() + "  ex = " + e), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

