/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.bytecode;

import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.Type;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;

class d_BCValidate {
    private static final String[] csPackages = new String[]{"java", "com.pivotal.gemfirexd.internal.exe.", "com.pivotal.gemfirexd.internal.iapi.", "com.pivotal.gemfirexd.internal.jdbc.", "com.pivotal.gemfirexd.internal.iapi.", "com.pivotal.gemfirexd.internal.impl.", "com.pivotal.gemfirexd.internal.authentication.", "com.pivotal.gemfirexd.internal.catalog.", "com.pivotal.gemfirexd.internal.iapi.db.", "com.pivotal.gemfirexd.internal.iapi.types.", "com.pivotal.gemfirexd.internal.iapi.types.", "com.pivotal.gemfirexd.internal.catalog.types."};
    private static final Class[] NO_PARAMS = new Class[0];
    private static Hashtable primitives = new Hashtable();

    d_BCValidate() {
    }

    static void checkMethod(short opcode, Type dt, String methodName, String[] debugParameterTypes, Type rt) {
        String reason = null;
        try {
            String actualReturnType;
            int p;
            String declaringClass = dt.javaName();
            if (declaringClass.startsWith("com.pivotal.gemfirexd.internal.exe.")) {
                return;
            }
            for (p = 0; p < csPackages.length && !declaringClass.startsWith(csPackages[p]); ++p) {
            }
            if (p == csPackages.length) {
                return;
            }
            Class[] params = NO_PARAMS;
            Class declaring = d_BCValidate.loadClass(declaringClass);
            if (debugParameterTypes != null) {
                params = new Class[debugParameterTypes.length];
                for (int i = 0; i < debugParameterTypes.length; ++i) {
                    params[i] = d_BCValidate.loadClass(debugParameterTypes[i]);
                }
            }
            ClassLoader declareLoader = declaring.getClassLoader();
            ClassLoader myLoader = d_BCValidate.class.getClassLoader();
            boolean sameClassLoader = false;
            if (declareLoader == myLoader) {
                sameClassLoader = true;
            } else if (declareLoader != null) {
                sameClassLoader = declareLoader.equals(myLoader);
            }
            if (methodName.equals("<init>")) {
                Constructor c;
                if (sameClassLoader) {
                    c = declaring.getDeclaredConstructor(params);
                } else {
                    c = declaring.getConstructor(params);
                    if (!c.getDeclaringClass().equals(declaring)) {
                        reason = "constructor " + c.toString() + " declared on " + c.getDeclaringClass() + " expected " + declaring;
                    }
                }
                actualReturnType = "void";
            } else {
                Method m;
                if (sameClassLoader) {
                    m = declaring.getDeclaredMethod(methodName, params);
                } else {
                    m = declaring.getMethod(methodName, params);
                    if (!m.getDeclaringClass().equals(declaring)) {
                        reason = "method " + m.toString() + " declared on " + m.getDeclaringClass() + " expected " + declaring;
                    }
                }
                actualReturnType = m.getReturnType().getName();
            }
            if (reason == null) {
                Class requestedReturnType = d_BCValidate.loadClass(rt.javaName());
                if (actualReturnType.equals(requestedReturnType.getName())) {
                    if (opcode != 185) {
                        return;
                    }
                    if (declaring.isInterface()) {
                        return;
                    }
                    reason = "declaring class is not an interface";
                } else {
                    reason = "return type is " + actualReturnType;
                }
            }
        }
        catch (Exception e) {
            reason = e.toString();
            e.printStackTrace(System.out);
        }
        String sig = dt.javaName() + " >> " + rt.javaName() + " " + methodName + "(";
        if (debugParameterTypes != null) {
            for (int i = 0; i < debugParameterTypes.length; ++i) {
                if (i != 0) {
                    sig = sig + ", ";
                }
                sig = sig + debugParameterTypes[i];
            }
        }
        sig = sig + ")";
        String msg = "Invalid method " + sig + " because " + reason;
        System.out.println(msg);
        SanityManager.THROWASSERT((String)msg);
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        Class c = (Class)primitives.get(name);
        if (c != null) {
            return c;
        }
        if (name.endsWith("[]")) {
            Class baseClass = d_BCValidate.loadClass(name.substring(0, name.length() - 2));
            return Array.newInstance(baseClass, 0).getClass();
        }
        return Class.forName(name);
    }

    static {
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("void", Void.TYPE);
    }
}

