/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.pivotal.gemfirexd.internal.impl.drda.DDMReader;
import com.pivotal.gemfirexd.internal.impl.drda.DDMWriter;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAConnThread;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAProtocolException;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAXid;
import com.pivotal.gemfirexd.internal.impl.drda.XADatabase;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class DRDAXAProtocol {
    private DRDAConnThread connThread;
    private DDMReader reader;
    private DDMWriter writer;
    private Xid xid;

    DRDAXAProtocol(DRDAConnThread connThread) {
        this.connThread = connThread;
        this.reader = connThread.getReader();
        this.writer = connThread.getWriter();
        this.xid = null;
    }

    protected void parseSYNCCTL() throws DRDAProtocolException {
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint(4487);
        int syncType = this.parseSYNCTYPE();
        int xaflags = 0;
        boolean readXAFlags = false;
        Xid xid = null;
        long xaTimeout = -1L;
        boolean readXATimeout = false;
        codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 6145: {
                    xid = this.parseXID();
                    break;
                }
                case 6403: {
                    xaflags = this.parseXAFlags();
                    readXAFlags = true;
                    break;
                }
                case 6407: {
                    xaTimeout = this.parseXATimeout();
                    readXATimeout = true;
                    break;
                }
                case 4511: {
                    this.connThread.codePointNotSupported(codePoint);
                }
                default: {
                    this.connThread.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        this.connThread.trace("syncType = " + this.syncTypeToString(syncType));
        this.connThread.trace("xid = " + xid);
        this.connThread.trace("xaflags =" + this.xaflagsToString(xaflags));
        if (syncType != 12) {
            if (xid == null) {
                this.connThread.missingCodePoint(6145);
            }
            if (syncType != 6 && !readXAFlags) {
                this.connThread.missingCodePoint(6403);
            }
        }
        switch (syncType) {
            case 9: {
                this.startXATransaction(xid, xaflags, xaTimeout);
                break;
            }
            case 11: {
                this.endXA(xid, xaflags);
                break;
            }
            case 1: {
                this.prepareXATransaction(xid);
                break;
            }
            case 2: {
                this.connThread.codePointNotSupported(codePoint);
                break;
            }
            case 5: {
                this.commitTransaction(xid, xaflags);
                break;
            }
            case 3: {
                this.commitTransaction(xid, xaflags);
                break;
            }
            case 6: {
                this.forgetXATransaction(xid);
                break;
            }
            case 4: {
                this.rollbackTransaction(xid, true);
                break;
            }
            case 12: {
                if (readXAFlags) {
                    this.recoverXA(xaflags);
                    break;
                }
                this.recoverXA();
                break;
            }
            default: {
                this.connThread.invalidCodePoint(codePoint);
            }
        }
    }

    protected int parseSYNCTYPE() throws DRDAProtocolException {
        return this.reader.readUnsignedByte();
    }

    private Xid parseXID() throws DRDAProtocolException {
        int formatId = this.reader.readNetworkInt();
        byte[] gtrid = null;
        byte[] bqual = null;
        if (formatId != -1) {
            int gtridLen = this.reader.readNetworkInt();
            int bqualLen = this.reader.readNetworkInt();
            gtrid = this.reader.readBytes(gtridLen);
            bqual = this.reader.readBytes(bqualLen);
        }
        return new DRDAXid(formatId, gtrid, bqual);
    }

    private int parseXIDSHR() throws DRDAProtocolException {
        return this.reader.readUnsignedByte();
    }

    private int parseXAFlags() throws DRDAProtocolException {
        return this.reader.readNetworkInt();
    }

    private long parseXATimeout() throws DRDAProtocolException {
        return this.reader.readNetworkLong();
    }

    private void startXATransaction(Xid xid, int xaflags, long xaTimeout) throws DRDAProtocolException {
        XAResource xaResource = this.getXAResource();
        int xaRetVal = 0;
        try {
            if (xid.getFormatId() == -1 && xaTimeout != -1L) {
                throw new XAException(-6);
            }
            if (xaTimeout != -1L && xaflags != 0) {
                throw new XAException(-6);
            }
            if (xaTimeout == 0L) {
                xaResource.setTransactionTimeout(Integer.MAX_VALUE);
            } else if (xaTimeout == -1L) {
                xaResource.setTransactionTimeout(0);
            } else {
                xaResource.setTransactionTimeout((int)(xaTimeout / 1000L));
            }
            if (xid.getFormatId() != -1) {
                xaResource.start(xid, xaflags);
            }
            this.xid = xid;
        }
        catch (XAException xe) {
            xaRetVal = this.processXAException(xe);
        }
        this.writeSYNCCRD(9, xaRetVal, null);
    }

    private void commitTransaction(Xid xid, int xaflags) throws DRDAProtocolException {
        boolean local;
        boolean bl = local = xid.getFormatId() == -1;
        if (local) {
            this.commitLocalTransaction();
        } else {
            this.commitXATransaction(xid, xaflags);
        }
    }

    private void commitLocalTransaction() throws DRDAProtocolException {
        int xaRetVal = 0;
        try {
            this.connThread.getDatabase().commit();
        }
        catch (Exception e) {
            xaRetVal = -7;
            this.connThread.getServer().consoleExceptionPrint(e);
        }
        this.writeSYNCCRD(3, xaRetVal, null);
    }

    private void commitXATransaction(Xid xid, int xaflags) throws DRDAProtocolException {
        XAResource xaResource = this.getXAResource();
        int xaRetVal = 0;
        boolean isOnePhase = (xaflags & 0x40000000) != 0;
        try {
            xaResource.commit(xid, isOnePhase);
            this.connThread.trace("committed XA transaction: xaRetVal=" + xaRetVal);
        }
        catch (XAException xe) {
            xaRetVal = this.processXAException(xe);
        }
        this.writeSYNCCRD(3, xaRetVal, null);
    }

    private void rollbackTransaction(Xid xid, boolean sendSYNCCRD) throws DRDAProtocolException {
        boolean local;
        boolean bl = local = xid.getFormatId() == -1;
        if (local) {
            this.rollbackLocalTransaction(sendSYNCCRD);
        } else {
            this.rollbackXATransaction(xid, sendSYNCCRD);
        }
    }

    private void rollbackLocalTransaction(boolean sendSYNCCRD) throws DRDAProtocolException {
        int xaRetVal = 0;
        try {
            this.connThread.getDatabase().rollback();
        }
        catch (Exception e) {
            xaRetVal = -7;
            this.connThread.getServer().consoleExceptionPrint(e);
        }
        if (sendSYNCCRD) {
            this.writeSYNCCRD(3, xaRetVal, null);
        }
    }

    private void rollbackXATransaction(Xid xid, boolean sendSYNCCRD) throws DRDAProtocolException {
        XAResource xaResource = this.getXAResource();
        int xaRetVal = 0;
        try {
            xaResource.rollback(xid);
            this.connThread.trace("rollback  XA transaction: xaRetVal=" + xaRetVal);
        }
        catch (XAException xe) {
            xaRetVal = this.processXAException(xe);
        }
        if (sendSYNCCRD) {
            this.writeSYNCCRD(4, xaRetVal, null);
        }
    }

    private void endXA(Xid xid, int xaflags) throws DRDAProtocolException {
        XAResource xaResource = this.getXAResource();
        int xaRetVal = 0;
        try {
            xaResource.end(xid, xaflags);
            this.xid = null;
            this.connThread.trace("ended XA transaction. xid =  " + xid + " xaflags =" + xaflags + "xaRetVal=" + xaRetVal);
        }
        catch (XAException xe) {
            xaRetVal = this.processXAException(xe);
        }
        this.writeSYNCCRD(11, xaRetVal, null);
    }

    private void prepareXATransaction(Xid xid) throws DRDAProtocolException {
        XAResource xaResource = this.getXAResource();
        int xaRetVal = 0;
        try {
            xaRetVal = xaResource.prepare(xid);
            this.connThread.trace("prepared xa transaction: xaRetVal=" + xaRetVal);
        }
        catch (XAException xe) {
            xaRetVal = this.processXAException(xe);
        }
        this.writeSYNCCRD(1, xaRetVal, null);
    }

    private void forgetXATransaction(Xid xid) throws DRDAProtocolException {
        XAResource xaResource = this.getXAResource();
        int xaRetVal = 0;
        try {
            xaResource.forget(xid);
            this.connThread.trace("forgot xa transaction: xaRetVal=" + xaRetVal);
        }
        catch (XAException xe) {
            xaRetVal = this.processXAException(xe);
        }
        this.writeSYNCCRD(6, xaRetVal, null);
    }

    private void recoverXA() throws DRDAProtocolException {
        this.recoverXA(0x1000000);
    }

    private void recoverXA(int xaflags) throws DRDAProtocolException {
        XAResource xaResource = this.getXAResource();
        int xaRetVal = 0;
        Xid[] indoubtXids = null;
        try {
            indoubtXids = xaResource.recover(xaflags);
        }
        catch (XAException xe) {
            xaRetVal = this.processXAException(xe);
        }
        this.writeSYNCCRD(12, xaRetVal, indoubtXids);
    }

    private void writeSYNCCRD(int synctype, int xaRetVal, Xid[] xids) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(4680);
        this.writer.startDdm(6404);
        this.writer.writeInt(xaRetVal);
        this.writer.endDdm();
        if (xids != null) {
            this.writePRPHRCLST(xids);
        }
        this.writer.endDdmAndDss();
    }

    private void writePRPHRCLST(Xid[] xids) throws DRDAProtocolException {
        int xidcnt = xids == null ? 0 : xids.length;
        this.writer.startDdm(6405);
        this.writer.writeScalar2Bytes(6406, xidcnt);
        for (int i = 0; i < xidcnt; ++i) {
            this.writeXID(xids[i]);
        }
        this.writer.endDdm();
    }

    private void writeXID(Xid xid) throws DRDAProtocolException {
        this.writer.startDdm(6145);
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        this.writer.writeInt(formatId);
        this.writer.writeInt(gtrid.length);
        this.writer.writeInt(bqual.length);
        this.writer.writeBytes(gtrid);
        this.writer.writeBytes(bqual);
        this.writer.endDdm();
    }

    private XAResource getXAResource() {
        return ((XADatabase)this.connThread.getDatabase()).getXAResource();
    }

    private String syncTypeToString(int syncType) {
        switch (syncType) {
            case 9: {
                return "SYNCTYPE_NEW_UOW";
            }
            case 11: {
                return "SYNCTYPE_END_UOW";
            }
            case 1: {
                return "SYNCTYPE_PREPARE";
            }
            case 2: {
                return "SYNCTYPE_MIGRATE";
            }
            case 5: {
                return "SYNCTYPE_REQ_COMMIT";
            }
            case 3: {
                return "SYNCTYPE_COMMITTED";
            }
            case 6: {
                return "SYNCTYPE_FORGET";
            }
            case 4: {
                return "SYNCTYPE_ROLLBACK";
            }
            case 8: {
                return "SYNCTYPE_REQ_LOG";
            }
            case 10: {
                return "SYNCTYPE_MIGRATED";
            }
            case 12: {
                return "SYNCTYPE_INDOUBT";
            }
        }
        return "UNKNOWN SYNCTYPE";
    }

    private String xaflagsToString(int xaflags) {
        switch (xaflags) {
            case 0x800000: {
                return "XAResource.TMENDRSCAN";
            }
            case 0x20000000: {
                return "XAResource.TMFAIL";
            }
            case 0: {
                return "XAResource.TMNOFLAGS";
            }
            case 0x200000: {
                return "XAResource.TMJOIN";
            }
            case 0x40000000: {
                return "XAResource.TMONEPHASE";
            }
            case 0x8000000: {
                return "XAResource.TMRESUME";
            }
            case 0x1000000: {
                return "XAResource.TMSTARTRSCAN";
            }
            case 0x4000000: {
                return "XAResource.TMSUCCESS";
            }
            case 0x2000000: {
                return "XAResource.TMSUSPEND";
            }
        }
        return "UNRECOGNIZED flags:" + xaflags;
    }

    private int processXAException(XAException xe) {
        int xaRetVal = xe.errorCode;
        this.connThread.getServer().consoleExceptionPrint(xe);
        return xaRetVal;
    }

    void rollbackCurrentTransaction() {
        if (this.xid != null) {
            boolean local = this.xid.getFormatId() == -1;
            try {
                block6: {
                    try {
                        if (!local) {
                            XAResource xaResource = this.getXAResource();
                            xaResource.end(this.xid, 0x20000000);
                        }
                    }
                    catch (XAException e) {
                        if (e.errorCode >= 100 && e.errorCode <= 107) break block6;
                        this.connThread.getServer().consoleExceptionPrint(e);
                    }
                }
                this.rollbackTransaction(this.xid, false);
            }
            catch (DRDAProtocolException e) {
                this.connThread.getServer().consoleExceptionPrint(e);
            }
            this.xid = null;
        }
    }
}

