/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.util;

public class CheapDateFormatter {
    static final long SECONDS = 1000L;
    static final long MINUTES = 60000L;
    static final long HOURS = 3600000L;
    static final long DAYS = 86400000L;
    static final long NORMAL_YEAR = 31536000000L;
    static final long LEAP_YEAR = 31622400000L;
    static final long FOURYEARS = 126230400000L;
    static final long END_OF_FIRST_YEAR = 31536000000L;
    static final long END_OF_SECOND_YEAR = 63158400000L;
    static final long END_OF_THIRD_YEAR = 94694400000L;
    static final int[] DAYS_IN_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int FEBRUARY = 1;

    public static String formatDate(long time) {
        int daysInMonth;
        boolean leapYear = false;
        long year = time / 126230400000L * 4L;
        long leftover = time % 126230400000L;
        time -= year / 4L * 126230400000L;
        year += 1970L;
        if (leftover >= 31536000000L) {
            ++year;
            time -= 31536000000L;
        }
        if (leftover >= 63158400000L) {
            ++year;
            time -= 31536000000L;
        }
        if (leftover >= 94694400000L) {
            ++year;
            time -= 31622400000L;
        }
        if (year % 4L == 0L) {
            if (year % 100L == 0L && year % 400L == 0L) {
                leapYear = true;
            }
            leapYear = true;
        }
        long days = time / 86400000L + 1L;
        int month = 1;
        for (int i = 0; i < DAYS_IN_MONTH.length && days > (long)(daysInMonth = leapYear && i == 1 ? 29 : DAYS_IN_MONTH[i]); days -= (long)daysInMonth, ++i) {
            ++month;
        }
        long hours = (time %= 86400000L) / 3600000L;
        long minutes = (time %= 3600000L) / 60000L;
        long seconds = (time %= 60000L) / 1000L;
        return year + "-" + CheapDateFormatter.twoDigits(month) + "-" + CheapDateFormatter.twoDigits(days) + " " + CheapDateFormatter.twoDigits(hours) + ":" + CheapDateFormatter.twoDigits(minutes) + ":" + CheapDateFormatter.twoDigits(seconds) + "." + CheapDateFormatter.threeDigits(time %= 1000L) + " GMT";
    }

    private static String twoDigits(long val) {
        String retval = val < 10L ? "0" + val : Long.toString(val);
        return retval;
    }

    private static String threeDigits(long val) {
        String retval = val < 10L ? "00" + val : (val < 100L ? "0" + val : Long.toString(val));
        return retval;
    }
}

