/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RefDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public final class SQLRef
extends DataType
implements RefDataValue {
    protected RowLocation value;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLRef.class);

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.value) {
            sz += this.value.estimateMemoryUsage();
        }
        return sz;
    }

    @Override
    public String getString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue.isNull()) {
            this.setToNull();
        } else {
            this.value = (RowLocation)theValue.getObject();
        }
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public String getTypeName() {
        return "REF";
    }

    @Override
    public int getTypeFormatId() {
        return 82;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((this.value != null ? 1 : 0) != 0, (String)"writeExternal() is not supposed to be called for null values.");
        out.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = (RowLocation)in.readObject();
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException, ClassNotFoundException {
        this.value = (RowLocation)in.readObject();
    }

    @Override
    public void restoreToNull() {
        this.value = null;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        return this.value.compare(op, ((SQLRef)other).value, orderedNulls, unknownRV);
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        return this.value.compare(((SQLRef)other).value);
    }

    @Override
    public DataValueDescriptor getClone() {
        if (this.value == null) {
            return new SQLRef();
        }
        return new SQLRef((RowLocation)this.value.cloneObject());
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLRef();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) {
        SanityManager.THROWASSERT((String)"setValueFromResultSet() is not supposed to be called for SQLRef.");
    }

    @Override
    public void setInto(PreparedStatement ps, int position) {
        SanityManager.THROWASSERT((String)"setValueInto(PreparedStatement) is not supposed to be called for SQLRef.");
    }

    public SQLRef() {
    }

    public SQLRef(RowLocation rowLocation) {
        this.value = rowLocation;
    }

    @Override
    public void setValue(RowLocation rowLocation) {
        this.value = rowLocation;
    }

    public String toString() {
        if (this.value == null) {
            return "NULL";
        }
        return this.value.toString();
    }

    @Override
    public final int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.getClass());
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.getClass());
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation for " + this.toString());
    }
}

