/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.CollatorSQLLongvarchar;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import java.text.RuleBasedCollator;

public class SQLLongvarchar
extends SQLVarchar {
    @Override
    public String getTypeName() {
        return "LONG VARCHAR";
    }

    @Override
    public DataValueDescriptor getClone() {
        try {
            return new SQLLongvarchar(this.getString());
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("Unexpected exception", se);
        }
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLLongvarchar();
    }

    @Override
    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLLongvarchar s = new CollatorSQLLongvarchar(collatorForComparison);
        s.copyState(this);
        return s;
    }

    @Override
    public int getTypeFormatId() {
        return 235;
    }

    public SQLLongvarchar() {
    }

    public SQLLongvarchar(String val) {
        super(val);
    }

    @Override
    protected void normalize(DataTypeDescriptor desiredType, String sourceValue) throws StandardException {
        if (sourceValue.length() > desiredType.getMaximumWidth()) {
            throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)StringUtil.formatForPrint(sourceValue), (Object)String.valueOf(desiredType.getMaximumWidth()));
        }
        this.setValue(sourceValue);
    }

    @Override
    public StringDataValue concatenate(StringDataValue leftOperand, StringDataValue rightOperand, StringDataValue result) throws StandardException {
        super.concatenate(leftOperand, rightOperand, result);
        if (result.getString() != null && result.getString().length() > 32700) {
            throw StandardException.newException("54006", (Object)"CONCAT", (Object)String.valueOf(32700));
        }
        return result;
    }

    @Override
    public int typePrecedence() {
        return 12;
    }

    @Override
    public byte getTypeId() {
        return 89;
    }
}

