/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.classfile;

import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassFormatOutput;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassHolder;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ConstantPoolEntry;
import java.io.IOException;

public final class CONSTANT_Utf8_info
extends ConstantPoolEntry {
    private final String value;
    private int asString;
    private int asCode;

    CONSTANT_Utf8_info(String value) {
        super(1);
        this.value = value;
    }

    @Override
    Object getKey() {
        return this.value;
    }

    @Override
    int classFileSize() {
        return 3 + this.value.length();
    }

    public String toString() {
        return this.value;
    }

    int setAsCode() {
        if (ClassHolder.isExternalClassName(this.value)) {
            if (this.asString == 0) {
                this.asCode = this.getIndex();
            }
            return this.asCode;
        }
        return this.getIndex();
    }

    int setAsString() {
        if (ClassHolder.isExternalClassName(this.value)) {
            if (this.asCode == 0) {
                this.asString = this.getIndex();
            }
            return this.asString;
        }
        return this.getIndex();
    }

    void setAlternative(int index) {
        if (this.asCode == 0) {
            this.asCode = index;
        } else {
            this.asString = index;
        }
    }

    @Override
    void put(ClassFormatOutput out) throws IOException {
        super.put(out);
        if (this.getIndex() == this.asCode) {
            out.writeUTF(ClassHolder.convertToInternalClassName(this.value));
        } else {
            out.writeUTF(this.value);
        }
    }
}

