/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ui;

import com.pivotal.gemfirexd.internal.engine.ui.SnappyUtils;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.collections.buffer.CircularFifoBuffer;

public class MemberStatistics {
    static final int MAX_SAMPLE_SIZE = 180;
    private long lastUpdatedOn;
    private String id;
    private String name;
    private String host;
    private String userDir;
    private String logFile;
    private String processId;
    private String diskStoreName;
    private UUID diskStoreUUID;
    private long diskStoreDiskSpace;
    private boolean isLocator;
    private boolean isLead;
    private boolean isLeadActive;
    private boolean isDataServer;
    private int cores;
    private int cpuActive;
    private long clientsCount;
    private String status;
    private long jvmMaxMemory;
    private long jvmFreeMemory;
    private long jvmTotalMemory;
    private long jvmUsedMemory;
    private long heapStoragePoolUsed;
    private long heapStoragePoolSize;
    private long heapExecutionPoolUsed;
    private long heapExecutionPoolSize;
    private long heapMemoryUsed;
    private long heapMemorySize;
    private long offHeapStoragePoolUsed;
    private long offHeapStoragePoolSize;
    private long offHeapExecutionPoolUsed;
    private long offHeapExecutionPoolSize;
    private long offHeapMemoryUsed;
    private long offHeapMemorySize;
    private final CircularFifoBuffer timeLine = new CircularFifoBuffer(180);
    private final CircularFifoBuffer cpuUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer jvmUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer heapUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer heapStoragePoolUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer heapExecutionPoolUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer offHeapUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer offHeapStoragePoolUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer offHeapExecutionPoolUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer aggrMemoryUsageTrend = new CircularFifoBuffer(180);
    private final CircularFifoBuffer diskStoreDiskSpaceTrend = new CircularFifoBuffer(180);
    public static final int TREND_TIMELINE = 0;
    public static final int TREND_CPU_USAGE = 1;
    public static final int TREND_JVM_HEAP_USAGE = 2;
    public static final int TREND_HEAP_USAGE = 3;
    public static final int TREND_HEAP_STORAGE_USAGE = 4;
    public static final int TREND_HEAP_EXECUTION_USAGE = 5;
    public static final int TREND_OFFHEAP_USAGE = 6;
    public static final int TREND_OFFHEAP_STORAGE_USAGE = 7;
    public static final int TREND_OFFHEAP_EXECUTION_USAGE = 8;
    public static final int TREND_AGGR_MEMORY_USAGE = 9;
    public static final int TREND_DISKSTORE_DISKSPACE_USAGE = 10;

    public MemberStatistics(String id, String name, String diskStoreName, UUID diskStoreUUID) {
        this.id = id;
        this.name = name;
        this.diskStoreName = diskStoreName;
        this.diskStoreUUID = diskStoreUUID;
    }

    public MemberStatistics(HashMap memberStatsMap) {
        this.id = (String)memberStatsMap.get("id");
        this.name = (String)memberStatsMap.get("name");
        this.diskStoreName = (String)memberStatsMap.get("diskStoreName");
        this.diskStoreUUID = (UUID)memberStatsMap.get("diskStoreUUID");
        this.updateMemberStatistics(memberStatsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMemberStatistics(HashMap memberStatsMap) {
        int cpuActive;
        long lastUpdatedOn;
        String id = (String)memberStatsMap.get("id");
        UUID diskStoreUUID = (UUID)memberStatsMap.get("diskStoreUUID");
        if (this.getDiskStoreUUID() != null) {
            if (!this.getDiskStoreUUID().equals(diskStoreUUID)) {
                return;
            }
            this.id = (String)memberStatsMap.get("id");
            this.name = (String)memberStatsMap.get("name");
        } else if (this.getId() != null && !this.getId().equals(id)) {
            return;
        }
        this.lastUpdatedOn = lastUpdatedOn = ((Long)memberStatsMap.get("lastUpdatedOn")).longValue();
        CircularFifoBuffer circularFifoBuffer = this.timeLine;
        synchronized (circularFifoBuffer) {
            this.timeLine.add((Object)lastUpdatedOn);
        }
        this.host = (String)memberStatsMap.get("host");
        this.userDir = (String)memberStatsMap.get("userDir");
        this.logFile = (String)memberStatsMap.get("logFile");
        this.processId = (String)memberStatsMap.get("processId");
        this.isLocator = (Boolean)memberStatsMap.get("locator");
        this.isLead = (Boolean)memberStatsMap.get("lead");
        this.isLeadActive = (Boolean)memberStatsMap.get("activeLead");
        this.isDataServer = (Boolean)memberStatsMap.get("dataServer");
        this.clientsCount = (Long)memberStatsMap.get("clients");
        this.cores = (Integer)memberStatsMap.get("cores");
        this.cpuActive = cpuActive = ((Integer)memberStatsMap.get("cpuActive")).intValue();
        CircularFifoBuffer circularFifoBuffer2 = this.cpuUsageTrend;
        synchronized (circularFifoBuffer2) {
            this.cpuUsageTrend.add((Object)cpuActive);
        }
        long jvmTotalMemory = (Long)memberStatsMap.get("totalMemory");
        long jvmUsedMemory = (Long)memberStatsMap.get("usedMemory");
        this.jvmTotalMemory = jvmTotalMemory;
        this.jvmUsedMemory = jvmUsedMemory;
        this.jvmMaxMemory = (Long)memberStatsMap.get("maxMemory");
        this.jvmFreeMemory = (Long)memberStatsMap.get("freeMemory");
        CircularFifoBuffer circularFifoBuffer3 = this.jvmUsageTrend;
        synchronized (circularFifoBuffer3) {
            this.jvmUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(jvmUsedMemory, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        long heapStoragePoolUsed = (Long)memberStatsMap.get("heapStoragePoolUsed");
        long heapStoragePoolSize = (Long)memberStatsMap.get("heapStoragePoolSize");
        long heapExecutionPoolUsed = (Long)memberStatsMap.get("heapExecutionPoolUsed");
        long heapExecutionPoolSize = (Long)memberStatsMap.get("heapExecutionPoolSize");
        long heapMemoryUsed = (Long)memberStatsMap.get("heapMemoryUsed");
        long heapMemorySize = (Long)memberStatsMap.get("heapMemorySize");
        this.heapStoragePoolUsed = heapStoragePoolUsed;
        this.heapStoragePoolSize = heapStoragePoolSize;
        this.heapExecutionPoolUsed = heapExecutionPoolUsed;
        this.heapExecutionPoolSize = heapExecutionPoolSize;
        this.heapMemoryUsed = heapMemoryUsed;
        this.heapMemorySize = heapMemorySize;
        CircularFifoBuffer circularFifoBuffer4 = this.heapStoragePoolUsageTrend;
        synchronized (circularFifoBuffer4) {
            this.heapStoragePoolUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(heapStoragePoolUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer4 = this.heapExecutionPoolUsageTrend;
        synchronized (circularFifoBuffer4) {
            this.heapExecutionPoolUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(heapExecutionPoolUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer4 = this.heapUsageTrend;
        synchronized (circularFifoBuffer4) {
            this.heapUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(heapMemoryUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        long offHeapStoragePoolUsed = (Long)memberStatsMap.get("offHeapStoragePoolUsed");
        long offHeapStoragePoolSize = (Long)memberStatsMap.get("offHeapStoragePoolSize");
        long offHeapExecutionPoolUsed = (Long)memberStatsMap.get("offHeapExecutionPoolUsed");
        long offHeapExecutionPoolSize = (Long)memberStatsMap.get("offHeapExecutionPoolSize");
        long offHeapMemoryUsed = (Long)memberStatsMap.get("offHeapMemoryUsed");
        long offHeapMemorySize = (Long)memberStatsMap.get("offHeapMemorySize");
        this.offHeapStoragePoolUsed = offHeapStoragePoolUsed;
        this.offHeapStoragePoolSize = offHeapStoragePoolSize;
        this.offHeapExecutionPoolUsed = offHeapExecutionPoolUsed;
        this.offHeapExecutionPoolSize = offHeapExecutionPoolSize;
        this.offHeapMemoryUsed = offHeapMemoryUsed;
        this.offHeapMemorySize = offHeapMemorySize;
        CircularFifoBuffer circularFifoBuffer5 = this.offHeapStoragePoolUsageTrend;
        synchronized (circularFifoBuffer5) {
            this.offHeapStoragePoolUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(offHeapStoragePoolUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer5 = this.offHeapExecutionPoolUsageTrend;
        synchronized (circularFifoBuffer5) {
            this.offHeapExecutionPoolUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(offHeapExecutionPoolUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        circularFifoBuffer5 = this.offHeapUsageTrend;
        synchronized (circularFifoBuffer5) {
            this.offHeapUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(offHeapMemoryUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        long aggrMemoryUsed = heapMemoryUsed + offHeapMemoryUsed;
        CircularFifoBuffer circularFifoBuffer6 = this.aggrMemoryUsageTrend;
        synchronized (circularFifoBuffer6) {
            this.aggrMemoryUsageTrend.add((Object)SnappyUtils.bytesToGivenUnits(aggrMemoryUsed, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
        this.diskStoreDiskSpace = (Long)memberStatsMap.get("diskStoreDiskSpace");
        circularFifoBuffer6 = this.diskStoreDiskSpaceTrend;
        synchronized (circularFifoBuffer6) {
            this.diskStoreDiskSpaceTrend.add((Object)SnappyUtils.bytesToGivenUnits(this.diskStoreDiskSpace, SnappyUtils.STORAGE_SIZE_UNIT_GB));
        }
    }

    public long getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public void setLastUpdatedOn(long lastUpdatedOn) {
        this.lastUpdatedOn = lastUpdatedOn;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUserDir() {
        return this.userDir;
    }

    public void setUserDir(String userDir) {
        this.userDir = userDir;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    public UUID getDiskStoreUUID() {
        return this.diskStoreUUID;
    }

    public void setDiskStoreUUID(UUID diskStoreUUID) {
        this.diskStoreUUID = diskStoreUUID;
    }

    public long getDiskStoreDiskSpace() {
        return this.diskStoreDiskSpace;
    }

    public void setDiskStoreDiskSpace(long diskStoreDiskSpace) {
        this.diskStoreDiskSpace = diskStoreDiskSpace;
    }

    public boolean isLocator() {
        return this.isLocator;
    }

    public void setLocator(boolean locator) {
        this.isLocator = locator;
    }

    public boolean isLead() {
        return this.isLead;
    }

    public void setLead(boolean lead) {
        this.isLead = lead;
    }

    public boolean isLeadActive() {
        return this.isLeadActive;
    }

    public void setLeadActive(boolean leadActive) {
        this.isLeadActive = leadActive;
    }

    public boolean isDataServer() {
        return this.isDataServer;
    }

    public void setDataServer(boolean dataServer) {
        this.isDataServer = dataServer;
    }

    public int getCores() {
        return this.cores;
    }

    public int getCpuActive() {
        return this.cpuActive;
    }

    public void setCpuActive(int cpuActive) {
        this.cpuActive = cpuActive;
    }

    public long getClientsCount() {
        return this.clientsCount;
    }

    public void setClientsCount(long clientsCount) {
        this.clientsCount = clientsCount;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public long getJvmMaxMemory() {
        return this.jvmMaxMemory;
    }

    public void setJvmMaxMemory(long jvmMaxMemory) {
        this.jvmMaxMemory = jvmMaxMemory;
    }

    public long getJvmFreeMemory() {
        return this.jvmFreeMemory;
    }

    public void setJvmFreeMemory(long jvmFreeMemory) {
        this.jvmFreeMemory = jvmFreeMemory;
    }

    public long getJvmTotalMemory() {
        return this.jvmTotalMemory;
    }

    public void setJvmTotalMemory(long jvmTotalMemory) {
        this.jvmTotalMemory = jvmTotalMemory;
    }

    public long getJvmUsedMemory() {
        return this.jvmUsedMemory;
    }

    public void setJvmUsedMemory(long jvmUsedMemory) {
        this.jvmUsedMemory = jvmUsedMemory;
    }

    public long getHeapStoragePoolUsed() {
        return this.heapStoragePoolUsed;
    }

    public void setHeapStoragePoolUsed(long heapStoragePoolUsed) {
        this.heapStoragePoolUsed = heapStoragePoolUsed;
    }

    public long getHeapStoragePoolSize() {
        return this.heapStoragePoolSize;
    }

    public void setHeapStoragePoolSize(long heapStoragePoolSize) {
        this.heapStoragePoolSize = heapStoragePoolSize;
    }

    public long getHeapExecutionPoolUsed() {
        return this.heapExecutionPoolUsed;
    }

    public void setHeapExecutionPoolUsed(long heapExecutionPoolUsed) {
        this.heapExecutionPoolUsed = heapExecutionPoolUsed;
    }

    public long getHeapExecutionPoolSize() {
        return this.heapExecutionPoolSize;
    }

    public void setHeapExecutionPoolSize(long heapExecutionPoolSize) {
        this.heapExecutionPoolSize = heapExecutionPoolSize;
    }

    public long getHeapMemoryUsed() {
        return this.heapMemoryUsed;
    }

    public void setHeapMemoryUsed(long heapMemoryUsed) {
        this.heapMemoryUsed = heapMemoryUsed;
    }

    public long getHeapMemorySize() {
        return this.heapMemorySize;
    }

    public void setHeapMemorySize(long heapMemorySize) {
        this.heapMemorySize = heapMemorySize;
    }

    public long getOffHeapStoragePoolUsed() {
        return this.offHeapStoragePoolUsed;
    }

    public void setOffHeapStoragePoolUsed(long offHeapStoragePoolUsed) {
        this.offHeapStoragePoolUsed = offHeapStoragePoolUsed;
    }

    public long getOffHeapStoragePoolSize() {
        return this.offHeapStoragePoolSize;
    }

    public void setOffHeapStoragePoolSize(long offHeapStoragePoolSize) {
        this.offHeapStoragePoolSize = offHeapStoragePoolSize;
    }

    public long getOffHeapExecutionPoolUsed() {
        return this.offHeapExecutionPoolUsed;
    }

    public void setOffHeapExecutionPoolUsed(long offHeapExecutionPoolUsed) {
        this.offHeapExecutionPoolUsed = offHeapExecutionPoolUsed;
    }

    public long getOffHeapExecutionPoolSize() {
        return this.offHeapExecutionPoolSize;
    }

    public void setOffHeapExecutionPoolSize(long offHeapExecutionPoolSize) {
        this.offHeapExecutionPoolSize = offHeapExecutionPoolSize;
    }

    public long getOffHeapMemoryUsed() {
        return this.offHeapMemoryUsed;
    }

    public void setOffHeapMemoryUsed(long offHeapMemoryUsed) {
        this.offHeapMemoryUsed = offHeapMemoryUsed;
    }

    public long getOffHeapMemorySize() {
        return this.offHeapMemorySize;
    }

    public void setOffHeapMemorySize(long offHeapMemorySize) {
        this.offHeapMemorySize = offHeapMemorySize;
    }

    public Object[] getUsageTrends(int trendType) {
        Object[] returnArray = null;
        switch (trendType) {
            case 0: {
                returnArray = this.timeLine.toArray();
                break;
            }
            case 1: {
                returnArray = this.cpuUsageTrend.toArray();
                break;
            }
            case 2: {
                returnArray = this.jvmUsageTrend.toArray();
                break;
            }
            case 3: {
                returnArray = this.heapUsageTrend.toArray();
                break;
            }
            case 4: {
                returnArray = this.heapStoragePoolUsageTrend.toArray();
                break;
            }
            case 5: {
                returnArray = this.heapExecutionPoolUsageTrend.toArray();
                break;
            }
            case 6: {
                returnArray = this.offHeapUsageTrend.toArray();
                break;
            }
            case 7: {
                returnArray = this.offHeapStoragePoolUsageTrend.toArray();
                break;
            }
            case 8: {
                returnArray = this.offHeapExecutionPoolUsageTrend.toArray();
                break;
            }
            case 9: {
                returnArray = this.aggrMemoryUsageTrend.toArray();
                break;
            }
            case 10: {
                returnArray = this.diskStoreDiskSpaceTrend.toArray();
            }
        }
        return returnArray;
    }
}

