/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store.offheap;

import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.pivotal.gemfirexd.internal.engine.store.offheap.CollectionBasedOHAddressCache;
import java.util.ArrayList;
import java.util.List;

public final class OffHeapOHAddressCache
implements CollectionBasedOHAddressCache {
    private long head = 0L;
    private static final long NULL = 0L;
    private static final long REMOVED = 1L;
    private static final int ADD_COUNT_OFFSET = 8;
    private static final int REMOVE_COUNT_OFFSET = 12;
    private static final int DOWN_OFFSET = 16;
    private static final int UP_OFFSET = 24;
    private static final int REFS_OFFSET = 32;
    private static final int BLOCK_SIZE = 4088;
    private static final int REFS_LENGTH = 507;

    private static long allocateBlock(long oldHead) {
        SimpleMemoryAllocatorImpl.Chunk chunk = (SimpleMemoryAllocatorImpl.Chunk)SimpleMemoryAllocatorImpl.getAllocator().allocate(4088, null);
        long result = chunk.getMemoryAddress();
        OffHeapOHAddressCache.setAddCount(result, 0);
        OffHeapOHAddressCache.setRemoveCount(result, 0);
        OffHeapOHAddressCache.setDown(result, oldHead);
        OffHeapOHAddressCache.setUp(result, 0L);
        if (oldHead != 0L) {
            OffHeapOHAddressCache.setUp(oldHead, result);
        }
        return result;
    }

    private static void setRefs(long addr, int idx, long v) {
        UnsafeMemoryChunk.writeAbsoluteLong((long)(addr + 32L + (long)idx * 8L), (long)v);
    }

    private static void setUp(long addr, long v) {
        UnsafeMemoryChunk.writeAbsoluteLong((long)(addr + 24L), (long)v);
    }

    private static void setDown(long addr, long v) {
        UnsafeMemoryChunk.writeAbsoluteLong((long)(addr + 16L), (long)v);
    }

    private static void setRemoveCount(long addr, int v) {
        UnsafeMemoryChunk.writeAbsoluteInt((long)(addr + 12L), (int)v);
    }

    private static void setAddCount(long addr, int v) {
        UnsafeMemoryChunk.writeAbsoluteInt((long)(addr + 8L), (int)v);
    }

    private static long getRefs(long addr, int idx) {
        return UnsafeMemoryChunk.readAbsoluteLong((long)(addr + 32L + (long)idx * 8L));
    }

    private static long getUp(long addr) {
        return UnsafeMemoryChunk.readAbsoluteLong((long)(addr + 24L));
    }

    private static long getDown(long addr) {
        return UnsafeMemoryChunk.readAbsoluteLong((long)(addr + 16L));
    }

    private static int getRemoveCount(long addr) {
        return UnsafeMemoryChunk.readAbsoluteInt((long)(addr + 12L));
    }

    private static int getAddCount(long addr) {
        return UnsafeMemoryChunk.readAbsoluteInt((long)(addr + 8L));
    }

    public void release() {
        long e = this.head;
        while (e != 0L) {
            OffHeapOHAddressCache.releaseBlock(e);
            long releaseAddr = e;
            e = OffHeapOHAddressCache.getDown(e);
            SimpleMemoryAllocatorImpl.Chunk.release((long)releaseAddr, (boolean)true);
        }
        this.head = 0L;
    }

    private static void releaseBlock(long addr) {
        int addCount = OffHeapOHAddressCache.getAddCount(addr);
        for (int i = 0; i < addCount; ++i) {
            long ref = OffHeapOHAddressCache.getRefs(addr, i);
            if (ref == 0L || ref == 1L) continue;
            SimpleMemoryAllocatorImpl.Chunk.release((long)ref, (boolean)true);
        }
    }

    @Override
    public void put(long addr) {
        if (OffHeapOHAddressCache.isBlockFull(this.head)) {
            this.head = OffHeapOHAddressCache.allocateBlock(this.head);
        }
        this.addRefToBlock(this.head, addr);
    }

    private void addRefToBlock(long addr, long refAddr) {
        int addCount = OffHeapOHAddressCache.getAddCount(addr);
        OffHeapOHAddressCache.setRefs(addr, addCount, refAddr);
        OffHeapOHAddressCache.setAddCount(addr, addCount + 1);
    }

    @Override
    public void releaseByteSource(int idx) {
        long e = OffHeapOHAddressCache.removeRefFromBlock(this.head, idx);
        if (OffHeapOHAddressCache.isBlockEmpty(e)) {
            if (e == this.head) {
                long eDown = OffHeapOHAddressCache.getDown(e);
                if (eDown != 0L) {
                    this.head = eDown;
                    OffHeapOHAddressCache.setUp(eDown, 0L);
                } else {
                    this.head = 0L;
                }
                SimpleMemoryAllocatorImpl.Chunk.release((long)e, (boolean)true);
            } else {
                long eDown = OffHeapOHAddressCache.getDown(e);
                long eUp = OffHeapOHAddressCache.getUp(e);
                if (eDown != 0L) {
                    OffHeapOHAddressCache.setUp(eDown, eUp);
                }
                OffHeapOHAddressCache.setDown(eUp, eDown);
                SimpleMemoryAllocatorImpl.Chunk.release((long)e, (boolean)true);
            }
        }
    }

    private static long removeRefFromBlock(long e, int idx) {
        int eAddCount;
        if (e == 0L) {
            throw new IndexOutOfBoundsException("list was empty");
        }
        if (idx == 0) {
            while (OffHeapOHAddressCache.isBlockEmpty(e)) {
                long eDown = OffHeapOHAddressCache.getDown(e);
                if (eDown != 0L) {
                    e = eDown;
                    continue;
                }
                throw new IndexOutOfBoundsException("list was empty");
            }
            eAddCount = OffHeapOHAddressCache.getAddCount(e) - 1;
            OffHeapOHAddressCache.setAddCount(e, eAddCount);
            long ref = OffHeapOHAddressCache.getRefs(e, eAddCount);
            if (ref != 0L) {
                SimpleMemoryAllocatorImpl.Chunk.release((long)ref, (boolean)true);
            }
        } else {
            boolean onLastTarget = false;
            int targetIdx = OffHeapOHAddressCache.getAddCount(e);
            int liveCount = targetIdx - OffHeapOHAddressCache.getRemoveCount(e);
            if (liveCount <= idx) {
                if ((idx -= liveCount) == 0) {
                    onLastTarget = true;
                }
                targetIdx = 0;
            }
            boolean doNext = false;
            do {
                --targetIdx;
                while (targetIdx < 0) {
                    long eDown = OffHeapOHAddressCache.getDown(e);
                    if (eDown != 0L) {
                        e = eDown;
                        targetIdx = OffHeapOHAddressCache.getAddCount(e);
                        liveCount = targetIdx - OffHeapOHAddressCache.getRemoveCount(e);
                        if (liveCount <= idx) {
                            if ((idx -= liveCount) == 0) {
                                onLastTarget = true;
                            }
                            targetIdx = 0;
                        }
                        --targetIdx;
                        continue;
                    }
                    throw new IndexOutOfBoundsException("removeRef idx did not exist");
                }
                if (OffHeapOHAddressCache.getRefs(e, targetIdx) != 1L) {
                    if (onLastTarget) {
                        doNext = false;
                        continue;
                    }
                    doNext = true;
                    if (--idx != 0) continue;
                    onLastTarget = true;
                    continue;
                }
                doNext = true;
            } while (doNext);
            long ref = OffHeapOHAddressCache.getRefs(e, targetIdx);
            if (ref != 0L) {
                SimpleMemoryAllocatorImpl.Chunk.release((long)ref, (boolean)true);
            }
            OffHeapOHAddressCache.setRefs(e, targetIdx, 1L);
            OffHeapOHAddressCache.setRemoveCount(e, OffHeapOHAddressCache.getRemoveCount(e) + 1);
        }
        eAddCount = OffHeapOHAddressCache.getAddCount(e);
        while (eAddCount > 0 && OffHeapOHAddressCache.getRefs(e, eAddCount - 1) == 1L) {
            OffHeapOHAddressCache.setRemoveCount(e, OffHeapOHAddressCache.getRemoveCount(e) - 1);
            OffHeapOHAddressCache.setAddCount(e, --eAddCount);
        }
        return e;
    }

    private static boolean isBlockEmpty(long addr) {
        return OffHeapOHAddressCache.getAddCount(addr) - OffHeapOHAddressCache.getRemoveCount(addr) <= 0;
    }

    private static boolean isBlockFull(long addr) {
        return addr == 0L || OffHeapOHAddressCache.getAddCount(addr) >= 507;
    }

    private static int sizeBlock(long addr) {
        return OffHeapOHAddressCache.getAddCount(addr) - OffHeapOHAddressCache.getRemoveCount(addr);
    }

    private static void copyBlockToList(long addr, ArrayList<Long> list) {
        for (int i = OffHeapOHAddressCache.getAddCount(addr) - 1; i >= 0; --i) {
            long ref = OffHeapOHAddressCache.getRefs(addr, i);
            if (ref == 0L) {
                list.add(null);
                continue;
            }
            if (ref == 1L) continue;
            list.add(ref);
        }
    }

    @Override
    public int testHook_getSize() {
        int result = 0;
        long e = this.head;
        while (e != 0L) {
            result += OffHeapOHAddressCache.sizeBlock(e);
            e = OffHeapOHAddressCache.getDown(e);
        }
        return result;
    }

    @Override
    public List<Long> testHook_copyToList() {
        ArrayList<Long> result = new ArrayList<Long>(this.testHook_getSize());
        long e = this.head;
        while (e != 0L) {
            OffHeapOHAddressCache.copyBlockToList(e, result);
            e = OffHeapOHAddressCache.getDown(e);
        }
        return result;
    }
}

