/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store.offheap;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.ListOfDeltas;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.delta.Delta;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import java.io.DataInput;
import java.io.IOException;

public final class OffHeapDeltas
extends OffHeapByteSource {
    public static final SimpleMemoryAllocatorImpl.ChunkType TYPE = new SimpleMemoryAllocatorImpl.ChunkType(){

        public int getSrcType() {
            return 0x18000000;
        }

        public SimpleMemoryAllocatorImpl.Chunk newChunk(long memoryAddress) {
            return new OffHeapDeltas(memoryAddress);
        }

        public SimpleMemoryAllocatorImpl.Chunk newChunk(long memoryAddress, int chunkSize) {
            return new OffHeapDeltas(memoryAddress, chunkSize);
        }
    };

    private OffHeapDeltas(long address, int chunkSize) {
        super(address, chunkSize, TYPE);
    }

    private OffHeapDeltas(long address) {
        super(address);
    }

    @Override
    public Object getDeserializedValue(Region r, RegionEntry re) {
        int numDeltas = this.readNumDeltas();
        ListOfDeltas lod = new ListOfDeltas(numDeltas);
        DataInput wrapper = this.getDataInputStreamWrapper(0, this.getLength());
        for (int i = 0; i < numDeltas; ++i) {
            GemFireContainer.SerializableDelta sd = new GemFireContainer.SerializableDelta();
            try {
                InternalDataSerializer.invokeFromData((DataSerializableFixedID)sd, (DataInput)wrapper);
            }
            catch (IOException e) {
                throw new GemFireXDRuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new GemFireXDRuntimeException(e);
            }
            lod.merge(null, (Delta)sd);
        }
        return lod;
    }

    public int getSizeInBytes() {
        return 0;
    }

    private int readNumDeltas() {
        if (OffHeapRegionEntryHelper.NATIVE_BYTE_ORDER_IS_LITTLE_ENDIAN) {
            return Integer.reverseBytes(UnsafeMemoryChunk.readAbsoluteInt((long)this.getBaseDataAddress()));
        }
        return UnsafeMemoryChunk.readAbsoluteInt((long)this.getBaseDataAddress());
    }

    @Override
    public int readNumLobsColumns(boolean throwExceptionOnWrongSource) {
        if (throwExceptionOnWrongSource) {
            throw new UnsupportedOperationException("readNumLobsColumns not suppoted on DELTAS");
        }
        return 0;
    }

    @Override
    public final long getUnsafeAddress(int offset, int size) {
        return super.getUnsafeBaseAddress(offset + 4, size);
    }

    @Override
    public final long getUnsafeAddress() {
        return super.getUnsafeAddress() + 4L;
    }

    @Override
    public final int getLength() {
        return super.getLength() - 4;
    }

    @Override
    public final int getOffsetAdjustment() {
        return 4;
    }
}

