/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ConstantValueSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ConstantValueSetImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameter;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicNoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class GfxdSubqueryResultSet
extends NoPutResultSetImpl {
    private ResultSet source;
    private final boolean whereClauseBased;
    final List<Integer> params;
    private final GenericPreparedStatement ps;
    private final boolean isGFEActvn;
    private List<DataValueDescriptor> cachedRows;
    private boolean cacheComplete;
    private Iterator<DataValueDescriptor> pointer;
    private boolean openedOnce;
    private Activation childActivation;
    private ValueRow templateRow;
    private final SelectQueryInfo sqi;
    private boolean keepSubqueryRSOpen = false;

    public GfxdSubqueryResultSet(boolean whereClauseBased, String subqueryText, Activation parentActivation, SelectQueryInfo sqi, List<Integer> params, GenericPreparedStatement ps, int rsNum, boolean isGFEActvn) {
        super(parentActivation, rsNum, 0.0, 0.0);
        this.whereClauseBased = whereClauseBased;
        this.params = params;
        this.ps = ps;
        this.isGFEActvn = isGFEActvn;
        this.sqi = sqi;
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecRow getNextRowCore() throws StandardException {
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.onGetNextRowCoreOfGfxdSubQueryResultSet(this);
        }
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.cacheComplete) {
            if (this.pointer.hasNext()) {
                ValueRow row;
                DataValueDescriptor dvd = this.pointer.next();
                if (dvd != null) {
                    row = this.templateRow;
                    row.setColumn(1, dvd);
                    this.getActivation().setCurrentRow(row, this.resultSetNumber);
                    ++this.rowsSeen;
                } else {
                    row = null;
                }
                if (this.statisticsTimingOn) {
                    this.nextTime += this.getElapsedNanos(this.beginTime);
                }
                return row;
            }
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
            return null;
        }
        if (this.pointer != null && this.pointer.hasNext()) {
            ValueRow row;
            DataValueDescriptor dvd = this.pointer.next();
            if (dvd != null) {
                row = this.templateRow;
                row.setColumn(1, dvd);
                this.getActivation().setCurrentRow(row, this.resultSetNumber);
                ++this.rowsSeen;
            } else {
                row = null;
            }
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
            return row;
        }
        if (this.pointer != null) {
            this.pointer = null;
        }
        if (this.whereClauseBased) {
            ExecRow row = this.source.getNextRow();
            if (row != null) {
                DataValueDescriptor dvd = row.getColumn(1).getClone();
                row = this.templateRow;
                row.setColumn(1, dvd);
                this.getActivation().setCurrentRow(row, this.resultSetNumber);
                this.cachedRows.add(dvd);
            } else {
                this.cacheComplete = true;
                try {
                    this.keepSubqueryRSOpen = true;
                    this.source.close(false);
                }
                catch (Exception ignore) {
                    LogWriter logger = Misc.getCacheLogWriterNoThrow();
                    logger.warning("Exception in closing subquery resultset", (Throwable)ignore);
                }
                finally {
                    this.keepSubqueryRSOpen = false;
                }
            }
            if (row != null) {
                ++this.rowsSeen;
            }
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
            return row;
        }
        throw new AssertionError((Object)"Supporting only where clause based subquery, should not reach here");
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.isOpen = true;
        this.pointer = this.cachedRows.iterator();
        this.templateRow = new ValueRow(1);
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void openCore() throws StandardException {
        try {
            GemFireXDQueryObserver observer;
            this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
            this.isOpen = true;
            this.templateRow = new ValueRow(1);
            if (this.openedOnce) {
                this.pointer = this.cachedRows.iterator();
                ++this.numOpens;
                if (this.statisticsTimingOn) {
                    this.openTime += this.getElapsedNanos(this.beginTime);
                }
                return;
            }
            this.cachedRows = new ArrayList<DataValueDescriptor>();
            this.pointer = this.cachedRows.iterator();
            if (GemFireXDUtils.TraceActivation) {
                SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)"GfxdSubQueryResultset::openCore");
            }
            LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
            this.childActivation = this.ps.getActivation(lcc, false, this.ps.getSource(), true);
            if (GemFireXDUtils.TraceActivation) {
                SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)("GfxdSubQueryResultset::Using activation ==" + this.childActivation));
            }
            this.childActivation.setTimeOutMillis(this.activation.getTimeOutMillis());
            this.childActivation.setMaxRows(0);
            this.childActivation.setIsPrepStmntQuery(this.sqi.isPreparedStatementQuery());
            if (GemFireXDUtils.TraceActivation) {
                SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)("GfxdSubQueryResultset::is sub query prepared statement ==" + this.sqi.isPreparedStatementQuery()));
            }
            this.childActivation.setConnectionID(-2L);
            this.childActivation.setStatementID(lcc.getStatementId());
            this.childActivation.setExecutionID(this.getActivation().getExecutionID());
            this.ps.setFlags(true, true);
            if (this.sqi.getParameterCount() > 0) {
                if (this.childActivation.getParameterValueSet() != null && this.childActivation.getParameterValueSet() != this.getActivation().getParameterValueSet()) {
                    throw new AssertionError((Object)"GfxdSubqueryResultSet: Parameter Value Set should have been null for subquery");
                }
                ParameterValueSet subPvs = this.createSubqueryPVSWrapper();
                this.childActivation.setParameters(subPvs, null);
            }
            if (GemFireXDUtils.TraceActivation) {
                SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)("GfxdSubQueryResultset::Using activation ==" + this.childActivation + " for fetching results"));
            }
            this.source = this.ps.execute(this.childActivation, true, this.childActivation.getTimeOutMillis(), true, true);
            if (GemFireXDUtils.TraceActivation) {
                SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)"GfxdSubQueryResultset::openCore:fetched subquery results");
            }
            if ((observer = GemFireXDQueryObserverHolder.getInstance()) != null) {
                observer.independentSubqueryResultsetFetched(this.activation, this.source);
            }
            this.openedOnce = true;
            ++this.numOpens;
            if (this.statisticsTimingOn) {
                this.openTime += this.getElapsedNanos(this.beginTime);
            }
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("XCL55.S")) {
                throw StandardException.newException("XCL32.S");
            }
            throw se;
        }
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (GemFireXDUtils.TraceActivation) {
            SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)("GfxdSubQueryResultset totalTime = " + time));
        }
        if (type == 0) {
            return time - this.source.getTimeSpent(1, 0);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen && !this.keepSubqueryRSOpen) {
            if (this.source != null) {
                if (this.source instanceof BasicNoPutResultSetImpl) {
                    ((BasicNoPutResultSetImpl)this.source).subqueryTrackingArray = null;
                }
                this.childActivation.close();
                this.source.close(cleanupOnError);
                this.cachedRows = null;
                this.pointer = null;
                this.templateRow = null;
                this.cacheComplete = false;
                this.openedOnce = false;
            }
            this.localTXState = null;
            this.localTXStateSet = false;
        }
        this.isOpen = false;
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(1);
        visitor.visit(this);
        this.source.accept(visitor);
    }

    @Override
    public void resetStatistics() {
        super.resetStatistics();
        this.source.resetStatistics();
    }

    public long estimateMemoryUsage() throws StandardException {
        long memory = 0L;
        if (this.cachedRows != null) {
            for (DataValueDescriptor dvd : this.cachedRows) {
                memory += (long)dvd.estimateMemoryUsage();
            }
        }
        if (!this.cacheComplete) {
            memory += this.lcc.getLanguageConnectionFactory().getExecutionFactory().getResultSetStatisticsFactory().getResultSetMemoryUsage(this.source);
        }
        return memory;
    }

    private ParameterValueSet createSubqueryPVSWrapper() {
        if (this.sqi.isPreparedStatementQuery()) {
            return new GenricSubqueryPVSWrapper(this.activation.getParameterValueSet());
        }
        return new ConstantValueSubqueryPVSWrapper((ConstantValueSet)this.activation.getParameterValueSet());
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "SUBQUERY");
        if (this.source != null && this.source instanceof NoPutResultSet) {
            ((NoPutResultSet)this.source).buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null && this.source instanceof NoPutResultSetImpl ? ((NoPutResultSetImpl)this.source).resultSetNumber() : -1)));
        }
    }

    private class ConstantValueSubqueryPVSWrapper
    extends SubqueryParameterValueSetWrapper
    implements ConstantValueSet {
        private final DataTypeDescriptor[] paramTypes;
        private final int[] tokenKind;
        private String[] tokenImages;

        ConstantValueSubqueryPVSWrapper(ConstantValueSet cvs) {
            super(cvs);
            ConstantValueSetImpl cvsi = (ConstantValueSetImpl)cvs;
            if (GfxdSubqueryResultSet.this.isGFEActvn) {
                int size = GfxdSubqueryResultSet.this.params.size();
                int[] actualTokKind = cvsi.getTokenKinds();
                String[] actualTokImages = cvsi.getTokenImages();
                this.paramTypes = new DataTypeDescriptor[size];
                this.tokenKind = new int[size];
                this.tokenImages = new String[size];
                int k = 0;
                for (Integer actualIndex : GfxdSubqueryResultSet.this.params) {
                    this.tokenKind[k] = actualTokKind[actualIndex];
                    this.tokenImages[k] = actualTokImages[actualIndex];
                    ++k;
                }
            } else {
                this.paramTypes = cvsi.getParamTypes();
                this.tokenImages = cvsi.getTokenImages();
                this.tokenKind = cvsi.getTokenKinds();
            }
        }

        @Override
        public int allAreSet() {
            return 0;
        }

        @Override
        public boolean checkNoDeclaredOutputParameters() {
            return false;
        }

        @Override
        public void clearParameters() {
            throw new IllegalStateException("Soubhik: This should not have got invoked as batch operation is not possible for statements ");
        }

        @Override
        public void transferDataValues(ParameterValueSet pvstarget) throws StandardException {
            ConstantValueSetImpl cpvsi = (ConstantValueSetImpl)this.allPvs;
            cpvsi.setTransferData(this.paramTypes, this.tokenKind, this.tokenImages);
        }

        @Override
        public String[] getTokenImages() {
            return this.tokenImages;
        }

        @Override
        public int[] getTokenKinds() {
            return this.tokenKind;
        }

        @Override
        public DataTypeDescriptor[] getParamTypes() {
            return this.paramTypes;
        }

        @Override
        public List<TypeCompiler> getOrigTypeCompilers() {
            return null;
        }

        @Override
        public void setActivation(Activation ownedActivation) {
        }

        @Override
        public void refreshTypes(DataTypeDescriptor[] dtds) {
        }

        @Override
        public void validate() {
            if (this.tokenImages == null || this.tokenImages.length <= 0) {
                SanityManager.THROWASSERT((String)"ConstantValueSubqueryPVSWrapper: Token images are supposed to be existent");
            }
            if (this.tokenKind == null || this.tokenKind.length <= 0) {
                SanityManager.THROWASSERT((String)"ConstantValueSet: Token kind should be non-null");
            }
            if (GemFireXDUtils.TraceStatementMatching) {
                StringBuilder sb = new StringBuilder("ConstantValueSubqueryPVSWrapper: Validating tokens : [");
                for (int i = 0; i < this.tokenImages.length; ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(this.tokenImages[i]).append(" (").append(ConstantValueSetImpl.tokenKindAsString(this.tokenKind[i])).append(")");
                }
                sb.append("]");
                SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)sb.toString());
                sb.append("]");
                SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)sb.toString());
            }
        }

        @Override
        public String getConstantImage(int position) {
            ConstantValueSet cvs = (ConstantValueSet)this.allPvs;
            return cvs.getConstantImage(GfxdSubqueryResultSet.this.params.get(position));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append(";Constant Tokens=" + Arrays.toString(this.tokenImages) + "; param count=" + this.getParameterCount());
            return sb.toString();
        }

        @Override
        public int validateParameterizedData() {
            return -1;
        }
    }

    private class GenricSubqueryPVSWrapper
    extends SubqueryParameterValueSetWrapper
    implements ParameterValueSet {
        GenricSubqueryPVSWrapper(ParameterValueSet pvs) {
            super(pvs);
        }

        @Override
        public int allAreSet() {
            GenericParameterValueSet gpvs = (GenericParameterValueSet)this.allPvs;
            for (Integer posn : GfxdSubqueryResultSet.this.params) {
                GenericParameter gp = gpvs.getGenericParameter(posn);
                if (gp.isSet()) continue;
                switch (gp.getParameterMode()) {
                    case 4: {
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        return posn + 1;
                    }
                }
            }
            return 0;
        }

        @Override
        public boolean checkNoDeclaredOutputParameters() {
            boolean hasDeclaredOutputParameter = false;
            GenericParameterValueSet gpvs = (GenericParameterValueSet)this.allPvs;
            for (Integer posn : GfxdSubqueryResultSet.this.params) {
                GenericParameter gp = gpvs.getGenericParameter(posn);
                switch (gp.getParameterMode()) {
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 4: {
                        hasDeclaredOutputParameter = true;
                        break;
                    }
                    case 0: {
                        gp.setParameterMode((short)1);
                    }
                }
            }
            return hasDeclaredOutputParameter;
        }

        @Override
        public void clearParameters() {
            GenericParameterValueSet gpvs = (GenericParameterValueSet)this.allPvs;
            for (Integer posn : GfxdSubqueryResultSet.this.params) {
                GenericParameter gp = gpvs.getGenericParameter(posn);
                gp.clear();
            }
        }

        @Override
        public void transferDataValues(ParameterValueSet pvstarget) throws StandardException {
            GenericParameterValueSet gpvs = (GenericParameterValueSet)this.allPvs;
            int firstParam = pvstarget.hasReturnOutputParameter() ? 1 : 0;
            int paramSize = GfxdSubqueryResultSet.this.params.size();
            for (int i = firstParam; i < paramSize; ++i) {
                GenericParameter oldp = gpvs.getGenericParameter(GfxdSubqueryResultSet.this.params.get(i));
                if (oldp.getRegisterOutputType() != 0) {
                    pvstarget.registerOutParameter(i, oldp.getRegisterOutputType(), oldp.getRegisterOutScale());
                }
                if (!oldp.getIsSet()) continue;
                pvstarget.getParameterForSet(i).setValue(oldp.getValue());
            }
        }
    }

    private abstract class SubqueryParameterValueSetWrapper {
        final ParameterValueSet allPvs;

        public SubqueryParameterValueSetWrapper(ParameterValueSet all) {
            this.allPvs = all;
        }

        public ParameterValueSet getClone() {
            throw new IllegalStateException("This should not have got invoked");
        }

        public DataValueDescriptor getParameter(int position) throws StandardException {
            int indx = GfxdSubqueryResultSet.this.isGFEActvn ? GfxdSubqueryResultSet.this.params.get(position) : position;
            return this.allPvs.getParameter(indx);
        }

        public int getParameterCount() {
            return GfxdSubqueryResultSet.this.params.size();
        }

        public DataValueDescriptor getParameterForGet(int position) throws StandardException {
            return this.allPvs.getParameterForGet(GfxdSubqueryResultSet.this.params.get(position));
        }

        public DataValueDescriptor getParameterForSet(int position) throws StandardException {
            return this.allPvs.getParameterForSet(GfxdSubqueryResultSet.this.params.get(position));
        }

        public short getParameterMode(int parameterIndex) {
            return this.allPvs.getParameterMode(GfxdSubqueryResultSet.this.params.get(parameterIndex));
        }

        public int getPrecision(int parameterIndex) {
            return this.allPvs.getPrecision(GfxdSubqueryResultSet.this.params.get(parameterIndex));
        }

        public DataValueDescriptor getReturnValueForSet() throws StandardException {
            throw new IllegalStateException("This should not have got invoked");
        }

        public int getScale(int parameterIndex) {
            return this.allPvs.getScale(GfxdSubqueryResultSet.this.params.get(parameterIndex));
        }

        public boolean hasReturnOutputParameter() {
            return false;
        }

        public void initialize(DataTypeDescriptor[] types) throws StandardException {
        }

        public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws StandardException {
            this.allPvs.registerOutParameter(GfxdSubqueryResultSet.this.params.get(parameterIndex), sqlType, scale);
        }

        public void setParameterAsObject(int parameterIndex, Object value) throws StandardException {
            this.allPvs.setParameterAsObject(GfxdSubqueryResultSet.this.params.get(parameterIndex), value);
        }

        public void setParameterMode(int position, int mode) {
            this.allPvs.setParameterMode(GfxdSubqueryResultSet.this.params.get(position), mode);
        }

        public void validate() throws StandardException {
            throw new IllegalStateException("This should not have got invoked");
        }

        public boolean isListOfConstants() {
            return this.allPvs.isListOfConstants();
        }

        public boolean canReleaseOnClose() {
            return true;
        }
    }
}

