/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.compile.Token;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ConstantValueSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ConstantValueSetImpl
implements ConstantValueSet {
    private static final String SINGLE_QUOTE = "'";
    private transient DataValueDescriptor[] staticParameters;
    private DataTypeDescriptor[] paramTypes;
    private List<TypeCompiler> origParamTCs;
    private Activation activation;
    private int[] tokenKind;
    private String[] tokenImages;

    public ConstantValueSetImpl(Activation ownedactivation, List<Token> tokenlist, List<TypeCompiler> origParamTCs) {
        this.activation = ownedactivation;
        int constantSize = tokenlist.size();
        this.tokenKind = new int[constantSize];
        this.tokenImages = new String[constantSize];
        for (int index = 0; index < constantSize; ++index) {
            Token tok = tokenlist.get(index);
            this.tokenKind[index] = tok.kind;
            this.tokenImages[index] = tok.image;
        }
        this.origParamTCs = origParamTCs;
        this.staticParameters = new DataValueDescriptor[constantSize];
    }

    public ConstantValueSetImpl(int[] tokentypes, String[] tokenstrings) {
        this.staticParameters = null;
        this.paramTypes = null;
        this.activation = null;
        this.tokenImages = tokenstrings;
        this.tokenKind = tokentypes;
        if (GemFireXDUtils.TraceStatementMatching) {
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("read " + this));
        }
    }

    @Override
    public void setActivation(Activation ownedActivation) {
        this.activation = ownedActivation;
    }

    @Override
    public void initialize(DataTypeDescriptor[] types) throws StandardException {
        this.paramTypes = types;
        if (this.staticParameters == null) {
            this.staticParameters = new DataValueDescriptor[types.length];
        }
    }

    @Override
    public final String getConstantImage(int position) {
        int kind = this.tokenKind[position];
        String image = this.tokenImages[position];
        switch (kind) {
            case 525: 
            case 526: {
                return this.escapeQuotes(image);
            }
        }
        return image;
    }

    public static final String tokenKindAsString(int kind) {
        switch (kind) {
            case 525: {
                return "STRING";
            }
            case 526: {
                return "HEX_STRING";
            }
            case 522: {
                return "EXACT_NUMERIC";
            }
            case 0: {
                SanityManager.THROWASSERT((String)("ConstantValueSet: Invalid token received " + kind));
            }
        }
        return String.valueOf(kind);
    }

    private String escapeQuotes(String image) {
        int index = image.indexOf(SINGLE_QUOTE, 0);
        while (index != -1 && index < image.length()) {
            image = image.substring(0, index + 1) + SINGLE_QUOTE + image.substring(index + 1);
            index = image.indexOf(SINGLE_QUOTE, index + 2);
        }
        return SINGLE_QUOTE + image + SINGLE_QUOTE;
    }

    @Override
    public final DataValueDescriptor getParameter(int position) throws StandardException {
        if (this.staticParameters == null) {
            ExecPreparedStatement ps = this.activation.getPreparedStatement();
            SanityManager.THROWASSERT((String)(GemFireXDUtils.addressOf(this) + ":getParameter(int): [" + (ps != null ? ps.getStatement() : " NULL ") + "] StaticParameterSet is found null but parser have identified the constants."));
            throw StandardException.newException("07009");
        }
        if (this.staticParameters[position] == null) {
            DataValueDescriptor dvd = this.paramTypes[position].getNull();
            dvd.setValue(this.tokenImages[position]);
            this.staticParameters[position] = dvd;
        }
        ExecPreparedStatement ps = this.activation.getPreparedStatement();
        if (GemFireXDUtils.TraceStatementMatching && SanityManager.isFinerEnabled) {
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)(GemFireXDUtils.addressOf(this) + ":getParameter(int): [" + (ps != null ? ps.getStatement() : " NULL ") + "] returning  staticParams[" + position + "]=" + this.staticParameters[position]));
        }
        return this.staticParameters[position];
    }

    @Override
    public int getParameterCount() {
        return this.staticParameters != null ? this.staticParameters.length : (this.tokenImages != null ? this.tokenImages.length : 0);
    }

    @Override
    public void validate() throws StandardException {
        if (this.tokenImages == null || this.tokenImages.length <= 0) {
            SanityManager.THROWASSERT((String)"ConstantValueSet: Token images are supposed to be existent");
        }
        if (this.tokenKind == null || this.tokenKind.length <= 0) {
            SanityManager.THROWASSERT((String)"ConstantValueSet: Token kind should be non-null");
        }
        if (GemFireXDUtils.TraceStatementMatching) {
            StringBuilder sb = new StringBuilder("ConstantValueSet: Validating tokens : [");
            for (int i = 0; i < this.tokenImages.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.tokenImages[i]).append(" (").append(ConstantValueSetImpl.tokenKindAsString(this.tokenKind[i])).append(")");
            }
            sb.append("]");
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)sb.toString());
        }
    }

    @Override
    public int validateParameterizedData() throws StandardException {
        assert (this.paramTypes == null && this.tokenImages == null || this.paramTypes.length == this.tokenImages.length) : "ConstantValueSet: parameters type definition should be equal to number of tokens";
        int constantSize = 0;
        if (this.tokenImages != null) {
            constantSize = this.tokenImages.length;
        }
        if (constantSize != (this.paramTypes != null ? this.paramTypes.length : 0)) {
            SanityManager.THROWASSERT((String)("constantTokenList=" + constantSize + " typeDescriptors=" + (this.paramTypes != null ? this.paramTypes.length : 0)));
        }
        int paramCount = this.getParameterCount();
        for (int i = 0; i < paramCount; ++i) {
            if (this.origParamTCs.get(i).compatible(this.paramTypes[i].getTypeId())) continue;
            if (this.paramTypes[i].getTypeId().isBooleanTypeId()) {
                try {
                    SQLBoolean.getBoolean(this.tokenImages[i]);
                    continue;
                }
                catch (StandardException se) {
                    return i;
                }
            }
            return i;
        }
        return -1;
    }

    @Override
    public void transferDataValues(ParameterValueSet pvstarget) throws StandardException {
        if (!this.getClass().isInstance(pvstarget)) {
            SanityManager.THROWASSERT((String)("Incapable of transfering parameters to " + pvstarget.getClass().getName()));
        }
        ConstantValueSetImpl target = (ConstantValueSetImpl)pvstarget;
        target.staticParameters = new DataValueDescriptor[this.staticParameters.length];
        target.paramTypes = this.paramTypes;
        target.tokenKind = this.tokenKind;
        target.tokenImages = this.tokenImages;
    }

    public void setTransferData(DataTypeDescriptor[] paramTypes, int[] tokenKind, String[] tokenImages) {
        this.paramTypes = paramTypes;
        this.tokenKind = tokenKind;
        this.tokenImages = tokenImages;
        this.staticParameters = new DataValueDescriptor[paramTypes.length];
    }

    public static void writeBytes(DataOutput out, ParameterValueSet pvs) throws IOException {
        if (pvs == null || pvs.getParameterCount() <= 0) {
            InternalDataSerializer.writeArrayLength((int)-1, (DataOutput)out);
            return;
        }
        assert (pvs instanceof ConstantValueSet) : "ConstantValueSet: pvs must be an instanceof this class.";
        ConstantValueSet cvs = (ConstantValueSet)pvs;
        int paramCount = cvs.getParameterCount();
        InternalDataSerializer.writeArrayLength((int)paramCount, (DataOutput)out);
        int[] tokenKinds = cvs.getTokenKinds();
        Object[] tokenImages = cvs.getTokenImages();
        for (int index = 0; index < paramCount; ++index) {
            InternalDataSerializer.writeSignedVL((long)tokenKinds[index], (DataOutput)out);
            InternalDataSerializer.writeString((String)tokenImages[index], (DataOutput)out);
        }
        if (GemFireXDUtils.TraceStatementMatching) {
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("ConstantValueSet: written " + Arrays.toString(tokenImages)));
        }
    }

    public static ConstantValueSetImpl readBytes(DataInput in) throws IOException {
        int paramCount = InternalDataSerializer.readArrayLength((DataInput)in);
        if (paramCount <= 0) {
            return null;
        }
        int[] paramkind = new int[paramCount];
        String[] paramstrings = new String[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            paramkind[i] = (int)InternalDataSerializer.readSignedVL((DataInput)in);
            paramstrings[i] = InternalDataSerializer.readString((DataInput)in);
        }
        return new ConstantValueSetImpl(paramkind, paramstrings);
    }

    @Override
    public void refreshTypes(DataTypeDescriptor[] constantDescriptors) {
        this.paramTypes = constantDescriptors;
        if (GemFireXDUtils.TraceStatementMatching) {
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)(this + " received parameter descriptors " + Arrays.toString(this.paramTypes)));
        }
        assert (this.tokenImages.length == this.paramTypes.length);
        this.staticParameters = new DataValueDescriptor[this.paramTypes.length];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConstantValueSet@");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.tokenImages != null) {
            sb.append(" tokens: ");
            boolean firstCall = true;
            for (String s : this.tokenImages) {
                if (firstCall) {
                    firstCall = false;
                } else {
                    sb.append(',');
                }
                sb.append(s != null ? s : "NULL");
            }
        } else {
            sb.append(" NONE ");
        }
        return sb.toString();
    }

    @Override
    public int allAreSet() {
        return 0;
    }

    @Override
    public boolean checkNoDeclaredOutputParameters() {
        return false;
    }

    @Override
    public void clearParameters() {
        throw new IllegalStateException("This should not have got invoked as batch operation is not possible for statements");
    }

    @Override
    public ParameterValueSet getClone() {
        throw new IllegalStateException("This should not have got invoked as we don't want the shell object to be cloned ever");
    }

    @Override
    public DataValueDescriptor getParameterForGet(int position) throws StandardException {
        throw new IllegalStateException("This should not have got invoked as everything is only incoming");
    }

    @Override
    public DataValueDescriptor getParameterForSet(int position) throws StandardException {
        throw new IllegalStateException("This should not have got invoked as everything is only incoming");
    }

    @Override
    public short getParameterMode(int parameterIndex) {
        return 1;
    }

    @Override
    public int getPrecision(int parameterIndex) {
        throw new IllegalStateException("This should not have got invoked as outgoing parameter not cater for");
    }

    @Override
    public DataValueDescriptor getReturnValueForSet() throws StandardException {
        throw new IllegalStateException("This should not have got invoked as outgoing parameter not cater for");
    }

    @Override
    public int getScale(int parameterIndex) {
        throw new IllegalStateException("This should not have got invoked as outgoing parameter not cater for");
    }

    @Override
    public boolean hasReturnOutputParameter() {
        return false;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws StandardException {
        throw new IllegalStateException("This should not have got invoked as outgoing parameter not cater for");
    }

    @Override
    public void setParameterAsObject(int parameterIndex, Object value) throws StandardException {
    }

    @Override
    public void setParameterMode(int position, int mode) {
        throw new IllegalStateException("This should not have got invoked only PARAMETER_MODE_IN is expected");
    }

    @Override
    public boolean isListOfConstants() {
        return true;
    }

    @Override
    public boolean canReleaseOnClose() {
        return false;
    }

    @Override
    public String[] getTokenImages() {
        return this.tokenImages;
    }

    @Override
    public int[] getTokenKinds() {
        return this.tokenKind;
    }

    @Override
    public DataTypeDescriptor[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public List<TypeCompiler> getOrigTypeCompilers() {
        return this.origParamTCs;
    }
}

