/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure.coordinate;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.execute.InternalResultCollector;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.procedure.ProcedureChunkMessage;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.OutgoingResultSetImpl;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.IncomingResultSetImpl;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProxyResultDescription;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.procedure.IncomingResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ProcedureResultCollector
implements InternalResultCollector<Object, Object> {
    private ConcurrentHashMap<Integer, ConcurrentHashMap<String, IncomingResultSetImpl>> incomingResultSets;
    private ProxyResultDescription[] proxyResultDescriptions;
    private ConcurrentHashMap<String, IncomingResultSetImpl> outParameters;
    private final AtomicInteger finishedNodeCount = new AtomicInteger(0);
    private ConcurrentHashMap<String, ConcurrentHashMap<Integer, ProcedureChunkMessage>> disorderMessages;
    private ConcurrentHashMap<String, SequenceNumber> seqNumbers;
    private CountDownLatch prepareLatch;
    private ResultCollector<?, ?> rc;
    private ReplyProcessor21 proc;
    private boolean reexecute;
    private final int numResultSets;
    private final String sqlText;

    public void setRC(ResultCollector<?, ?> resCol) {
        this.rc = resCol;
    }

    public void setProcessor(ReplyProcessor21 processor) {
        this.proc = processor;
    }

    public ReplyProcessor21 getProcessor() {
        return this.proc;
    }

    public void getResultFromTheInternalRCForBlocking() throws StandardException {
        if (this.rc != null) {
            try {
                this.rc.getResult();
            }
            catch (GemFireException gfeex) {
                throw Misc.processGemFireException(gfeex, gfeex, "execution of " + this.sqlText, true);
            }
        }
    }

    ProcedureResultCollector(int numResults, String sqlText) {
        this.numResultSets = numResults;
        this.sqlText = sqlText;
        this.initMembers(this.numResultSets);
    }

    private void initMembers(int numResultSets) {
        this.incomingResultSets = new ConcurrentHashMap();
        for (int i = 0; i < numResultSets; ++i) {
            this.incomingResultSets.put(i, new ConcurrentHashMap());
        }
        this.outParameters = new ConcurrentHashMap();
        this.prepareLatch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResult(DistributedMember sender, Object resultOfSingleExecution) {
        try {
            this.prepareLatch.await();
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)" the thread has been interrupted!");
        }
        assert (resultOfSingleExecution instanceof ProcedureChunkMessage) : "resultOfSingleExecution is: " + resultOfSingleExecution;
        ProcedureChunkMessage message = (ProcedureChunkMessage)resultOfSingleExecution;
        String member = sender.getId();
        SequenceNumber sn = this.seqNumbers.get(member);
        if (sn == null) {
            return;
        }
        SequenceNumber sequenceNumber = sn;
        synchronized (sequenceNumber) {
            ProcedureChunkMessage disorderMessage;
            if (message.getPrevSeqNumber() != sn.getSeqNo()) {
                ConcurrentHashMap<Integer, ProcedureChunkMessage> memberDisorderMessages = this.disorderMessages.get(member);
                if (memberDisorderMessages == null) {
                    memberDisorderMessages = new ConcurrentHashMap();
                    this.disorderMessages.put(member, memberDisorderMessages);
                }
                if (GemFireXDUtils.TraceProcedureExecution) {
                    SanityManager.DEBUG_PRINT((String)"TraceProcedureExecution", (String)("Recieving disordered " + message.toString()));
                }
                memberDisorderMessages.put(message.getPrevSeqNumber(), message);
                return;
            }
            sn.setSeqNo(message.getSeqNumber());
            this.processMessage(message, member);
            ConcurrentHashMap<Integer, ProcedureChunkMessage> memberDisorderMessages = this.disorderMessages.get(member);
            if (memberDisorderMessages == null) {
                return;
            }
            while ((disorderMessage = memberDisorderMessages.remove(sn.seqNo)) != null) {
                if (GemFireXDUtils.TraceProcedureExecution) {
                    SanityManager.DEBUG_PRINT((String)"TraceProcedureExecution", (String)("Processing disordered " + disorderMessage.toString()));
                }
                sn.setSeqNo(disorderMessage.getSeqNumber());
                this.processMessage(disorderMessage, member);
            }
        }
    }

    private void processMessage(ProcedureChunkMessage message, String memberId) {
        byte messageType = message.getType();
        if (GemFireXDUtils.TraceProcedureExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceProcedureExecution", (String)("Recieving " + message.toString()));
        }
        switch (messageType) {
            case 3: {
                this.processResultSetMessage(message, memberId);
                break;
            }
            case 2: {
                this.processMetaDataMessage(message, memberId);
                break;
            }
            case 1: {
                this.processOutParameterMessage(message, memberId);
                break;
            }
            case 4: {
                this.processProcedureEndMessage(message, memberId);
            }
        }
    }

    private void processResultSetMessage(ProcedureChunkMessage message, String memberId) {
        int resultSetNumber = message.getResultSetNumber();
        ConcurrentHashMap<String, IncomingResultSetImpl> resultSetGroup = this.incomingResultSets.get(resultSetNumber);
        IncomingResultSetImpl irs = resultSetGroup.get(memberId);
        assert (irs != null) : "the thead conflict exists!";
        ArrayList<List<Object>> rows = message.getChunks();
        int size = rows.size();
        if (size < 1) {
            return;
        }
        assert (resultSetNumber > -1 && resultSetNumber < this.proxyResultDescriptions.length) : "the result set number is out of bound!";
        ProxyResultDescription proxyDescription = this.proxyResultDescriptions[resultSetNumber];
        if (!proxyDescription.isSet()) {
            List<Object> firstRow = rows.get(0);
            proxyDescription.setResultDescription(OutgoingResultSetImpl.generateResultDescriptionOnRow(firstRow));
        }
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            irs.addRow(rows.get(rowIndex));
        }
        if (message.isLast()) {
            irs.addRow(IncomingResultSet.END_OF_RESULTS);
        }
    }

    private void processOutParameterMessage(ProcedureChunkMessage message, String memberId) {
        ArrayList<List<Object>> rows;
        IncomingResultSetImpl irs = this.outParameters.get(memberId);
        if (irs == null) {
            this.outParameters.putIfAbsent(memberId, new IncomingResultSetImpl());
            irs = this.outParameters.get(memberId);
        }
        int size = (rows = message.getChunks()) == null ? 0 : rows.size();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            irs.addRow(rows.get(rowIndex));
        }
        irs.addRow(IncomingResultSet.END_OF_RESULTS);
    }

    private void processProcedureEndMessage(ProcedureChunkMessage message, String memberId) {
        for (Integer key : this.incomingResultSets.keySet()) {
            ConcurrentHashMap<String, IncomingResultSetImpl> groupResultSets = this.incomingResultSets.get(key);
            IncomingResultSetImpl resultSet = groupResultSets.get(memberId);
            resultSet.addRow(IncomingResultSet.END_OF_RESULTS);
        }
        if (this.finishedNodeCount.decrementAndGet() > 0) {
            return;
        }
        if (this.proxyResultDescriptions == null) {
            return;
        }
        for (ProxyResultDescription prd : this.proxyResultDescriptions) {
            if (prd.isSet()) continue;
            ResultDescription rd = OutgoingResultSetImpl.generateResultDescriptionOnRow(new ArrayList<Object>());
            prd.setResultDescription(rd);
        }
    }

    public void endResults() {
    }

    public void clearResults() {
        this.initMembers(this.numResultSets);
        this.reexecute = true;
    }

    public boolean getIfReExecute() {
        return this.reexecute;
    }

    public Object getResult() throws FunctionException {
        return null;
    }

    public Object getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
        return null;
    }

    public IncomingResultSet[] getIncomingResultSets(int resultSetNumber) {
        IncomingResultSet[] retValue = null;
        Integer key = resultSetNumber;
        if (this.incomingResultSets.containsKey(key)) {
            ConcurrentHashMap<String, IncomingResultSetImpl> sameNumberResultSets = this.incomingResultSets.get(key);
            retValue = new IncomingResultSet[sameNumberResultSets.size()];
            retValue = sameNumberResultSets.values().toArray(retValue);
        }
        return retValue;
    }

    public IncomingResultSet[] getOutParameters() {
        int numNodes = this.outParameters.size();
        if (numNodes == 0) {
            return null;
        }
        IncomingResultSet[] retValue = new IncomingResultSet[numNodes];
        retValue = this.outParameters.values().toArray(retValue);
        return retValue;
    }

    void setProxyResultDescritptions(ProxyResultDescription[] prds) {
        this.proxyResultDescriptions = prds;
    }

    void processMetaDataMessage(ProcedureChunkMessage message, String memberId) {
    }

    public void initializeResultSets(Collection<InternalDistributedMember> members) {
        if (this.proxyResultDescriptions != null && (members == null || members.size() == 0)) {
            for (ProxyResultDescription rsd : this.proxyResultDescriptions) {
                assert (rsd != null);
                rsd.setReady();
            }
            return;
        }
        for (Integer key : this.incomingResultSets.keySet()) {
            ConcurrentHashMap<String, IncomingResultSetImpl> resultSets = this.incomingResultSets.get(key);
            for (InternalDistributedMember m : members) {
                resultSets.putIfAbsent(m.getId(), new IncomingResultSetImpl());
            }
        }
        this.disorderMessages = new ConcurrentHashMap();
        this.seqNumbers = new ConcurrentHashMap();
        for (InternalDistributedMember m : members) {
            String member = m.getId();
            this.outParameters.putIfAbsent(member, new IncomingResultSetImpl());
            this.seqNumbers.put(member, new SequenceNumber());
        }
        this.finishedNodeCount.set(members.size());
        this.prepareLatch.countDown();
    }

    static class SequenceNumber {
        int seqNo = 0;

        SequenceNumber() {
        }

        public int getSeqNo() {
            return this.seqNo;
        }

        public void setSeqNo(int no) {
            this.seqNo = no;
        }
    }
}

