/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler;

import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.PathNotFoundException;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.Utils;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.EvaluationContextImpl;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.PathToken;
import java.util.List;

class PropertyPathToken
extends PathToken {
    private final List<String> properties;

    public PropertyPathToken(List<String> properties) {
        this.properties = properties;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    @Override
    void evaluate(String currentPath, Object model, EvaluationContextImpl ctx) {
        if (ctx.jsonProvider().isPdxInstance(model)) {
            this.handleObjectProperty(currentPath, model, ctx, this.properties);
        } else if (ctx.jsonProvider().isArray(model)) {
            for (int idx = 0; idx < ctx.jsonProvider().length(model); ++idx) {
                Object evalHit = ctx.jsonProvider().getArrayIndex(model, idx);
                this.handleObjectProperty(currentPath, evalHit, ctx, this.properties);
            }
        } else {
            throw new PathNotFoundException("Property " + this.getPathFragment() + " not found in path " + currentPath);
        }
    }

    @Override
    boolean isTokenDefinite() {
        return true;
    }

    @Override
    public String getPathFragment() {
        return "[" + Utils.join(", ", "'", this.properties) + "]";
    }
}

