/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath;

import com.gemstone.gemfire.pdx.PdxInstance;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Configuration;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Filter;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.InvalidPathException;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Option;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.ParseContext;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.ReadContext;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.JsonReader;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.Utils;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.PathCompiler;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.compiler.Path;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.http.HttpProviderFactory;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.json.JsonProvider;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.json.JsonProviderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class JsonPath {
    private final Path path;

    private JsonPath(String jsonPath, Filter[] filters) {
        Utils.notNull(jsonPath, "path can not be null", new Object[0]);
        this.path = PathCompiler.tokenize(jsonPath, filters);
    }

    public String getPath() {
        return this.path.toString();
    }

    public static boolean isPathDefinite(String path) {
        return JsonPath.compile(path, new Filter[0]).isDefinite();
    }

    public boolean isDefinite() {
        return this.path.isDefinite();
    }

    public <T> T read(Object jsonObject) {
        return this.read(jsonObject, Configuration.defaultConfiguration());
    }

    public <T> T read(Object jsonObject, Configuration configuration) {
        Object res = this.path.evaluate(jsonObject, configuration).getValue();
        return res;
    }

    public <T> T _read(Object jsonObject, Configuration configuration) {
        boolean optAsPathList = configuration.containsOption(Option.AS_PATH_LIST);
        boolean optAlwaysReturnList = configuration.containsOption(Option.ALWAYS_RETURN_LIST);
        boolean optSuppressExceptions = configuration.containsOption(Option.SUPPRESS_EXCEPTIONS);
        boolean optThrowOnMissingProperty = configuration.containsOption(Option.THROW_ON_MISSING_PROPERTY);
        try {
            if (optAsPathList) {
                return this.path.evaluate(jsonObject, configuration).getPath();
            }
            Object res = this.path.evaluate(jsonObject, configuration).getValue();
            if (optAlwaysReturnList && this.path.isDefinite()) {
                Object array = configuration.getProvider().createArray();
                configuration.getProvider().setProperty(array, 0, res);
                return (T)array;
            }
            return res;
        }
        catch (RuntimeException e) {
            if (optThrowOnMissingProperty || !optSuppressExceptions) {
                throw e;
            }
            if (optAsPathList) {
                return (T)configuration.getProvider().createArray();
            }
            if (optAlwaysReturnList) {
                return (T)configuration.getProvider().createArray();
            }
            return (T)(this.path.isDefinite() ? null : configuration.getProvider().createArray());
        }
    }

    public <T> T read(String json) {
        return this.read(json, Configuration.defaultConfiguration());
    }

    public <T> T read(String json, Configuration configuration) {
        Utils.notEmpty(json, "json can not be null or empty", new Object[0]);
        Utils.notNull(configuration, "jsonProvider can not be null", new Object[0]);
        return this.read(configuration.getProvider().parse(json), configuration);
    }

    public <T> T read(URL jsonURL) throws IOException {
        return this.read(jsonURL, Configuration.defaultConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(URL jsonURL, Configuration configuration) throws IOException {
        Utils.notNull(jsonURL, "json URL can not be null", new Object[0]);
        Utils.notNull(configuration, "jsonProvider can not be null", new Object[0]);
        InputStream in = null;
        try {
            in = HttpProviderFactory.getProvider().get(jsonURL);
            T t = this.read(configuration.getProvider().parse(in), configuration);
            return t;
        }
        finally {
            Utils.closeQuietly(in);
        }
    }

    public <T> T read(File jsonFile) throws IOException {
        return this.read(jsonFile, Configuration.defaultConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(File jsonFile, Configuration configuration) throws IOException {
        T t;
        Utils.notNull(jsonFile, "json file can not be null", new Object[0]);
        Utils.isTrue(jsonFile.exists(), "json file does not exist");
        Utils.notNull(configuration, "jsonProvider can not be null", new Object[0]);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(jsonFile);
            t = this.read(configuration.getProvider().parse(fis), configuration);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(fis);
            throw throwable;
        }
        Utils.closeQuietly(fis);
        return t;
    }

    public <T> T read(InputStream jsonInputStream) throws IOException {
        Utils.notNull(jsonInputStream, "json input stream can not be null", new Object[0]);
        try {
            T t = this.read(JsonProviderFactory.createProvider().parse(jsonInputStream));
            return t;
        }
        finally {
            Utils.closeQuietly(jsonInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(InputStream jsonInputStream, Configuration configuration) throws IOException {
        Utils.notNull(jsonInputStream, "json input stream can not be null", new Object[0]);
        Utils.notNull(configuration, "configuration can not be null", new Object[0]);
        try {
            T t = this.read(configuration.getProvider().parse(jsonInputStream), configuration);
            return t;
        }
        finally {
            Utils.closeQuietly(jsonInputStream);
        }
    }

    public static <T> T jsonPathQuery(PdxInstance pdxInstance, String query) {
        JsonPath jp = null;
        try {
            jp = JsonPath.compile(query, new Filter[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidPathException("Could no compile provided jsonpath '" + query + "'", e);
        }
        return jp.read(pdxInstance);
    }

    public static JsonPath compile(String jsonPath, Filter ... filters) {
        Utils.notEmpty(jsonPath, "json can not be null or empty", new Object[0]);
        return new JsonPath(jsonPath, filters);
    }

    public static <T> T read(Object json, String jsonPath, Filter ... filters) {
        return new JsonReader().parse(json).read(jsonPath, filters);
    }

    public static <T> T read(String json, String jsonPath, Filter ... filters) {
        return new JsonReader().parse(json).read(jsonPath, filters);
    }

    public static <T> T read(URL jsonURL, String jsonPath, Filter ... filters) throws IOException {
        return new JsonReader().parse(jsonURL).read(jsonPath, filters);
    }

    public static <T> T read(File jsonFile, String jsonPath, Filter ... filters) throws IOException {
        return new JsonReader().parse(jsonFile).read(jsonPath, filters);
    }

    public static <T> T read(InputStream jsonInputStream, String jsonPath, Filter ... filters) throws IOException {
        return new JsonReader().parse(jsonInputStream).read(jsonPath, filters);
    }

    public static ParseContext using(Configuration configuration) {
        return new JsonReader(configuration);
    }

    public static ParseContext using(JsonProvider provider) {
        return new JsonReader(Configuration.builder().jsonProvider(provider).build());
    }

    public static ReadContext parse(Object json) {
        return new JsonReader().parse(json);
    }

    public static ReadContext parse(String json) {
        return new JsonReader().parse(json);
    }

    public static ReadContext parse(InputStream json) {
        return new JsonReader().parse(json);
    }

    public static ReadContext parse(File json) throws IOException {
        return new JsonReader().parse(json);
    }

    public static ReadContext parse(URL json) throws IOException {
        return new JsonReader().parse(json);
    }

    public static ReadContext parse(Object json, Configuration configuration) {
        return new JsonReader(configuration).parse(json);
    }

    public static ReadContext parse(String json, Configuration configuration) {
        return new JsonReader(configuration).parse(json);
    }

    public static ReadContext parse(InputStream json, Configuration configuration) {
        return new JsonReader(configuration).parse(json);
    }

    public static ReadContext parse(File json, Configuration configuration) throws IOException {
        return new JsonReader(configuration).parse(json);
    }

    public static ReadContext parse(URL json, Configuration configuration) throws IOException {
        return new JsonReader(configuration).parse(json);
    }
}

