/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.fabricservice;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceUtils;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;

public class FabricServerImpl
extends FabricServiceImpl
implements FabricServer {
    private final Object initializationNotification = new Object();
    private String regionPathToWaitFor = "";
    private boolean notified;
    private boolean initializedOrWait;

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void start(Properties bootProperties) throws SQLException {
        this.start(bootProperties, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Properties bootProperties, boolean ignoreIfStarted) throws SQLException {
        Class<CacheFactory> clazz = CacheFactory.class;
        synchronized (CacheFactory.class) {
            FabricServerImpl fabricServerImpl = this;
            synchronized (fabricServerImpl) {
                try {
                    this.startImpl(bootProperties, ignoreIfStarted, false);
                }
                catch (Throwable t) {
                    Error err;
                    if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                        FabricServiceUtils.clearSystemProperties(this.monitorlite, this.sysProps);
                        SystemFailure.initiateFailure((Error)err);
                        throw err;
                    }
                    SystemFailure.checkFailure();
                    this.handleThrowable(t);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void notifyWaiting(String regionPath, Set<PersistentMemberID> membersToWaitFor, Set<Integer> missingBuckets, PersistentMemberID myId, String message) {
        if (GemFireXDUtils.TraceFabricServiceBoot) {
            this.logger.info("Accepting WAITING notification" + (message != null ? ": " + message : ""));
        }
        if (missingBuckets != null && missingBuckets.isEmpty() && membersToWaitFor.isEmpty()) {
            this.notifyTableWait(regionPath);
        } else {
            if (this.serverstatus != FabricService.State.WAITING) {
                this.previousServerStatus = this.serverstatus;
            }
            this.serverstatus = FabricService.State.WAITING;
            this.notifyTableWait(regionPath);
            FabricServerImpl.notifyWaitingInLauncher(regionPath, membersToWaitFor, missingBuckets, myId, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTableInitialized(boolean initialized, String regionPath) {
        Object object = this.initializationNotification;
        synchronized (object) {
            if (regionPath.equals(this.regionPathToWaitFor)) {
                this.notified = true;
                this.initializedOrWait = initialized;
                this.initializationNotification.notifyAll();
                this.regionPathToWaitFor = "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTableWait(String regionPath) {
        Object object = this.initializationNotification;
        synchronized (object) {
            if (regionPath.equals(this.regionPathToWaitFor)) {
                this.notified = true;
                this.initializedOrWait = true;
                this.initializationNotification.notifyAll();
                this.regionPathToWaitFor = "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTableInitialized(Future<?> waitFor, String regionPath) throws InterruptedException {
        Object object = this.initializationNotification;
        synchronized (object) {
            this.regionPathToWaitFor = regionPath;
            while (this.regionPathToWaitFor.equals(regionPath) && !this.notified && !waitFor.isDone()) {
                this.initializationNotification.wait(500L);
            }
            this.notified = false;
        }
    }

    public boolean isInitializedOrWait() {
        return this.initializedOrWait;
    }

    public boolean isNotified() {
        return this.notified;
    }
}

