/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DeleteNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;

public class DeleteQueryInfo
extends DMLQueryInfo {
    private boolean isDeleteWithReferencedKeys;
    private int deleteTargetTableNum = -1;

    public DeleteQueryInfo(QueryInfoContext qic) throws StandardException {
        super(qic);
        qic.setRootQueryInfo(this);
        this.queryType = GemFireXDUtils.set(this.queryType, 4);
    }

    @Override
    public void init() throws StandardException {
        GemFireContainer container;
        super.init();
        TableQueryInfo tqi = null;
        if (this.tableQueryInfoList.size() != 1 || !(tqi = (TableQueryInfo)this.tableQueryInfoList.get(0)).isPrimaryKeyBased() || !this.isWhereClauseSatisfactory(tqi)) {
            this.queryType = GemFireXDUtils.clear(this.queryType, 4);
        }
        this.isDeleteWithReferencedKeys = !(container = (GemFireContainer)this.getTargetRegion().getUserAttribute()).isTemporaryContainer() ? container.getExtraTableInfo().getReferencedKeyColumns() != null : false;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof DeleteNode) {
            DeleteNode dn = (DeleteNode)node;
            this.deleteTargetTableNum = dn.getTargetTableID();
            this.visit(dn.getResultSetNode());
        } else if (node instanceof ProjectRestrictNode) {
            this.handleProjectRestrictNode((ProjectRestrictNode)node);
        } else {
            super.visit(node);
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return node instanceof ProjectRestrictNode || node instanceof FromBaseTable || node instanceof AndNode || node instanceof ResultColumn;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public final boolean isDelete() {
        return true;
    }

    @Override
    public final boolean isDeleteWithReferencedKeys() {
        return this.isDeleteWithReferencedKeys;
    }

    public LocalRegion getTargetRegion() {
        return ((TableQueryInfo)this.tableQueryInfoList.get(this.deleteTargetTableNum)).getRegion();
    }
}

