/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.message.LeadNodeExecutorMsg;
import com.pivotal.gemfirexd.internal.engine.distributed.message.LeadNodeGetStatsMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.util.Set;

public class GetLeadNodeInfoAsStringMessage
extends MemberExecutorMessage<Object> {
    private Object[] additionalArgs;
    private DataReqType requestType;

    public GetLeadNodeInfoAsStringMessage(ResultCollector<Object, Object> rc, DataReqType reqType, Object ... args) {
        super(rc, null, false, true);
        this.requestType = reqType;
        this.additionalArgs = args;
    }

    public GetLeadNodeInfoAsStringMessage() {
        super(true);
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return Misc.getLeadNode();
    }

    @Override
    public void postExecutionCallback() {
    }

    @Override
    public boolean isHA() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    protected void execute() throws Exception {
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"GetLeadNodeInfoAsStringMessage.execute: ");
        }
        try {
            String result = null;
            switch (this.requestType) {
                case GET_JARS: {
                    result = this.handleGetJarsRequest();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("GetLeadNodeInfoAsStringMessage: Unknown data request type: " + (Object)((Object)this.requestType));
                }
            }
            this.lastResult(result, false, false, true);
        }
        catch (Exception ex) {
            throw LeadNodeExecutorMsg.getExceptionToSendToServer(ex);
        }
    }

    private String handleGetJarsRequest() {
        URLClassLoader ul = CallbackFactoryProvider.getStoreCallbacks().getLeadClassLoader();
        URL[] allJarUris = ul.getURLs();
        StringBuffer res = new StringBuffer();
        for (URL u : allJarUris) {
            res.append(u);
            res.append(',');
        }
        if (res.length() > 0) {
            return res.substring(0, res.length() - 1);
        }
        return null;
    }

    @Override
    protected void executeFunction(boolean enableStreaming) throws StandardException, SQLException {
        try {
            super.executeFunction(enableStreaming);
        }
        catch (RuntimeException re) {
            throw LeadNodeExecutorMsg.handleLeadNodeRuntimeException(re);
        }
    }

    @Override
    protected LeadNodeGetStatsMessage clone() {
        LeadNodeGetStatsMessage msg = new LeadNodeGetStatsMessage((ResultCollector<Object, Object>)this.userCollector);
        return msg;
    }

    @Override
    public byte getGfxdID() {
        return 60;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.requestType = (DataReqType)((Object)DataSerializer.readObject((DataInput)in));
        this.additionalArgs = DataSerializer.readObjectArray((DataInput)in);
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject((Object)((Object)this.requestType), (DataOutput)out);
        DataSerializer.writeObjectArray((Object[])this.additionalArgs, (DataOutput)out);
    }

    @Override
    public void appendFields(StringBuilder sb) {
    }

    public static enum DataReqType {
        GET_JARS;

    }
}

