/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import com.gemstone.gemfire.internal.cache.wan.CloneableCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GfxdCallbackArgument
extends GfxdDataSerializable
implements Sizeable {
    static final byte RT_SET = 1;
    private static final byte CLEAR_RT_SET = -2;
    static final byte CONN_SET = 2;
    private static final byte CLEAR_CONN_SET = -3;
    static final short IS_CACHE_LOADED = 4;
    static final short IS_TRANSACTIONAL = 8;
    static final short IS_PKBASED = 16;
    static final short SKIP_LISTENER = 32;
    static final short IS_TSS_INSTANCE = 64;
    static final short BULK_FK_CHECKS_ENABLED = 128;
    static final short SKIP_CONSTRAINT_CHECKS = 256;
    private static final byte CLEAR_TSS_INSTANCE = -65;
    private static final GfxdCallbackArgument fixedInstance = new GfxdCallbackArgument();
    private static final NoPkBased fixedInstanceNoPkBased = new NoPkBased();
    private static final CacheLoaded fixedInstanceCL = new CacheLoaded();
    private static final CacheLoadedSkipListeners fixedInstanceCLSL = new CacheLoadedSkipListeners();
    private static final Transactional fixedInstanceTX = new Transactional();
    private static final TransactionalNoPkBased fixedInstanceTXNoPkBased = new TransactionalNoPkBased();
    private static final ThreadLocal<WithInfoFieldsType> tssInstance = new ThreadLocal<WithInfoFieldsType>(){

        @Override
        protected WithInfoFieldsType initialValue() {
            WithInfoFieldsType inst = new WithInfoFieldsType();
            inst.setFields(-1, -1L, (short)64);
            return inst;
        }
    };

    private GfxdCallbackArgument() {
    }

    public Integer getRoutingObject() {
        return null;
    }

    public boolean isRoutingObjectSet() {
        return false;
    }

    public void setRoutingObject(Integer routingObject) {
        throw new IllegalStateException("GfxdCallbackArgument::setRoutingObject: not expected to get invoked");
    }

    public void setConnectionProperties(long connID) {
        throw new IllegalStateException("GfxdCallbackArgument::setConnectionID: not expected to get invoked");
    }

    public void setSkipListeners() {
        throw new IllegalStateException("GfxdCallbackArgument::setSkipListeners: not expected to get invoked");
    }

    public void setBulkFkChecksEnabled() {
        throw new IllegalStateException("GfxdCallbackArgument::setBulkFkChecksEnabled: not expected to get invoked");
    }

    public void setSkipConstraintChecks() {
        throw new IllegalStateException("GfxdCallbackArgument::setSkipConstraintChecks: not expected to get invoked");
    }

    public long getConnectionID() {
        return -1L;
    }

    public boolean isConnectionIDSet() {
        return false;
    }

    public boolean isFixedInstance() {
        return true;
    }

    public boolean isThreadLocalInstance() {
        return false;
    }

    @Override
    public byte getGfxdID() {
        return 91;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        return "GfxdCallbackArgument: isPkBased=true";
    }

    public void clear() {
    }

    public boolean isCacheLoaded() {
        return false;
    }

    public boolean isTransactional() {
        return false;
    }

    public boolean isPkBased() {
        return true;
    }

    public boolean isSkipListeners() {
        return false;
    }

    public boolean isBulkFkChecksEnabled() {
        return false;
    }

    public boolean isSkipConstraintChecks() {
        return false;
    }

    public void setCacheLoaded() {
        throw new IllegalStateException("GfxdCallbackArgument::setCacheLoaded: not expected to get invoked");
    }

    public void setTransactional() {
        throw new IllegalStateException("GfxdCallbackArgument::setTransactional: not expected to get invoked");
    }

    public void setPkBased() {
    }

    public int getSizeInBytes() {
        return 2;
    }

    public GfxdCallbackArgument cloneObject() {
        return this;
    }

    public static GfxdCallbackArgument getFixedInstance() {
        return fixedInstance;
    }

    public static GfxdCallbackArgument getFixedInstanceNoPkBased() {
        return fixedInstanceNoPkBased;
    }

    public static GfxdCallbackArgument getThreadLocalInstance() {
        WithInfoFieldsType callbackArg = tssInstance.get();
        callbackArg.setFields(-1, -1L, (short)64);
        return callbackArg;
    }

    public static GfxdCallbackArgument getFixedInstanceCacheLoaded() {
        return fixedInstanceCL;
    }

    public static GfxdCallbackArgument getFixedInstanceCacheLoadedSkipListeners() {
        return fixedInstanceCLSL;
    }

    public static GfxdCallbackArgument getFixedInstanceTransactional() {
        return fixedInstanceTX;
    }

    public static GfxdCallbackArgument getFixedInstanceTransactionalNoPkBased() {
        return fixedInstanceTXNoPkBased;
    }

    public static GfxdCallbackArgument getWithInfoFieldsType() {
        return new WithInfoFieldsType();
    }

    public static final class WithInfoFieldsType
    extends GfxdCallbackArgument
    implements CloneableCallbackArgument {
        private int routingObject = -1;
        private short flags;
        private long connId = -1L;

        private final void setFields(int routingObject, long connId, short flags) {
            this.routingObject = routingObject;
            this.connId = connId;
            this.flags = flags;
        }

        @Override
        public final Integer getRoutingObject() {
            return this.isRoutingObjectSet() ? Integer.valueOf(this.routingObject) : null;
        }

        @Override
        public final boolean isRoutingObjectSet() {
            return (this.flags & 1) != 0;
        }

        @Override
        public final void setRoutingObject(Integer routingObject) {
            if (routingObject != null) {
                this.routingObject = routingObject;
                this.flags = (short)(this.flags | 1);
            } else {
                this.routingObject = -1;
                this.flags = (short)(this.flags & 0xFFFFFFFE);
            }
        }

        @Override
        public void setSkipListeners() {
            this.flags = (short)(this.flags | 0x20);
        }

        @Override
        public void setBulkFkChecksEnabled() {
            this.flags = (short)(this.flags | 0x80);
        }

        @Override
        public void setSkipConstraintChecks() {
            this.flags = (short)(this.flags | 0x100);
        }

        @Override
        public final void setConnectionProperties(long connId) {
            this.connId = connId;
        }

        @Override
        public final long getConnectionID() {
            return this.connId;
        }

        @Override
        public final boolean isConnectionIDSet() {
            return this.connId != -1L;
        }

        @Override
        public boolean isFixedInstance() {
            return false;
        }

        @Override
        public boolean isThreadLocalInstance() {
            return (this.flags & 0x40) != 0;
        }

        @Override
        public boolean isCacheLoaded() {
            return (this.flags & 4) != 0;
        }

        @Override
        public final boolean isTransactional() {
            return (this.flags & 8) != 0;
        }

        @Override
        public final boolean isPkBased() {
            return (this.flags & 0x10) != 0;
        }

        @Override
        public boolean isSkipListeners() {
            return (this.flags & 0x20) != 0;
        }

        @Override
        public boolean isBulkFkChecksEnabled() {
            return (this.flags & 0x80) != 0;
        }

        @Override
        public boolean isSkipConstraintChecks() {
            return (this.flags & 0x100) != 0;
        }

        @Override
        public void setCacheLoaded() {
            this.flags = (short)(this.flags | 4);
        }

        @Override
        public void setTransactional() {
            this.flags = (short)(this.flags | 8);
        }

        @Override
        public void setPkBased() {
            this.flags = (short)(this.flags | 0x10);
        }

        @Override
        public int getSizeInBytes() {
            return 10;
        }

        @Override
        public WithInfoFieldsType cloneObject() {
            WithInfoFieldsType clone = new WithInfoFieldsType();
            clone.setFields(this.routingObject, this.connId, (short)(this.flags & 0xFFFFFFBF));
            return clone;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof WithInfoFieldsType) {
                WithInfoFieldsType other = (WithInfoFieldsType)o;
                return this.routingObject == other.routingObject && this.connId == other.connId && (this.flags & 0xFFFFFFBF) == (other.flags & 0xFFFFFFBF);
            }
            return false;
        }

        public int hashCode() {
            int h = (int)(this.connId ^ this.connId >>> 32);
            return h ^ this.routingObject ^ this.flags & 0xFFFFFFBF;
        }

        @Override
        public byte getGfxdID() {
            return 99;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            long connId = this.connId;
            int flag = this.flags & 0xFFFFFFBF;
            if (connId != -1L) {
                flag |= 2;
            }
            out.writeShort(flag);
            if (this.isRoutingObjectSet()) {
                InternalDataSerializer.writeSignedVL((long)this.routingObject, (DataOutput)out);
            }
            if (connId != -1L) {
                GemFireXDUtils.writeCompressedHighLow(out, connId);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            short flag = in.readShort();
            if ((flag & 1) != 0) {
                this.routingObject = (int)InternalDataSerializer.readSignedVL((DataInput)in);
            }
            if ((flag & 2) != 0) {
                this.connId = GemFireXDUtils.readCompressedHighLow(in);
                flag = (short)(flag & 0xFFFFFFFD);
            }
            this.flags = flag;
        }

        @Override
        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("GfxdCallbackArgument.");
            if (this.isThreadLocalInstance()) {
                sbuff.append("TSSInstance@");
            } else {
                sbuff.append("WithInfoFieldsType@");
            }
            sbuff.append(Integer.toHexString(System.identityHashCode(this)));
            sbuff.append("(isRoutingObjectSet=").append(this.isRoutingObjectSet());
            sbuff.append(";routingObject=").append(this.getRoutingObject());
            sbuff.append(";isConnectionIDSet=").append(this.isConnectionIDSet());
            sbuff.append(";connectionID=").append(this.getConnectionID());
            sbuff.append(";isCacheLoaded=").append(this.isCacheLoaded());
            sbuff.append(";isTransactional=").append(this.isTransactional());
            sbuff.append(";isPkBased=").append(this.isPkBased());
            sbuff.append(";isSkipListeners=").append(this.isSkipListeners());
            sbuff.append(";isBulkFkChecksEnabled=").append(this.isBulkFkChecksEnabled());
            sbuff.append(";skipConstraintChecks=").append(this.isSkipConstraintChecks());
            return sbuff.append(')').toString();
        }

        public CloneableCallbackArgument getClone() {
            if (this.isThreadLocalInstance()) {
                return this.cloneObject();
            }
            return this;
        }
    }

    public static final class TransactionalNoPkBased
    extends GfxdCallbackArgument {
        private TransactionalNoPkBased() {
        }

        @Override
        public boolean isTransactional() {
            return true;
        }

        @Override
        public boolean isPkBased() {
            return false;
        }

        @Override
        public byte getGfxdID() {
            return 103;
        }

        @Override
        public String toString() {
            return "GFXD Transactional: isTransactional=true isPkBased=false";
        }
    }

    public static final class Transactional
    extends GfxdCallbackArgument {
        private Transactional() {
        }

        @Override
        public boolean isTransactional() {
            return true;
        }

        @Override
        public boolean isPkBased() {
            return true;
        }

        @Override
        public byte getGfxdID() {
            return 102;
        }

        @Override
        public String toString() {
            return "GFXD Transactional: isTransactional=true isPkBased=true";
        }
    }

    public static final class CacheLoadedSkipListeners
    extends GfxdCallbackArgument {
        private CacheLoadedSkipListeners() {
        }

        @Override
        public boolean isCacheLoaded() {
            return true;
        }

        @Override
        public boolean isSkipListeners() {
            return true;
        }

        @Override
        public byte getGfxdID() {
            return 101;
        }

        @Override
        public String toString() {
            return "CacheLoadedSkipListeners: isSkipListeners=true isPkBased=true";
        }
    }

    public static final class CacheLoaded
    extends GfxdCallbackArgument {
        private CacheLoaded() {
        }

        @Override
        public boolean isCacheLoaded() {
            return true;
        }

        @Override
        public boolean isSkipListeners() {
            return false;
        }

        @Override
        public byte getGfxdID() {
            return 100;
        }

        @Override
        public String toString() {
            return "CacheLoaded: isSkipListeners=false isPkBased=true";
        }
    }

    public static final class NoPkBased
    extends GfxdCallbackArgument {
        private NoPkBased() {
        }

        @Override
        public boolean isPkBased() {
            return false;
        }

        @Override
        public void setPkBased() {
            throw new IllegalStateException("GfxdCallbackArgument.NoPkBased::setPkBased: unexpected invocation");
        }

        @Override
        public byte getGfxdID() {
            return 84;
        }

        @Override
        public String toString() {
            return "GfxdCallbackArgument: isPkBased=false";
        }
    }
}

