/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplateNoAllNodesRoute;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;

public class SysVTIs
extends GfxdVTITemplate
implements GfxdVTITemplateNoAllNodesRoute {
    public static final String LOCAL_VTI = "LOCAL VTI";
    private Iterator<GemFireXDUtils.Pair<TableDescriptor, ResultSetMetaData>> vtis;
    private GemFireXDUtils.Pair<TableDescriptor, ResultSetMetaData> currentVTI;
    private int currentVTIColumn;
    private static final String SCHEMA = "SCHEMANAME";
    private static final String TABLE = "TABLENAME";
    private static final String TYPE = "TABLETYPE";
    private static final String COLUMN = "COLUMNNAME";
    private static final String TYPEID = "TYPEID";
    private static final String TYPENAME = "TYPENAME";
    private static final String ORDINAL = "ORDINAL";
    private static final String PRECISION = "PRECISION";
    private static final String SCALE = "SCALE";
    private static final String DISPLAYWIDTH = "DISPLAYWIDTH";
    private static final String NULLABLE = "NULLABLE";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("SCHEMANAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("TABLENAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("TABLETYPE", 12, false, 64), EmbedResultSetMetaData.getResultColumnDescriptor("COLUMNNAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("TYPEID", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("TYPENAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("ORDINAL", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("PRECISION", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("SCALE", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("DISPLAYWIDTH", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("NULLABLE", 16, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.vtis == null) {
            this.vtis = Misc.getMemStoreBooting().getDatabase().getDataDictionary().getRegisteredVTIs().iterator();
        }
        while (true) {
            if (this.currentVTI != null && this.currentVTIColumn < this.currentVTI.getValue().getColumnCount()) {
                ++this.currentVTIColumn;
                this.wasNull = false;
                return true;
            }
            if (!this.vtis.hasNext()) break;
            this.currentVTI = this.vtis.next();
            this.currentVTIColumn = 0;
        }
        this.currentVTI = null;
        this.currentVTIColumn = Integer.MAX_VALUE;
        return false;
    }

    @Override
    protected Object getObjectForColumn(int columnNumber) throws SQLException {
        switch (columnNumber) {
            case 1: {
                return this.currentVTI.getKey().getSchemaName();
            }
            case 2: {
                return this.currentVTI.getKey().getName();
            }
            case 3: {
                return this.currentVTI.getKey().routeQueryToAllNodes() ? LOCAL_VTI : "VIRTUAL TABLE";
            }
            case 4: {
                return this.currentVTI.getValue().getColumnName(this.currentVTIColumn);
            }
            case 5: {
                return this.currentVTI.getValue().getColumnType(this.currentVTIColumn);
            }
            case 6: {
                return this.currentVTI.getValue().getColumnTypeName(this.currentVTIColumn);
            }
            case 7: {
                return this.currentVTIColumn;
            }
            case 8: {
                return this.currentVTI.getValue().getPrecision(this.currentVTIColumn);
            }
            case 9: {
                return this.currentVTI.getValue().getScale(this.currentVTIColumn);
            }
            case 10: {
                return this.currentVTI.getValue().getColumnDisplaySize(this.currentVTIColumn);
            }
            case 11: {
                return this.currentVTI.getValue().isNullable(this.currentVTIColumn) != 0;
            }
        }
        throw new GemFireXDRuntimeException("unexpected column=" + columnNumber + " for SysVTIs");
    }
}

