/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.gemstone.gemfire.internal.cache.ExternalTableMetaData;
import com.pivotal.gemfirexd.internal.catalog.ExternalCatalog;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplateNoAllNodesRoute;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialClob;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTablesVTI
extends GfxdVTITemplate
implements GfxdVTITemplateNoAllNodesRoute {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private Iterator<ExternalTableMetaData> tableMetas;
    private ExternalTableMetaData currentTableMeta;
    private ListIterator<ExternalTableMetaData.Column> currentTableColumns;
    private ExternalTableMetaData.Column currentTableColumn;
    private static final String SCHEMA = "SCHEMANAME";
    private static final String TABLE = "TABLENAME";
    private static final String TYPE = "TABLETYPE";
    private static final String PROVIDER = "PROVIDER";
    private static final String SOURCEPATH = "SOURCEPATH";
    private static final String COMPRESSION = "COMPRESSION";
    private static final String COLUMN = "COLUMNNAME";
    private static final String TYPEID = "TYPEID";
    private static final String TYPENAME = "TYPENAME";
    private static final String ORDINAL = "ORDINAL";
    private static final String PRECISION = "PRECISION";
    private static final String SCALE = "SCALE";
    private static final String MAXWIDTH = "MAXWIDTH";
    private static final String NULLABLE = "NULLABLE";
    private static final String VIEWTEXT = "VIEWTEXT";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("SCHEMANAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("TABLENAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("TABLETYPE", 12, false, 64), EmbedResultSetMetaData.getResultColumnDescriptor("PROVIDER", 12, true, 8192), EmbedResultSetMetaData.getResultColumnDescriptor("SOURCEPATH", 12, false, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("COMPRESSION", 12, true, 64), EmbedResultSetMetaData.getResultColumnDescriptor("COLUMNNAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("TYPEID", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("TYPENAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("ORDINAL", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("PRECISION", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("SCALE", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("MAXWIDTH", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("NULLABLE", 16, false), EmbedResultSetMetaData.getResultColumnDescriptor("VIEWTEXT", 2005, true)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }

    @Override
    public boolean next() {
        if (this.tableMetas == null) {
            ExternalCatalog hiveCatalog;
            if (!GfxdDataDictionary.SKIP_CATALOG_OPS.get().skipHiveCatalogCalls && (hiveCatalog = Misc.getMemStore().getExternalCatalog()) != null) {
                try {
                    this.tableMetas = hiveCatalog.getCatalogTables().iterator();
                }
                catch (Exception e) {
                    this.logger.warn("ERROR in retrieving Hive tables: " + e.toString());
                    this.tableMetas = Collections.emptyIterator();
                }
            } else {
                this.tableMetas = Collections.emptyIterator();
            }
            this.currentTableColumns = Collections.emptyListIterator();
        }
        while (true) {
            if (this.currentTableColumns.hasNext()) {
                this.currentTableColumn = this.currentTableColumns.next();
                this.wasNull = false;
                return true;
            }
            if (!this.tableMetas.hasNext()) break;
            this.currentTableMeta = this.tableMetas.next();
            this.currentTableColumns = this.currentTableMeta.columns.listIterator();
        }
        this.currentTableMeta = null;
        this.currentTableColumn = null;
        return false;
    }

    @Override
    protected Object getObjectForColumn(int columnNumber) {
        String provider = this.currentTableMeta.shortProvider;
        switch (columnNumber) {
            case 1: {
                return this.currentTableMeta.schema;
            }
            case 2: {
                return this.currentTableMeta.entityName;
            }
            case 3: {
                return this.currentTableMeta.tableType;
            }
            case 4: {
                if (provider == null || provider.length() < 30) {
                    return provider;
                }
                if (this.currentTableColumns.nextIndex() == 1) {
                    return provider;
                }
                return "";
            }
            case 5: {
                if (this.currentTableColumns.nextIndex() == 1) {
                    return this.currentTableMeta.dataSourcePath;
                }
                return "";
            }
            case 6: {
                String compression = this.currentTableMeta.compressionCodec;
                return compression != null ? compression : ("COLUMN".equalsIgnoreCase(this.currentTableMeta.tableType) || "INDEX".equalsIgnoreCase(this.currentTableMeta.tableType) || "SAMPLE".equalsIgnoreCase(this.currentTableMeta.tableType) ? "lz4" : null);
            }
            case 7: {
                return this.currentTableColumn.name;
            }
            case 8: {
                return this.currentTableColumn.typeId;
            }
            case 9: {
                return this.currentTableColumn.typeName;
            }
            case 10: {
                return this.currentTableColumns.nextIndex();
            }
            case 11: {
                return this.currentTableColumn.precision;
            }
            case 12: {
                return this.currentTableColumn.scale;
            }
            case 13: {
                return this.currentTableColumn.maxWidth;
            }
            case 14: {
                return this.currentTableColumn.nullable;
            }
            case 15: {
                if (this.currentTableColumns.nextIndex() == 1) {
                    return this.currentTableMeta.viewText;
                }
                return null;
            }
        }
        throw new GemFireXDRuntimeException("unexpected column=" + columnNumber + " for HiveTablesVTI");
    }

    @Override
    public Clob getClob(int columnNumber) throws SQLException {
        switch (columnNumber) {
            case 15: {
                String viewText = this.getString(columnNumber);
                return viewText != null ? new HarmonySerialClob(viewText) : null;
            }
        }
        throw Util.generateCsSQLException("42Z9B", (Object)"HIVETABLES", columnNumber);
    }
}

