/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.wan.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.LogWriter;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.WanProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractGfxdReplayableMessage;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GfxdGatewaySenderStartMessage
extends AbstractGfxdReplayableMessage {
    private static final long serialVersionUID = 3396292910027181410L;
    private String id;
    private boolean isAsyncQueue;
    protected static final short IS_ASYNC_QUEUE = 64;

    public GfxdGatewaySenderStartMessage() {
    }

    public GfxdGatewaySenderStartMessage(String id, boolean isAsyncQueue) {
        this.id = id;
        this.isAsyncQueue = isAsyncQueue;
    }

    @Override
    public void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append(";GatewaySender/AsyncQueue ID=");
        sb.append(this.id);
        sb.append(";isAsyncQueue=").append(this.isAsyncQueue);
    }

    @Override
    public byte getGfxdID() {
        return 40;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.id = DataSerializer.readString((DataInput)in);
        this.isAsyncQueue = (this.flags & 0x40) != 0;
    }

    @Override
    protected short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.isAsyncQueue) {
            flags = (short)(flags | 0x40);
        }
        return flags;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString((String)this.id, (DataOutput)out);
    }

    @Override
    public void execute() throws StandardException {
        LogWriter logger = Misc.getGemFireCache().getLoggerI18n().convertToLogWriter();
        if (this.isAsyncQueue) {
            if (logger.infoEnabled()) {
                logger.info("Starting AsyncEventListener : " + this.id);
            }
            try {
                WanProcedures.startAsyncQueueLocally(this.id);
            }
            catch (Exception ex) {
                throw StandardException.newException("X0Z22.S", ex, (Object)this.id, (Object)ex.toString());
            }
        }
        try {
            if (logger.infoEnabled()) {
                logger.info("Starting Gateway Sender : " + this.id);
            }
            WanProcedures.startGatewaySenderLocally(this.id);
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z22.S", ex, (Object)this.id, (Object)ex.toString());
        }
    }

    public boolean shouldBeConflated() {
        return false;
    }

    public String getRegionToConflate() {
        return "SYS." + (this.isAsyncQueue ? "__GFXD_INTERNAL_ASYNCLISTENER_" : "__GFXD_INTERNAL_GATEWAYSENDER_") + this.id;
    }

    public Object getKeyToConflate() {
        return "START_STOP";
    }

    public Object getValueToConflate() {
        return null;
    }

    @Override
    public String getSQLStatement() {
        StringBuilder sb = new StringBuilder();
        if (this.isAsyncQueue) {
            sb.append("CALL SYS.START_ASYNC_EVENT_LISTENER('");
        } else {
            sb.append("CALL SYS.START_GATEWAYSENDER('");
        }
        return sb.append(this.id).append("')").toString();
    }
}

