/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.wan.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TObjectProcedure;
import com.pivotal.gemfirexd.callbacks.AsyncEventHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.GfxdSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.JavaObjectsList;
import com.pivotal.gemfirexd.internal.engine.distributed.message.BitSetSet;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.DVDStoreResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RawStoreResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.JSON;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBit;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBlob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongVarbit;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongvarchar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLReal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLRef;
import com.pivotal.gemfirexd.internal.iapi.types.SQLSmallint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTime;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTinyint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarbit;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.UserType;
import com.pivotal.gemfirexd.internal.iapi.types.XML;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class GfxdCBArgForSynchPrms
extends GfxdDataSerializable
implements GatewaySenderEventCallbackArgument,
GfxdSerializable,
Event,
TableMetaData,
Sizeable {
    private String dmlString;
    private int numParams;
    private DataValueDescriptor[] params;
    private byte[] sqlParamTypes;
    private BitSetSet notNullSet;
    private ArrayList<Object> bulkInsertRows;
    private boolean isBulkInsert;
    private boolean transactional;
    private int approxSize;
    private boolean posDup;
    private static final byte JAVA_OBJECT = 100;
    private static final byte BLOB = 104;
    private static final byte CLOB = 105;
    private static final byte SQLXML = 109;
    private static final byte JSON = 110;
    private int originatingDSId = -1;
    private final THashSet receipientDSIds;
    private transient GenericParameterValueSet pvs;
    private transient DataTypeDescriptor[] dtds;
    private String schema;
    private String tableName;
    private GemFireContainer container;
    private transient ExtraTableInfo tableInfo;
    private boolean isPutDML = false;

    public GfxdCBArgForSynchPrms(String dmlString, String schema, String tableName, boolean isTransactional, GatewaySenderEventCallbackArgument senderArg, boolean isPutDML) {
        this.dmlString = dmlString;
        this.schema = schema;
        this.tableName = tableName;
        this.approxSize = this.schema.length() * 2 + this.dmlString.length() * 2 + 32;
        this.transactional = isTransactional;
        if (senderArg != null) {
            this.originatingDSId = senderArg.getOriginatingDSId();
            this.receipientDSIds = new THashSet((Collection)senderArg.getRecipientDSIds());
        } else {
            this.receipientDSIds = new THashSet();
        }
        this.isPutDML = isPutDML;
    }

    public GfxdCBArgForSynchPrms() {
        this.receipientDSIds = new THashSet();
    }

    public GfxdCBArgForSynchPrms(String dmlString, GenericParameterValueSet pvs, DataTypeDescriptor[] dtds, String schema, String tableName, boolean isTransactional, GatewaySenderEventCallbackArgument senderArg, boolean isPutDML) throws StandardException {
        this.dmlString = dmlString;
        this.schema = schema;
        this.tableName = tableName;
        this.numParams = pvs.getParameterCount();
        this.pvs = pvs;
        this.dtds = dtds;
        this.approxSize = this.schema.length() * 2 + this.dmlString.length() * 2 + 32;
        this.approxSize += this.numParams % 8;
        for (int i = 0; i < this.numParams; ++i) {
            this.approxSize += this.pvs.getParameter(i).estimateMemoryUsage();
        }
        this.transactional = isTransactional;
        if (senderArg != null) {
            this.originatingDSId = senderArg.getOriginatingDSId();
            this.receipientDSIds = new THashSet((Collection)senderArg.getRecipientDSIds());
        } else {
            this.receipientDSIds = new THashSet();
        }
        this.isPutDML = isPutDML;
    }

    public GfxdCBArgForSynchPrms(String dmlString, ArrayList<Object> bulkInsertRows, GemFireContainer container, boolean isTransactional, GatewaySenderEventCallbackArgument senderArg, boolean isPutDML) throws StandardException {
        this.dmlString = dmlString;
        this.schema = container.getSchemaName();
        this.tableName = container.getTableName();
        this.container = container;
        this.bulkInsertRows = new ArrayList<Object>(bulkInsertRows);
        this.isBulkInsert = true;
        this.numParams = -1;
        this.transactional = isTransactional;
        if (senderArg != null) {
            this.originatingDSId = senderArg.getOriginatingDSId();
            this.receipientDSIds = new THashSet((Collection)senderArg.getRecipientDSIds());
        } else {
            this.receipientDSIds = new THashSet();
        }
        this.isPutDML = isPutDML;
    }

    private GfxdCBArgForSynchPrms(GfxdCBArgForSynchPrms other) {
        this.dmlString = other.dmlString;
        this.schema = other.schema;
        this.tableName = other.tableName;
        this.container = other.container;
        this.numParams = other.numParams;
        this.pvs = other.pvs != null ? (GenericParameterValueSet)other.pvs.getClone() : null;
        this.dtds = other.dtds;
        this.bulkInsertRows = other.bulkInsertRows;
        this.isBulkInsert = other.isBulkInsert;
        this.approxSize = other.approxSize;
        this.posDup = other.posDup;
        this.params = other.params;
        this.notNullSet = other.notNullSet;
        this.sqlParamTypes = other.sqlParamTypes;
        this.originatingDSId = other.originatingDSId;
        this.receipientDSIds = new THashSet((Collection)other.receipientDSIds);
        this.isPutDML = other.isPutDML;
    }

    public final GfxdCBArgForSynchPrms getClone() {
        return new GfxdCBArgForSynchPrms(this);
    }

    @Override
    public byte getGfxdID() {
        return 93;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        byte flags;
        super.fromData(in);
        this.dmlString = DataSerializer.readString((DataInput)in);
        this.schema = DataSerializer.readString((DataInput)in);
        this.tableName = DataSerializer.readString((DataInput)in);
        this.originatingDSId = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
        int numRecips = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
        this.receipientDSIds.clear();
        if (numRecips > 0) {
            for (int i = 0; i < numRecips; ++i) {
                this.receipientDSIds.add((Object)((int)InternalDataSerializer.readUnsignedVL((DataInput)in)));
            }
        }
        this.isBulkInsert = ((flags = in.readByte()) & 1) != 0;
        this.transactional = (flags & 2) != 0;
        boolean bl = this.isPutDML = (flags & 4) != 0;
        if (this.isBulkInsert) {
            this.bulkInsertRows = InternalDataSerializer.readArrayList((DataInput)in);
            return;
        }
        this.numParams = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
        if (this.numParams > 0) {
            this.approxSize = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
            this.sqlParamTypes = new byte[this.numParams];
            this.params = new DataValueDescriptor[this.numParams];
            BitSetSet notNulls = BitSetSet.fromData(in);
            for (int i = 0; i < this.numParams; ++i) {
                byte sqlType;
                this.sqlParamTypes[i] = sqlType = in.readByte();
                if (notNulls == null || !notNulls.containsInt(i)) continue;
                DataValueDescriptor dvd = GfxdCBArgForSynchPrms.getNullDVD(sqlType);
                dvd.fromDataForOptimizedResultHolder(in);
                this.params[i] = dvd;
            }
            this.notNullSet = notNulls;
        } else {
            this.approxSize = this.schema.length() * 2 + this.dmlString.length() * 2 + 32;
        }
    }

    @Override
    public void toData(final DataOutput out) throws IOException {
        int numRecipIds;
        super.toData(out);
        DataSerializer.writeString((String)this.dmlString, (DataOutput)out);
        DataSerializer.writeString((String)this.schema, (DataOutput)out);
        DataSerializer.writeString((String)this.tableName, (DataOutput)out);
        InternalDataSerializer.writeUnsignedVL((long)this.originatingDSId, (DataOutput)out);
        if (this.receipientDSIds != null && (numRecipIds = this.receipientDSIds.size()) > 0) {
            InternalDataSerializer.writeArrayLength((int)numRecipIds, (DataOutput)out);
            try {
                this.receipientDSIds.forEach(new TObjectProcedure(){

                    public final boolean execute(Object o) {
                        try {
                            InternalDataSerializer.writeUnsignedVL((long)((Integer)o).intValue(), (DataOutput)out);
                            return true;
                        }
                        catch (IOException ioe) {
                            throw new GemFireIOException(null, (Throwable)ioe);
                        }
                    }
                });
            }
            catch (GemFireIOException ioe) {
                if (ioe.getCause() instanceof IOException) {
                    throw (IOException)ioe.getCause();
                }
                throw ioe;
            }
        } else {
            InternalDataSerializer.writeUnsignedVL((long)0L, (DataOutput)out);
        }
        int flags = 0;
        if (this.isPutDML) {
            flags = (byte)(flags | 4);
        }
        if (this.transactional) {
            flags = (byte)(flags | 2);
        }
        if (this.isBulkInsert) {
            out.writeByte(flags | 1);
            InternalDataSerializer.writeArrayList(this.bulkInsertRows, (DataOutput)out);
            return;
        }
        out.writeByte(flags);
        InternalDataSerializer.writeUnsignedVL((long)this.numParams, (DataOutput)out);
        if (this.numParams > 0) {
            InternalDataSerializer.writeUnsignedVL((long)this.approxSize, (DataOutput)out);
            if (this.pvs != null) {
                try {
                    DataValueDescriptor dvd;
                    if (this.notNullSet == null) {
                        BitSetSet notNulls = new BitSetSet(this.numParams);
                        for (int i = 0; i < this.numParams; ++i) {
                            dvd = this.pvs.getParameter(i);
                            if (dvd == null || dvd.isNull()) continue;
                            notNulls.addInt(i);
                        }
                        this.notNullSet = notNulls;
                    }
                    BitSetSet.toData(this.notNullSet, out);
                    for (int i = 0; i < this.numParams; ++i) {
                        int sqlType = this.mapSQLType(this.dtds[i].getJDBCTypeId());
                        out.writeByte(sqlType);
                        if (!this.notNullSet.containsInt(i)) continue;
                        dvd = this.pvs.getParameter(i);
                        dvd.toDataForOptimizedResultHolder(out);
                    }
                }
                catch (StandardException se) {
                    throw new IOException(se);
                }
            } else {
                BitSetSet.toData(this.notNullSet, out);
                for (int i = 0; i < this.numParams; ++i) {
                    byte sqlType = this.sqlParamTypes[i];
                    DataValueDescriptor dvd = this.params[i];
                    out.writeByte(sqlType);
                    if (dvd == null) continue;
                    dvd.toDataForOptimizedResultHolder(out);
                }
            }
        }
    }

    public int getOriginatingDSId() {
        return this.originatingDSId;
    }

    public void setOriginatingDSId(int originatingDSId) {
        this.originatingDSId = originatingDSId;
    }

    public Set<Integer> getRecipientDSIds() {
        return this.receipientDSIds;
    }

    public void initializeReceipientDSIds(Collection<Integer> originalGatewaysReceivers) {
        this.receipientDSIds.clear();
        if (originalGatewaysReceivers != null) {
            this.receipientDSIds.addAll(originalGatewaysReceivers);
        }
    }

    @Override
    public Event.Type getType() {
        return this.isBulkInsert ? Event.Type.BULK_INSERT : Event.Type.BULK_DML;
    }

    public final boolean isBulkInsert() {
        return this.isBulkInsert;
    }

    @Override
    public String getDMLString() {
        if (AsyncEventHelper.POSTGRESQL_SYNTAX) {
            return this.dmlString.replace("\"", "");
        }
        return this.dmlString;
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public String getTableName() {
        return this.getContainer().getQualifiedTableName();
    }

    @Override
    public int getTableSchemaVersion() {
        return this.getContainer().getCurrentSchemaVersion();
    }

    @Override
    public boolean tableHasAutogeneratedColumns() {
        return this.getExtraTableInfo().hasAutoGeneratedColumns();
    }

    @Override
    public List<Object> getNewRow() throws UnsupportedOperationException {
        if (!this.isBulkInsert) {
            if (this.pvs != null) {
                return new JavaObjectsList.PVSJavaObjectsList(this.pvs);
            }
            return new JavaObjectsList.DVDArrayJavaObjectsList(this.params);
        }
        throw new UnsupportedOperationException("not expected to be invoked for a " + (Object)((Object)this.getType()) + " operation");
    }

    @Override
    public ResultSet getNewRowsAsResultSet() {
        if (this.isBulkInsert) {
            return new RawStoreResultSet(this.bulkInsertRows.iterator(), null, this.getExtraTableInfo().getRowFormatter());
        }
        if (this.params != null) {
            return new DVDStoreResultSet(this.params, this.params.length, null, null, this);
        }
        if (this.pvs != null) {
            return new DVDStoreResultSet(this.pvs, this);
        }
        return null;
    }

    @Override
    public ResultSet getPrimaryKeysAsResultSet() throws UnsupportedOperationException {
        if (this.isBulkInsert) {
            ExtraTableInfo tableInfo = this.getExtraTableInfo();
            int[] pkCols = tableInfo.getPrimaryKeyColumns();
            if (pkCols != null) {
                return new RawStoreResultSet(this.bulkInsertRows.iterator(), tableInfo.getRowFormatter(), pkCols, tableInfo.getPrimaryKeyFormatter().getMetaData());
            }
            return null;
        }
        throw new UnsupportedOperationException("not expected to be invoked for a " + (Object)((Object)this.getType()) + " operation");
    }

    @Override
    public TableMetaData getResultSetMetaData() {
        return this.getExtraTableInfo().getRowFormatter().getMetaData();
    }

    @Override
    public boolean isOriginRemote() {
        return this.pvs == null;
    }

    @Override
    public boolean isPossibleDuplicate() {
        return this.posDup;
    }

    @Override
    public boolean isTransactional() {
        return this.transactional;
    }

    public void setPossibleDuplicate(boolean posDup) {
        this.posDup = posDup;
    }

    @Override
    public boolean isLoad() {
        return false;
    }

    @Override
    public boolean isExpiration() {
        return false;
    }

    @Override
    public boolean isEviction() {
        return false;
    }

    @Override
    public List<Object> getOldRow() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("not expected to be invoked for a " + (Object)((Object)this.getType()) + " operation");
    }

    @Override
    public ResultSet getOldRowAsResultSet() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("not expected to be invoked for a " + (Object)((Object)this.getType()) + " operation");
    }

    @Override
    public int[] getModifiedColumns() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("not expected to be invoked for a " + (Object)((Object)this.getType()) + " operation");
    }

    @Override
    public Object[] getPrimaryKey() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("not expected to be invoked for a " + (Object)((Object)this.getType()) + " operation");
    }

    @Override
    public final boolean hasParameters() {
        return this.numParams > 0 || this.bulkInsertRows != null;
    }

    public final ArrayList<Object> getRawBulkInsertRows() {
        return this.bulkInsertRows;
    }

    public GemFireContainer getContainer() {
        GemFireContainer container = this.container;
        if (container != null) {
            return container;
        }
        if (this.tableName != null) {
            this.container = (GemFireContainer)Misc.getRegionByPath('/' + this.schema + '/' + this.tableName, true).getUserAttribute();
        }
        return this.container;
    }

    private ExtraTableInfo getExtraTableInfo() {
        if (this.tableInfo != null) {
            return this.tableInfo;
        }
        if (this.isBulkInsert && this.bulkInsertRows.size() > 0) {
            this.tableInfo = this.getContainer().getExtraTableInfo(this.bulkInsertRows.get(0));
            return this.tableInfo;
        }
        this.tableInfo = this.getContainer().getExtraTableInfo();
        return this.tableInfo;
    }

    private int mapSQLType(int sqlType) throws IllegalStateException {
        switch (sqlType) {
            case 2000: {
                return 100;
            }
            case 2004: {
                return 104;
            }
            case 2005: {
                return 105;
            }
            case 2009: {
                return 109;
            }
            case 4002: {
                return 110;
            }
        }
        if (sqlType < -128 || sqlType > 127) {
            throw new IllegalStateException("Sql type =" + sqlType + " not supported as it exceeds Byte limit ");
        }
        return sqlType;
    }

    public int getSizeInBytes() {
        return this.approxSize;
    }

    @Override
    public int getTableColumnPosition(int column) throws SQLException {
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public int getColumnPosition(String columnName) throws SQLException {
        throw Util.generateCsSQLException("42X04", columnName);
    }

    @Override
    public int getSchemaVersion() {
        return this.getExtraTableInfo().getSchemaVersion();
    }

    @Override
    public int getDeclaredColumnWidth(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            if (this.dtds != null) {
                return this.dtds[column - 1].getMaximumWidth();
            }
            return this.getPrecision(column);
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.numParams;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            if (this.dtds != null) {
                return this.dtds[column - 1].isNullable() ? 1 : 0;
            }
            return 2;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            if (this.dtds != null) {
                return this.dtds[column - 1].getTypeId().isNumericTypeId();
            }
            return DataTypeDescriptor.isNumericType(this.sqlParamTypes[column - 1]);
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            return false;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            int sqlType = this.dtds != null ? this.dtds[column - 1].getTypeId().getJDBCTypeId() : this.sqlParamTypes[column - 1];
            switch (sqlType) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2009: {
                    return true;
                }
            }
            return false;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            return true;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            int sqlType = this.dtds != null ? this.dtds[column - 1].getTypeId().getJDBCTypeId() : this.sqlParamTypes[column - 1];
            switch (sqlType) {
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            return true;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            return false;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            return false;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            if (this.dtds != null) {
                return DataTypeUtilities.getPrecision(this.dtds[column - 1]);
            }
            switch (this.sqlParamTypes[column - 1]) {
                case 2: 
                case 3: {
                    return 0;
                }
                case 5: {
                    return 5;
                }
                case 4: {
                    return 10;
                }
                case -5: {
                    return 19;
                }
                case 6: {
                    return 15;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 15;
                }
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1: 
                case 12: 
                case 104: 
                case 105: 
                case 110: {
                    return 0;
                }
                case 91: {
                    return 10;
                }
                case 92: {
                    return 8;
                }
                case 93: {
                    return 26;
                }
                case 100: {
                    return 0;
                }
            }
            throw Util.generateCsSQLException("XJ021.S");
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            if (this.dtds != null) {
                return this.dtds[column - 1].getScale();
            }
            switch (this.sqlParamTypes[column - 1]) {
                case 93: {
                    return 6;
                }
            }
            return 0;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            if (this.dtds != null) {
                return this.dtds[column - 1].getTypeId().getJDBCTypeId();
            }
            byte sqlType = this.sqlParamTypes[column - 1];
            switch (sqlType) {
                case 104: {
                    return 2004;
                }
                case 105: {
                    return 2005;
                }
                case 100: {
                    return 2000;
                }
                case 109: {
                    return 2009;
                }
                case 110: {
                    return 4002;
                }
            }
            return sqlType;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            if (this.dtds != null) {
                return this.dtds[column - 1].getTypeId().getSQLTypeName();
            }
            switch (this.sqlParamTypes[column - 1]) {
                case 16: {
                    return "BOOLEAN";
                }
                case 4: {
                    return "INTEGER";
                }
                case 5: {
                    return "SMALLINT";
                }
                case -6: {
                    return "TINYINT";
                }
                case -5: {
                    return "BIGINT";
                }
                case 3: {
                    return "DECIMAL";
                }
                case 8: {
                    return "DOUBLE";
                }
                case 7: {
                    return "REAL";
                }
                case 1: {
                    return "CHAR";
                }
                case 12: {
                    return "VARCHAR";
                }
                case -1: {
                    return "LONG VARCHAR";
                }
                case 105: {
                    return "CLOB";
                }
                case -2: {
                    return "CHAR () FOR BIT DATA";
                }
                case -3: {
                    return "VARCHAR () FOR BIT DATA";
                }
                case -4: {
                    return "LONG VARCHAR FOR BIT DATA";
                }
                case 104: {
                    return "BLOB";
                }
                case 91: {
                    return "DATE";
                }
                case 92: {
                    return "TIME";
                }
                case 93: {
                    return "TIMESTAMP";
                }
                case 109: {
                    return "XML";
                }
                case 110: {
                    return "JSON";
                }
                case 100: {
                    DataValueDescriptor dvd = this.params[column - 1];
                    if (dvd != null) {
                        try {
                            Object o = dvd.getObject();
                            if (o != null) {
                                return o.getClass().getName();
                            }
                        }
                        catch (StandardException se) {
                            throw Util.generateCsSQLException(se);
                        }
                    }
                    return "NULL UDT";
                }
            }
            throw Util.generateCsSQLException("XJ021.S");
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            if (this.dtds != null) {
                return this.dtds[column - 1].getTypeId().getResultSetMetaDataTypeName();
            }
            switch (this.sqlParamTypes[column - 1]) {
                case -7: 
                case 16: {
                    return "java.lang.Boolean";
                }
                case -6: {
                    return "java.lang.Integer";
                }
                case 5: {
                    return "java.lang.Integer";
                }
                case 4: {
                    return "java.lang.Integer";
                }
                case -5: {
                    return "java.lang.Long";
                }
                case 6: 
                case 7: {
                    return "java.lang.Float";
                }
                case 8: {
                    return "java.lang.Double";
                }
                case 2: 
                case 3: {
                    return "java.math.BigDecimal";
                }
                case -1: 
                case 1: 
                case 12: {
                    return "java.lang.String";
                }
                case 91: {
                    return "java.sql.Date";
                }
                case 92: {
                    return "java.sql.Time";
                }
                case 93: {
                    return "java.sql.Timestamp";
                }
                case -4: 
                case -3: 
                case -2: {
                    return "byte[]";
                }
                case 104: {
                    return "java.sql.Blob";
                }
                case 105: {
                    return "java.sql.Clob";
                }
                case 109: {
                    return "com.pivotal.gemfirexd.internal.iapi.types.XML";
                }
                case 110: {
                    return "com.pivotal.gemfirexd.internal.iapi.types.JSON";
                }
                case 100: {
                    DataValueDescriptor dvd = this.params[column - 1];
                    if (dvd != null) {
                        try {
                            Object o = dvd.getObject();
                            if (o != null) {
                                return o.getClass().getName();
                            }
                        }
                        catch (StandardException se) {
                            throw Util.generateCsSQLException(se);
                        }
                    }
                    return "NULL UDT";
                }
            }
            throw Util.generateCsSQLException("XJ021.S");
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int precision = this.getPrecision(column);
        return precision != 0 ? precision : 15;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            return "COLUMN_" + column;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            return "COLUMN_" + column;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            return this.schema;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            return this.tableName;
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        if (column > 0 && column <= this.numParams) {
            return "";
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw Util.generateCsSQLException("XJ128.S", iface);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    static final DataValueDescriptor getNullDVD(int sqlType) {
        switch (sqlType) {
            case -2: {
                return new SQLBit();
            }
            case -7: 
            case 16: {
                return new SQLBoolean();
            }
            case 1: {
                return new SQLChar();
            }
            case 91: {
                return new SQLDate();
            }
            case 8: {
                return new SQLDouble();
            }
            case 4: {
                return new SQLInteger();
            }
            case -5: {
                return new SQLLongint();
            }
            case 2: 
            case 3: {
                return new SQLDecimal();
            }
            case 6: 
            case 7: {
                return new SQLReal();
            }
            case 5: {
                return new SQLSmallint();
            }
            case 92: {
                return new SQLTime();
            }
            case 93: {
                return new SQLTimestamp();
            }
            case -6: {
                return new SQLTinyint();
            }
            case 12: {
                return new SQLVarchar();
            }
            case -1: {
                return new SQLLongvarchar();
            }
            case -3: {
                return new SQLVarbit();
            }
            case -4: {
                return new SQLLongVarbit();
            }
            case 2006: {
                return new SQLRef();
            }
            case 104: {
                SQLBlob blob = new SQLBlob();
                blob.setWrapBytesForSQLBlob(true);
                return blob;
            }
            case 105: {
                return new SQLClob();
            }
            case 100: {
                return new UserType();
            }
            case 109: {
                return new XML();
            }
            case 110: {
                return new JSON();
            }
        }
        throw GemFireXDRuntimeException.newRuntimeException("unexpected SQL type=" + sqlType, null);
    }

    public String toString() {
        StringBuilder tempBuffer;
        block9: {
            tempBuffer = new StringBuilder("GfxdCBArgForSynchPrms:- dml string = " + this.dmlString);
            tempBuffer.append("; Schema = " + this.schema);
            tempBuffer.append("; Originator = " + this.originatingDSId);
            tempBuffer.append("; Recipients = " + this.receipientDSIds);
            if (this.bulkInsertRows != null) {
                tempBuffer.append("; Bulk insert rows = " + this.bulkInsertRows.size());
                return tempBuffer.toString();
            }
            tempBuffer.append("; Num Parameters = " + this.numParams);
            tempBuffer.append("; Approx Size = " + this.approxSize);
            if (this.numParams <= 0) break block9;
            if (this.pvs != null) {
                for (int i = 0; i < this.numParams; ++i) {
                    try {
                        DataValueDescriptor dvd = this.pvs.getParameter(i);
                        if (dvd != null && !dvd.isNull()) {
                            tempBuffer.append(";  param" + (i + 1) + " = " + dvd.getObject());
                        } else {
                            tempBuffer.append(";  param" + (i + 1) + " = " + null);
                        }
                        tempBuffer.append(", Jdbc Type = " + this.dtds[i].getJDBCTypeId());
                        continue;
                    }
                    catch (StandardException se) {
                        tempBuffer.append("Exception = " + se);
                    }
                }
            } else {
                for (int i = 0; i < this.numParams; ++i) {
                    byte sqlType = this.sqlParamTypes[i];
                    tempBuffer.append("; param" + (i + 1) + " = " + this.params[i]);
                    tempBuffer.append(", Jdbc Type = " + sqlType);
                }
            }
        }
        return tempBuffer.toString();
    }

    public boolean isPutDML() {
        return this.isPutDML;
    }
}

